(function() {
    let view = definePackage("jtekma.view");

    view.MatchesDisplay = class MatchesDisplay extends view.main {

        constructor(treeType, double3rdPlace, matchesData) {
            super("div");
            this.matchesData = matchesData;

            if (treeType == "TABLE2" || treeType == "TABLE3" || treeType == "TABLE4" || treeType == "TABLE5") {
                var matchesToShow = [];

                if (treeType == "TABLE2") {
                    matchesToShow.push(4);
                }
                else if (treeType == "TABLE3") {
                    matchesToShow.push(5);
                    matchesToShow.push(4);
                    matchesToShow.push(8);
                }
                else if (treeType == "TABLE4") {
                    matchesToShow.push(7);
                    matchesToShow.push(8);
                    matchesToShow.push(2);
                    matchesToShow.push(4);
                    matchesToShow.push(9);
                    matchesToShow.push(5);
                }
                else if (treeType == "TABLE5") {
                    for (let i = 1; i <= 10; i++) {
                        matchesToShow.push(i);
                    }
                }
                for (let match of matchesData) {
                    if (!matchesToShow.includes(match.number)) {
                        continue;
                    }
                    if (match.status != "WAITING" && match.status != "INQUEUE" && match.status != "INPROGRESS" && match.status != "FINISHED") {
                        continue;
                    }
                    this.addContent(new view.MatchDisplay(match));
                }
            }
            else if (treeType == "TREE4") {
                this.addClass("tree-matches");
                this.addStyle("width", "560px");
                this.addStyle("height", "330px");

                for (let i = 117; i <= 118; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 20, (i - 117) * 80 + 40));
                }
                for (let i = 124; i <= 124; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 260, (i - 124) * (-80) + 80));
                }
                //repasague
                for (let i = 123; i <= 123; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 260, (i - 123) * (-80) + 240));
                }
            }
            else if (treeType == "TREE8") {
                this.addClass("tree-matches");
                this.addStyle("width", "770px");
                this.addStyle("height", "560px");

                for (let i = 105; i <= 108; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 20, (i - 105) * 80 + 40));
                }
                for (let i = 117; i <= 118; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 260, (i - 117) * 160 + 80));
                }
                for (let i = 124; i <= 124; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 500, (i - 124) * 80 + 160));
                }
                //repasague
                for (let i = 119; i <= 120; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 20, (i - 119) * 80 + 390));
                }
                for (let i = 121; i <= 122; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 260, (i - 121) * 80 + 390));
                }
                if (!double3rdPlace) {
                    for (let i = 123; i <= 123; i++) {
                        let match = this.getMatchByNumber(i);
                        this.addContent(new view.MatchDisplay(match, 500, (i - 123) * 80 + 430));
                    }
                }
            }
            else if (treeType == "TREE16") {
                this.addClass("tree-matches");
                this.addStyle("width", "1220px");
                this.addStyle("height", "1040px");

                for (let i = 81; i <= 88; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 20, (i - 81) * 80 + 40));
                }
                for (let i = 105; i <= 108; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 260, (i - 105) * 160 + 80));
                }
                for (let i = 117; i <= 118; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 500, (i - 117) * 320 + 160));
                }
                for (let i = 124; i <= 124; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 740, (i - 124) * 80 + 320));
                }
                //repasague
                for (let i = 109; i <= 112; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 20, (i - 109) * 80 + 700));
                }
                for (let i = 113; i <= 116; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 260, (i - 113) * 80 + 700));
                }
                for (let i = 119; i <= 120; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 500, (i - 119) * 160 + 740));
                }
                for (let i = 121; i <= 122; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 740, (i - 121) * 160 + 740));
                }
                if (!double3rdPlace) {
                    for (let i = 123; i <= 123; i++) {
                        let match = this.getMatchByNumber(i);
                        this.addContent(new view.MatchDisplay(match, 980, (i - 123) * 80 + 820));
                    }
                }
            }
            else if (treeType == "TREE32") {
                this.addClass("tree-matches");
                this.addStyle("width", "1700px");
                this.addStyle("height", "2010px");

                for (let i = 33; i <= 48; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 20, (i - 33) * 80 + 40));
                }
                for (let i = 81; i <= 88; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 260, (i - 81) * 160 + 80));
                }
                for (let i = 105; i <= 108; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 500, (i - 105) * 320 + 160));
                }
                for (let i = 117; i <= 118; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 740, (i - 117) * 640 + 320));
                }
                for (let i = 124; i <= 124; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 980, (i - 124) * 80 + 640));
                }
                //repasague
                for (let i = 89; i <= 96; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 20, (i - 89) * 80 + 1360));
                }
                for (let i = 97; i <= 104; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 260, (i - 97) * 80 + 1360));
                }
                for (let i = 109; i <= 112; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 500, (i - 109) * 160 + 1400));
                }
                for (let i = 113; i <= 116; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 740, (i - 113) * 160 + 1400));
                }
                for (let i = 119; i <= 120; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 980, (i - 119) * 320 + 1480));
                }
                for (let i = 121; i <= 122; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 1220, (i - 121) * 320 + 1480));
                }
                if (!double3rdPlace) {
                    for (let i = 123; i <= 123; i++) {
                        let match = this.getMatchByNumber(i);
                        this.addContent(new view.MatchDisplay(match, 1460, (i - 123) * 80 + 1650));
                    }
                }
            }
            else if (treeType == "TREE64") {
                this.addClass("tree-matches");
                this.addStyle("width", "2200px");
                this.addStyle("height", "3960px");

                for (let i = 1; i <= 32; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 20, (i - 1) * 80 + 40));
                }
                for (let i = 33; i <= 48; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 260, (i - 33) * 160 + 80));
                }
                for (let i = 81; i <= 88; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 500, (i - 81) * 320 + 160));
                }
                for (let i = 105; i <= 108; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 740, (i - 105) * 640 + 320));
                }
                for (let i = 117; i <= 118; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 980, (i - 117) * 1280 + 640));
                }
                for (let i = 124; i <= 124; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 1220, (i - 124) * 80 + 1280));
                }
                //repasague
                for (let i = 49; i <= 64; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 20, (i - 49) * 80 + 2660));
                }
                for (let i = 65; i <= 80; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 260, (i - 65) * 80 + 2660));
                }
                for (let i = 89; i <= 96; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 500, (i - 89) * 160 + 2700));
                }
                for (let i = 97; i <= 104; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 740, (i - 97) * 160 + 2700));
                }
                for (let i = 109; i <= 112; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 980, (i - 109) * 320 + 2780));
                }
                for (let i = 113; i <= 116; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 1220, (i - 113) * 320 + 2780));
                }
                for (let i = 119; i <= 120; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 1460, (i - 119) * 640 + 2950));
                }
                for (let i = 121; i <= 122; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 1700, (i - 121) * 640 + 2950));
                }
                if (!double3rdPlace) {
                    for (let i = 123; i <= 123; i++) {
                        let match = this.getMatchByNumber(i);
                        this.addContent(new view.MatchDisplay(match, 1940, (i - 123) * 80 + 3260));
                    }
                }
            }
            else {
                for (let match of matchesData) {
                    if (match.status != "WAITING" && match.status != "INQUEUE" && match.status != "INPROGRESS" && match.status != "FINISHED") {
                        continue;
                    }
                    this.addContent(new view.MatchDisplay(match));
                }
            }
        }

        getMatchByNumber(number) {
            for (let match of this.matchesData) {
                if (match.number == number) {
                    return match;
                }
            }
            return null;
        }

    };

    view.MatchDisplay = class MatchDisplay extends view.main {

        constructor(matchData, left, top) {
            super("div");
            this.addClass("match");

            if (isNotNull(left) && isNotNull(top)) {
                this.addStyle("position", "absolute");
                this.addStyle("left", String(left) + "px");
                this.addStyle("top", String(top) + "px");
            }

            let header = new view.div();
            header.addClass("header");

            let badge = new view.span(matchData.shortName);
            badge.addClass("badge");
            header.addContent(badge);
            header.addContent(" ");

            let label = new view.span(getSpringMessage("match.status." + matchData.status));
            if (matchData.status == "NOTNEEDED") {
                label.addClass("label label-default");
            }
            else if (matchData.status == "WAITING") {
                label.addClass("label label-danger");
            }
            else if (matchData.status == "INQUEUE") {
                label.addClass("label label-info");
            }
            else if (matchData.status == "INPROGRESS") {
                label.addClass("label label-warning");
            }
            else if (matchData.status == "FINISHED") {
                label.addClass("label label-success");
            }
            header.addContent(label);

            this.addContent(header);

            let competitor1data = matchData.competitor1;
            let competitor1 = new view.div();
            competitor1.addClass("competitor1");
            let name1 = new view.div();
            name1.addClass("name");
            if (isNotNull(competitor1data)) {
                if (competitor1data.winner) {
                    competitor1.addClass("winner");
                }
                name1.setContent(new view.div(competitor1data.shortName + " / " + competitor1data.shortClubName));
            }
            competitor1.addContent(name1);
            let points1 = new view.div();
            points1.addClass("points");
            points1.setContentText(matchData.points1);
            competitor1.addContent(points1);
            this.addContent(competitor1);

            let competitor2data = matchData.competitor2;
            let competitor2 = new view.div();
            competitor2.addClass("competitor2");
            let name2 = new view.div();
            name2.addClass("name");
            if (isNotNull(competitor2data)) {
                if (competitor2data.winner) {
                    competitor2.addClass("winner");
                }
                name2.setContent(new view.div(competitor2data.shortName + " / " + competitor2data.shortClubName));
            }
            competitor2.addContent(name2);
            let points2 = new view.div();
            points2.addClass("points");
            points2.setContentText(matchData.points2);
            competitor2.addContent(points2);
            this.addContent(competitor2);
        }

    };

})();
