(function() {
    let view = definePackage("jtekma.view");

    view.CategoryListDisplay = class CategoryListDisplay extends view.main {

        constructor(categoryListData) {
            super("div");
            if (isNotNull(categoryListData) && isNotNull(categoryListData.categoryData)) {
                for (let categoryData of categoryListData.categoryData) {
                    if (isNotNull(categoryData)) {
                        this.addContent(new view.CategoryDisplay(categoryData));
                    }
                }
            }
        }

    };

    view.CategoryDisplay = class CategoryDisplay extends view.main {

        constructor(categoryData) {
            super("div");
            this.addContent(new view.h3(categoryData.categoryName));

            if (isNotNull(categoryData.table)) {
                this.addContent(new view.TableDisplay(categoryData.table));
            }

            if (isNotNull(categoryData.duoTable)) {
                this.addContent(new view.DuoTableDisplay(categoryData.duoTable));
            }

            if (isArray(categoryData.duoPresentations) && categoryData.duoPresentations.length > 0) {
                this.addContent(new view.DuoPresentationsDisplay(categoryData.duoPresentations));
            }

            if (isArray(categoryData.matches) && categoryData.matches.length > 0) {
                this.addContent(new view.MatchesDisplay(categoryData.treeType, categoryData.double3rdPlace, categoryData.matches));
            }

            if (isArray(categoryData.placings) && categoryData.placings.length > 0) {
                this.addContent(new view.PlacingsDisplay(categoryData.placings));
            }

            this.addContent(new view.hr());
        }

    };

    view.TableDisplay = class TableDisplay extends view.main {

        constructor(tableData) {
            super("div");

            let table = new view.table();
            table.setClass("table table-bordered table-striped");

            let headers = [];
            headers.push(getSpringMessage("competition.competitor"));

            for (let i = 0; i < tableData.rows.length; i++) {
                headers.push(String(i + 1));
            }

            headers.push(getSpringMessage("competition.wins"));
            headers.push(getSpringMessage("competition.fiWins"));
            headers.push(getSpringMessage("competition.points"));
            headers.push(getSpringMessage("competition.placing"));

            table.setHeader(headers);

            let rows = [];

            for (let tableRow of tableData.rows) {
                if (isNull(tableRow)) {
                    continue;
                }

                let row = [];
                if (isNotNull(tableRow.competitor)) {
                    row.push(tableRow.competitor.shortName + "/" + tableRow.competitor.shortClubName);
                }
                else {
                    row.push("");
                }

                if (isArray(tableRow.matches)) {
                    for (let matchData of tableRow.matches) {
                        let points = "";
                        if (isNotNull(matchData.points1)) {
                            points += String(matchData.points1);
                        }
                        points += ":";
                        if (isNotNull(matchData.points2)) {
                            points += String(matchData.points2);
                        }
                        row.push(points);
                    }
                }

                row.push(String(tableRow.wins));
                row.push(String(tableRow.fullIpponWins));
                row.push(String(tableRow.pointsGained));
                row.push(String(tableRow.placing));

                rows.push(row);
            }

            table.setData(rows);

            this.addContent(table);
        }

    };

    view.DuoTableDisplay = class DuoTableDisplay extends view.main {

        constructor(duoTableData) {
            super("div");

            let table = new view.table();
            table.setClass("table table-bordered table-striped");

            let headers = [];
            headers.push(getSpringMessage("competition.competitor"));
            headers.push(getSpringMessage("competition.round1Points"));
            headers.push(getSpringMessage("competition.round2Points"));
            headers.push(getSpringMessage("competition.round3Points"));
            headers.push(getSpringMessage("competition.varietyScorePoints"));
            headers.push(getSpringMessage("competition.points"));
            headers.push(getSpringMessage("competition.placing"));
            table.setHeader(headers);

            let rows = [];

            for (let tableRow of duoTableData.rows) {
                if (isNull(tableRow)) {
                    continue;
                }

                let row = [];
                if (isNotNull(tableRow.competitor)) {
                    row.push(tableRow.competitor.shortName + "/" + tableRow.competitor.shortClubName);
                }
                else {
                    row.push("");
                }

                row.push(String(tableRow.round1Points));
                row.push(String(tableRow.round2Points));
                row.push(String(tableRow.round3Points));
                row.push(String(tableRow.varietyScorePoints));
                row.push(String(tableRow.points));
                row.push(String(tableRow.placing));

                rows.push(row);
            }

            table.setData(rows);

            this.addContent(table);
        }

    };

    view.PlacingsDisplay = class PlacingsDisplay extends view.main {

        constructor(placingsData) {
            super("div");

            let titleDiv = new view.div(getSpringMessage("competition.placings"));
            titleDiv.addStyle("font-weight", "bold");
            this.addContent(titleDiv);

            let showWorldLevel = false;
            let showAdvanced = false;

            for (let placing of placingsData) {
                if (placing.rank == "WORLD_LEVEL") {
                    showWorldLevel = true;
                }
                else if (placing.rank == "ADVANCED") {
                    showAdvanced = true;
                }
            }

            if (showWorldLevel) {
                this.addContent(new view.div(getSpringMessage("competition.worldLevel")));
                for (let placing of placingsData) {
                    if (placing.rank == "WORLD_LEVEL") {
                        this.addContent(new view.div(String(placing.place) + ". " + placing.competitor.name + " / " + placing.competitor.clubName));
                    }
                }
                this.addContent(new view.br());
            }

            if (showAdvanced) {
                this.addContent(new view.div(getSpringMessage("competition.advancedLevel")));
                for (let placing of placingsData) {
                    if (placing.rank == "ADVANCED") {
                        this.addContent(new view.div(String(placing.place) + ". " + placing.competitor.name + " / " + placing.competitor.clubName));
                    }
                }
            }

            if (!showWorldLevel && !showAdvanced) {
                for (let placing of placingsData) {
                    this.addContent(new view.div(String(placing.place) + ". " + placing.competitor.name + " / " + placing.competitor.clubName));
                }
            }
        }

    };

})();