(function() {
    var jtekma = definePackage("jtekma");
    var models = definePackage("jtekma.models");
    var views = definePackage("jtekma.views");

	views.MatchAddView = Backbone.View.extend({
		"tagName": "div",
		"template": templates.getTemplate("/competition/template/add-match"),
		"initialize": function() {
			$(this.el).attr("class","modal fade");

			var obj = this;

			this.on("show",function() {
				$("body").append(obj.el);

				$(obj.el).modal({
			    	show: false
			    });

				$(obj.el).on("hidden.bs.modal", function () {
					$(obj.el).remove();
				});

				obj.render();
				$(obj.el).modal("show");
			});
		},
		"render":function() {
			var obj = this;

			var competitorCollection = new models.CompetitorCollection();
			competitorCollection.fetch({
				"data": {
					"categoryId": jtekma.displaySettings.get("category").get("id")
				},
				"async": false
			});

			var data = {
				"competitors": competitorCollection.toJSON()
			};

			$(this.el).html(Mustache.render(this.template, data));

			$("[name='competitor1']", obj.el).chosen({
				"search_contains": true,
				"width": "250px"
			});

			$("[name='competitor2']", obj.el).chosen({
				"search_contains": true,
				"width": "250px"
			});

			$(".btn-primary", this.el).on("click", function() {
				var data = {
					"competitor1id": Number($("[name='competitor1']", obj.el).val()),
					"competitor2id": Number($("[name='competitor2']", obj.el).val()),
					"type": $("[name='match-type']", obj.el).val()
				};

				$.ajax({
					"async": false,
					"url": contextPath + "/competition/data/add-match?categoryId=" + jtekma.displaySettings.get("category").get("id"),
					"type": "POST",
					"contentType": "application/json; charset=utf-8",
					"data": JSON.stringify(data)
				});
				$(obj.el).modal("hide");
				jtekma.reloadData();
			});

			return this;
		}
	});

})();