/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.DirtyRegionContainer;
import com.sun.javafx.geom.DirtyRegionPool;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.Translate2D;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;

public class Offset
extends Effect {
    private int xoff;
    private int yoff;

    public Offset(int xoff, int yoff, Effect input) {
        super(input);
        this.xoff = xoff;
        this.yoff = yoff;
    }

    public final Effect getInput() {
        return this.getInputs().get(0);
    }

    public void setInput(Effect input) {
        this.setInput(0, input);
    }

    public int getX() {
        return this.xoff;
    }

    public void setX(int xoff) {
        int old = this.xoff;
        this.xoff = xoff;
    }

    public int getY() {
        return this.yoff;
    }

    public void setY(int yoff) {
        float old = this.yoff;
        this.yoff = yoff;
    }

    static BaseTransform getOffsetTransform(BaseTransform transform, double xoff, double yoff) {
        if (transform == null || transform.isIdentity()) {
            return Translate2D.getInstance(xoff, yoff);
        }
        return transform.copy().deriveWithTranslation(xoff, yoff);
    }

    @Override
    public BaseBounds getBounds(BaseTransform transform, Effect defaultInput) {
        BaseTransform at = Offset.getOffsetTransform(transform, this.xoff, this.yoff);
        Effect input = this.getDefaultedInput(0, defaultInput);
        return input.getBounds(at, defaultInput);
    }

    @Override
    public ImageData filter(FilterContext fctx, BaseTransform transform, Rectangle outputClip, Object renderHelper, Effect defaultInput) {
        BaseTransform at = Offset.getOffsetTransform(transform, this.xoff, this.yoff);
        Effect input = this.getDefaultedInput(0, defaultInput);
        return input.filter(fctx, at, outputClip, renderHelper, defaultInput);
    }

    @Override
    public Point2D transform(Point2D p, Effect defaultInput) {
        p = this.getDefaultedInput(0, defaultInput).transform(p, defaultInput);
        float x = p.x + (float)this.xoff;
        float y = p.y + (float)this.yoff;
        p = new Point2D(x, y);
        return p;
    }

    @Override
    public Point2D untransform(Point2D p, Effect defaultInput) {
        float x = p.x - (float)this.xoff;
        float y = p.y - (float)this.yoff;
        p = new Point2D(x, y);
        p = this.getDefaultedInput(0, defaultInput).untransform(p, defaultInput);
        return p;
    }

    @Override
    public Effect.AccelType getAccelType(FilterContext fctx) {
        return this.getInputs().get(0).getAccelType(fctx);
    }

    @Override
    public boolean reducesOpaquePixels() {
        return this.getX() != 0 || this.getY() != 0 || this.getInput() != null && this.getInput().reducesOpaquePixels();
    }

    @Override
    public DirtyRegionContainer getDirtyRegions(Effect defaultInput, DirtyRegionPool regionPool) {
        Effect di = this.getDefaultedInput(0, defaultInput);
        DirtyRegionContainer drc = di.getDirtyRegions(defaultInput, regionPool);
        if (this.xoff != 0 || this.yoff != 0) {
            for (int i = 0; i < drc.size(); ++i) {
                drc.getDirtyRegion(i).translate(this.xoff, this.yoff, 0.0f);
            }
        }
        return drc;
    }
}

