/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.web.security.impl;

import java.util.Calendar;
import java.util.Random;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.rememberme.PersistentRememberMeToken;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;
import si.nevensrok.common.utils.ByteUtil;
import si.nevensrok.common.utils.HashUtil;
import si.nevensrok.common.utils.StringUtil;
import si.nevensrok.common.web.security.impl.UserAuthentication;
import si.nevensrok.common.web.servlet.security.AdditionalSecurityFilter;

public class TokenBasedRememberMeService
implements RememberMeServices,
LogoutHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenBasedRememberMeService.class);
    private static final String ATTRIBUTE_LAZY = "TBRMS_lazy";
    private PersistentTokenRepository persistentTokenRepository;
    private UserDetailsService userDetailsService;
    private String cookiePrefix = "";
    private int cookieExpiryTime = 1209600;
    private String cookiePath = null;
    private String parameterName = "remember_me";
    private AdditionalSecurityFilter[] additionalSecurityFilters;
    private static final char[] CHARS = "abcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
    private Random random = new Random();

    public void setPersistentTokenRepository(PersistentTokenRepository persistentTokenRepository) {
        this.persistentTokenRepository = persistentTokenRepository;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public void setCookiePrefix(String cookiePrefix) {
        this.cookiePrefix = cookiePrefix;
    }

    public void setCookieExpiryTime(int cookieExpiryTime) {
        this.cookieExpiryTime = cookieExpiryTime;
    }

    public void setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
    }

    private String getCookieName() {
        return this.cookiePrefix + "REMEMBER_ME";
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public void setAdditionalSecurityFilters(AdditionalSecurityFilter[] additionalSecurityFilters) {
        this.additionalSecurityFilters = additionalSecurityFilters;
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        this.cancelCookie(request, response);
    }

    public Authentication autoLogin(HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = this.extractRememberMeCookie(request);
        if (cookie == null) {
            return null;
        }
        String cookieValue = cookie.getValue();
        if (cookieValue == null) {
            return null;
        }
        String[] cookieValueParts = cookieValue.split(":");
        String series = cookieValueParts[0];
        String key = cookieValueParts[1];
        if (StringUtil.isEmpty((String)series)) {
            LOGGER.error("Series is empty");
            return null;
        }
        if (StringUtil.isEmpty((String)key)) {
            LOGGER.error("Key is empty");
            return null;
        }
        PersistentRememberMeToken token = this.persistentTokenRepository.getTokenForSeries(series);
        if (token == null) {
            return null;
        }
        String username = token.getUsername();
        String signature = this.makeTokenSignature(series, key, username);
        if (!signature.equals(token.getTokenValue())) {
            LOGGER.error("Token signature is invalid");
            return null;
        }
        long validTo = token.getDate().getTime() + (long)this.cookieExpiryTime * 1000L;
        if (validTo < System.currentTimeMillis()) {
            LOGGER.error("Token validity expired");
            return null;
        }
        UserDetails userDetails = this.userDetailsService.loadUserByUsername(username);
        if (!userDetails.isEnabled()) {
            LOGGER.error("User is not enabled");
            return null;
        }
        if (!userDetails.isAccountNonExpired()) {
            LOGGER.error("Account is expired");
            return null;
        }
        if (!userDetails.isAccountNonLocked()) {
            LOGGER.error("Account is locked");
            return null;
        }
        if (!userDetails.isCredentialsNonExpired()) {
            LOGGER.error("Account credentials expired");
            return null;
        }
        this.persistentTokenRepository.updateToken(series, signature, Calendar.getInstance().getTime());
        UserAuthentication userAuthentication = new UserAuthentication();
        userAuthentication.setUsername(username);
        cookie.setMaxAge(this.cookieExpiryTime);
        cookie.setPath(this.getCookiePath(request));
        response.addCookie(cookie);
        if (this.additionalSecurityFilters != null) {
            for (AdditionalSecurityFilter additionalSecurityFilter : this.additionalSecurityFilters) {
                additionalSecurityFilter.addUserAuthenticatedFlag(request);
            }
        }
        return userAuthentication;
    }

    public void loginFail(HttpServletRequest request, HttpServletResponse response) {
        this.cancelCookie(request, response);
    }

    public void loginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication successfulAuthentication) {
        String key;
        String series;
        String signature;
        HttpSession httpSession = request.getSession();
        if (request.getParameter(this.parameterName) == null && httpSession.getAttribute(ATTRIBUTE_LAZY) == null) {
            LOGGER.trace("No remember me parameter present");
            return;
        }
        String username = this.retrieveUserName(successfulAuthentication);
        UserDetails userDetails = this.userDetailsService.loadUserByUsername(username);
        if (userDetails == null) {
            LOGGER.error("User details are null");
            return;
        }
        if (this.additionalSecurityFilters != null) {
            for (AdditionalSecurityFilter additionalSecurityFilter : this.additionalSecurityFilters) {
                if (additionalSecurityFilter.isUserAuthenticated(request)) continue;
                LOGGER.trace("Setting lazy flag");
                httpSession.setAttribute(ATTRIBUTE_LAZY, (Object)Boolean.TRUE);
                return;
            }
        }
        if ((signature = this.makeTokenSignature(series = this.generateRandomKey(100), key = this.generateRandomKey(100), username)) == null) {
            LOGGER.error("Signature is null");
            return;
        }
        PersistentRememberMeToken token = new PersistentRememberMeToken(username, series, signature, Calendar.getInstance().getTime());
        this.persistentTokenRepository.createNewToken(token);
        String cookieValue = series + ":" + key;
        LOGGER.trace("Setting remember me cookie");
        this.setCookie(cookieValue, request, response);
        httpSession.removeAttribute(ATTRIBUTE_LAZY);
    }

    private String retrieveUserName(Authentication authentication) {
        if (authentication instanceof UserDetails) {
            return ((UserDetails)authentication.getPrincipal()).getUsername();
        }
        Object principal = authentication.getPrincipal();
        if (principal instanceof User) {
            return ((User)principal).getUsername();
        }
        return authentication.getPrincipal().toString();
    }

    private void setCookie(String cookieValue, HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = new Cookie(this.getCookieName(), cookieValue);
        cookie.setMaxAge(this.cookieExpiryTime);
        cookie.setPath(this.getCookiePath(request));
        cookie.setSecure(request.isSecure());
        response.addCookie(cookie);
    }

    private void cancelCookie(HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = new Cookie(this.getCookieName(), null);
        cookie.setMaxAge(0);
        cookie.setPath(this.getCookiePath(request));
        response.addCookie(cookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateRandomKey(int length) {
        StringBuilder series = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            Random random = this.random;
            synchronized (random) {
                series.append(CHARS[this.random.nextInt(CHARS.length)]);
                continue;
            }
        }
        return series.toString();
    }

    private String makeTokenSignature(String series, String key, String username) {
        String signature = null;
        try {
            String data = series + ":" + key + ":" + username;
            signature = ByteUtil.toHexString((byte[])HashUtil.generateHash((byte[])data.getBytes("UTF8"), (HashUtil.HashType)HashUtil.HashType.SHA256));
        }
        catch (Exception e) {
            LOGGER.error("Error generating signature", (Throwable)e);
        }
        return signature;
    }

    private String getCookiePath(HttpServletRequest request) {
        if (this.cookiePath != null) {
            return this.cookiePath;
        }
        String contextPath = request.getContextPath();
        return contextPath.length() > 0 ? contextPath : "/";
    }

    private Cookie extractRememberMeCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        String cookieName = this.getCookieName();
        for (Cookie cookie : cookies) {
            if (!cookieName.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }
}

