/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.dao;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.query.Query;
import si.nevensrok.common.dl.CoreDao;
import si.nevensrok.common.dl.ParamsBinder;
import si.nevensrok.common.dl.adapters.database.DatabaseAdapterPool;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.system.CompetitionRole;
import si.nevensrok.jtekma.common.system.User;
import si.nevensrok.jtekma.server.dl.dto.competition.CompetitionDTO;
import si.nevensrok.jtekma.server.dl.dto.system.UserCompetitionRoleDTO;
import si.nevensrok.jtekma.server.dl.dto.system.UserDTO;

public class CompetitionRoleDAO
extends CoreDao {
    protected DatabaseAdapterPool adapterPool;

    public void setDatabaseAdapterPool(DatabaseAdapterPool adapterPool) {
        this.adapterPool = adapterPool;
    }

    public DatabaseAdapterPool getAdapterPool() {
        return this.adapterPool;
    }

    public List<CompetitionRole> getRolesForUser(User user) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select userCompetitionRole,userCompetitionRole.userCompetitionRoleKey.user,userCompetitionRole.userCompetitionRoleKey.competition from UserCompetitionRoleDTO as userCompetitionRole where userCompetitionRole.userCompetitionRoleKey.user.id=");
        sql.append(paramsBinder.addParam(user.getUserId()));
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        LinkedList<CompetitionRole> competitionRoles = new LinkedList<CompetitionRole>();
        List list = query.getResultList();
        for (Object item : list) {
            Object[] parts = (Object[])item;
            UserCompetitionRoleDTO userCompetitionRoleDTO = (UserCompetitionRoleDTO)parts[0];
            CompetitionRole competitionRole = new CompetitionRole();
            competitionRole.setRole(userCompetitionRoleDTO.getRole());
            competitionRole.setUser((User)this.getAdapterPool().create(User.class, parts[1]));
            competitionRole.setCompetition((Competition)this.getAdapterPool().create(Competition.class, parts[2]));
            competitionRoles.add(competitionRole);
        }
        this.flush();
        return competitionRoles;
    }

    public CompetitionRole getRoleForUser(User user, Competition competition) {
        UserDTO userDTO = new UserDTO();
        userDTO.setUserId(user.getUserId());
        CompetitionDTO competitionDTO = new CompetitionDTO();
        competitionDTO.setCompetitionId(competition.getCompetitionId());
        UserCompetitionRoleDTO userCompetitionRoleDTO = (UserCompetitionRoleDTO)this.getCurrentSession().get(UserCompetitionRoleDTO.class, (Serializable)new UserCompetitionRoleDTO.UserCompetitionRoleKey(userDTO, competitionDTO));
        CompetitionRole competitionRole = new CompetitionRole();
        competitionRole.setUser((User)this.getAdapterPool().create(User.class, (Object)userCompetitionRoleDTO.getUserCompetitionRoleKey().getUser()));
        competitionRole.setCompetition((Competition)this.getAdapterPool().create(Competition.class, (Object)userCompetitionRoleDTO.getUserCompetitionRoleKey().getCompetition()));
        competitionRole.setRole(userCompetitionRoleDTO.getRole());
        return competitionRole;
    }

    public void setRolesForUser(User user, List<CompetitionRole> competitionRoles) {
        Competition competition;
        List<CompetitionRole> currentCompetitionRoles = this.getRolesForUser(user);
        for (CompetitionRole competitionRole : competitionRoles) {
            competition = competitionRole.getCompetition();
            CompetitionRole currentAssignedRole = null;
            for (CompetitionRole currentCompetitionRole : currentCompetitionRoles) {
                if (!currentCompetitionRole.getUser().getId().equals(competitionRole.getUser().getId()) || !currentCompetitionRole.getCompetition().getId().equals(competitionRole.getCompetition().getId())) continue;
                currentAssignedRole = currentCompetitionRole;
                break;
            }
            currentCompetitionRoles.remove(currentAssignedRole);
            UserDTO userDTO = new UserDTO();
            userDTO.setUserId(user.getUserId());
            CompetitionDTO competitionDTO = new CompetitionDTO();
            competitionDTO.setCompetitionId(competition.getCompetitionId());
            UserCompetitionRoleDTO userCompetitionRoleDTO = new UserCompetitionRoleDTO(userDTO, competitionDTO);
            userCompetitionRoleDTO.setRole(competitionRole.getRole());
            this.saveInstance(userCompetitionRoleDTO);
        }
        for (CompetitionRole currentCompetitionRole : currentCompetitionRoles) {
            competition = currentCompetitionRole.getCompetition();
            UserDTO userDTO = new UserDTO();
            userDTO.setUserId(user.getUserId());
            CompetitionDTO competitionDTO = new CompetitionDTO();
            competitionDTO.setCompetitionId(competition.getCompetitionId());
            UserCompetitionRoleDTO userCompetitionRoleDTO = new UserCompetitionRoleDTO(userDTO, competitionDTO);
            this.deleteInstance(userCompetitionRoleDTO);
        }
        this.flush();
    }

    public void setCompetitionRole(CompetitionRole competitionRole) {
        UserDTO userDTO = new UserDTO();
        userDTO.setUserId(competitionRole.getUser().getUserId());
        CompetitionDTO competitionDTO = new CompetitionDTO();
        competitionDTO.setCompetitionId(competitionRole.getCompetition().getCompetitionId());
        UserCompetitionRoleDTO userCompetitionRoleDTO = new UserCompetitionRoleDTO(userDTO, competitionDTO);
        userCompetitionRoleDTO.setRole(competitionRole.getRole());
        this.saveInstance(userCompetitionRoleDTO);
        this.flush();
    }

    public void removeCompetitionRole(CompetitionRole competitionRole) {
        UserDTO userDTO = new UserDTO();
        userDTO.setUserId(competitionRole.getUser().getUserId());
        CompetitionDTO competitionDTO = new CompetitionDTO();
        competitionDTO.setCompetitionId(competitionRole.getCompetition().getCompetitionId());
        UserCompetitionRoleDTO userCompetitionRoleDTO = new UserCompetitionRoleDTO(userDTO, competitionDTO);
        this.deleteInstance(userCompetitionRoleDTO);
        this.flush();
    }
}

