/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.embedded;

import java.awt.Desktop;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URI;
import java.util.Locale;
import javax.imageio.ImageIO;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.ClassPathResource;
import si.nevensrok.common.settings.Settings;
import si.nevensrok.common.threads.ThreadUtil;
import si.nevensrok.jtekma.embedded.JettyServer;
import si.nevensrok.jtekma.embedded.gui.CloseWindow;

public class Run {
    private static final Logger LOGGER = LoggerFactory.getLogger(Run.class);
    private static ClassPathXmlApplicationContext applicationContext;
    private static Settings settings;
    private static CloseWindow closeWindow;
    private static JettyServer jettyServer;
    public static final int port = 6683;

    public static void main(String[] args) {
        LOGGER.info("Running embedded JTekma server");
        try {
            applicationContext = new ClassPathXmlApplicationContext("/si/nevensrok/jtekma/embedded/context.xml");
            settings = (Settings)applicationContext.getBean("settings");
            closeWindow = (CloseWindow)applicationContext.getBean("closeWindow");
            Run.setupDerbyConfiguration();
            Run.setupLogFile();
            Run.displayCloseMenu();
            Run.initJetty();
            LOGGER.info("Opening web page");
            Run.openWebPage();
            LOGGER.info("Tomcat server started");
        }
        catch (Exception e) {
            LOGGER.error("Error starting JTekma server", e);
            System.exit(1);
        }
    }

    private static void setupDerbyConfiguration() {
        File derbyDir = new File(settings.getFilesDirectory(), "derbydb");
        derbyDir.mkdirs();
        File derbyLog = new File(settings.getFilesDirectory(), "derby.log");
        System.setProperty("derby.system.home", derbyDir.getAbsolutePath());
        System.setProperty("derby.stream.error.file", derbyLog.getAbsolutePath());
    }

    private static void setupLogFile() throws Exception {
        File logDir = new File(settings.getFilesDirectory(), "log");
        logDir.mkdirs();
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getRootLogger();
        RollingFileAppender fileAppender = new RollingFileAppender();
        fileAppender.setName("logFile");
        fileAppender.setFile(logDir.getAbsolutePath() + File.separator + "jtekma.log", true, true, 1024);
        fileAppender.setMaximumFileSize(0x500000L);
        fileAppender.setMaxBackupIndex(20);
        fileAppender.setEncoding("UTF8");
        PatternLayout patternLayout = new PatternLayout();
        patternLayout.setConversionPattern("[%-5p] [%d] (%t) %c: %m%n");
        fileAppender.setLayout(patternLayout);
        logger.addAppender(fileAppender);
    }

    private static void openWebPage() {
        ThreadUtil.runInBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    Desktop.getDesktop().browse(new URI("http://localhost:6683/"));
                }
                catch (Exception e) {
                    LOGGER.error("Error opening web page", e);
                }
            }
        }, true);
    }

    private static void displayCloseMenu() throws Exception {
        if (SystemTray.isSupported()) {
            closeWindow.setShutdownOnClose(false);
            PopupMenu popupMenu = new PopupMenu();
            MenuItem displayPageItem = new MenuItem(applicationContext.getMessage("text.openBrowser", null, Locale.getDefault()));
            displayPageItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ThreadUtil.runInBackground(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Desktop.getDesktop().browse(new URI("http://localhost:6683/"));
                            }
                            catch (Exception e) {
                                LOGGER.error("Error opening web page", e);
                            }
                        }
                    }, true);
                }
            });
            popupMenu.add(displayPageItem);
            MenuItem closeItem = new MenuItem(applicationContext.getMessage("text.close", null, Locale.getDefault()));
            closeItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Run.shutdown();
                }
            });
            popupMenu.add(closeItem);
            TrayIcon trayIcon = new TrayIcon(ImageIO.read(new ClassPathResource("/si/nevensrok/jtekma/embedded/jjicon.png").getInputStream()), "JTekma2", popupMenu);
            trayIcon.setImageAutoSize(true);
            trayIcon.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 2) {
                        closeWindow.setLocationByPlatform(true);
                        closeWindow.setVisible(true);
                    }
                }
            });
            SystemTray.getSystemTray().add(trayIcon);
        } else {
            closeWindow.setLocationByPlatform(true);
            closeWindow.setVisible(true);
        }
    }

    private static void initJetty() throws Exception {
        jettyServer = new JettyServer();
        jettyServer.start();
    }

    public static void shutdown() {
        LOGGER.info("Closing embedded JTekma server");
        try {
            jettyServer.stop();
            applicationContext.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }
}

