/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import si.nevensrok.common.dl.Pojo;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.ExampleFilter;
import si.nevensrok.common.dl.query.FieldFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.GroupFilter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.common.utils.CollectionUtil;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.CategoryCompetitorCount;
import si.nevensrok.jtekma.common.category.CategoryMatchCount;
import si.nevensrok.jtekma.common.category.Duo2023Category;
import si.nevensrok.jtekma.common.category.DuoCategory;
import si.nevensrok.jtekma.common.category.FightingCategory;
import si.nevensrok.jtekma.common.category.NewazaCategory;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.club.Club;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.competitors.GroupDraw;
import si.nevensrok.jtekma.common.matches.DuoPresentation;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.Rank;
import si.nevensrok.jtekma.common.system.User;
import si.nevensrok.jtekma.server.dl.dao.CategoryDAO;
import si.nevensrok.jtekma.server.management.AgeCategoryOptionManager;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.CategoryTreeUpdateManager;
import si.nevensrok.jtekma.server.management.MatchManager;
import si.nevensrok.jtekma.server.management.TatamiFightsManager;
import si.nevensrok.jtekma.server.management.TreeAdvancmentManager;
import si.nevensrok.jtekma.server.management.WeightCategoryOptionManager;

public class CategoryManagerImpl
implements CategoryManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CategoryManagerImpl.class);
    private CategoryDAO categoryDAO;
    private MatchManager matchManager;
    private TreeAdvancmentManager treeAdvancmentManager;
    private WeightCategoryOptionManager weightCategoryOptionManager;
    private AgeCategoryOptionManager ageCategoryOptionManager;
    private CategoryTreeUpdateManager categoryTreeUpdateManager;
    private TatamiFightsManager tatamiFightsManager;

    public void setCategoryDAO(CategoryDAO categoryDAO) {
        this.categoryDAO = categoryDAO;
    }

    public void setMatchManager(MatchManager matchManager) {
        this.matchManager = matchManager;
    }

    public void setTreeAdvancmentManager(TreeAdvancmentManager treeAdvancmentManager) {
        this.treeAdvancmentManager = treeAdvancmentManager;
    }

    public void setWeightCategoryOptionManager(WeightCategoryOptionManager weightCategoryOptionManager) {
        this.weightCategoryOptionManager = weightCategoryOptionManager;
    }

    public void setAgeCategoryOptionManager(AgeCategoryOptionManager ageCategoryOptionManager) {
        this.ageCategoryOptionManager = ageCategoryOptionManager;
    }

    public void setCategoryTreeUpdateManager(CategoryTreeUpdateManager categoryTreeUpdateManager) {
        this.categoryTreeUpdateManager = categoryTreeUpdateManager;
    }

    public void setTatamiFightsManager(TatamiFightsManager tatamiFightsManager) {
        this.tatamiFightsManager = tatamiFightsManager;
    }

    @Transactional(value="jtekmaTransactionManager")
    public Category createCategory(Category category) {
        LOGGER.debug("Creating category: {}", (Object)category);
        category = (Category)this.categoryDAO.create((Pojo)category);
        LinkedList<Match> matches = new LinkedList<Match>();
        if (category.getType() == Category.Type.FIGHTING) {
            for (int i = 1; i <= 124; ++i) {
                Match match = new Match();
                match.setCategory(category);
                match.setFightNumber(Integer.valueOf(i));
                match.setNoWinner(Boolean.valueOf(false));
                match.setStatus(Match.Status.WAITING);
                match.setType(Match.Type.FIGHT);
                match.setNotNeeded(Boolean.valueOf(true));
                match.setMatchEmpty(Boolean.valueOf(true));
                matches.add(match);
            }
        } else if (category.getType() == Category.Type.DUO) {
            for (int i = 1; i <= 124; ++i) {
                Match match = new Match();
                match.setCategory(category);
                match.setFightNumber(Integer.valueOf(i));
                match.setNoWinner(Boolean.valueOf(false));
                match.setStatus(Match.Status.WAITING);
                match.setType(Match.Type.DUO);
                match.setNotNeeded(Boolean.valueOf(true));
                match.setMatchEmpty(Boolean.valueOf(true));
                matches.add(match);
            }
        } else if (category.getType() == Category.Type.NEWAZA) {
            for (int i = 1; i <= 124; ++i) {
                Match match = new Match();
                match.setCategory(category);
                match.setFightNumber(Integer.valueOf(i));
                match.setNoWinner(Boolean.valueOf(false));
                match.setStatus(Match.Status.WAITING);
                match.setType(Match.Type.NEWAZA);
                match.setNotNeeded(Boolean.valueOf(true));
                match.setMatchEmpty(Boolean.valueOf(true));
                matches.add(match);
            }
        }
        if (CollectionUtil.isNotEmpty(matches)) {
            this.matchManager.createMatches(matches);
        }
        return category;
    }

    @Transactional(value="jtekmaTransactionManager")
    public List<Category> createCategories(List<Category> categories) {
        for (Category category : categories) {
            this.createCategory(category);
        }
        return categories;
    }

    @Transactional(value="jtekmaTransactionManager")
    public Category updateCategory(Category category) {
        LOGGER.debug("Updating category: {}", (Object)category);
        return (Category)this.categoryDAO.update((Pojo)category);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Category updateCategoryFull(Category category) {
        LOGGER.debug("Updating category full data: {}", (Object)category);
        category = (Category)this.categoryDAO.update((Pojo)category);
        if (category instanceof TreeCategory) {
            TreeCategory treeCategory = (TreeCategory)category;
            this.categoryDAO.setCategoryTreeAdvancment(treeCategory, treeCategory.getTreeAdvancment());
        }
        if (category instanceof FightingCategory) {
            FightingCategory fightingCategory = (FightingCategory)category;
            this.categoryDAO.setCategoryWeightCategoryOption(fightingCategory, fightingCategory.getWeightCategoryOption());
            this.categoryDAO.setCategoryAgeCategoryOption(fightingCategory, fightingCategory.getAgeCategoryOption());
        }
        if (category instanceof DuoCategory) {
            DuoCategory duoCategory = (DuoCategory)category;
            this.categoryDAO.setCategoryAgeCategoryOption(duoCategory, duoCategory.getAgeCategoryOption());
        }
        if (category instanceof NewazaCategory) {
            NewazaCategory newazaCategory = (NewazaCategory)category;
            this.categoryDAO.setCategoryWeightCategoryOption(newazaCategory, newazaCategory.getWeightCategoryOption());
            this.categoryDAO.setCategoryAgeCategoryOption(newazaCategory, newazaCategory.getAgeCategoryOption());
        }
        if (category instanceof Duo2023Category) {
            Duo2023Category duo2023Category = (Duo2023Category)category;
            this.categoryDAO.setCategoryAgeCategoryOption(duo2023Category, duo2023Category.getAgeCategoryOption());
        }
        return category;
    }

    @Transactional(value="jtekmaTransactionManager")
    public void deleteCategory(Category category) {
        LOGGER.debug("Deleting category {}", (Object)category);
        this.tatamiFightsManager.removeMatchesForCategory(category);
        category = (Category)this.categoryDAO.getById((Object)category.getCategoryId());
        category.setStatus(Category.Status.DELETED);
        this.categoryDAO.update((Pojo)category);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Category getById(Long categoryId) {
        return (Category)this.categoryDAO.getById((Object)categoryId);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Category getFullById(Long categoryId) {
        Category category = (Category)this.categoryDAO.getById((Object)categoryId);
        if (category instanceof TreeCategory) {
            TreeCategory treeCategory = (TreeCategory)category;
            treeCategory.setTreeAdvancment(this.treeAdvancmentManager.getForCategory(treeCategory));
        }
        if (category instanceof FightingCategory) {
            FightingCategory fightingCategory = (FightingCategory)category;
            fightingCategory.setWeightCategoryOption(this.weightCategoryOptionManager.getForCategory(fightingCategory));
            fightingCategory.setAgeCategoryOption(this.ageCategoryOptionManager.getForCategory(fightingCategory));
        }
        if (category instanceof DuoCategory) {
            DuoCategory duoCategory = (DuoCategory)category;
            duoCategory.setAgeCategoryOption(this.ageCategoryOptionManager.getForCategory(duoCategory));
        }
        if (category instanceof NewazaCategory) {
            NewazaCategory newazaCategory = (NewazaCategory)category;
            newazaCategory.setWeightCategoryOption(this.weightCategoryOptionManager.getForCategory(newazaCategory));
            newazaCategory.setAgeCategoryOption(this.ageCategoryOptionManager.getForCategory(newazaCategory));
        }
        if (category instanceof Duo2023Category) {
            Duo2023Category duo2023Category = (Duo2023Category)category;
            duo2023Category.setAgeCategoryOption(this.ageCategoryOptionManager.getForCategory(duo2023Category));
        }
        return category;
    }

    @Transactional(value="jtekmaTransactionManager")
    public PageDataResult<Category> find(Competition competition, DataFilter dataFilter) {
        GroupFilter rootFilter = new GroupFilter(GroupFilter.Combine.AND);
        rootFilter.addFilter((Filter)new FieldFilter("competition", FieldFilter.Comparator.EQUAL, (Object)competition.getId()));
        rootFilter.addFilter(dataFilter.getFilter());
        ((SimpleDataFilter)dataFilter).setFilter((Filter)rootFilter);
        return this.categoryDAO.find(dataFilter, false);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void deleteEmptyCategories(Competition competition) {
        List<Category> categories = this.getActiveCategoriesForCompetition(competition);
        Map<Category, CategoryCompetitorCount> competitorCount = this.getCategoryCompetitorCount(new HashSet<Category>(categories));
        for (Map.Entry<Category, CategoryCompetitorCount> entry : competitorCount.entrySet()) {
            if (entry.getValue().getAllCompetitors() != 0) continue;
            this.deleteCategory(entry.getKey());
        }
    }

    @Transactional(value="jtekmaTransactionManager")
    public Map<Competitor, Integer> getDraw(Category category) {
        return this.categoryDAO.getDraw(category);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Map<Competitor, GroupDraw> getGroupDraw(Category category) {
        return this.categoryDAO.getGroupDraw(category);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Map<Integer, Competitor> getDrawAsNumber(Category category) {
        Map<Competitor, Integer> draw = this.getDraw(category);
        HashMap<Integer, Competitor> drawAsNumber = new HashMap<Integer, Competitor>();
        for (Map.Entry<Competitor, Integer> entry : draw.entrySet()) {
            drawAsNumber.put(entry.getValue(), entry.getKey());
        }
        return drawAsNumber;
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setDraw(Category category, Map<Competitor, Integer> draw) {
        this.categoryDAO.setDraw(category, draw);
        this.categoryTreeUpdateManager.updateCategory(category);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setGroupDraw(Category category, Map<Competitor, GroupDraw> draw) {
        this.categoryDAO.setGroupDraw(category, draw);
        this.categoryTreeUpdateManager.updateCategory(category);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setPlacings(Category category, Map<Competitor, Integer> placings) {
        this.categoryDAO.setPlacings(category, placings);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setPlacings(Category category, Map<Competitor, Integer> placings, Rank rank) {
        this.categoryDAO.setPlacings(category, placings, rank);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Map<Competitor, Integer> getPlacings(Category category) {
        return this.categoryDAO.getPlacings(category);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Map<Competitor, Integer> getPlacings(Category category, Rank rank) {
        return this.categoryDAO.getPlacings(category, rank);
    }

    @Transactional(value="jtekmaTransactionManager")
    public List<Category> getCategoriesForCompetitor(Competitor competitor) {
        return this.categoryDAO.getCategoriesForCompetitor(competitor);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setCategoryTreeType(TreeCategory category, TreeCategory.TreeType treeType) {
        this.categoryDAO.setCategoryTreeType(category, treeType);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setRepassageType(TreeCategory category, TreeCategory.RepassageType repassageType) {
        this.categoryDAO.setRepassageType(category, repassageType);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setDouble3rdPlace(TreeCategory category, Boolean double3rdPlace) {
        this.categoryDAO.setDouble3rdPlace(category, double3rdPlace);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setRepassageFromRound(TreeCategory category, Integer repassageFromRound) {
        this.categoryDAO.setRepassageFromRound(category, repassageFromRound);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setDouble3rdPlace(Duo2023Category category, Boolean double3rdPlace) {
        this.categoryDAO.setDouble3rdPlace(category, double3rdPlace);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setAdvancedLevel(Duo2023Category category, Boolean advancedLevel) {
        this.categoryDAO.setAdvancedLevel(category, advancedLevel);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setNoviceLevel(Duo2023Category category, Boolean noviceLevel) {
        this.categoryDAO.setNoviceLevel(category, noviceLevel);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Category getCategoryForMatch(Match match) {
        return this.categoryDAO.getCategoryForMatch(match);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Category getCategoryForDuoPresentation(DuoPresentation duoPresentation) {
        return this.categoryDAO.getCategoryForDuoPresentation(duoPresentation);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Category getActiveCategoryByName(Competition competition, String name) {
        return this.categoryDAO.getActiveCategoryByName(competition, name);
    }

    @Transactional(value="jtekmaTransactionManager")
    public boolean hasCompetitorInCategory(Category category, Club club) {
        return this.categoryDAO.hasCompetitorInCategory(category, club);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setShowCategoryForUser(User user, Map<Category, Boolean> categories) {
        this.categoryDAO.setShowCategoryForUser(user, categories);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Map<Category, Boolean> getShowCategoryForUser(User user, Set<Category> categories) {
        return this.categoryDAO.getShowCategoryForUser(user, categories);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Map<Category, CategoryMatchCount> getCategoryMatchCount(Set<Category> categories) {
        return this.categoryDAO.getCategoryMatchCount(categories);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Map<Category, CategoryCompetitorCount> getCategoryCompetitorCount(Set<Category> categories) {
        return this.categoryDAO.getCategoryCompetitorCount(categories);
    }

    @Transactional(value="jtekmaTransactionManager")
    public List<Category> getActiveCategoriesForCompetition(Competition competition) {
        Category example = new Category();
        example.setStatus(Category.Status.ACTIVE);
        example.setCompetition(competition);
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setFetchCount(false);
        dataFilter.setFilter((Filter)new ExampleFilter((Object)example));
        PageDataResult resultPage = this.categoryDAO.find((DataFilter)dataFilter);
        return resultPage.getData();
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setCompetitorsForCategory(Category category, List<Competitor> competitors) {
        this.categoryDAO.setCompetitorsForCategory(category, competitors);
    }

    @Transactional(value="jtekmaTransactionManager")
    public List<Competitor> getCompetitorsForCategory(Category category) {
        return this.categoryDAO.getCompetitorsForCategory(category);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setCategoryAutomationOrder(Competition competition, Map<Category, Integer> categoryAutomationOrder) {
        this.categoryDAO.setCategoryAutomationOrder(competition, categoryAutomationOrder);
    }

    @Transactional(value="jtekmaTransactionManager")
    public List<Category> getCategoriesForAutomation(Competition competition) {
        return this.categoryDAO.getCategoriesForAutomation(competition);
    }
}

