/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.systemsettings;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.FieldFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.GroupFilter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.common.utils.ObjectUtil;
import si.nevensrok.common.web.filter.SearchFilter;
import si.nevensrok.jtekma.common.Gender;
import si.nevensrok.jtekma.common.category.WeightCategoryOption;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.controllers.systemsettings.WeightCategoryOptionModel;
import si.nevensrok.jtekma.server.web.tools.FilterGeneratorTool;

@Controller
@RequestMapping(value={"/system-settings/weight-categories"})
@SessionAttributes(value={"weightCategoryFilter"})
public class WeightCategoryController
extends CoreController {
    public Map<String, String> getGenderOptions(Locale locale) {
        LinkedHashMap<String, String> categoryTypes = new LinkedHashMap<String, String>();
        categoryTypes.put(Gender.MALE.name(), this.getLanguageText(locale, "gender." + Gender.MALE.name()));
        categoryTypes.put(Gender.FEMALE.name(), this.getLanguageText(locale, "gender." + Gender.FEMALE.name()));
        return categoryTypes;
    }

    public Map<String, String> getStatuses(Locale locale) {
        LinkedHashMap<String, String> categoryTypes = new LinkedHashMap<String, String>();
        categoryTypes.put(WeightCategoryOption.Status.ACTIVE.name(), this.getLanguageText(locale, "weightCategories.status." + WeightCategoryOption.Status.ACTIVE.name()));
        categoryTypes.put(WeightCategoryOption.Status.INACTIVE.name(), this.getLanguageText(locale, "weightCategories.status." + WeightCategoryOption.Status.INACTIVE.name()));
        return categoryTypes;
    }

    private void addFormOptions(Model model, Locale locale) {
        model.addAttribute("genderOptions", this.getGenderOptions(locale));
        model.addAttribute("statuses", this.getStatuses(locale));
    }

    @ModelAttribute(value="weightCategoriesActive")
    public Boolean getWeightCategoriesActive() {
        return Boolean.TRUE;
    }

    @ModelAttribute(value="weightCategoryFilter")
    public SearchFilter getSearchFilter() {
        return FilterGeneratorTool.generateDefaultSearchFilter();
    }

    @RequestMapping
    public String list(HttpServletRequest request, Model model, @ModelAttribute(value="weightCategoryFilter") SearchFilter searchFilter, @RequestParam(value="messageCode", required=false, defaultValue="0") Integer messageCode) {
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        GroupFilter rootFilter = new GroupFilter(GroupFilter.Combine.AND);
        dataFilter.setFilter((Filter)rootFilter);
        GroupFilter statusFilter = new GroupFilter(GroupFilter.Combine.OR);
        rootFilter.addFilter((Filter)statusFilter);
        statusFilter.addFilter((Filter)new FieldFilter("status", FieldFilter.Comparator.EQUAL, (Object)WeightCategoryOption.Status.ACTIVE));
        statusFilter.addFilter((Filter)new FieldFilter("status", FieldFilter.Comparator.EQUAL, (Object)WeightCategoryOption.Status.INACTIVE));
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("gender", Sort.Field.Direction.ASC));
        dataFilter.getSort().addField(new Sort.Field("isAbsolute", Sort.Field.Direction.ASC));
        dataFilter.getSort().addField(new Sort.Field("weight", Sort.Field.Direction.ASC));
        dataFilter.setItemCountPerPage(searchFilter.getShowPerPage().intValue());
        dataFilter.setPage(searchFilter.getPage().intValue());
        PageDataResult dataResult = this.getManagersList().getWeightCategoryOptionManager().find((DataFilter)dataFilter);
        model.addAttribute("weightCategories", (Object)dataResult.getData());
        model.addAttribute("totalPages", (Object)dataResult.getPageCount(true));
        if (messageCode.equals(1)) {
            model.addAttribute("message", (Object)this.getLanguageText(RequestContextUtils.getLocale((HttpServletRequest)request), "weightCategories.text.added"));
        } else if (messageCode.equals(2)) {
            model.addAttribute("message", (Object)this.getLanguageText(RequestContextUtils.getLocale((HttpServletRequest)request), "weightCategories.text.updated"));
        } else if (messageCode.equals(3)) {
            model.addAttribute("message", (Object)this.getLanguageText(RequestContextUtils.getLocale((HttpServletRequest)request), "weightCategories.text.deleted"));
        }
        return "system-settings/weight-category-list";
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(HttpServletRequest request, Model model, @ModelAttribute(value="weightCategoryOption") WeightCategoryOptionModel weightCategoryOptionModel, BindingResult bindingResult) {
        model.addAttribute("adding", (Object)true);
        if (!bindingResult.hasErrors()) {
            weightCategoryOptionModel.setGender(Gender.MALE);
            weightCategoryOptionModel.setIsAbsolute(Boolean.FALSE);
            weightCategoryOptionModel.setStatus(WeightCategoryOption.Status.ACTIVE);
            weightCategoryOptionModel.setWeight(62);
        }
        this.addFormOptions(model, RequestContextUtils.getLocale((HttpServletRequest)request));
        return "system-settings/weight-category-edit";
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public String addPost(HttpServletRequest request, Model model, @ModelAttribute(value="weightCategoryOption") @Valid WeightCategoryOptionModel weightCategoryOptionModel, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return this.add(request, model, weightCategoryOptionModel, bindingResult);
        }
        WeightCategoryOption weightCategoryOption = new WeightCategoryOption();
        ObjectUtil.copyNotNullProperties((Object)weightCategoryOptionModel, (Object)weightCategoryOption);
        weightCategoryOption = this.getManagersList().getWeightCategoryOptionManager().createWeightCategoryOption(weightCategoryOption);
        return "redirect:/system-settings/weight-categories?messageCode=1";
    }

    @RequestMapping(value={"/edit/{weightCategoryId}"}, method={RequestMethod.GET})
    public String edit(HttpServletRequest request, Model model, @PathVariable(value="weightCategoryId") Long weightCategoryId, @ModelAttribute(value="weightCategoryOption") WeightCategoryOptionModel weightCategoryOptionModel, BindingResult bindingResult) {
        WeightCategoryOption weightCategoryOption = this.getManagersList().getWeightCategoryOptionManager().getById(weightCategoryId);
        ObjectUtil.copyNotNullProperties((Object)weightCategoryOption, (Object)weightCategoryOptionModel);
        this.addFormOptions(model, RequestContextUtils.getLocale((HttpServletRequest)request));
        return "system-settings/weight-category-edit";
    }

    @RequestMapping(value={"/edit/{weightCategoryId}"}, method={RequestMethod.POST})
    public String editPost(HttpServletRequest request, Model model, @PathVariable(value="weightCategoryId") Long weightCategoryId, @ModelAttribute(value="weightCategoryOption") @Valid WeightCategoryOptionModel weightCategoryOptionModel, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return this.edit(request, model, weightCategoryId, weightCategoryOptionModel, bindingResult);
        }
        WeightCategoryOption weightCategoryOption = this.getManagersList().getWeightCategoryOptionManager().getById(weightCategoryId);
        ObjectUtil.copyNotNullProperties((Object)weightCategoryOptionModel, (Object)weightCategoryOption);
        weightCategoryOption = this.getManagersList().getWeightCategoryOptionManager().updateWeightCategoryOption(weightCategoryOption);
        return "redirect:/system-settings/weight-categories?messageCode=2";
    }

    @RequestMapping(value={"/delete/{weightCategoryId}"})
    public String delete(HttpServletRequest request, Model model, @PathVariable(value="weightCategoryId") Long weightCategoryId) {
        WeightCategoryOption weightCategoryOption = this.getManagersList().getWeightCategoryOptionManager().getById(weightCategoryId);
        weightCategoryOption.setStatus(WeightCategoryOption.Status.DELETED);
        weightCategoryOption = this.getManagersList().getWeightCategoryOptionManager().updateWeightCategoryOption(weightCategoryOption);
        return "redirect:/system-settings/weight-categories?messageCode=3";
    }
}

