/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.data;

import java.text.Normalizer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.ExampleFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.common.utils.ObjectUtil;
import si.nevensrok.common.web.filter.SearchFilter;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.system.Right;
import si.nevensrok.jtekma.common.tatami.Semaphore;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.common.tatami.TatamiOnSemaphore;
import si.nevensrok.jtekma.server.dataimport.DataImportException;
import si.nevensrok.jtekma.server.dataimport.FileType;
import si.nevensrok.jtekma.server.web.common.ImportDataModel;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.controllers.data.SemaphoreModel;
import si.nevensrok.jtekma.server.web.security.ForbiddenException;
import si.nevensrok.jtekma.server.web.security.MethodRight;
import si.nevensrok.jtekma.server.web.tools.FilterGeneratorTool;

@Controller
@RequestMapping(value={"/data/semaphores"})
@SessionAttributes(value={"semaphoreListFilter"})
public class SemaphoreController
extends CoreController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SemaphoreController.class);

    @ModelAttribute(value="semaphoresActive")
    public Boolean getSemaphoresActive() {
        return Boolean.TRUE;
    }

    @ModelAttribute(value="semaphoreListFilter")
    public SearchFilter getSearchFilter() {
        return FilterGeneratorTool.generateDefaultSearchFilter();
    }

    @ModelAttribute(value="editRights")
    public Boolean getEditRights() {
        return this.hasRights(Right.SEMAPHOREEDIT);
    }

    @ModelAttribute(value="fileTypes")
    public Map<FileType, String> getFileTypes(HttpServletRequest request) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        LinkedHashMap<FileType, String> importType = new LinkedHashMap<FileType, String>();
        importType.put(FileType.CSV, this.getLanguageText(locale, "filetypes.csv"));
        importType.put(FileType.ODS, this.getLanguageText(locale, "filetypes.ods"));
        importType.put(FileType.XLS, this.getLanguageText(locale, "filetypes.xls"));
        importType.put(FileType.XLSX, this.getLanguageText(locale, "filetypes.xlsx"));
        return importType;
    }

    @RequestMapping
    public String list(HttpServletRequest request, Model model, @ModelAttribute(value="semaphoreListFilter") SearchFilter searchFilter, @RequestParam(value="messageCode", required=false, defaultValue="0") Integer messageCode) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        Semaphore example = new Semaphore();
        example.setName("%" + searchFilter.getSearch().trim() + "%");
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setFilter((Filter)new ExampleFilter((Object)example));
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        dataFilter.setItemCountPerPage(searchFilter.getShowPerPage().intValue());
        dataFilter.setPage(searchFilter.getPage().intValue());
        model.addAttribute("currentPage", (Object)searchFilter.getPage());
        PageDataResult dataResult = this.getManagersList().getSemaphoreManager().find(this.getUserData().getCompetition(), (DataFilter)dataFilter);
        model.addAttribute("semaphores", (Object)dataResult.getData());
        model.addAttribute("totalPages", (Object)dataResult.getPageCount(true));
        if (messageCode.equals(1)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "semaphores.text.added"));
        } else if (messageCode.equals(2)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "semaphores.text.updated"));
        } else if (messageCode.equals(3)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "semaphores.text.deleted"));
        } else if (messageCode.equals(4)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "semaphores.text.tatamisSet"));
        } else if (messageCode.equals(5)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "semaphores.text.imported"));
        }
        return "data/semaphore-list";
    }

    @MethodRight(value={Right.SEMAPHOREEDIT})
    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(HttpServletRequest request, Model model, @ModelAttribute(value="semaphore") SemaphoreModel semaphoreModel, BindingResult bindingResult) {
        model.addAttribute("adding", (Object)true);
        if (!bindingResult.hasErrors()) {
            semaphoreModel.setDisplayRows(1);
        }
        return "data/semaphore-edit";
    }

    @MethodRight(value={Right.SEMAPHOREEDIT})
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public String addPost(HttpServletRequest request, Model model, @ModelAttribute(value="semaphore") @Valid SemaphoreModel semaphoreModel, BindingResult bindingResult) {
        if (semaphoreModel.getPassword() == null || semaphoreModel.getPassword().isEmpty()) {
            bindingResult.rejectValue("password", "common.error.dataNotEntered");
        }
        if (bindingResult.hasErrors()) {
            return this.add(request, model, semaphoreModel, bindingResult);
        }
        Semaphore semaphore = new Semaphore();
        ObjectUtil.copyNotNullProperties((Object)semaphoreModel, (Object)semaphore);
        semaphore.setCompetition(this.getUserData().getCompetition());
        semaphore = this.getManagersList().getSemaphoreManager().createSemaphore(semaphore);
        return "redirect:/data/semaphores?messageCode=1";
    }

    @MethodRight(value={Right.SEMAPHOREEDIT})
    @RequestMapping(value={"/edit/{semaphoreId}"}, method={RequestMethod.GET})
    public String edit(HttpServletRequest request, Model model, @PathVariable(value="semaphoreId") Long semaphoreId, @ModelAttribute(value="semaphore") SemaphoreModel semaphoreModel, BindingResult bindingResult) {
        Semaphore semaphore = this.getManagersList().getSemaphoreManager().getById(semaphoreId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForSemaphore(semaphore).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        ObjectUtil.copyNotNullProperties((Object)semaphore, (Object)semaphoreModel);
        semaphoreModel.setPassword("");
        return "data/semaphore-edit";
    }

    @MethodRight(value={Right.SEMAPHOREEDIT})
    @RequestMapping(value={"/edit/{semaphoreId}"}, method={RequestMethod.POST})
    public String editPost(HttpServletRequest request, Model model, @PathVariable(value="semaphoreId") Long semaphoreId, @ModelAttribute(value="semaphore") @Valid SemaphoreModel semaphoreModel, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return this.edit(request, model, semaphoreId, semaphoreModel, bindingResult);
        }
        Semaphore semaphore = this.getManagersList().getSemaphoreManager().getById(semaphoreId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForSemaphore(semaphore).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        ObjectUtil.copyNotNullProperties((Object)semaphoreModel, (Object)semaphore);
        semaphore = this.getManagersList().getSemaphoreManager().updateSemaphore(semaphore);
        if (semaphoreModel.getPassword() != null && !semaphoreModel.getPassword().isEmpty()) {
            semaphore.setPassword(semaphoreModel.getPassword());
            this.getManagersList().getSemaphoreManager().updateSemaphorePassword(semaphore);
        }
        return "redirect:/data/semaphores?messageCode=2";
    }

    @MethodRight(value={Right.SEMAPHOREEDIT})
    @RequestMapping(value={"/delete/{semaphoreId}"})
    public String delete(HttpServletRequest request, Model model, @PathVariable(value="semaphoreId") Long semaphoreId) {
        Semaphore semaphore = this.getManagersList().getSemaphoreManager().getById(semaphoreId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForSemaphore(semaphore).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        this.getManagersList().getSemaphoreManager().deleteSemaphore(semaphore);
        return "redirect:/data/semaphores?messageCode=3";
    }

    @MethodRight(value={Right.SEMAPHOREEDIT})
    @RequestMapping(value={"/tatamis/{semaphoreId}"}, method={RequestMethod.GET})
    public String categories(HttpServletRequest request, Model model, @PathVariable(value="semaphoreId") Long semaphoreId) {
        Semaphore semaphore = this.getManagersList().getSemaphoreManager().getById(semaphoreId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForSemaphore(semaphore).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        model.addAttribute("semaphore", (Object)semaphore);
        HashMap<Long, Integer> currentTatamis = new HashMap<Long, Integer>();
        for (TatamiOnSemaphore tatamiOnSemaphore : this.getManagersList().getSemaphoreManager().getTatamisForSemaphore(semaphore)) {
            currentTatamis.put(tatamiOnSemaphore.getTatami().getTatamiId(), tatamiOnSemaphore.getOrderNum());
        }
        model.addAttribute("currentTatamis", currentTatamis);
        Tatami example = new Tatami();
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setFilter((Filter)new ExampleFilter((Object)example));
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        PageDataResult dataResult = this.getManagersList().getTatamiManager().find(this.getUserData().getCompetition(), (DataFilter)dataFilter);
        model.addAttribute("tatamis", (Object)dataResult.getData());
        return "data/semaphore-tatamis";
    }

    @MethodRight(value={Right.SEMAPHOREEDIT})
    @RequestMapping(value={"/tatamis/{semaphoreId}"}, method={RequestMethod.POST})
    public String categoriesPost(HttpServletRequest request, Model model, @PathVariable(value="semaphoreId") Long semaphoreId) {
        Semaphore semaphore = this.getManagersList().getSemaphoreManager().getById(semaphoreId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForSemaphore(semaphore).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        HashSet<TatamiOnSemaphore> tatamiOnSemaphores = new HashSet<TatamiOnSemaphore>();
        Map parameters = request.getParameterMap();
        for (String key : parameters.keySet()) {
            if (!key.startsWith("tatami_")) continue;
            Long tatamiId = Long.parseLong(key.split("_")[1]);
            Integer orderNum = 0;
            if (parameters.containsKey("tatamiorder_" + tatamiId) && ((String[])parameters.get("tatamiorder_" + tatamiId))[0] != null && !((String[])parameters.get("tatamiorder_" + tatamiId))[0].isEmpty()) {
                orderNum = Integer.parseInt(((String[])parameters.get("tatamiorder_" + tatamiId))[0]);
            }
            Tatami tatami = new Tatami();
            tatami.setTatamiId(tatamiId);
            TatamiOnSemaphore tatamiOnSemaphore = new TatamiOnSemaphore();
            tatamiOnSemaphore.setSemaphore(semaphore);
            tatamiOnSemaphore.setTatami(tatami);
            tatamiOnSemaphore.setOrderNum(orderNum);
            tatamiOnSemaphores.add(tatamiOnSemaphore);
        }
        this.getManagersList().getSemaphoreManager().setTatamisForSemaphore(semaphore, tatamiOnSemaphores);
        return "redirect:/data/semaphores?messageCode=4";
    }

    @MethodRight(value={Right.SEMAPHOREEDIT})
    @RequestMapping(value={"/import"}, method={RequestMethod.GET})
    public String importData(HttpServletRequest request, Model model, @ModelAttribute(value="data") ImportDataModel importDataModel) {
        return "data/semaphore-import";
    }

    @MethodRight(value={Right.SEMAPHOREEDIT})
    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    public String importDataPost(HttpServletRequest request, Model model, @ModelAttribute(value="data") ImportDataModel importDataModel) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        try {
            List semaphores = this.getManagersList().getSemaphoreImporter().parseSemaphores(importDataModel.getFileType(), importDataModel.getFile().getBytes());
            this.getManagersList().getSemaphoreImporter().importSemaphores(this.getUserData().getCompetition(), semaphores);
            return "redirect:/data/semaphores?messageCode=5";
        }
        catch (DataImportException e) {
            if (e.getErrorType() == DataImportException.ErrorType.NoSemaphoreName) {
                model.addAttribute("errorText", (Object)this.getLanguageText(locale, "semaphores.error.noSemaphoreName"));
                return this.importData(request, model, importDataModel);
            }
            if (e.getErrorType() == DataImportException.ErrorType.NoSemaphorePassword) {
                model.addAttribute("errorText", (Object)this.getLanguageText(locale, "semaphores.error.noSemaphorePassword"));
                return this.importData(request, model, importDataModel);
            }
            LOGGER.error("Error while reading semaphore data", (Throwable)e);
            model.addAttribute("errorText", (Object)this.getLanguageText(locale, "semaphores.error.importError"));
            return this.importData(request, model, importDataModel);
        }
        catch (Exception e) {
            LOGGER.error("Error while reading semaphore data", (Throwable)e);
            model.addAttribute("errorText", (Object)this.getLanguageText(locale, "semaphores.error.importError"));
            return this.importData(request, model, importDataModel);
        }
    }

    @RequestMapping(value={"/export/{fileType}"})
    public void exportData(HttpServletRequest request, HttpServletResponse response, Model model, @PathVariable(value="fileType") FileType fileType) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Competition competition = this.getUserData().getCompetition();
        String fileName = competition.getName() + "-" + this.getLanguageText(locale, "semaphores.export.fileName");
        if (fileType == FileType.CSV) {
            fileName = fileName + ".csv";
            response.setContentType("text/csv");
        } else if (fileType == FileType.ODS) {
            fileName = fileName + ".ods";
            response.setContentType("application/vnd.oasis.opendocument.spreadsheet");
        } else if (fileType == FileType.XLS) {
            fileName = fileName + ".xls";
            response.setContentType("application/vnd.ms-excel");
        } else if (fileType == FileType.XLSX) {
            fileName = fileName + ".xlsx";
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        }
        fileName = Normalizer.normalize(fileName, Normalizer.Form.NFD).replaceAll("[^\\p{Alnum}\\x20\\x2B\\x2D\\x2E\\x5F]", "");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        List semaphores = this.getManagersList().getSemaphoreManager().find(competition, (DataFilter)new SimpleDataFilter()).getData();
        String[] header = new String[]{this.getLanguageText(locale, "semaphores.export.semaphore"), this.getLanguageText(locale, "semaphores.export.password"), this.getLanguageText(locale, "semaphores.export.rows")};
        try {
            byte[] data = this.getManagersList().getSemaphoreImporter().exportSemaphores(fileType, semaphores, header);
            response.getOutputStream().write(data);
            response.getOutputStream().close();
        }
        catch (Exception e) {
            LOGGER.error("Error writeing to output stream", (Throwable)e);
        }
    }
}

