/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.competition;

import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import si.nevensrok.jtekma.common.system.CompetitionRole;
import si.nevensrok.jtekma.common.system.Right;
import si.nevensrok.jtekma.common.system.User;
import si.nevensrok.jtekma.server.web.common.competition.Competition;
import si.nevensrok.jtekma.server.web.controllers.CoreController;

@Controller
@RequestMapping(value={"/competition/data"})
public class CompetitionDataController
extends CoreController {
    @RequestMapping(value={"/current-competition"}, method={RequestMethod.GET})
    @ResponseBody
    public Competition getCurrentCompetition(HttpServletResponse response) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        User user = this.getUserData().getLoginedUser();
        Competition competition = new Competition(this.getUserData().getCompetition());
        competition.setCanManage(false);
        if (user.getIsSuperAdmin() != null && user.getIsSuperAdmin().booleanValue()) {
            competition.setCanManage(true);
        } else {
            CompetitionRole competitionRole = this.getManagersList().getUserManager().getRoleForUser(user, this.getUserData().getCompetition());
            if (competitionRole != null) {
                competition.setCanManage(this.getManagersList().getRightManager().hasRights(competitionRole.getRole(), Right.LEADCOMPETITION));
            }
        }
        return competition;
    }
}

