/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.broadcaster;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.network.NetworkMessage;
import si.nevensrok.common.network.NetworkMessageHandler;
import si.nevensrok.common.network.QueueNetworkMessageHandler;
import si.nevensrok.common.network.udp.UdpMessageReceiver;
import si.nevensrok.common.network.udp.UdpMessageSender;
import si.nevensrok.jtekma.utils.broadcaster.FindServer;
import si.nevensrok.jtekma.utils.broadcaster.ServerInfo;

public class ServerBroadcaster
implements InitializingBean,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerBroadcaster.class);
    private boolean enable = false;
    private int port = 12701;
    private String address;
    private UdpMessageReceiver udpMessageReceiver = null;
    private QueueNetworkMessageHandler messageHandler = new QueueNetworkMessageHandler();

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.enable) {
            this.udpMessageReceiver = new UdpMessageReceiver();
            this.udpMessageReceiver.setPort(Integer.valueOf(this.port));
            this.udpMessageReceiver.setNetworkMessageHandler((NetworkMessageHandler)this.messageHandler);
            this.udpMessageReceiver.afterPropertiesSet();
            Thread thread = new Thread("Server broadcaster listener thread"){

                @Override
                public void run() {
                    LOGGER.info("Starting JTekma server broadcast listener on port {}", (Object)ServerBroadcaster.this.port);
                    while (ServerBroadcaster.this.udpMessageReceiver != null) {
                        UdpMessageSender udpMessageSender = null;
                        try {
                            NetworkMessage networkMessage = ServerBroadcaster.this.messageHandler.receiveMessage();
                            Object data = networkMessage.getObject();
                            if (!(data instanceof FindServer)) continue;
                            FindServer findServer = (FindServer)data;
                            ServerInfo serverInfo = new ServerInfo();
                            serverInfo.setAddress(ServerBroadcaster.this.address);
                            udpMessageSender = new UdpMessageSender();
                            udpMessageSender.setAddress(networkMessage.getSender().getHostAddress());
                            udpMessageSender.setPort(findServer.getResponsePort());
                            udpMessageSender.afterPropertiesSet();
                            udpMessageSender.sendMessage((Object)serverInfo);
                            udpMessageSender.destroy();
                        }
                        catch (Exception e) {
                            try {
                                udpMessageSender.destroy();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            LOGGER.debug("Error handling server broadcast message", (Throwable)e);
                        }
                    }
                    LOGGER.info("Stopping JTekma server broadcast listener on port {}", (Object)ServerBroadcaster.this.port);
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
    }

    public void destroy() throws Exception {
        if (this.udpMessageReceiver != null) {
            this.udpMessageReceiver.destroy();
        }
        this.udpMessageReceiver = null;
    }
}

