/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ssl;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.ssl.CertificateAndKeyRepository;

public class KeystoreCertificateRepository
implements CertificateAndKeyRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeystoreCertificateRepository.class);
    private KeyStore keyStore;
    private char[] password;

    public KeystoreCertificateRepository() {
    }

    public KeystoreCertificateRepository(KeyStore keyStore) {
        this.keyStore = keyStore;
        this.password = "changeit".toCharArray();
    }

    public KeystoreCertificateRepository(KeyStore keyStore, String password) {
        this.keyStore = keyStore;
        if (password != null) {
            this.password = password.toCharArray();
        }
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public void setPassword(String password) {
        this.password = (char[])(password != null ? password.toCharArray() : null);
    }

    @Override
    public boolean isPrivateKeyPresent(String alias) {
        try {
            return this.keyStore.isKeyEntry(alias);
        }
        catch (Exception e) {
            LOGGER.error("Error checking for private key", (Throwable)e);
            return false;
        }
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        try {
            return (PrivateKey)this.keyStore.getKey(alias, this.password);
        }
        catch (Exception e) {
            LOGGER.error("Error fetching private key", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<String> getAliasesWithPrivateKey() {
        LinkedList<String> aliases = new LinkedList<String>();
        try {
            Enumeration<String> aliasEnumeration = this.keyStore.aliases();
            while (aliasEnumeration.hasMoreElements()) {
                String alias = aliasEnumeration.nextElement();
                if (!this.keyStore.isKeyEntry(alias)) continue;
                aliases.add(alias);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error fetching aliases with private key", (Throwable)e);
            return null;
        }
        return aliases;
    }

    @Override
    public boolean isCertificatePresent(String alias) {
        try {
            return this.keyStore.isCertificateEntry(alias) || this.keyStore.isKeyEntry(alias);
        }
        catch (Exception e) {
            LOGGER.error("Error checking for certificate", (Throwable)e);
            return false;
        }
    }

    @Override
    public Certificate getCertificate(String alias) {
        try {
            return this.keyStore.getCertificate(alias);
        }
        catch (Exception e) {
            LOGGER.error("Error fetching certificate", (Throwable)e);
            return null;
        }
    }

    @Override
    public Certificate[] getCertificateChain(String alias) {
        try {
            if (this.keyStore.isKeyEntry(alias)) {
                return this.keyStore.getCertificateChain(alias);
            }
            return new Certificate[]{this.keyStore.getCertificate(alias)};
        }
        catch (Exception e) {
            LOGGER.error("Error fetching certificate chain", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<String> getAliases() {
        LinkedList<String> aliases = new LinkedList<String>();
        try {
            Enumeration<String> aliasEnumeration = this.keyStore.aliases();
            while (aliasEnumeration.hasMoreElements()) {
                String alias = aliasEnumeration.nextElement();
                aliases.add(alias);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error fetching aliases with private key", (Throwable)e);
            return null;
        }
        return aliases;
    }
}

