/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.logging.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public final class LoggingUtil {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS Z";

    private LoggingUtil() {
    }

    public static String debugCalendar(Date date) {
        if (date == null) {
            return "null";
        }
        return new SimpleDateFormat(DATE_FORMAT).format(date);
    }

    public static String debugCalendar(Calendar calendar) {
        if (calendar == null) {
            return "null";
        }
        return new SimpleDateFormat(DATE_FORMAT).format(calendar.getTime());
    }

    public static String debugBytes(byte[] data) {
        if (data == null) {
            return "null";
        }
        StringBuilder text = new StringBuilder();
        text.append("byte [length=");
        text.append(data.length);
        text.append("]");
        return text.toString();
    }

    public static String debugPassword(String password) {
        if (password == null) {
            return "null";
        }
        return "*****";
    }

    public static String debugObject(Object obj) {
        if (obj == null) {
            return "null";
        }
        return obj.getClass().getName() + "@" + obj.hashCode();
    }

    public static String getStackTrace(Throwable e) {
        StringWriter buffer = new StringWriter();
        e.printStackTrace(new PrintWriter(buffer));
        return buffer.getBuffer().toString();
    }
}

