/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.horizontal;

import java.awt.Color;
import java.awt.EventQueue;
import javax.swing.JLabel;
import javax.swing.JPanel;
import si.nevensrok.common.utils.StringUtil;
import si.nevensrok.jtekma.common.matches.Rank;
import si.nevensrok.jtekma.tabla.common.Constants;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.common.TableType;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.util.FontSizeUtil;

public class CategoryPanel
extends JPanel {
    private JLabel categoryNameLabel = new JLabel();
    private JLabel additionalTextLabel = new JLabel();
    private MatchData matchData;
    private TablaManager tablaManager;

    public CategoryPanel() {
        this.setLayout(null);
        this.add(this.categoryNameLabel);
        this.add(this.additionalTextLabel);
        this.categoryNameLabel.setHorizontalAlignment(0);
        this.additionalTextLabel.setHorizontalAlignment(0);
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.tablaManager = tablaManager;
    }

    public void redrawElements() {
        final int width = this.getWidth();
        final int height = this.getHeight();
        final int offsetTop = (int)Math.round((double)height * 0.05);
        final String additionalText = this.getAdditionalText();
        final int categoryNameHeight = StringUtil.isEmpty((String)additionalText) ? height : (int)Math.floor((float)height * 0.7f);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CategoryPanel.this.categoryNameLabel.setLocation(0, offsetTop);
                CategoryPanel.this.categoryNameLabel.setSize(width, categoryNameHeight);
                if (StringUtil.isEmpty((String)additionalText)) {
                    CategoryPanel.this.additionalTextLabel.setLocation(0, 0);
                    CategoryPanel.this.additionalTextLabel.setSize(0, 0);
                } else {
                    CategoryPanel.this.additionalTextLabel.setLocation(0, categoryNameHeight);
                    CategoryPanel.this.additionalTextLabel.setSize(width, height - categoryNameHeight);
                    CategoryPanel.this.additionalTextLabel.setText(additionalText);
                    FontSizeUtil.refitFontSize(Constants.FONT, CategoryPanel.this.additionalTextLabel);
                }
                CategoryPanel.this.categoryNameLabel.setText(CategoryPanel.this.matchData.getCategory());
                FontSizeUtil.refitFontSize(Constants.FONT, CategoryPanel.this.categoryNameLabel);
            }
        });
    }

    private String getAdditionalText() {
        if (this.matchData.getTableType() == TableType.DUO2023 || this.matchData.getTableType() == TableType.DUO_PRESENTATION) {
            StringBuilder additionalText = new StringBuilder();
            additionalText.append(this.tablaManager.getLanguageText("text.round"));
            additionalText.append(" ");
            additionalText.append(this.matchData.getRound().ordinal() + 1);
            additionalText.append(", ");
            if (this.matchData.getRank() == Rank.WORLD_LEVEL) {
                additionalText.append(this.tablaManager.getLanguageText("text.worldLevel"));
            } else if (this.matchData.getRank() == Rank.ADVANCED) {
                additionalText.append(this.tablaManager.getLanguageText("text.advancedLevel"));
            } else if (this.matchData.getRank() == Rank.NOVICE) {
                additionalText.append(this.tablaManager.getLanguageText("text.noviceLevel"));
            }
            return additionalText.toString();
        }
        return null;
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.categoryNameLabel != null) {
            this.categoryNameLabel.setBackground(bg);
        }
        if (this.additionalTextLabel != null) {
            this.additionalTextLabel.setBackground(bg);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.categoryNameLabel != null) {
            this.categoryNameLabel.setForeground(fg);
        }
        if (this.additionalTextLabel != null) {
            this.additionalTextLabel.setForeground(fg);
        }
    }
}

