/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.duo;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.tabla.common.Duo2023Points;
import si.nevensrok.jtekma.tabla.fw.TablaManager;

public class Duo2023PenaltyDocument
extends PlainDocument {
    private CompetitorType competitorType;
    private Duo2023Points duo2023Points;
    private TablaManager tablaManager;

    public Duo2023PenaltyDocument(CompetitorType competitorType, Duo2023Points duo2023Points, TablaManager tablaManager) {
        this.competitorType = competitorType;
        this.duo2023Points = duo2023Points;
        this.tablaManager = tablaManager;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        try {
            int newNum;
            StringBuffer buffer = new StringBuffer(this.getText(0, this.getLength()));
            buffer.insert(offs, str);
            if (buffer.length() > 1 && buffer.charAt(0) == '0') {
                super.remove(0, 1);
                buffer.deleteCharAt(0);
            }
            if ((newNum = Integer.parseInt(buffer.toString())) >= 0 && newNum <= 9) {
                super.insertString(0, str, a);
                this.updatePoints();
                this.tablaManager.recalculatePoints();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        try {
            StringBuffer buffer = new StringBuffer(this.getText(0, this.getLength()));
            buffer.delete(offs, offs + len);
            if (buffer.length() == 0) {
                super.remove(offs, len);
                if (this.competitorType == CompetitorType.COMPETITOR1) {
                    this.duo2023Points.setPenalty1(0);
                } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                    this.duo2023Points.setPenalty2(0);
                }
                this.tablaManager.recalculatePoints();
            } else {
                int newNum = Integer.parseInt(buffer.toString());
                if (newNum >= 0 && newNum <= 9) {
                    super.remove(offs, len);
                    this.updatePoints();
                    this.tablaManager.recalculatePoints();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updatePoints() throws NumberFormatException, BadLocationException {
        if (this.competitorType == CompetitorType.COMPETITOR1) {
            this.duo2023Points.setPenalty1(Integer.parseInt(super.getText(0, super.getLength())));
        } else if (this.competitorType == CompetitorType.COMPETITOR2) {
            this.duo2023Points.setPenalty2(Integer.parseInt(super.getText(0, super.getLength())));
        }
    }
}

