/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import si.nevensrok.common.utils.StringUtil;
import si.nevensrok.jtekma.common.category.AgeCategoryOption;
import si.nevensrok.jtekma.common.management.RulesManager;
import si.nevensrok.jtekma.common.matches.Rank;
import si.nevensrok.jtekma.common.matches.Round;
import si.nevensrok.jtekma.common.rules.DuoPresentationAttack;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.gui.TablaWindow;
import si.nevensrok.jtekma.tabla.httpserver.HttpServer;

public class SettingsDialog
extends JDialog
implements ApplicationContextAware,
InitializingBean,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(SettingsDialog.class);
    private static final int LABEL_WIDTH = 290;
    private static final int LABEL_HEIGHT = 20;
    private static final int FIELD_WIDTH = 200;
    private static final int FIELD_HEIGHT = 20;
    private static final int PANEL_HORIZONTAL_GAP = 10;
    private static final int PANEL_VERTICAL_GAP = 5;
    private NumberFormat secondsNumberFormat = new DecimalFormat("00");
    private ApplicationContext applicationContext;
    private MatchData matchData;
    private TablaWindow tablaWindow;
    private RulesManager rulesManager;
    private TablaManager tablaManager;
    private HttpServer httpServer;
    private JButton saveButton = new JButton("Save");
    private JButton cancelButton = new JButton("Cancel");
    private JLabel matchTimeLabel = new JLabel("Default match time");
    private JTextField matchTimeField = new JTextField();
    private JLabel hosekomiTimeLabel = new JLabel("Hosekomi time");
    private JTextField hosekomiTimeField = new JTextField();
    private JLabel newazaHansokumakePenaltiesLabel = new JLabel("Ne waza hansokumake penalties");
    private JTextField newazaHansokumakePenaltiesField = new JTextField();
    private JLabel rulesLabel = new JLabel("Rules");
    private JComboBox<String> rulesComboBox = new JComboBox();
    private JLabel roundLabel = new JLabel("Round");
    private JComboBox<String> roundComboBox = new JComboBox();
    private JLabel rankLabel = new JLabel("Rank");
    private JComboBox<String> rankComboBox = new JComboBox();
    private JLabel ageLabel = new JLabel("Age");
    private JTextField ageLabelField = new JTextField("22");
    private JLabel duoJudgesLabel = new JLabel("Duo judges");
    private JComboBox<String> duoJudgesComboBox = new JComboBox();
    private JLabel languageLabel = new JLabel("Language");
    private JComboBox<String> languagesComboBox = new JComboBox();
    private JLabel httpServerLabel = new JLabel("Http server port");
    private JTextField httpServerField = new JTextField("0");
    private JLabel flipHttpPositionLabel = new JLabel("Flip http position");
    private JCheckBox flipHttpPositionCheckBox = new JCheckBox();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public void setTablaWindow(TablaWindow tablaWindow) {
        this.tablaWindow = tablaWindow;
    }

    public void setRulesManager(RulesManager rulesManager) {
        this.rulesManager = rulesManager;
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.tablaManager = tablaManager;
    }

    public void setHttpServer(HttpServer httpServer) {
        this.httpServer = httpServer;
    }

    public String getLanguageText(String key) {
        return this.applicationContext.getMessage(key, null, key, this.matchData.getLocale());
    }

    public void afterPropertiesSet() throws Exception {
        final List rules = this.rulesManager.getAvailableCompetitionRules();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultComboBoxModel comboBoxModel;
                if (SettingsDialog.this.rulesComboBox.getModel() instanceof DefaultComboBoxModel) {
                    comboBoxModel = (DefaultComboBoxModel)SettingsDialog.this.rulesComboBox.getModel();
                    for (String rule : rules) {
                        comboBoxModel.addElement(rule);
                    }
                }
                if (SettingsDialog.this.roundComboBox.getModel() instanceof DefaultComboBoxModel) {
                    comboBoxModel = (DefaultComboBoxModel)SettingsDialog.this.roundComboBox.getModel();
                    for (int i = 1; i <= 5; ++i) {
                        comboBoxModel.addElement(SettingsDialog.this.getLanguageText("text.round") + " " + String.valueOf(i));
                    }
                }
                if (SettingsDialog.this.rankComboBox.getModel() instanceof DefaultComboBoxModel) {
                    comboBoxModel = (DefaultComboBoxModel)SettingsDialog.this.rankComboBox.getModel();
                    comboBoxModel.addElement(SettingsDialog.this.getLanguageText("text.worldLevel"));
                    comboBoxModel.addElement(SettingsDialog.this.getLanguageText("text.advancedLevel"));
                    comboBoxModel.addElement(SettingsDialog.this.getLanguageText("text.noviceLevel"));
                }
                if (SettingsDialog.this.duoJudgesComboBox.getModel() instanceof DefaultComboBoxModel) {
                    comboBoxModel = (DefaultComboBoxModel)SettingsDialog.this.duoJudgesComboBox.getModel();
                    comboBoxModel.addElement("5");
                    comboBoxModel.addElement("3");
                }
                if (SettingsDialog.this.languagesComboBox.getModel() instanceof DefaultComboBoxModel) {
                    comboBoxModel = (DefaultComboBoxModel)SettingsDialog.this.languagesComboBox.getModel();
                    comboBoxModel.addElement(SettingsDialog.this.getLanguageText("locale.english"));
                    comboBoxModel.addElement(SettingsDialog.this.getLanguageText("locale.slovenian"));
                }
            }
        });
    }

    public void destroy() throws Exception {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SettingsDialog.this.setVisible(false);
                SettingsDialog.this.dispose();
            }
        });
    }

    public SettingsDialog() {
        this.setAlwaysOnTop(true);
        this.setSize(600, 390);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        JPanel settingsPanel = new JPanel();
        this.add((Component)settingsPanel, "Center");
        settingsPanel.setLayout(new GridLayout(11, 1));
        JPanel matchTimePanel = new JPanel(new FlowLayout(0, 10, 5));
        settingsPanel.add(matchTimePanel);
        matchTimePanel.add(this.matchTimeLabel);
        matchTimePanel.add(this.matchTimeField);
        this.matchTimeLabel.setPreferredSize(new Dimension(290, 20));
        this.matchTimeField.setPreferredSize(new Dimension(200, 20));
        JPanel hosekomiTimePanel = new JPanel(new FlowLayout(0, 10, 5));
        settingsPanel.add(hosekomiTimePanel);
        hosekomiTimePanel.add(this.hosekomiTimeLabel);
        hosekomiTimePanel.add(this.hosekomiTimeField);
        this.hosekomiTimeLabel.setPreferredSize(new Dimension(290, 20));
        this.hosekomiTimeField.setPreferredSize(new Dimension(200, 20));
        JPanel newazaHansokumakePenaltiesPanel = new JPanel(new FlowLayout(0, 10, 5));
        settingsPanel.add(newazaHansokumakePenaltiesPanel);
        newazaHansokumakePenaltiesPanel.add(this.newazaHansokumakePenaltiesLabel);
        newazaHansokumakePenaltiesPanel.add(this.newazaHansokumakePenaltiesField);
        this.newazaHansokumakePenaltiesLabel.setPreferredSize(new Dimension(290, 20));
        this.newazaHansokumakePenaltiesField.setPreferredSize(new Dimension(200, 20));
        JPanel rulesPanel = new JPanel(new FlowLayout(0, 10, 5));
        settingsPanel.add(rulesPanel);
        rulesPanel.add(this.rulesLabel);
        rulesPanel.add(this.rulesComboBox);
        this.rulesLabel.setPreferredSize(new Dimension(290, 20));
        this.rulesComboBox.setPreferredSize(new Dimension(200, 20));
        JPanel roundPanel = new JPanel(new FlowLayout(0, 10, 5));
        settingsPanel.add(roundPanel);
        roundPanel.add(this.roundLabel);
        roundPanel.add(this.roundComboBox);
        this.roundLabel.setPreferredSize(new Dimension(290, 20));
        this.roundComboBox.setPreferredSize(new Dimension(200, 20));
        JPanel rankPanel = new JPanel(new FlowLayout(0, 10, 5));
        settingsPanel.add(rankPanel);
        rankPanel.add(this.rankLabel);
        rankPanel.add(this.rankComboBox);
        this.rankLabel.setPreferredSize(new Dimension(290, 20));
        this.rankComboBox.setPreferredSize(new Dimension(200, 20));
        JPanel agePanel = new JPanel(new FlowLayout(0, 10, 5));
        settingsPanel.add(agePanel);
        agePanel.add(this.ageLabel);
        agePanel.add(this.ageLabelField);
        this.ageLabel.setPreferredSize(new Dimension(290, 20));
        this.ageLabelField.setPreferredSize(new Dimension(200, 20));
        JPanel duoJudgesPanel = new JPanel(new FlowLayout(0, 10, 5));
        settingsPanel.add(duoJudgesPanel);
        duoJudgesPanel.add(this.duoJudgesLabel);
        duoJudgesPanel.add(this.duoJudgesComboBox);
        this.duoJudgesLabel.setPreferredSize(new Dimension(290, 20));
        this.duoJudgesComboBox.setPreferredSize(new Dimension(200, 20));
        JPanel languagePanel = new JPanel(new FlowLayout(0, 10, 5));
        settingsPanel.add(languagePanel);
        languagePanel.add(this.languageLabel);
        languagePanel.add(this.languagesComboBox);
        this.languageLabel.setPreferredSize(new Dimension(290, 20));
        this.languagesComboBox.setPreferredSize(new Dimension(200, 20));
        JPanel httpServerPanel = new JPanel(new FlowLayout(0, 10, 5));
        settingsPanel.add(httpServerPanel);
        httpServerPanel.add(this.httpServerLabel);
        httpServerPanel.add(this.httpServerField);
        this.httpServerLabel.setPreferredSize(new Dimension(290, 20));
        this.httpServerField.setPreferredSize(new Dimension(200, 20));
        JPanel httpFlipPanel = new JPanel(new FlowLayout(0, 10, 5));
        settingsPanel.add(httpFlipPanel);
        httpFlipPanel.add(this.flipHttpPositionLabel);
        httpFlipPanel.add(this.flipHttpPositionCheckBox);
        this.flipHttpPositionLabel.setPreferredSize(new Dimension(290, 20));
        JPanel buttonsPanel = new JPanel(new FlowLayout(1, 20, 10));
        this.add((Component)buttonsPanel, "South");
        buttonsPanel.add(this.saveButton);
        buttonsPanel.add(this.cancelButton);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String hosekomiTimeText;
                String timeText = SettingsDialog.this.matchTimeField.getText().trim();
                if (!timeText.isEmpty()) {
                    try {
                        String[] parts = timeText.split(":");
                        long minutes = 0L;
                        long seconds = 0L;
                        if (parts.length > 1) {
                            minutes = Long.parseLong(parts[0].trim());
                            seconds = Long.parseLong(parts[1].trim());
                        } else {
                            minutes = 0L;
                            seconds = Long.parseLong(parts[0].trim());
                        }
                        SettingsDialog.this.matchData.setDefaultMatchTime((minutes * 60L + seconds) * 1000L);
                    }
                    catch (Exception ex) {
                        LOGGER.error("Error while parsing match time", (Throwable)ex);
                    }
                }
                if (!(hosekomiTimeText = SettingsDialog.this.hosekomiTimeField.getText()).isEmpty()) {
                    try {
                        long seconds = Long.parseLong(hosekomiTimeText);
                        SettingsDialog.this.matchData.setMaximumHosekomiTime(seconds * 1000L);
                    }
                    catch (Exception ex) {
                        LOGGER.error("Error while parsing hosekomi time", (Throwable)ex);
                    }
                }
                try {
                    int penalties = Integer.parseInt(SettingsDialog.this.newazaHansokumakePenaltiesField.getText());
                    SettingsDialog.this.matchData.setNewazaPenaltyHansokumake(penalties);
                }
                catch (Exception ex) {
                    LOGGER.error("Error while parsing ne waza hansokumake penalties", (Throwable)ex);
                }
                SettingsDialog.this.matchData.setRules((String)SettingsDialog.this.rulesComboBox.getSelectedItem());
                if (SettingsDialog.this.roundComboBox.getSelectedIndex() == 0) {
                    SettingsDialog.this.matchData.setRound(Round.ROUND_1);
                } else if (SettingsDialog.this.roundComboBox.getSelectedIndex() == 1) {
                    SettingsDialog.this.matchData.setRound(Round.ROUND_2);
                } else if (SettingsDialog.this.roundComboBox.getSelectedIndex() == 2) {
                    SettingsDialog.this.matchData.setRound(Round.ROUND_3);
                } else if (SettingsDialog.this.roundComboBox.getSelectedIndex() == 3) {
                    SettingsDialog.this.matchData.setRound(Round.ROUND_4);
                } else if (SettingsDialog.this.roundComboBox.getSelectedIndex() == 4) {
                    SettingsDialog.this.matchData.setRound(Round.ROUND_5);
                }
                if (SettingsDialog.this.rankComboBox.getSelectedIndex() == 0) {
                    SettingsDialog.this.matchData.setRank(Rank.WORLD_LEVEL);
                } else if (SettingsDialog.this.rankComboBox.getSelectedIndex() == 1) {
                    SettingsDialog.this.matchData.setRank(Rank.ADVANCED);
                } else if (SettingsDialog.this.rankComboBox.getSelectedIndex() == 2) {
                    SettingsDialog.this.matchData.setRank(Rank.NOVICE);
                }
                int age = 22;
                if (StringUtil.isNotBlank((String)SettingsDialog.this.ageLabelField.getText())) {
                    try {
                        age = Integer.valueOf(SettingsDialog.this.ageLabelField.getText().trim());
                    }
                    catch (Exception e) {
                        LOGGER.debug("Error parsing age", (Throwable)e);
                    }
                }
                SettingsDialog.this.matchData.setAge(age);
                AgeCategoryOption ageCategoryOption = new AgeCategoryOption();
                ageCategoryOption.setAge(Integer.valueOf(age));
                Set attacks = SettingsDialog.this.tablaManager.getCurrentCompetitionRules().getDuoPresentationAttacks(ageCategoryOption, SettingsDialog.this.matchData.getRound().ordinal() + 1);
                SettingsDialog.this.tablaManager.getDuoPresentationPoints().setAttacks(new ArrayList<DuoPresentationAttack>(attacks));
                SettingsDialog.this.tablaManager.getDuo2023Points().setAttacks(new ArrayList<DuoPresentationAttack>(attacks));
                if (SettingsDialog.this.duoJudgesComboBox.getSelectedIndex() == 0) {
                    SettingsDialog.this.matchData.setDuoJudges(5);
                } else if (SettingsDialog.this.duoJudgesComboBox.getSelectedIndex() == 1) {
                    SettingsDialog.this.matchData.setDuoJudges(3);
                }
                if (SettingsDialog.this.languagesComboBox.getSelectedIndex() == 0) {
                    SettingsDialog.this.matchData.setLocale(new Locale("en"));
                } else if (SettingsDialog.this.languagesComboBox.getSelectedIndex() == 1) {
                    SettingsDialog.this.matchData.setLocale(new Locale("sl"));
                }
                try {
                    int port = 0;
                    if (StringUtil.isNotBlank((String)SettingsDialog.this.httpServerField.getText())) {
                        port = Integer.valueOf(SettingsDialog.this.httpServerField.getText().trim());
                    }
                    if (port == 0 && SettingsDialog.this.httpServer.isRunning()) {
                        SettingsDialog.this.httpServer.stop();
                    } else if (SettingsDialog.this.httpServer.getPort() != port) {
                        SettingsDialog.this.httpServer.stop();
                        SettingsDialog.this.httpServer.start(port);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error handling http server", (Throwable)e);
                }
                SettingsDialog.this.matchData.setFlipHttpPosition(SettingsDialog.this.flipHttpPositionCheckBox.isSelected());
                SettingsDialog.this.setVisible(false);
                SettingsDialog.this.tablaManager.recalculatePoints();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.setVisible(false);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    SettingsDialog.this.setVisible(false);
                }
            }
        });
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.setLocationRelativeTo(this.tablaWindow);
            this.setTitle(this.getLanguageText("title.settings"));
            this.matchTimeLabel.setText(this.getLanguageText("text.defaultMatchTime"));
            this.hosekomiTimeLabel.setText(this.getLanguageText("text.hosekomiTime"));
            this.newazaHansokumakePenaltiesLabel.setText(this.getLanguageText("text.newazaHansokumakePenalties"));
            this.rulesLabel.setText(this.getLanguageText("text.rules"));
            this.roundLabel.setText(this.getLanguageText("text.round"));
            this.rankLabel.setText(this.getLanguageText("text.rank"));
            this.ageLabel.setText(this.getLanguageText("text.age"));
            this.duoJudgesLabel.setText(this.getLanguageText("text.duoJudges"));
            this.languageLabel.setText(this.getLanguageText("text.language"));
            this.httpServerLabel.setText(this.getLanguageText("text.httpServerPort"));
            this.flipHttpPositionLabel.setText(this.getLanguageText("text.flipHttpPosition"));
            this.saveButton.setText(this.getLanguageText("text.save"));
            this.cancelButton.setText(this.getLanguageText("text.cancel"));
            long time = this.matchData.getDefaultMatchTime() / 1000L;
            long minutes = time / 60L;
            long seconds = time % 60L;
            String timeText = String.valueOf(minutes) + ":" + this.secondsNumberFormat.format(seconds);
            this.matchTimeField.setText(timeText);
            long hosekomiTime = this.matchData.getMaximumHosekomiTime() / 1000L;
            String hosekomiTimeText = this.secondsNumberFormat.format(hosekomiTime);
            this.hosekomiTimeField.setText(hosekomiTimeText);
            this.newazaHansokumakePenaltiesField.setText(String.valueOf(this.matchData.getNewazaPenaltyHansokumake()));
            this.rulesComboBox.setSelectedItem(this.matchData.getRules());
            this.roundComboBox.setSelectedIndex(this.matchData.getRound().ordinal());
            if (this.rankComboBox.getModel() instanceof DefaultComboBoxModel) {
                DefaultComboBoxModel comboBoxModel = (DefaultComboBoxModel)this.rankComboBox.getModel();
                comboBoxModel.removeAllElements();
                comboBoxModel.addElement(this.getLanguageText("text.worldLevel"));
                comboBoxModel.addElement(this.getLanguageText("text.advancedLevel"));
                comboBoxModel.addElement(this.getLanguageText("text.noviceLevel"));
            }
            this.rankComboBox.setSelectedIndex(this.matchData.getRank().ordinal());
            this.ageLabelField.setText(String.valueOf(this.matchData.getAge()));
            if (this.matchData.getDuoJudges() == 3) {
                this.duoJudgesComboBox.setSelectedIndex(1);
            } else {
                this.duoJudgesComboBox.setSelectedIndex(0);
            }
            this.languagesComboBox.setSelectedItem(this.getLanguageText("locale.current"));
            this.httpServerField.setText(String.valueOf(this.httpServer.getPort()));
            this.flipHttpPositionCheckBox.setSelected(this.matchData.isFlipHttpPosition());
            this.revalidate();
            this.repaint();
        }
    }
}

