/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.captcha.simple;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import nl.captcha.Captcha;
import nl.captcha.backgrounds.BackgroundProducer;
import nl.captcha.backgrounds.GradiatedBackgroundProducer;
import nl.captcha.gimpy.DropShadowGimpyRenderer;
import nl.captcha.gimpy.GimpyRenderer;
import nl.captcha.noise.CurvedLineNoiseProducer;
import nl.captcha.noise.NoiseProducer;
import nl.captcha.noise.StraightLineNoiseProducer;
import nl.captcha.text.producer.TextProducer;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.captcha.AbstractCaptchaGenerator;
import si.nevensrok.common.captcha.Captcha;
import si.nevensrok.common.captcha.simple.RandomPixelNoiseProducer;
import si.nevensrok.common.captcha.simple.WordRenderer;

public class SimpleCaptchaGenerator
extends AbstractCaptchaGenerator
implements InitializingBean {
    public static final String IMAGE_WIDTH = "IMAGE_WIDTH";
    public static final String IMAGE_HEIGHT = "IMAGE_HEIGHT";
    public static final String FONT_SIZE = "FONT_SIZE";
    private Random random = new Random();
    private Integer defaultImageWidth = 240;
    private Integer defaultImageHeight = 100;
    private List<Color> foregroundColors = null;
    private List<Color> backgroundColors = null;

    public void setDefaultImageHeight(Integer defaultImageHeight) {
        this.defaultImageHeight = defaultImageHeight;
    }

    public void setDefaultImageWidth(Integer defaultImageWidth) {
        this.defaultImageWidth = defaultImageWidth;
    }

    public void setForegroundColors(Color[] foregroundColors) {
        this.foregroundColors = new ArrayList<Color>();
        for (Color color : foregroundColors) {
            this.foregroundColors.add(color);
        }
    }

    public void setBackgroundColors(Color[] backgroundColors) {
        this.backgroundColors = new ArrayList<Color>();
        for (Color color : backgroundColors) {
            this.backgroundColors.add(color);
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.foregroundColors == null) {
            this.foregroundColors = new ArrayList<Color>();
            this.foregroundColors.add(new Color(4784154));
            this.foregroundColors.add(new Color(1609));
            this.foregroundColors.add(new Color(18695));
        }
        if (this.backgroundColors == null) {
            this.backgroundColors = new ArrayList<Color>();
            this.backgroundColors.add(new Color(16175312));
            this.backgroundColors.add(new Color(0xCFC6F6));
            this.backgroundColors.add(new Color(12509430));
            this.backgroundColors.add(new Color(12646075));
            this.backgroundColors.add(new Color(16179646));
        }
    }

    @Override
    public Captcha generateCaptcha(final String text, Map<String, Object> options) {
        int width = this.defaultImageWidth;
        int height = this.defaultImageHeight;
        if (options.containsKey(IMAGE_WIDTH)) {
            width = (Integer)options.get(IMAGE_WIDTH);
        }
        if (options.containsKey(IMAGE_HEIGHT)) {
            width = (Integer)options.get(IMAGE_HEIGHT);
        }
        TextProducer textProducer = new TextProducer(){

            public String getText() {
                return text;
            }
        };
        ArrayList<Color> textColors = new ArrayList<Color>(this.foregroundColors);
        Color line1Color = Color.BLACK;
        Color line2Color = Color.BLACK;
        if (textColors.size() >= 3) {
            line1Color = (Color)textColors.remove(this.random.nextInt(textColors.size()));
            line2Color = (Color)textColors.remove(this.random.nextInt(textColors.size()));
        } else {
            line1Color = (Color)textColors.get(this.random.nextInt(textColors.size()));
            line2Color = (Color)textColors.get(this.random.nextInt(textColors.size()));
        }
        Color bgColor1 = this.backgroundColors.get(this.random.nextInt(this.backgroundColors.size()));
        Color bgColor2 = this.backgroundColors.get(this.random.nextInt(this.backgroundColors.size()));
        ArrayList<Font> fonts = new ArrayList<Font>();
        fonts.add(new Font("Serif", 0, 45));
        fonts.add(new Font("Dialog", 0, 45));
        nl.captcha.Captcha c = new Captcha.Builder(width, height).addNoise((NoiseProducer)new CurvedLineNoiseProducer(line1Color, 10.0f)).addNoise((NoiseProducer)new StraightLineNoiseProducer(line2Color, 5)).addText(textProducer, (nl.captcha.text.renderer.WordRenderer)new WordRenderer(textColors, fonts)).addNoise((NoiseProducer)new RandomPixelNoiseProducer(this.foregroundColors)).addBackground((BackgroundProducer)new GradiatedBackgroundProducer(bgColor1, bgColor2)).gimp((GimpyRenderer)new DropShadowGimpyRenderer()).build();
        return new Captcha(c.getAnswer(), c.getImage());
    }
}

