/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.robot;

import java.nio.Buffer;
import java.nio.IntBuffer;

public class FXRobotImage {
    private final IntBuffer pixelBuffer;
    private final int width;
    private final int height;
    private final int scanlineStride;

    public static FXRobotImage create(Buffer pixelBuffer, int width, int height, int scanlineStride) {
        return new FXRobotImage(pixelBuffer, width, height, scanlineStride);
    }

    private FXRobotImage(Buffer pixelBuffer, int width, int height, int scanlineStride) {
        if (pixelBuffer == null) {
            throw new IllegalArgumentException("Pixel buffer must be non-null");
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Image dimensions must be > 0");
        }
        this.pixelBuffer = (IntBuffer)pixelBuffer;
        this.width = width;
        this.height = height;
        this.scanlineStride = scanlineStride;
    }

    public Buffer getPixelBuffer() {
        return this.pixelBuffer;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public int getPixelStride() {
        return 4;
    }

    public int getArgbPre(int x, int y) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            throw new IllegalArgumentException("x,y must be >0, <width, height");
        }
        return this.pixelBuffer.get(x + y * this.scanlineStride / 4);
    }

    public int getArgb(int x, int y) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            throw new IllegalArgumentException("x,y must be >0, <width, height");
        }
        int argb = this.pixelBuffer.get(x + y * this.scanlineStride / 4);
        if (argb >> 24 == -1) {
            return argb;
        }
        int a = argb >>> 24;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        int a2 = a + (a >> 7);
        r = r * a2 >> 8;
        g = g * a2 >> 8;
        b = b * a2 >> 8;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public String toString() {
        return super.toString() + " [format=INT_ARGB_PRE width=" + this.width + " height=" + this.height + " scanlineStride=" + this.scanlineStride + " pixelStride=" + this.getPixelStride() + " pixelBuffer=" + this.pixelBuffer + "]";
    }
}

