(function () {
	var router = definePackage("router");

    router.enabled = false;
	router.routes = [];

    window.addEventListener('hashchange', function (event){
        if (!router.enabled) {
            return;
        }
        var url = event.newURL;
        var n = url.indexOf("#");
        if (n >= 0) {
            url = url.substring(n + 1);
            router.handleLocationChange(url);
        }
    });

    function matchesRouteUrl(routeUrl, url) {
        if (routeUrl == url) {
            return true;
        }
        if (routeUrl.endsWith("*")) {
            var prefix = routeUrl.substring(0, routeUrl.length - 1);
            if (url.startsWith(prefix)) {
                return true;
            }
        }
        return false;
    };

    router.handleLocationChange = function(url) {
        for (var route of router.routes) {
            var matches = false;
            if (isString(route.target)) {
                matches = matchesRouteUrl(route.target, url);
            }
            else if (isArray(route.target)) {
                var urlArray = this.decodeUrl(url);
                for (var i in route.target) {
                    var item = route.target[i];
                    var urlPart = urlArray[i];
                    if (isNull(urlPart)) {
                        continue;
                    }
                    if (!isString(item)) {
                        throw new Error("Route item is not string");
                    }
                    matches = matchesRouteUrl(item, urlPart);
                    if (matches) {
                        break;
                    }
                }
            }
            else {
                throw new Error("Target is not string or array");
            }
            if (matches) {
                route.callback(url);
                return;
            }
        }
        if (isFunction(router.unknownRouteHandler)) {
            router.unknownRouteHandler(url);
        }
    }

    router.changeLocation = function(url) {
        if (isString(url)) {
            window.location.hash = url;
        }
        else if (isArray(url)) {
            window.location.hash = router.encodeUrl(url);
        }
        else {
            throw new Error("Url is not string or array");
        }
    };

    router.handleRoute = function(target, callback) {
        if (isNull(target)) {
            throw new Error("Target not provided");
        }
        if (!isString(target) && !isArray(target)) {
            throw new Error("Target is not string or array");
        }
        if (!isFunction(callback)) {
            throw new Error("Callback is not a function");
        }
        router.routes.push({
            "target": target,
            "callback": callback
        });
    };

    router.handleUnknownRoute = function(callback) {
        if (!isFunction(callback)) {
            throw new Error("Callback is not a function");
        }
        router.unknownRouteHandler = callback;
    }

    router.encodeUrl = function(url) {
        if (!isArray(url)) {
            throw new Error("Url is not array");
        }
        var target = "";
        for (var item of url) {
            if (target.length > 0) {
                target += "/";
            }
            target += encodeURIComponent(item);
        }
        return target;
    };

    router.decodeUrl = function(url) {
        if (!isString(url)) {
            throw new Error("Url is not string");
        }
        var parts = url.split("/");
        var target = [];
        for (var item of parts) {
            target.push(decodeURIComponent(item));
        }
        return target;
    };

})();

$(document).ready(function() {
    setTimeout(() => {
        var router = loadModule("router");
        if (!router.enabled) {
            return;
        }
        var url = window.location.href;
        var n = url.indexOf("#");
        if (n >= 0) {
            url = url.substring(n + 1);
            router.handleLocationChange(url);
        }
        else {
            router.handleLocationChange("");
        }
    }, 50);
});