(function() {
    var jtekma = definePackage("jtekma");
    var models = definePackage("jtekma.models");
    var views = definePackage("jtekma.views");

    jtekma.displaySettings = new models.DisplaySettings();

    jtekma.reloadData = function() {
        jtekma.displaySettings.trigger("change:tatami");
        jtekma.displaySettings.trigger("change:category");
    }

	jtekma.displaySettings.on("change:category change:type", function() {
		$("#competition-main").html("");

		var category = this.get("category");
		
		if (isNull(category)) {
			return;
		}
		
		if (category.get("type") == "FIGHTING" || category.get("type") == "DUO" || category.get("type") == "NEWAZA") {
			if (this.get("type") == "draw") {
				var competitorCollection = new models.CompetitorCollection();
				new views.DrawView({
					"el": $("#competition-main"),
					"collection": competitorCollection
				});
				competitorCollection.fetch({
					"data": {
						"categoryId": this.get("category").get("id")
					},
					"reset": true
				});
			}
			else if (this.get("type") == "tree") {
				var tableOrTreeView = new views.TableOrTreeView({
					"el": $("#competition-main")
				});
				tableOrTreeView.render();
			}
			else if (this.get("type") == "matches") {
				var matchCollection = new models.MatchCollection();
				matchCollection.category = category;
				new views.MatchesView({
					"el": $("#competition-main"),
					"collection": matchCollection
				});
				matchCollection.fetch({
					"data": {
						"categoryId": category.get("id")
					},
					"reset": true
				});
			}
			else if (this.get("type") == "placings") {
				var placingCollection = new models.PlacingCollection();
				new views.PlacingView({
					"el": $("#competition-main"),
					"collection": placingCollection
				});
				placingCollection.fetch({
					"data": {
						"categoryId": category.get("id")
					},
					"reset": true
				});
			}
		}
		else if (category.get("type") == "DUO_2023") {
            if (this.get("type") == "draw") {
				var competitorCollection = new models.CompetitorCollection();
				new views.DrawDuo2023View({
					"el": $("#competition-main"),
					"collection": competitorCollection
				});
				competitorCollection.fetch({
					"data": {
						"categoryId": this.get("category").get("id")
					},
					"reset": true
				});
			}
			else if (this.get("type") == "tree") {
				var tableOrTreeView = new views.TableOrTreeView({
                    "el": $("#competition-main")
                });
                tableOrTreeView.render();
			}
			else if (this.get("type") == "matches") {
			    var data = {
			        "category": category,
			        "duoPresentations": new models.DuoPresentationCollection(),
			        "matches": new models.MatchCollection()
			    };
				new views.DuoPresentationsView({
					"el": $("#competition-main"),
					"model": data
				});
				data.duoPresentations.fetch({
					"data": {
						"categoryId": category.get("id")
					},
					"reset": true
				});
				data.matches.fetch({
                    "data": {
                        "categoryId": category.get("id")
                    },
                    "reset": true
                });
			}
			else if (this.get("type") == "placings") {
				var placingCollection = new models.Duo2023PlacingCollection();
				new views.Duo2023PlacingView({
					"el": $("#competition-main"),
					"collection": placingCollection
				});
				placingCollection.fetch({
					"data": {
						"categoryId": category.get("id")
					},
					"reset": true
				});
			}
		}
		else if (this.get("category").get("type") == "CUSTOM") {
			if (this.get("type") == "matches") {
				var matchCollection = new models.MatchCollection();
				new views.CustomMatchesView({
					"el": $("#competition-main"),
					"collection": matchCollection
				});
				matchCollection.fetch({
					"data": {
						"categoryId": category.get("id")
					},
					"reset": true
				});
			}
		}
	}, jtekma.displaySettings);
	
	jtekma.displaySettings.on("change:tatami change:tatami-display-type", function() {
		$("#tatami-fights").html("");
		
		if (this.get("tatami-display-type")=="nextFights") {
			var tatamiFightCollection = new models.TatamiFightCollection();
			
			new views.TatamiFightsView({
				"el": $("#tatami-fights"),
				"collection": tatamiFightCollection
			});
			
			if (this.get("tatami") != null) {
				tatamiFightCollection.fetch({
					"data": {
						"tatamiId": this.get("tatami").get("id")
					},
					"reset": true
				});
			}
		}
		else if (this.get("tatami-display-type") == "history") {
			var tatamiHistoryEventCollection = new models.TatamiHistoryEventCollection();
			
			new views.TatamiHistoryEventsView({
				"el": $("#tatami-fights"),
				"collection": tatamiHistoryEventCollection
			});
			
			if (this.get("tatami") != null) {
				tatamiHistoryEventCollection.fetch({
					"data": {
						"tatamiId": this.get("tatami").get("id")
					},
					"reset": true
				});
			}
		}
	}, jtekma.displaySettings);
	
	/*----- Competition ---------*/
	models.Competition = Backbone.Model.extend({
		"defaults": {
			"id": 0,
			"name": "",
			"date": null,
			"status": "",
			"canManage": false
		},
		"url": function() {
		  return contextPath + "/competition/data/current-competition";
		},
		"initialize": function() {
			
		}
	});
	
	views.Competition = Backbone.View.extend({
		"template": templates.getTemplate("/competition/template/competition"),
		"initialize": function() {
			this.model.on("change", function() {
				this.render();
			}, this);
		},
		"render": function() {
			$(this.el).html(this.template);
			
			$("[rel='tooltip']", this.el).tooltip();
			
			$("#displayButtons label", this.el).on("click", function() {
				jtekma.displaySettings.set("type", $(this).attr("link"));
			});
			
			$("#displayButtons label:first").click();
			
			var categoryCollection = new models.CategoryCollection();
			new views.CategorySelectView({
				"el": $("#category-select"),
				"collection": categoryCollection
			});
			new views.CategoryEnableView({
				"el": $("#category-enable-list"),
				"collection": categoryCollection
			});
			categoryCollection.fetch({ "reset": true });
			
			var tatamiCollection = new models.TatamiCollection();
			new views.TatamiSelectView({
				"el": $("#tatami-select"),
				"collection": tatamiCollection
			});
			tatamiCollection.fetch({ "reset": true });
			
			$(".addEventButton", this.el).on("click", function() {
				var eventModel = new models.EventModel();
				var eventEditView = new views.EventEditView({
					"model": eventModel
				});
				eventEditView.trigger("show");
			});
			
			$("#tatamiDisplayButtons label", this.el).on("click", function() {
				jtekma.displaySettings.set("tatami-display-type", $(this).attr("link"));
			});
			
			$("#tatamiDisplayButtons label:first").click();
			
			$(".refreshButton", this.el).on("click",function() {
				jtekma.reloadData();
			});
			
			var autoReload = false;
			
			$(".autoRefreshButton", this.el).on("click", function() {
				autoReload = $(this).attr("class").indexOf("active") < 0;
				if (autoReload) {
					jtekma.reloadData();
				}
			});
			
			setInterval(function(){
				if (autoReload) {
					jtekma.reloadData();
				}
			}, 30000);
			
			return this;
		}
	});
	
})();

$(document).ready(function() {
    var models = definePackage("jtekma.models");
    var views = definePackage("jtekma.views");

	var competition = new models.Competition();
	
	new views.Competition({
		"el": $("#competition-div"),
		"model": competition
	});
	
	competition.fetch();
});