/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.lock;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import si.nevensrok.common.lock.LockContext;

public abstract class AbstractExternalLock
implements Lock {
    private String name;

    public AbstractExternalLock(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void lock() {
        if (LockContext.initOrAddLock(this.name)) {
            return;
        }
        this.clearExpiredLock();
        while (true) {
            if (!this.isLocked()) {
                try {
                    if (this.acquireLock()) {
                        LockContext.addLock(this.name);
                        return;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                this.waitUntilNextTry(0L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        if (LockContext.initOrAddLock(this.name)) {
            return;
        }
        this.clearExpiredLock();
        try {
            while (true) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (!this.isLocked() && this.acquireLock()) {
                    LockContext.addLock(this.name);
                    return;
                }
                this.waitUntilNextTry(0L);
            }
        }
        catch (InterruptedException e) {
            this.cancelLock();
            throw e;
        }
    }

    @Override
    public boolean tryLock() {
        if (LockContext.initOrAddLock(this.name)) {
            return true;
        }
        this.clearExpiredLock();
        if (!this.isLocked()) {
            try {
                if (this.acquireLock()) {
                    LockContext.addLock(this.name);
                    return true;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.cancelLock();
        return false;
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        if (LockContext.initOrAddLock(this.name)) {
            return true;
        }
        long waitUntil = System.currentTimeMillis() + unit.toMillis(time);
        this.clearExpiredLock();
        try {
            while (true) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (!this.isLocked() && this.acquireLock()) {
                    LockContext.addLock(this.name);
                    return true;
                }
                long maxWaitTime = waitUntil - System.currentTimeMillis();
                if (maxWaitTime <= 0L) break;
                this.waitUntilNextTry(maxWaitTime);
            }
            this.cancelLock();
            return false;
        }
        catch (InterruptedException e) {
            this.cancelLock();
            throw e;
        }
    }

    @Override
    public void unlock() {
        if (LockContext.removeLock(this.name)) {
            this.removeLock();
        }
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException("Not jet implemented");
    }

    protected abstract void clearExpiredLock();

    protected abstract boolean isLocked();

    protected abstract boolean acquireLock() throws InterruptedException;

    protected abstract void cancelLock();

    protected abstract void removeLock();

    protected abstract void waitUntilNextTry(long var1) throws InterruptedException;
}

