/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.googleauth;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import si.nevensrok.common.googleauth.Base32String;

public class PasscodeGenerator {
    private static final int PASS_CODE_LENGTH = 6;
    private static final int INTERVAL = 30;
    private static final int ADJACENT_INTERVALS = 1;
    private static final int PIN_MODULO = (int)Math.pow(10.0, 6.0);
    private final Signer signer;
    private final int codeLength;
    private final int intervalPeriod;
    private IntervalClock clock = new IntervalClock(){

        @Override
        public long getCurrentInterval() {
            long currentTimeSeconds = System.currentTimeMillis() / 1000L;
            return currentTimeSeconds / (long)this.getIntervalPeriod();
        }

        @Override
        public int getIntervalPeriod() {
            return PasscodeGenerator.this.intervalPeriod;
        }
    };

    private static Mac initDefault(String secret) {
        try {
            byte[] keyBytes = Base32String.decode(secret);
            Mac mac = Mac.getInstance("HMACSHA1");
            mac.init(new SecretKeySpec(keyBytes, ""));
            return mac;
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing PasscodeGenerator", e);
        }
    }

    public PasscodeGenerator(String secret) {
        this(PasscodeGenerator.initDefault(secret));
    }

    public PasscodeGenerator(Mac mac) {
        this(mac, 6, 30);
    }

    public PasscodeGenerator(final Mac mac, int passCodeLength, int interval) {
        this(new Signer(){

            @Override
            public byte[] sign(byte[] data) {
                return mac.doFinal(data);
            }
        }, passCodeLength, interval);
    }

    public PasscodeGenerator(Signer signer, int passCodeLength, int interval) {
        this.signer = signer;
        this.codeLength = passCodeLength;
        this.intervalPeriod = interval;
    }

    private String padOutput(int value) {
        String result = Integer.toString(value);
        for (int i = result.length(); i < this.codeLength; ++i) {
            result = "0" + result;
        }
        return result;
    }

    public String generateTimeoutCode() throws GeneralSecurityException {
        return this.generateResponseCode(this.clock.getCurrentInterval());
    }

    public String generateResponseCode(long challenge) throws GeneralSecurityException {
        byte[] value = ByteBuffer.allocate(8).putLong(challenge).array();
        return this.generateResponseCode(value);
    }

    public String generateResponseCode(byte[] challenge) throws GeneralSecurityException {
        byte[] hash = this.signer.sign(challenge);
        int offset = hash[hash.length - 1] & 0xF;
        int truncatedHash = this.hashToInt(hash, offset) & Integer.MAX_VALUE;
        int pinValue = truncatedHash % PIN_MODULO;
        return this.padOutput(pinValue);
    }

    private int hashToInt(byte[] bytes, int start) {
        int val;
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(bytes, start, bytes.length - start));
        try {
            val = input.readInt();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return val;
    }

    public boolean verifyResponseCode(long challenge, String response) throws GeneralSecurityException {
        String expectedResponse = this.generateResponseCode(challenge);
        return expectedResponse.equals(response);
    }

    public boolean verifyTimeoutCode(String timeoutCode) throws GeneralSecurityException {
        return this.verifyTimeoutCode(timeoutCode, 1, 1);
    }

    public boolean verifyTimeoutCode(String timeoutCode, int pastIntervals, int futureIntervals) throws GeneralSecurityException {
        int i;
        long currentInterval = this.clock.getCurrentInterval();
        String expectedResponse = this.generateResponseCode(currentInterval);
        if (expectedResponse.equals(timeoutCode)) {
            return true;
        }
        for (i = 1; i <= pastIntervals; ++i) {
            String pastResponse = this.generateResponseCode(currentInterval - (long)i);
            if (!pastResponse.equals(timeoutCode)) continue;
            return true;
        }
        for (i = 1; i <= futureIntervals; ++i) {
            String futureResponse = this.generateResponseCode(currentInterval + (long)i);
            if (!futureResponse.equals(timeoutCode)) continue;
            return true;
        }
        return false;
    }

    static interface IntervalClock {
        public int getIntervalPeriod();

        public long getCurrentInterval();
    }

    static interface Signer {
        public byte[] sign(byte[] var1) throws GeneralSecurityException;
    }
}

