/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.dataimport;

import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.dataimport.AbstractFileReader;

public class XlsFileReader
extends AbstractFileReader {
    private static final Logger log = LoggerFactory.getLogger(XlsFileReader.class);
    private int sheetIndex = 0;
    private Iterator<Row> rowIteretor;
    private HSSFWorkbook workbook;

    @Override
    public void init(InputStream inputStream) throws Exception {
        this.workbook = new HSSFWorkbook(inputStream);
        HSSFSheet sheet = this.workbook.getSheetAt(this.sheetIndex);
        this.rowIteretor = sheet.rowIterator();
    }

    @Override
    public void close() throws Exception {
        this.workbook.close();
    }

    @Override
    public String[] readLine() throws Exception {
        if (!this.rowIteretor.hasNext()) {
            return null;
        }
        int n = 0;
        Row row = this.rowIteretor.next();
        LinkedList<String> rowData = new LinkedList<String>();
        Iterator cellIterator = row.cellIterator();
        while (cellIterator.hasNext()) {
            String text;
            Cell cell = (Cell)cellIterator.next();
            while (n < cell.getColumnIndex()) {
                rowData.add("");
                ++n;
            }
            if (cell.getCellType() == 1) {
                text = cell.getStringCellValue();
                rowData.add(text);
            } else if (cell.getCellType() == 0) {
                text = String.valueOf(cell.getNumericCellValue());
                rowData.add(text);
            } else if (cell.getCellType() == 3) {
                text = "";
                rowData.add(text);
            } else if (cell.getCellType() == 4) {
                text = String.valueOf(cell.getBooleanCellValue());
                rowData.add(text);
            } else if (cell.getCellType() == 2) {
                text = cell.getCellFormula();
                rowData.add(text);
            } else {
                log.warn("Unsupported cell type {}", (Object)cell.getCellType());
            }
            ++n;
        }
        return rowData.toArray(new String[0]);
    }
}

