/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.dto.matches;

import java.io.Serializable;
import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import si.nevensrok.common.objects.ObjectToString;
import si.nevensrok.jtekma.common.matches.Series;
import si.nevensrok.jtekma.server.dl.dto.matches.MatchDTO;

@Entity
@Table(name="match_valid_attacks")
public class MatchValidAttackDTO {
    @Id
    private MatchValidAttackKey matchValidAttackKey;
    @Column(name="attack_valid", nullable=false)
    private Boolean attackValid;
    @Column(name="sent_at", nullable=false)
    private Calendar sentAt;

    public MatchValidAttackDTO() {
    }

    public MatchValidAttackDTO(MatchDTO match, Integer competitor, Series series, Integer attack) {
        this.matchValidAttackKey = new MatchValidAttackKey(match, competitor, series, attack);
    }

    public MatchValidAttackKey getMatchValidAttackKey() {
        return this.matchValidAttackKey;
    }

    public void setMatchValidAttackKey(MatchValidAttackKey matchValidAttackKey) {
        this.matchValidAttackKey = matchValidAttackKey;
    }

    public Boolean getAttackValid() {
        return this.attackValid;
    }

    public void setAttackValid(Boolean attackValid) {
        this.attackValid = attackValid;
    }

    public Calendar getSentAt() {
        return this.sentAt;
    }

    public void setSentAt(Calendar sentAt) {
        this.sentAt = sentAt;
    }

    public String toString() {
        return new ObjectToString(MatchValidAttackDTO.class).addProperty("matchValidAttackKey", (Object)this.matchValidAttackKey).addProperty("attackValid", (Object)this.attackValid).addPropertyCalendar("sentAt", this.sentAt).generateString();
    }

    @Embeddable
    public static class MatchValidAttackKey
    implements Serializable {
        private static final long serialVersionUID = 5975850989862933646L;
        @ManyToOne(fetch=FetchType.LAZY)
        @JoinColumn(name="match_id", nullable=false, updatable=false)
        private MatchDTO match;
        @Column(name="competitor", nullable=false, updatable=false)
        private Integer competitor;
        @Enumerated(value=EnumType.STRING)
        @Column(length=32, name="series", nullable=false, updatable=false)
        private Series series;
        @Column(name="attack", nullable=false, updatable=false)
        private Integer attack;

        public MatchValidAttackKey() {
        }

        public MatchValidAttackKey(MatchDTO match, Integer competitor, Series series, Integer attack) {
            this.match = match;
            this.competitor = competitor;
            this.series = series;
            this.attack = attack;
        }

        public MatchDTO getMatch() {
            return this.match;
        }

        public void setMatch(MatchDTO match) {
            this.match = match;
        }

        public Integer getCompetitor() {
            return this.competitor;
        }

        public void setCompetitor(Integer competitor) {
            this.competitor = competitor;
        }

        public Series getSeries() {
            return this.series;
        }

        public void setSeries(Series series) {
            this.series = series;
        }

        public Integer getAttack() {
            return this.attack;
        }

        public void setAttack(Integer attack) {
            this.attack = attack;
        }

        public String toString() {
            return new ObjectToString(MatchValidAttackKey.class).addPropertyObjectHash("match", (Object)this.match).addProperty("competitor", (Object)this.competitor).addProperty("series", (Object)this.series).addProperty("attack", (Object)this.attack).generateString();
        }
    }
}

