/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.exporters;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.common.utils.ObjectUtil;
import si.nevensrok.jtekma.common.Gender;
import si.nevensrok.jtekma.common.category.AgeCategoryOption;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.CategoryGroup;
import si.nevensrok.jtekma.common.category.Duo2023Category;
import si.nevensrok.jtekma.common.category.DuoCategory;
import si.nevensrok.jtekma.common.category.FightingCategory;
import si.nevensrok.jtekma.common.category.NewazaCategory;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.category.WeightCategoryOption;
import si.nevensrok.jtekma.common.club.Club;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.competitors.CoupleCompetitor;
import si.nevensrok.jtekma.common.competitors.GroupDraw;
import si.nevensrok.jtekma.common.competitors.PersonCompetitor;
import si.nevensrok.jtekma.common.judges.Judge;
import si.nevensrok.jtekma.common.matches.DuoPresentation;
import si.nevensrok.jtekma.common.matches.DuoPresentationGrading;
import si.nevensrok.jtekma.common.matches.DuoPresentationPoint;
import si.nevensrok.jtekma.common.matches.DuoPresentationValidAttack;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchGrading;
import si.nevensrok.jtekma.common.matches.MatchPoint;
import si.nevensrok.jtekma.common.matches.MatchValidAttack;
import si.nevensrok.jtekma.common.matches.PointDetail;
import si.nevensrok.jtekma.common.matches.PointType;
import si.nevensrok.jtekma.common.matches.Rank;
import si.nevensrok.jtekma.common.matches.Round;
import si.nevensrok.jtekma.common.matches.Series;
import si.nevensrok.jtekma.common.matchupload.NextMatchUpload;
import si.nevensrok.jtekma.common.rules.SelectType;
import si.nevensrok.jtekma.common.rules.TreeAdvancment;
import si.nevensrok.jtekma.common.rules.TreeAdvancmentItem;
import si.nevensrok.jtekma.common.rules.TreeType;
import si.nevensrok.jtekma.common.tatami.Event;
import si.nevensrok.jtekma.common.tatami.FightOrder;
import si.nevensrok.jtekma.common.tatami.Semaphore;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.common.tatami.TatamiHistory;
import si.nevensrok.jtekma.common.tatami.TatamiOnSemaphore;
import si.nevensrok.jtekma.schema.competition.AgeCategoryOptionListType;
import si.nevensrok.jtekma.schema.competition.AgeCategoryOptionType;
import si.nevensrok.jtekma.schema.competition.CategoryGroupListType;
import si.nevensrok.jtekma.schema.competition.CategoryGroupType;
import si.nevensrok.jtekma.schema.competition.CategoryIdListType;
import si.nevensrok.jtekma.schema.competition.CategoryListType;
import si.nevensrok.jtekma.schema.competition.CategoryType;
import si.nevensrok.jtekma.schema.competition.CategoryTypeEnum;
import si.nevensrok.jtekma.schema.competition.ClubListType;
import si.nevensrok.jtekma.schema.competition.ClubType;
import si.nevensrok.jtekma.schema.competition.CompetitionData;
import si.nevensrok.jtekma.schema.competition.CompetitionSettingListType;
import si.nevensrok.jtekma.schema.competition.CompetitionSettingType;
import si.nevensrok.jtekma.schema.competition.CompetitionStatusEnum;
import si.nevensrok.jtekma.schema.competition.CompetitionType;
import si.nevensrok.jtekma.schema.competition.CompetitorDrawListType;
import si.nevensrok.jtekma.schema.competition.CompetitorDrawType;
import si.nevensrok.jtekma.schema.competition.CompetitorListType;
import si.nevensrok.jtekma.schema.competition.CompetitorPlacingListType;
import si.nevensrok.jtekma.schema.competition.CompetitorPlacingType;
import si.nevensrok.jtekma.schema.competition.CompetitorType;
import si.nevensrok.jtekma.schema.competition.CompetitorTypeEnum;
import si.nevensrok.jtekma.schema.competition.CoupleCompetitorType;
import si.nevensrok.jtekma.schema.competition.Duo2023CategoryType;
import si.nevensrok.jtekma.schema.competition.DuoCategoryType;
import si.nevensrok.jtekma.schema.competition.DuoPresentationGradingListType;
import si.nevensrok.jtekma.schema.competition.DuoPresentationGradingType;
import si.nevensrok.jtekma.schema.competition.DuoPresentationIdType;
import si.nevensrok.jtekma.schema.competition.DuoPresentationListType;
import si.nevensrok.jtekma.schema.competition.DuoPresentationPointListType;
import si.nevensrok.jtekma.schema.competition.DuoPresentationPointType;
import si.nevensrok.jtekma.schema.competition.DuoPresentationPointTypeEnum;
import si.nevensrok.jtekma.schema.competition.DuoPresentationType;
import si.nevensrok.jtekma.schema.competition.DuoPresentationValidAttackListType;
import si.nevensrok.jtekma.schema.competition.DuoPresentationValidAttackType;
import si.nevensrok.jtekma.schema.competition.EventType;
import si.nevensrok.jtekma.schema.competition.FightOrderListType;
import si.nevensrok.jtekma.schema.competition.FightOrderType;
import si.nevensrok.jtekma.schema.competition.FightingCategoryType;
import si.nevensrok.jtekma.schema.competition.GenderTypeEnum;
import si.nevensrok.jtekma.schema.competition.IdListType;
import si.nevensrok.jtekma.schema.competition.JudgeListType;
import si.nevensrok.jtekma.schema.competition.JudgeOnTatamiListType;
import si.nevensrok.jtekma.schema.competition.JudgeType;
import si.nevensrok.jtekma.schema.competition.MatchGradingListType;
import si.nevensrok.jtekma.schema.competition.MatchGradingType;
import si.nevensrok.jtekma.schema.competition.MatchIdType;
import si.nevensrok.jtekma.schema.competition.MatchListType;
import si.nevensrok.jtekma.schema.competition.MatchPointDetailListType;
import si.nevensrok.jtekma.schema.competition.MatchPointDetailType;
import si.nevensrok.jtekma.schema.competition.MatchPointListType;
import si.nevensrok.jtekma.schema.competition.MatchPointType;
import si.nevensrok.jtekma.schema.competition.MatchType;
import si.nevensrok.jtekma.schema.competition.MatchTypeEnum;
import si.nevensrok.jtekma.schema.competition.MatchValidAttackListType;
import si.nevensrok.jtekma.schema.competition.MatchValidAttackType;
import si.nevensrok.jtekma.schema.competition.NewazaCategoryType;
import si.nevensrok.jtekma.schema.competition.NextMatchUploadListType;
import si.nevensrok.jtekma.schema.competition.NextMatchUploadServerTypeEnum;
import si.nevensrok.jtekma.schema.competition.NextMatchUploadStatusEnum;
import si.nevensrok.jtekma.schema.competition.NextMatchUploadType;
import si.nevensrok.jtekma.schema.competition.PersonCompetitorType;
import si.nevensrok.jtekma.schema.competition.PointDetailChangeTypeEnum;
import si.nevensrok.jtekma.schema.competition.PointTypeEnum;
import si.nevensrok.jtekma.schema.competition.RankEnum;
import si.nevensrok.jtekma.schema.competition.RepassageTypeEnum;
import si.nevensrok.jtekma.schema.competition.RoundEnum;
import si.nevensrok.jtekma.schema.competition.SemaphoreListType;
import si.nevensrok.jtekma.schema.competition.SemaphoreType;
import si.nevensrok.jtekma.schema.competition.SeriesEnum;
import si.nevensrok.jtekma.schema.competition.SettingValueTypeEnum;
import si.nevensrok.jtekma.schema.competition.TatamiHistoryEventTypeEnum;
import si.nevensrok.jtekma.schema.competition.TatamiHistoryListType;
import si.nevensrok.jtekma.schema.competition.TatamiHistoryType;
import si.nevensrok.jtekma.schema.competition.TatamiListType;
import si.nevensrok.jtekma.schema.competition.TatamiOnSemaphoreListType;
import si.nevensrok.jtekma.schema.competition.TatamiOnSemaphoreType;
import si.nevensrok.jtekma.schema.competition.TatamiType;
import si.nevensrok.jtekma.schema.competition.TreeAdvancmentCompetitorTypeEnum;
import si.nevensrok.jtekma.schema.competition.TreeAdvancmentItemListType;
import si.nevensrok.jtekma.schema.competition.TreeAdvancmentItemType;
import si.nevensrok.jtekma.schema.competition.TreeAdvancmentListType;
import si.nevensrok.jtekma.schema.competition.TreeAdvancmentSelectTypeEnum;
import si.nevensrok.jtekma.schema.competition.TreeAdvancmentTreeType;
import si.nevensrok.jtekma.schema.competition.TreeAdvancmentType;
import si.nevensrok.jtekma.schema.competition.TreeCategoryType;
import si.nevensrok.jtekma.schema.competition.TreeTypeEnum;
import si.nevensrok.jtekma.schema.competition.WeightCategoryOptionListType;
import si.nevensrok.jtekma.schema.competition.WeightCategoryOptionType;
import si.nevensrok.jtekma.server.exporters.CompetitionExporter;

public class CompetitionV1Exporter
extends CompetitionExporter {
    private static final String SETTINGS_DATE_FORMAT_TEXT = "yyyy-MM-dd HH:mm:ss.SSS Z";

    @Override
    public CompetitionData generateCompetitionData() {
        SimpleDateFormat settingsDateFormat = new SimpleDateFormat(SETTINGS_DATE_FORMAT_TEXT);
        CompetitionData competitionData = new CompetitionData();
        competitionData.setVersion(1);
        competitionData.setDate(this.toXMLGregorianCalendar(Calendar.getInstance().getTime()));
        Competition competition = this.getCompetitionManager().getById(this.getCompetitionId());
        competitionData.setCompetition(new CompetitionType());
        competitionData.getCompetition().setName(competition.getName());
        competitionData.getCompetition().setDate(this.toXMLGregorianCalendar(competition.getCompetitonDate()));
        competitionData.getCompetition().setDescription(competition.getDescription());
        competitionData.getCompetition().setRules(competition.getRules());
        competitionData.getCompetition().setStatus(this.toCompetitionStatusEnum(competition.getStatus()));
        competitionData.getCompetition().setCompetitionSettingList(new CompetitionSettingListType());
        Map competitionSettings = this.getCompetitionManager().getCompetitionSettings(competition);
        for (Map.Entry entry : competitionSettings.entrySet()) {
            Comparable<Date> date;
            Number number;
            CompetitionSettingType competitionSettingType = new CompetitionSettingType();
            competitionSettingType.setSettingKey((String)entry.getKey());
            Object value = entry.getValue();
            if (value == null) {
                competitionSettingType.setValueType(SettingValueTypeEnum.STRING);
                competitionSettingType.setSettingValue(null);
            } else if (value instanceof String) {
                String text = (String)value;
                competitionSettingType.setValueType(SettingValueTypeEnum.STRING);
                competitionSettingType.setSettingValue(text);
            } else if (value instanceof Integer) {
                number = (Integer)value;
                competitionSettingType.setValueType(SettingValueTypeEnum.NUMBER);
                competitionSettingType.setSettingValue(((Integer)number).toString());
            } else if (value instanceof Long) {
                number = (Long)value;
                competitionSettingType.setValueType(SettingValueTypeEnum.NUMBER);
                competitionSettingType.setSettingValue(((Long)number).toString());
            } else if (value instanceof Float) {
                number = (Float)value;
                competitionSettingType.setValueType(SettingValueTypeEnum.DECIMAL);
                competitionSettingType.setSettingValue(((Float)number).toString());
            } else if (value instanceof Double) {
                number = (Double)value;
                competitionSettingType.setValueType(SettingValueTypeEnum.DECIMAL);
                competitionSettingType.setSettingValue(((Double)number).toString());
            } else if (value instanceof Date) {
                date = (Date)value;
                competitionSettingType.setValueType(SettingValueTypeEnum.DATE);
                competitionSettingType.setSettingValue(settingsDateFormat.format((Date)date));
            } else if (value instanceof Calendar) {
                date = (Calendar)value;
                competitionSettingType.setValueType(SettingValueTypeEnum.DATE);
                competitionSettingType.setSettingValue(settingsDateFormat.format(((Calendar)date).getTime()));
            } else if (value instanceof Boolean) {
                Boolean bool = (Boolean)value;
                competitionSettingType.setValueType(SettingValueTypeEnum.BOOLEAN);
                competitionSettingType.setSettingValue(bool.toString());
            }
            competitionData.getCompetition().getCompetitionSettingList().getCompetitionSetting().add(competitionSettingType);
        }
        competitionData.setAgeCategoryOptionList(new AgeCategoryOptionListType());
        List ageCategoryOptions = this.getAgeCategoryOptionManager().getActiveAgeCategoriesForCompetitions(competition);
        for (Object ageCategoryOption : ageCategoryOptions) {
            AgeCategoryOptionType ageCategoryOptionType = this.toAgeCategoryOptionType((AgeCategoryOption)ageCategoryOption);
            this.getAgeCategoryIds().put(ageCategoryOption.getAgeCategoryId(), ageCategoryOptionType.getId());
            competitionData.getAgeCategoryOptionList().getAgeCategoryOption().add(ageCategoryOptionType);
        }
        competitionData.setWeightCategoryOptionList(new WeightCategoryOptionListType());
        List list = this.getWeightCategoryOptionManager().getActiveWeightCategoriesForCompetitions(competition);
        for (Object weightCategoryOption : list) {
            WeightCategoryOptionType weightCategoryOptionType = this.toWeightCategoryOptionType((WeightCategoryOption)weightCategoryOption);
            this.getWeightCategoryIds().put(weightCategoryOption.getWeightCategoryOptionId(), weightCategoryOptionType.getId());
            competitionData.getWeightCategoryOptionList().getWeightCategoryOption().add(weightCategoryOptionType);
        }
        competitionData.setTreeAdvancmentList(new TreeAdvancmentListType());
        List treeAdvancements = this.getTreeAdvancmentManager().getActiveTreeAdvancmentsForCompetitions(competition);
        for (Object treeAdvancement : treeAdvancements) {
            TreeAdvancmentType treeAdvancmentType = this.toTreeAdvancmentType((TreeAdvancment)treeAdvancement);
            this.getTreeAdvancmentIds().put(treeAdvancement.getTreeAdvancmentId(), treeAdvancmentType.getId());
            competitionData.getTreeAdvancmentList().getTreeAdvancment().add(treeAdvancmentType);
        }
        competitionData.setClubList(new ClubListType());
        List clubs = this.getClubManager().getActiveClubForCompetition(competition);
        for (Object club : clubs) {
            ClubType clubType = this.toClubType((Club)club);
            this.getClubIds().put(club.getClubId(), clubType.getId());
            competitionData.getClubList().getClub().add(clubType);
        }
        competitionData.setCompetitorList(new CompetitorListType());
        List competitors = this.getCompetitorManager().getActiveCompetitorsForCompetition(competition);
        for (Object competitor : competitors) {
            CompetitorType competitorType = this.toCompetitorType((Competitor)competitor);
            this.getCompetitorIds().put(competitor.getCompetitorId(), competitorType.getId());
            competitionData.getCompetitorList().getCompetitor().add(competitorType);
        }
        competitionData.setCategoryList(new CategoryListType());
        List categories = this.getCategoryManager().getActiveCategoriesForCompetition(competition);
        for (Object category : categories) {
            CategoryType categoryType = this.toCategoryType((Category)category);
            this.getCategoryIds().put(category.getCategoryId(), categoryType.getId());
            competitionData.getCategoryList().getCategory().add(categoryType);
        }
        competitionData.setTatamiList(new TatamiListType());
        List tatamis = this.getTatamiManager().find(competition, (DataFilter)new SimpleDataFilter()).getData();
        for (Object tatami : tatamis) {
            TatamiType tatamiType = this.toTatamiType((Tatami)tatami);
            this.getTatamiIds().put(tatami.getTatamiId(), tatamiType.getId());
            competitionData.getTatamiList().getTatami().add(tatamiType);
        }
        competitionData.setSemaphoreList(new SemaphoreListType());
        List semaphores = this.getSemaphoreManager().find(competition, (DataFilter)new SimpleDataFilter()).getData();
        for (Object semaphore : semaphores) {
            SemaphoreType semaphoreType = this.toSemaphoreType((Semaphore)semaphore);
            this.getSemaphoreIds().put(semaphore.getSemaphoreId(), semaphoreType.getId());
            competitionData.getSemaphoreList().getSemaphore().add(semaphoreType);
        }
        competitionData.setNextMatchUploadList(new NextMatchUploadListType());
        List nextMatchUploads = this.getNextMatchUploadManager().find(competition, (DataFilter)new SimpleDataFilter()).getData();
        for (Object nextMatchUpload : nextMatchUploads) {
            NextMatchUploadType nextMatchUploadType = this.toNextMatchUploadType((NextMatchUpload)nextMatchUpload);
            competitionData.getNextMatchUploadList().getNextMatchUpload().add(nextMatchUploadType);
        }
        competitionData.setCategoryGroupList(new CategoryGroupListType());
        List categoryGroups = this.getCategoryGroupManager().findCategoryGroups(competition, (DataFilter)new SimpleDataFilter()).getData();
        for (CategoryGroup categoryGroup : categoryGroups) {
            CategoryGroupType categoryGroupType = this.toCategoryGroupType(categoryGroup);
            categoryGroupType.setCategoryIds(new IdListType());
            for (Object category : this.getCategoryGroupManager().getCategoriesForGroup(categoryGroup)) {
                String categoryId = this.getCategoryIds().get(category.getCategoryId());
                if (categoryId == null) continue;
                categoryGroupType.getCategoryIds().getId().add(categoryId);
            }
            competitionData.getCategoryGroupList().getCategoryGroup().add(categoryGroupType);
        }
        competitionData.setJudgeList(new JudgeListType());
        List judges = this.getJudgeManager().find(competition, (DataFilter)new SimpleDataFilter()).getData();
        for (Judge judge : judges) {
            JudgeType judgeType = this.toJudgeType(judge);
            this.getJudgeIds().put(judge.getJudgeId(), judgeType.getId());
            judgeType.setJudgeOnTatamiList(new JudgeOnTatamiListType());
            for (Tatami tatami : this.getJudgeManager().getTatamisForJudge(judge)) {
                judgeType.getJudgeOnTatamiList().getTatamiId().add(this.getTatamiIds().get(tatami.getId()));
            }
            competitionData.getJudgeList().getJudge().add(judgeType);
        }
        for (Map.Entry entry : this.getMatches().entrySet()) {
            for (MatchGrading matchGrading : this.getMatchManager().getMatchGradings((Match)entry.getKey())) {
                MatchGradingType matchGradingType = this.toMatchGradingType(matchGrading);
                ((MatchType)entry.getValue()).getMatchGradingList().getMatchGrading().add(matchGradingType);
            }
        }
        for (Map.Entry entry : this.getDuoPresentations().entrySet()) {
            for (DuoPresentationGrading duoPresentationGrading : this.getDuoPresentationManager().getDuoPresentationGradings((DuoPresentation)entry.getKey())) {
                DuoPresentationGradingType duoPresentationGradingType = this.toDuoPresentationGradingType(duoPresentationGrading);
                ((DuoPresentationType)entry.getValue()).getDuoPresentationGradingList().getDuoPresentationGrading().add(duoPresentationGradingType);
            }
        }
        return competitionData;
    }

    private AgeCategoryOptionType toAgeCategoryOptionType(AgeCategoryOption ageCategoryOption) {
        AgeCategoryOptionType ageCategoryOptionType = new AgeCategoryOptionType();
        ageCategoryOptionType.setId(this.generateId());
        ageCategoryOptionType.setName(ageCategoryOption.getName());
        ageCategoryOptionType.setAge(ageCategoryOption.getAge().intValue());
        ageCategoryOptionType.setFightTime(ageCategoryOption.getFightTime().intValue());
        ageCategoryOptionType.setHosekomiTime(ageCategoryOption.getHosekomiTime().intValue());
        ageCategoryOptionType.setNewazaPenaltyHansokumake(ageCategoryOption.getNewazaPenaltyHansokumake());
        return ageCategoryOptionType;
    }

    private WeightCategoryOptionType toWeightCategoryOptionType(WeightCategoryOption weightCategoryOption) {
        WeightCategoryOptionType weightCategoryOptionType = new WeightCategoryOptionType();
        weightCategoryOptionType.setId(this.generateId());
        weightCategoryOptionType.setWeight(weightCategoryOption.getWeight().intValue());
        weightCategoryOptionType.setIsAbsolute(weightCategoryOption.getIsAbsolute().booleanValue());
        weightCategoryOptionType.setGender(this.toGenderTypeEnum(weightCategoryOption.getGender()));
        return weightCategoryOptionType;
    }

    private GenderTypeEnum toGenderTypeEnum(Gender gender) {
        if (gender == null) {
            return null;
        }
        switch (gender) {
            case FEMALE: {
                return GenderTypeEnum.FEMALE;
            }
            case MALE: {
                return GenderTypeEnum.MALE;
            }
            case MIX: {
                return GenderTypeEnum.MIX;
            }
        }
        return null;
    }

    private ClubType toClubType(Club club) {
        ClubType clubType = new ClubType();
        clubType.setId(this.generateId());
        clubType.setName(club.getName());
        clubType.setShortName(club.getShortName());
        clubType.setCountForClubPlacings(club.getCountForClubPlacings());
        return clubType;
    }

    private CategoryType toCategoryType(Category category) {
        AgeCategoryOption ageCategoryOption;
        WeightCategoryOption weightCategoryOption;
        FightingCategoryType categoryType = null;
        if (category instanceof FightingCategory) {
            AgeCategoryOption ageCategoryOption2;
            FightingCategoryType fightingCategoryType;
            FightingCategory fightingCategory = (FightingCategory)category;
            categoryType = fightingCategoryType = new FightingCategoryType();
            fightingCategoryType.setType(CategoryTypeEnum.FIGHTING);
            weightCategoryOption = this.getWeightCategoryOptionManager().getForCategory(fightingCategory);
            if (weightCategoryOption != null) {
                fightingCategoryType.setWeightCategoryOptionId(this.getWeightCategoryIds().get(weightCategoryOption.getWeightCategoryOptionId()));
            }
            if ((ageCategoryOption2 = this.getAgeCategoryOptionManager().getForCategory(fightingCategory)) != null) {
                fightingCategoryType.setAgeCategoryOptionId(this.getAgeCategoryIds().get(ageCategoryOption2.getAgeCategoryId()));
            }
        } else if (category instanceof NewazaCategory) {
            AgeCategoryOption ageCategoryOption2;
            NewazaCategory newazaCategory = (NewazaCategory)category;
            NewazaCategoryType newazaCategoryType = new NewazaCategoryType();
            categoryType = newazaCategoryType;
            newazaCategoryType.setType(CategoryTypeEnum.NEWAZA);
            weightCategoryOption = this.getWeightCategoryOptionManager().getForCategory(newazaCategory);
            if (weightCategoryOption != null) {
                newazaCategoryType.setWeightCategoryOptionId(this.getWeightCategoryIds().get(weightCategoryOption.getWeightCategoryOptionId()));
            }
            if ((ageCategoryOption2 = this.getAgeCategoryOptionManager().getForCategory(newazaCategory)) != null) {
                newazaCategoryType.setAgeCategoryOptionId(this.getAgeCategoryIds().get(ageCategoryOption2.getAgeCategoryId()));
            }
        } else if (category instanceof DuoCategory) {
            DuoCategory duoCategory = (DuoCategory)category;
            DuoCategoryType duoCategoryType = new DuoCategoryType();
            categoryType = duoCategoryType;
            duoCategoryType.setType(CategoryTypeEnum.DUO);
            duoCategoryType.setGender(this.toGenderTypeEnum(duoCategory.getGender()));
            ageCategoryOption = this.getAgeCategoryOptionManager().getForCategory(duoCategory);
            if (ageCategoryOption != null) {
                duoCategoryType.setAgeCategoryOptionId(this.getAgeCategoryIds().get(ageCategoryOption.getAgeCategoryId()));
            }
        } else if (category instanceof Duo2023Category) {
            Duo2023Category duo2023Category = (Duo2023Category)category;
            Duo2023CategoryType duo2023CategoryType = new Duo2023CategoryType();
            categoryType = duo2023CategoryType;
            duo2023CategoryType.setType(CategoryTypeEnum.DUO_2023);
            duo2023CategoryType.setGender(this.toGenderTypeEnum(duo2023Category.getGender()));
            duo2023CategoryType.setDouble3RdPlace(((Boolean)ObjectUtil.ifNull((Object)duo2023Category.getDouble3rdPlace(), (Object)Boolean.FALSE)).booleanValue());
            duo2023CategoryType.setAdvancedLevel((Boolean)ObjectUtil.ifNull((Object)duo2023Category.getAdvancedLevel(), (Object)Boolean.TRUE));
            duo2023CategoryType.setNoviceLevel((Boolean)ObjectUtil.ifNull((Object)duo2023Category.getNoviceLevel(), (Object)Boolean.TRUE));
            ageCategoryOption = this.getAgeCategoryOptionManager().getForCategory(duo2023Category);
            if (ageCategoryOption != null) {
                duo2023CategoryType.setAgeCategoryOptionId(this.getAgeCategoryIds().get(ageCategoryOption.getAgeCategoryId()));
            }
            duo2023CategoryType.setCompetitorDrawList(new CompetitorDrawListType());
            Map draw = this.getCategoryManager().getGroupDraw((Category)duo2023Category);
            for (Map.Entry entry : draw.entrySet()) {
                CompetitorDrawType competitorDrawType = new CompetitorDrawType();
                competitorDrawType.setCompetitorId(this.getCompetitorIds().get(((Competitor)entry.getKey()).getCompetitorId()));
                competitorDrawType.setDrawNumber(((Integer)ObjectUtil.ifNull((Object)((GroupDraw)entry.getValue()).getDrawNumber(), (Object)0)).intValue());
                competitorDrawType.setDrawGroup(((GroupDraw)entry.getValue()).getDrawGroup());
                duo2023CategoryType.getCompetitorDrawList().getCompetitorDraw().add(competitorDrawType);
            }
            for (Rank rank : Rank.values()) {
                duo2023CategoryType.setCompetitorPlacingList(new CompetitorPlacingListType());
                Map placings = this.getCategoryManager().getPlacings((Category)duo2023Category, rank);
                for (Map.Entry entry : placings.entrySet()) {
                    CompetitorPlacingType competitorPlacingType = new CompetitorPlacingType();
                    competitorPlacingType.setCompetitorId(this.getCompetitorIds().get(((Competitor)entry.getKey()).getCompetitorId()));
                    competitorPlacingType.setPlacing(((Integer)ObjectUtil.ifNull(entry.getValue(), (Object)0)).intValue());
                    competitorPlacingType.setPlacingRank(this.toRankEnum(rank));
                    duo2023CategoryType.getCompetitorPlacingList().getCompetitorPlacing().add(competitorPlacingType);
                }
            }
        } else {
            categoryType = new CategoryType();
            categoryType.setType(CategoryTypeEnum.CUSTOM);
        }
        categoryType.setCompetitorIdList(new IdListType());
        List competitorsForCategory = this.getCategoryManager().getCompetitorsForCategory(category);
        for (Competitor competitor : competitorsForCategory) {
            categoryType.getCompetitorIdList().getId().add(this.getCompetitorIds().get(competitor.getCompetitorId()));
        }
        if (category instanceof TreeCategory) {
            TreeCategory treeCategory = (TreeCategory)category;
            TreeCategoryType treeCategoryType = (TreeCategoryType)categoryType;
            treeCategoryType.setTreeType(this.toTreeTypeEnum(treeCategory.getTreeType()));
            treeCategoryType.setRepassageType(this.toRepassageTypeEnum(treeCategory.getRepassageType()));
            treeCategoryType.setDouble3RdPlace(((Boolean)ObjectUtil.ifNull((Object)treeCategory.getDouble3rdPlace(), (Object)Boolean.FALSE)).booleanValue());
            treeCategoryType.setRepassageFromRound(treeCategory.getRepassageFromRound().intValue());
            TreeAdvancment treeAdvancment = this.getTreeAdvancmentManager().getForCategory(treeCategory);
            treeCategoryType.setTreeAdvancmentId(this.getTreeAdvancmentIds().get(treeAdvancment.getTreeAdvancmentId()));
            treeCategoryType.setCompetitorDrawList(new CompetitorDrawListType());
            Map map = this.getCategoryManager().getDraw((Category)treeCategory);
            for (Map.Entry entry : map.entrySet()) {
                CompetitorDrawType competitorDrawType = new CompetitorDrawType();
                competitorDrawType.setCompetitorId(this.getCompetitorIds().get(((Competitor)entry.getKey()).getCompetitorId()));
                competitorDrawType.setDrawNumber(((Integer)ObjectUtil.ifNull(entry.getValue(), (Object)0)).intValue());
                treeCategoryType.getCompetitorDrawList().getCompetitorDraw().add(competitorDrawType);
            }
            treeCategoryType.setCompetitorPlacingList(new CompetitorPlacingListType());
            Map map2 = this.getCategoryManager().getPlacings((Category)treeCategory);
            for (Map.Entry entry : map2.entrySet()) {
                CompetitorPlacingType competitorPlacingType = new CompetitorPlacingType();
                competitorPlacingType.setCompetitorId(this.getCompetitorIds().get(((Competitor)entry.getKey()).getCompetitorId()));
                competitorPlacingType.setPlacing(((Integer)ObjectUtil.ifNull(entry.getValue(), (Object)0)).intValue());
                treeCategoryType.getCompetitorPlacingList().getCompetitorPlacing().add(competitorPlacingType);
            }
        }
        categoryType.setId(this.generateId());
        categoryType.setName(category.getName());
        categoryType.setShortName(category.getShortName());
        categoryType.setAutomationOrder(category.getAutomationOrder());
        categoryType.setCountForClubPlacings(category.getCountForClubPlacings());
        categoryType.setMatches(new MatchListType());
        List matches = this.getMatchManager().getMatchesForCategory(category);
        HashMap matchPoints = new HashMap();
        for (Map.Entry entry : this.getMatchManager().getMatchPointsForMatches(new HashSet(matches)).entrySet()) {
            matchPoints.put(((Match)entry.getKey()).getMatchId(), entry.getValue());
        }
        HashMap matchPointDetails = new HashMap();
        for (Map.Entry entry : this.getMatchManager().getMatchPointDetailsForMatches(new HashSet(matches)).entrySet()) {
            matchPointDetails.put(((Match)entry.getKey()).getMatchId(), entry.getValue());
        }
        for (Match match : matches) {
            MatchType matchType = this.toMatchType(match);
            matchType.setCompetitor1Points(new MatchPointListType());
            matchType.setCompetitor2Points(new MatchPointListType());
            for (MatchPoint matchPoint : (Set)matchPoints.get(match.getMatchId())) {
                MatchPointType matchPointType = this.toMatchPointType(matchPoint);
                if (matchPoint.getCompetitor() == si.nevensrok.jtekma.common.rules.CompetitorType.COMPETITOR1) {
                    matchType.getCompetitor1Points().getMatchPoint().add(matchPointType);
                    continue;
                }
                if (matchPoint.getCompetitor() != si.nevensrok.jtekma.common.rules.CompetitorType.COMPETITOR2) continue;
                matchType.getCompetitor2Points().getMatchPoint().add(matchPointType);
            }
            matchType.setCompetitor1PointDetails(new MatchPointDetailListType());
            matchType.setCompetitor2PointDetails(new MatchPointDetailListType());
            for (PointDetail pointDetail : (Set)matchPointDetails.get(match.getMatchId())) {
                MatchPointDetailType matchPointDetailType = this.toMatchPointDetailType(pointDetail);
                if (pointDetail.getCompetitor() == si.nevensrok.jtekma.common.rules.CompetitorType.COMPETITOR1) {
                    matchType.getCompetitor1PointDetails().getMatchPointDetail().add(matchPointDetailType);
                    continue;
                }
                if (pointDetail.getCompetitor() != si.nevensrok.jtekma.common.rules.CompetitorType.COMPETITOR2) continue;
                matchType.getCompetitor2PointDetails().getMatchPointDetail().add(matchPointDetailType);
            }
            this.getMatches().put(match, matchType);
            categoryType.getMatches().getMatch().add(matchType);
        }
        categoryType.setDuoPresentations(new DuoPresentationListType());
        List list = this.getDuoPresentationManager().getDuoPresentationsForCategory(category);
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : this.getDuoPresentationManager().getDuoPresentationsForDuoPresentations(new HashSet(list)).entrySet()) {
            hashMap.put(((DuoPresentation)entry.getKey()).getDuoPresentationId(), entry.getValue());
        }
        for (DuoPresentation duoPresentation : list) {
            DuoPresentationType duoPresentationType = this.toDuoPresentationType(duoPresentation);
            duoPresentationType.setDuoPresentationPoints(new DuoPresentationPointListType());
            for (DuoPresentationPoint duoPresentationPoint : (Set)hashMap.get(duoPresentation.getDuoPresentationId())) {
                DuoPresentationPointType duoPresentationPointType = this.toDuoPresentationPointType(duoPresentationPoint);
                duoPresentationType.getDuoPresentationPoints().getDuoPresentationPoint().add(duoPresentationPointType);
            }
            this.getDuoPresentations().put(duoPresentation, duoPresentationType);
            categoryType.getDuoPresentations().getDuoPresentation().add(duoPresentationType);
        }
        return categoryType;
    }

    private TreeTypeEnum toTreeTypeEnum(TreeCategory.TreeType treeType) {
        switch (treeType) {
            case TABLE2: {
                return TreeTypeEnum.TABLE_2;
            }
            case TABLE3: {
                return TreeTypeEnum.TABLE_3;
            }
            case TABLE4: {
                return TreeTypeEnum.TABLE_4;
            }
            case TABLE5: {
                return TreeTypeEnum.TABLE_5;
            }
            case TREE4: {
                return TreeTypeEnum.TREE_4;
            }
            case TREE8: {
                return TreeTypeEnum.TREE_8;
            }
            case TREE16: {
                return TreeTypeEnum.TREE_16;
            }
            case TREE32: {
                return TreeTypeEnum.TREE_32;
            }
            case TREE64: {
                return TreeTypeEnum.TREE_64;
            }
            case BEST_OF_3: {
                return TreeTypeEnum.BEST_OF_3;
            }
        }
        return null;
    }

    private RepassageTypeEnum toRepassageTypeEnum(TreeCategory.RepassageType repassageType) {
        switch (repassageType) {
            case NONE: {
                return RepassageTypeEnum.NONE;
            }
            case SINGLE: {
                return RepassageTypeEnum.SINGLE;
            }
            case DOUBLE: {
                return RepassageTypeEnum.DOUBLE;
            }
        }
        return null;
    }

    private TreeAdvancmentType toTreeAdvancmentType(TreeAdvancment treeAdvancment) {
        TreeAdvancmentType treeAdvancmentType = new TreeAdvancmentType();
        treeAdvancmentType.setId(this.generateId());
        treeAdvancmentType.setName(treeAdvancment.getName());
        treeAdvancmentType.setTreeAdvancmentItemList(new TreeAdvancmentItemListType());
        for (TreeAdvancmentItem treeAdvancmentItem : treeAdvancment.getTreeAdvancmentItems()) {
            TreeAdvancmentItemType treeAdvancmentItemType = this.toTreeAdvancmentItemType(treeAdvancmentItem);
            treeAdvancmentType.getTreeAdvancmentItemList().getTreeAdvancmentItem().add(treeAdvancmentItemType);
        }
        return treeAdvancmentType;
    }

    private TreeAdvancmentItemType toTreeAdvancmentItemType(TreeAdvancmentItem treeAdvancmentItem) {
        TreeAdvancmentItemType treeAdvancmentItemType = new TreeAdvancmentItemType();
        treeAdvancmentItemType.setForMatch(treeAdvancmentItem.getForMatch().intValue());
        treeAdvancmentItemType.setCompetitorType(this.toTreeAdvancmentCompetitorTypeEnum(treeAdvancmentItem.getCompetitorType()));
        treeAdvancmentItemType.setFromMatch(treeAdvancmentItem.getFromMatch().intValue());
        treeAdvancmentItemType.setSelectType(this.toTreeAdvancmentSelectTypeEnum(treeAdvancmentItem.getSelectType()));
        treeAdvancmentItemType.setTreeType(this.toTreeAdvancmentTreeType(treeAdvancmentItem.getTreeType()));
        return treeAdvancmentItemType;
    }

    private TreeAdvancmentCompetitorTypeEnum toTreeAdvancmentCompetitorTypeEnum(si.nevensrok.jtekma.common.rules.CompetitorType competitorType) {
        switch (competitorType) {
            case COMPETITOR1: {
                return TreeAdvancmentCompetitorTypeEnum.COMPETITOR_1;
            }
            case COMPETITOR2: {
                return TreeAdvancmentCompetitorTypeEnum.COMPETITOR_2;
            }
        }
        return null;
    }

    private TreeAdvancmentSelectTypeEnum toTreeAdvancmentSelectTypeEnum(SelectType selectType) {
        switch (selectType) {
            case WINNER: {
                return TreeAdvancmentSelectTypeEnum.WINNER;
            }
            case LOSER: {
                return TreeAdvancmentSelectTypeEnum.LOSER;
            }
            case DRAW: {
                return TreeAdvancmentSelectTypeEnum.DRAW;
            }
        }
        return null;
    }

    private TreeAdvancmentTreeType toTreeAdvancmentTreeType(TreeType treeType) {
        switch (treeType) {
            case TREE: {
                return TreeAdvancmentTreeType.TREE;
            }
            case TABLE: {
                return TreeAdvancmentTreeType.TABLE;
            }
        }
        return null;
    }

    private CompetitorType toCompetitorType(Competitor competitor) {
        PersonCompetitorType competitorType = null;
        if (competitor instanceof PersonCompetitor) {
            PersonCompetitor personCompetitor = (PersonCompetitor)competitor;
            competitorType = new PersonCompetitorType();
            competitorType.setType(CompetitorTypeEnum.COMPETITOR);
            PersonCompetitorType personCompetitorType = competitorType;
            personCompetitorType.setName(personCompetitor.getName());
            personCompetitorType.setSurname(personCompetitor.getSurname());
            personCompetitorType.setShortName(personCompetitor.getShortName());
            if (personCompetitor.getYearOfBirth() != null) {
                personCompetitorType.setYearOfBirth(personCompetitor.getYearOfBirth().intValue());
            }
            if (personCompetitor.getWeight() != null) {
                personCompetitorType.setWeight(personCompetitor.getWeight().intValue());
            }
        } else if (competitor instanceof CoupleCompetitor) {
            CoupleCompetitor coupleCompetitor = (CoupleCompetitor)competitor;
            competitorType = new CoupleCompetitorType();
            competitorType.setType(CompetitorTypeEnum.COUPLE);
            CoupleCompetitorType coupleCompetitorType = (CoupleCompetitorType)competitorType;
            coupleCompetitorType.setName1(coupleCompetitor.getName1());
            coupleCompetitorType.setSurname1(coupleCompetitor.getSurname1());
            coupleCompetitorType.setName2(coupleCompetitor.getName2());
            coupleCompetitorType.setSurname2(coupleCompetitor.getSurname2());
            coupleCompetitorType.setShortName(coupleCompetitor.getShortName());
            if (coupleCompetitor.getYearOfBirth1() != null) {
                coupleCompetitorType.setYearOfBirth1(coupleCompetitor.getYearOfBirth1().intValue());
            }
            if (coupleCompetitor.getYearOfBirth2() != null) {
                coupleCompetitorType.setYearOfBirth2(coupleCompetitor.getYearOfBirth2().intValue());
            }
        }
        competitorType.setId(this.generateId());
        Club club = this.getClubManager().getClubForCompetitor(competitor);
        competitorType.setClubId(this.getClubIds().get(club.getClubId()));
        return competitorType;
    }

    private MatchType toMatchType(Match match) {
        MatchType matchType = new MatchType();
        if (match.getCompetitor1() != null) {
            matchType.setCompetitor1Id(this.getCompetitorIds().get(match.getCompetitor1().getCompetitorId()));
        }
        if (match.getCompetitor2() != null) {
            matchType.setCompetitor2Id(this.getCompetitorIds().get(match.getCompetitor2().getCompetitorId()));
        }
        matchType.setFightNumber(match.getFightNumber().intValue());
        matchType.setMatchType(this.toMatchTypeEnum(match.getType()));
        matchType.setFinished(match.getStatus() == Match.Status.FINISHED);
        matchType.setNoWinner(match.getNoWinner().booleanValue());
        matchType.setStartedAt(this.toXMLGregorianCalendar(match.getStartedAt()));
        matchType.setFinishedAt(this.toXMLGregorianCalendar(match.getFinishedAt()));
        matchType.setMatchDuration(match.getMatchDuration());
        matchType.setFightTimeLeft(match.getFightTimeLeft());
        matchType.setHosekomiTime(match.getHosekomiTime());
        matchType.setInjuryTime1(match.getInjuryTime1());
        matchType.setInjuryTime2(match.getInjuryTime2());
        matchType.setChallengesWon1(match.getChallengesWon1());
        matchType.setChallengesWon2(match.getChallengesWon2());
        matchType.setChallengesLost1(match.getChallengesLost1());
        matchType.setChallengesLost2(match.getChallengesLost2());
        matchType.setMatchGradingList(new MatchGradingListType());
        matchType.setMatchValidAttackList(new MatchValidAttackListType());
        for (MatchValidAttack matchValidAttack : this.getMatchManager().getValidAttacksForMatch(match)) {
            MatchValidAttackType matchValidAttackType = this.toMatchValidAttackType(matchValidAttack);
            matchType.getMatchValidAttackList().getMatchValidAttack().add(matchValidAttackType);
        }
        return matchType;
    }

    private MatchTypeEnum toMatchTypeEnum(Match.Type matchType) {
        switch (matchType) {
            case FIGHT: {
                return MatchTypeEnum.FIGHT;
            }
            case DUO: {
                return MatchTypeEnum.DUO;
            }
            case DUO2023: {
                return MatchTypeEnum.DUO_2023;
            }
            case NEWAZA: {
                return MatchTypeEnum.NEWAZA;
            }
        }
        return null;
    }

    private MatchPointType toMatchPointType(MatchPoint matchPoint) {
        MatchPointType matchPointType = new MatchPointType();
        matchPointType.setPointType(this.toPointTypeEnum(matchPoint.getPointType()));
        matchPointType.setPoints(matchPoint.getPoints().floatValue());
        matchPointType.setRound(matchPoint.getRound());
        matchPointType.setJudge(matchPoint.getJudge());
        matchPointType.setSeries(this.toSeriesEnum(matchPoint.getSeries()));
        matchPointType.setAttack(matchPoint.getAttack());
        matchPointType.setPart(matchPoint.getPart());
        return matchPointType;
    }

    private PointTypeEnum toPointTypeEnum(PointType pointType) {
        switch (pointType) {
            case WAZARI: {
                return PointTypeEnum.WAZARI;
            }
            case IPPON1: {
                return PointTypeEnum.IPPON_1;
            }
            case IPPON2: {
                return PointTypeEnum.IPPON_2;
            }
            case IPPON3: {
                return PointTypeEnum.IPPON_3;
            }
            case IPPON1_3P: {
                return PointTypeEnum.IPPON_1_3_P;
            }
            case IPPON2_3P: {
                return PointTypeEnum.IPPON_2_3_P;
            }
            case IPPON3_3P: {
                return PointTypeEnum.IPPON_3_3_P;
            }
            case IPPON3POINTS: {
                return PointTypeEnum.IPPON_3_POINTS;
            }
            case SHIDO: {
                return PointTypeEnum.SHIDO;
            }
            case CHUI: {
                return PointTypeEnum.CHUI;
            }
            case HANSOKUMAKE: {
                return PointTypeEnum.HANSOKUMAKE;
            }
            case JUDGE: {
                return PointTypeEnum.JUDGE;
            }
            case POINT1: {
                return PointTypeEnum.POINT_1;
            }
            case POINT2: {
                return PointTypeEnum.POINT_2;
            }
            case POINT3: {
                return PointTypeEnum.POINT_3;
            }
            case POINT4: {
                return PointTypeEnum.POINT_4;
            }
            case POINT5: {
                return PointTypeEnum.POINT_5;
            }
            case POINT6: {
                return PointTypeEnum.POINT_6;
            }
            case POINT7: {
                return PointTypeEnum.POINT_7;
            }
            case POINT100: {
                return PointTypeEnum.POINT_100;
            }
            case ADVANTAGE: {
                return PointTypeEnum.ADVANTAGE;
            }
            case FINISHINGMOVE: {
                return PointTypeEnum.FINISHINGMOVE;
            }
            case PENALTY: {
                return PointTypeEnum.PENALTY;
            }
            case VARIETY_SCORE_POINTS: {
                return PointTypeEnum.VARIETY_SCORE_POINTS;
            }
        }
        return null;
    }

    private MatchPointDetailType toMatchPointDetailType(PointDetail pointDetail) {
        MatchPointDetailType matchPointDetailType = new MatchPointDetailType();
        matchPointDetailType.setFightTime(pointDetail.getFightTime().intValue());
        matchPointDetailType.setPointType(this.toPointTypeEnum(pointDetail.getPointType()));
        matchPointDetailType.setChangeType(this.toPointDetailChangeTypeEnum(pointDetail.getChangeType()));
        return matchPointDetailType;
    }

    private PointDetailChangeTypeEnum toPointDetailChangeTypeEnum(PointDetail.ChangeType changeType) {
        switch (changeType) {
            case ADD: {
                return PointDetailChangeTypeEnum.ADD;
            }
            case REMOVE: {
                return PointDetailChangeTypeEnum.REMOVE;
            }
        }
        return null;
    }

    private DuoPresentationType toDuoPresentationType(DuoPresentation duoPresentation) {
        DuoPresentationType duoPresentationType = new DuoPresentationType();
        if (duoPresentation.getCompetitor() != null) {
            duoPresentationType.setCompetitorId(this.getCompetitorIds().get(duoPresentation.getCompetitor().getCompetitorId()));
        }
        duoPresentationType.setRound(this.toRoundEnum(duoPresentation.getRound()));
        duoPresentationType.setGroupNumber(duoPresentation.getGroupNumber());
        duoPresentationType.setGroupPosition(((Integer)ObjectUtil.ifNull((Object)duoPresentation.getGroupPosition(), (Object)0)).intValue());
        duoPresentationType.setFinished(duoPresentation.getStatus() == DuoPresentation.Status.FINISHED);
        duoPresentationType.setStartedAt(this.toXMLGregorianCalendar(duoPresentation.getStartedAt()));
        duoPresentationType.setFinishedAt(this.toXMLGregorianCalendar(duoPresentation.getFinishedAt()));
        duoPresentationType.setMatchDuration(duoPresentation.getMatchDuration());
        duoPresentationType.setDuoPresentationGradingList(new DuoPresentationGradingListType());
        duoPresentationType.setDuoPresentationValidAttackList(new DuoPresentationValidAttackListType());
        for (DuoPresentationValidAttack duoPresentationValidAttack : this.getDuoPresentationManager().getValidAttacksForDuoPresentation(duoPresentation)) {
            DuoPresentationValidAttackType duoPresentationValidAttackType = this.toDuoPresentationValidAttackType(duoPresentationValidAttack);
            duoPresentationType.getDuoPresentationValidAttackList().getDuoPresentationValidAttack().add(duoPresentationValidAttackType);
        }
        return duoPresentationType;
    }

    private DuoPresentationPointType toDuoPresentationPointType(DuoPresentationPoint duoPresentationPoint) {
        DuoPresentationPointType duoPresentationPointType = new DuoPresentationPointType();
        duoPresentationPointType.setType(this.toDuoPresentationPointTypeEnum(duoPresentationPoint.getType()));
        duoPresentationPointType.setPoints(duoPresentationPoint.getPoints().floatValue());
        duoPresentationPointType.setJudge(duoPresentationPoint.getJudge());
        duoPresentationPointType.setSeries(this.toSeriesEnum(duoPresentationPoint.getSeries()));
        duoPresentationPointType.setAttack(duoPresentationPoint.getAttack());
        duoPresentationPointType.setPart(duoPresentationPoint.getPart());
        return duoPresentationPointType;
    }

    private DuoPresentationPointTypeEnum toDuoPresentationPointTypeEnum(DuoPresentationPoint.Type type) {
        switch (type) {
            case POINTS: {
                return DuoPresentationPointTypeEnum.POINTS;
            }
            case VARIETY_SCORE_POINTS: {
                return DuoPresentationPointTypeEnum.VARIETY_SCORE_POINTS;
            }
            case PENALTY: {
                return DuoPresentationPointTypeEnum.PENALTY;
            }
        }
        return null;
    }

    private TatamiType toTatamiType(Tatami tatami) {
        TatamiType tatamiType = new TatamiType();
        tatamiType.setId(this.generateId());
        tatamiType.setName(tatami.getName());
        tatamiType.setPassword(tatami.getPassword());
        tatamiType.setDisplayText(tatami.getDisplayText());
        tatamiType.setCategoryIdList(new CategoryIdListType());
        for (Category category : this.getTatamiManager().getCategoriesForTatami(tatami)) {
            String categoryId = this.getCategoryIds().get(category.getCategoryId());
            if (categoryId == null) continue;
            tatamiType.getCategoryIdList().getCategoryId().add(categoryId);
        }
        tatamiType.setFightOrderList(new FightOrderListType());
        for (FightOrder fightOrder : this.getTatamiManager().getFightOrderForTatami(tatami)) {
            FightOrderType fightOrderType = this.toFightOrderType(fightOrder);
            if (fightOrderType == null) continue;
            tatamiType.getFightOrderList().getFightOrder().add(fightOrderType);
        }
        tatamiType.setTatamiHistoryList(new TatamiHistoryListType());
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setFetchCount(false);
        for (TatamiHistory tatamiHistory : this.getTatamiHistoryManager().findTatamiHistory(tatami, (DataFilter)dataFilter).getData()) {
            TatamiHistoryType tatamiHistoryType = this.toTatamiHistoryType(tatamiHistory);
            if (tatamiHistoryType == null) continue;
            tatamiType.getTatamiHistoryList().getTatamiHistory().add(tatamiHistoryType);
        }
        return tatamiType;
    }

    private FightOrderType toFightOrderType(FightOrder fightOrder) {
        FightOrderType fightOrderType = new FightOrderType();
        fightOrderType.setFightNumber(fightOrder.getFightNumber().intValue());
        if (fightOrder.getEvent() != null) {
            EventType eventType = this.toEventType(fightOrder.getEvent());
            fightOrderType.setEvent(eventType);
        }
        if (fightOrder.getMatch() != null) {
            MatchIdType matchIdType = this.toMatchIdType(fightOrder.getMatch());
            if (matchIdType == null) {
                return null;
            }
            fightOrderType.setMatch(matchIdType);
        }
        if (fightOrder.getDuoPresentation() != null) {
            DuoPresentation duoPresentation = fightOrder.getDuoPresentation();
            DuoPresentationIdType duoPresentationIdType = this.toDuoPresentationIdType(duoPresentation);
            if (duoPresentationIdType == null) {
                return null;
            }
            fightOrderType.setDuoPresentation(duoPresentationIdType);
        }
        return fightOrderType;
    }

    private EventType toEventType(Event event) {
        EventType eventType = new EventType();
        eventType.setAutoRemove(event.getAutoRemove().booleanValue());
        eventType.setText(event.getText());
        return eventType;
    }

    private TatamiHistoryType toTatamiHistoryType(TatamiHistory tatamiHistory) {
        TatamiHistoryType tatamiHistoryType = new TatamiHistoryType();
        tatamiHistoryType.setEventType(TatamiHistoryEventTypeEnum.valueOf((String)tatamiHistory.getEventType().name()));
        tatamiHistoryType.setEventDate(this.toXMLGregorianCalendar(tatamiHistory.getEventDate()));
        if (tatamiHistory.getMatch() != null) {
            MatchIdType matchIdType = this.toMatchIdType(tatamiHistory.getMatch());
            if (matchIdType == null) {
                return null;
            }
            tatamiHistoryType.setMatch(matchIdType);
        }
        if (tatamiHistory.getDuoPresentation() != null) {
            DuoPresentation duoPresentation = tatamiHistory.getDuoPresentation();
            DuoPresentationIdType duoPresentationIdType = this.toDuoPresentationIdType(duoPresentation);
            if (duoPresentationIdType == null) {
                return null;
            }
            tatamiHistoryType.setDuoPresentation(duoPresentationIdType);
        }
        return tatamiHistoryType;
    }

    private MatchIdType toMatchIdType(Match match) {
        Category category = this.getCategoryManager().getCategoryForMatch(match);
        MatchIdType matchIdType = new MatchIdType();
        String categoryId = this.getCategoryIds().get(category.getCategoryId());
        if (categoryId == null) {
            return null;
        }
        matchIdType.setCategoryId(categoryId);
        matchIdType.setMatchNum(match.getFightNumber().intValue());
        return matchIdType;
    }

    private SemaphoreType toSemaphoreType(Semaphore semaphore) {
        SemaphoreType semaphoreType = new SemaphoreType();
        semaphoreType.setId(this.generateId());
        semaphoreType.setName(semaphore.getName());
        semaphoreType.setPassword(semaphore.getPassword());
        semaphoreType.setDisplayRows(semaphore.getDisplayRows().intValue());
        semaphoreType.setTatamiOnSemaphoreList(new TatamiOnSemaphoreListType());
        for (TatamiOnSemaphore tatamiOnSemaphore : this.getSemaphoreManager().getTatamisForSemaphore(semaphore)) {
            TatamiOnSemaphoreType tatamiOnSemaphoreType = new TatamiOnSemaphoreType();
            tatamiOnSemaphoreType.setTatamiId(this.getTatamiIds().get(tatamiOnSemaphore.getTatami().getTatamiId()));
            tatamiOnSemaphoreType.setOrder(tatamiOnSemaphore.getOrderNum().intValue());
            semaphoreType.getTatamiOnSemaphoreList().getTatamiOnSemaphore().add(tatamiOnSemaphoreType);
        }
        return semaphoreType;
    }

    private NextMatchUploadType toNextMatchUploadType(NextMatchUpload nextMatchUpload) {
        NextMatchUploadType nextMatchUploadType = new NextMatchUploadType();
        nextMatchUploadType.setId(this.generateId());
        nextMatchUploadType.setStatus(NextMatchUploadStatusEnum.valueOf((String)nextMatchUpload.getStatus().name()));
        nextMatchUploadType.setServerType(NextMatchUploadServerTypeEnum.valueOf((String)nextMatchUpload.getServerType().name()));
        nextMatchUploadType.setUploadDelay(nextMatchUpload.getUploadDelay().longValue());
        nextMatchUploadType.setHostname(nextMatchUpload.getHostname());
        nextMatchUploadType.setPort(nextMatchUpload.getPort().intValue());
        nextMatchUploadType.setUsername(nextMatchUpload.getUsername());
        nextMatchUploadType.setPassword(nextMatchUpload.getPassword());
        nextMatchUploadType.setFileDirectory(nextMatchUpload.getFileDirectory());
        nextMatchUploadType.setFileName(nextMatchUpload.getFileName());
        nextMatchUploadType.setPageTemplate(nextMatchUpload.getPageTemplate());
        nextMatchUploadType.setPageLocale(nextMatchUpload.getPageLocale());
        return nextMatchUploadType;
    }

    private CategoryGroupType toCategoryGroupType(CategoryGroup categoryGroup) {
        CategoryGroupType categoryGroupType = new CategoryGroupType();
        categoryGroupType.setId(this.generateId());
        categoryGroupType.setName(categoryGroup.getName());
        return categoryGroupType;
    }

    private JudgeType toJudgeType(Judge judge) {
        JudgeType judgeType = new JudgeType();
        judgeType.setId(this.generateId());
        judgeType.setName(judge.getName());
        judgeType.setPassword(judge.getPassword());
        judgeType.setNormalReferee(((Boolean)ObjectUtil.ifNull((Object)judge.getNormalReferee(), (Object)Boolean.FALSE)).booleanValue());
        judgeType.setVideoReferee(((Boolean)ObjectUtil.ifNull((Object)judge.getVideoReferee(), (Object)Boolean.FALSE)).booleanValue());
        return judgeType;
    }

    private DuoPresentationGradingType toDuoPresentationGradingType(DuoPresentationGrading duoPresentationGrading) {
        DuoPresentationGradingType duoPresentationGradingType = new DuoPresentationGradingType();
        duoPresentationGradingType.setJudgeId(this.getJudgeIds().get(duoPresentationGrading.getJudge().getJudgeId()));
        duoPresentationGradingType.setJudgeNum(duoPresentationGrading.getJudgeNum().intValue());
        duoPresentationGradingType.setSentAt(this.toXMLGregorianCalendar(duoPresentationGrading.getSentAt()));
        duoPresentationGradingType.setFinalResult((Boolean)ObjectUtil.ifNull((Object)duoPresentationGrading.getFinalResult(), (Object)Boolean.FALSE));
        return duoPresentationGradingType;
    }

    private DuoPresentationValidAttackType toDuoPresentationValidAttackType(DuoPresentationValidAttack duoPresentationValidAttack) {
        DuoPresentationValidAttackType duoPresentationValidAttackType = new DuoPresentationValidAttackType();
        duoPresentationValidAttackType.setSeries(this.toSeriesEnum(duoPresentationValidAttack.getSeries()));
        duoPresentationValidAttackType.setAttack(duoPresentationValidAttack.getAttack().intValue());
        duoPresentationValidAttackType.setAttackValid(duoPresentationValidAttack.getAttackValid().booleanValue());
        duoPresentationValidAttackType.setSentAt(this.toXMLGregorianCalendar(duoPresentationValidAttack.getSentAt()));
        return duoPresentationValidAttackType;
    }

    private MatchGradingType toMatchGradingType(MatchGrading matchGrading) {
        MatchGradingType matchGradingType = new MatchGradingType();
        matchGradingType.setJudgeId(this.getJudgeIds().get(matchGrading.getJudge().getJudgeId()));
        matchGradingType.setJudgeNum(matchGrading.getJudgeNum().intValue());
        matchGradingType.setSentAt(this.toXMLGregorianCalendar(matchGrading.getSentAt()));
        matchGradingType.setFinalResult((Boolean)ObjectUtil.ifNull((Object)matchGrading.getFinalResult(), (Object)Boolean.FALSE));
        return matchGradingType;
    }

    private MatchValidAttackType toMatchValidAttackType(MatchValidAttack matchValidAttack) {
        MatchValidAttackType matchValidAttackType = new MatchValidAttackType();
        matchValidAttackType.setCompetitor(matchValidAttack.getCompetitor().intValue());
        matchValidAttackType.setSeries(this.toSeriesEnum(matchValidAttack.getSeries()));
        matchValidAttackType.setAttack(matchValidAttack.getAttack().intValue());
        matchValidAttackType.setAttackValid(matchValidAttack.getAttackValid().booleanValue());
        matchValidAttackType.setSentAt(this.toXMLGregorianCalendar(matchValidAttack.getSentAt()));
        return matchValidAttackType;
    }

    private DuoPresentationIdType toDuoPresentationIdType(DuoPresentation duoPresentation) {
        Category category = this.getCategoryManager().getCategoryForDuoPresentation(duoPresentation);
        DuoPresentationIdType duoPresentationIdType = new DuoPresentationIdType();
        String categoryId = this.getCategoryIds().get(category.getCategoryId());
        if (categoryId == null) {
            return null;
        }
        if (duoPresentation.getCompetitor() == null) {
            return null;
        }
        duoPresentationIdType.setCategoryId(categoryId);
        duoPresentationIdType.setRound(this.toRoundEnum(duoPresentation.getRound()));
        duoPresentationIdType.setCompetitorId(this.getCompetitorIds().get(duoPresentation.getCompetitor().getCompetitorId()));
        return duoPresentationIdType;
    }

    private SeriesEnum toSeriesEnum(Series series) {
        if (series == null) {
            return null;
        }
        switch (series) {
            case A: {
                return SeriesEnum.A;
            }
            case B: {
                return SeriesEnum.B;
            }
            case C: {
                return SeriesEnum.C;
            }
        }
        return null;
    }

    private RankEnum toRankEnum(Rank rank) {
        if (rank == null) {
            return null;
        }
        switch (rank) {
            case WORLD_LEVEL: {
                return RankEnum.WORLD_LEVEL;
            }
            case ADVANCED: {
                return RankEnum.ADVANCED;
            }
            case NOVICE: {
                return RankEnum.NOVICE;
            }
        }
        return null;
    }

    private RoundEnum toRoundEnum(Round round) {
        if (round == null) {
            return null;
        }
        switch (round) {
            case ROUND_1: {
                return RoundEnum.ROUND_1;
            }
            case ROUND_2: {
                return RoundEnum.ROUND_2;
            }
            case ROUND_3: {
                return RoundEnum.ROUND_3;
            }
            case ROUND_4: {
                return RoundEnum.ROUND_4;
            }
            case ROUND_5: {
                return RoundEnum.ROUND_5;
            }
        }
        return null;
    }

    private CompetitionStatusEnum toCompetitionStatusEnum(Competition.Status status) {
        switch (status) {
            case ACTIVE: {
                return CompetitionStatusEnum.ACTIVE;
            }
            case FINISHED: {
                return CompetitionStatusEnum.FINISHED;
            }
        }
        return null;
    }
}

