/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dataimport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.dataexport.FileWriter;
import si.nevensrok.common.dataimport.FileContent;
import si.nevensrok.common.dataimport.FileLine;
import si.nevensrok.common.dataimport.FileReader;
import si.nevensrok.jtekma.common.Gender;
import si.nevensrok.jtekma.common.category.AgeCategoryOption;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.CategoryGroup;
import si.nevensrok.jtekma.common.category.Duo2023Category;
import si.nevensrok.jtekma.common.category.DuoCategory;
import si.nevensrok.jtekma.common.category.FightingCategory;
import si.nevensrok.jtekma.common.category.NewazaCategory;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.category.WeightCategoryOption;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.rules.TreeAdvancment;
import si.nevensrok.jtekma.server.dataimport.DataImportException;
import si.nevensrok.jtekma.server.dataimport.FileType;
import si.nevensrok.jtekma.server.dataimport.ImportUtil;
import si.nevensrok.jtekma.server.dataimport.ImporterUtil;
import si.nevensrok.jtekma.server.management.AgeCategoryOptionManager;
import si.nevensrok.jtekma.server.management.CategoryGroupManager;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.WeightCategoryOptionManager;

public class CategoryImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CategoryImporter.class);
    private static final int BUFFER_SIZE = 65536;
    private CategoryManager categoryManager;
    private AgeCategoryOptionManager ageCategoryOptionManager;
    private WeightCategoryOptionManager weightCategoryOptionManager;
    private CategoryGroupManager categoryGroupManager;

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public void setAgeCategoryOptionManager(AgeCategoryOptionManager ageCategoryOptionManager) {
        this.ageCategoryOptionManager = ageCategoryOptionManager;
    }

    public void setWeightCategoryOptionManager(WeightCategoryOptionManager weightCategoryOptionManager) {
        this.weightCategoryOptionManager = weightCategoryOptionManager;
    }

    public void setCategoryGroupManager(CategoryGroupManager categoryGroupManager) {
        this.categoryGroupManager = categoryGroupManager;
    }

    public List<Category> parseCategories(FileType fileType, byte[] fileData, Competition competition, Category.Type defaultType, TreeCategory.RepassageType repassageType, boolean double3rdPlace, int repassageFromRound, boolean advancedLevel, boolean noviceLevel, TreeAdvancment treeAdvancment, Map<String, DataImportException.ErrorType> errors) throws Exception {
        LinkedList<Category> categories = new LinkedList<Category>();
        FileReader fileReader = ImporterUtil.getFileReader(fileType);
        FileContent fileContent = fileReader.readFile((InputStream)new ByteArrayInputStream(fileData));
        int categoryNameIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Kategorija", "Ime kategorije", "Category", "Category Name", "Name"});
        int categoryShortNameIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Kratica", "Category Short Name", "Short Name"});
        int categoryTypeIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Tip", "Type", "Category Type"});
        int ageCategoryIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Starostna kategorija", "Starost", "Age category", "Age"});
        int weightCategoryIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Te\u017enostna kategorija", "Weight category", "weight"});
        int categoryGroupIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Skupina", "Group", "Category group"});
        if (categoryNameIndex < 0) {
            throw new DataImportException(DataImportException.ErrorType.NoCategoryName);
        }
        if (categoryTypeIndex < 0) {
            throw new DataImportException(DataImportException.ErrorType.NoCategoryType);
        }
        for (FileLine fileLine : fileContent.getLines()) {
            String name = ImportUtil.formatName(fileLine.getData(categoryNameIndex));
            String shortName = ImportUtil.formatName(fileLine.getData(categoryShortNameIndex));
            if (name == null || name.isEmpty()) continue;
            if (shortName == null || shortName.isEmpty()) {
                shortName = name;
            }
            Category.Type type = defaultType;
            if (fileLine.getData(categoryTypeIndex) != null && !fileLine.getData(categoryTypeIndex).trim().isEmpty()) {
                String typeText = fileLine.getData(categoryTypeIndex).trim();
                if (typeText.equalsIgnoreCase("Fights") || typeText.equalsIgnoreCase("Fighting")) {
                    type = Category.Type.FIGHTING;
                } else if (typeText.equalsIgnoreCase("duo")) {
                    type = Category.Type.DUO;
                } else if (typeText.equalsIgnoreCase("duo2023") || typeText.equalsIgnoreCase("duo 2023") || typeText.equalsIgnoreCase("duo-2023")) {
                    type = Category.Type.DUO_2023;
                } else if (typeText.equalsIgnoreCase("newaza") || typeText.equalsIgnoreCase("ne-waza")) {
                    type = Category.Type.NEWAZA;
                } else if (typeText.equalsIgnoreCase("custom")) {
                    type = Category.Type.CUSTOM;
                } else {
                    errors.put(name, DataImportException.ErrorType.CategoryTypeInvalid);
                }
            } else {
                errors.put(name, DataImportException.ErrorType.CategoryTypeEmpty);
            }
            Object category = null;
            category = type == Category.Type.CUSTOM ? new Category() : (type == Category.Type.FIGHTING ? new FightingCategory() : (type == Category.Type.DUO ? new DuoCategory() : (type == Category.Type.DUO_2023 ? new Duo2023Category() : (type == Category.Type.NEWAZA ? new NewazaCategory() : new Category()))));
            AgeCategoryOption ageCategoryOption = null;
            if (fileLine.getData(ageCategoryIndex) != null && !fileLine.getData(ageCategoryIndex).trim().isEmpty() && (ageCategoryOption = this.ageCategoryOptionManager.getActiveAgeCategoryOptionByName(fileLine.getData(ageCategoryIndex).trim())) == null) {
                errors.put(name, DataImportException.ErrorType.AgeCategoryInvalid);
            }
            WeightCategoryOption weightCategoryOption = null;
            Gender gender = null;
            if (fileLine.getData(weightCategoryIndex) != null && !fileLine.getData(weightCategoryIndex).trim().isEmpty()) {
                String weightName = fileLine.getData(weightCategoryIndex).trim();
                if (category instanceof FightingCategory || category instanceof NewazaCategory) {
                    if (weightName.startsWith("m") || weightName.startsWith("M")) {
                        gender = Gender.MALE;
                    } else if (weightName.startsWith("w") || weightName.startsWith("W") || weightName.startsWith("f") || weightName.startsWith("F")) {
                        gender = Gender.FEMALE;
                    }
                    Integer weight = null;
                    Boolean isAbsolute = null;
                    try {
                        int n = weightName.indexOf(45);
                        if (n >= 0) {
                            isAbsolute = false;
                            weight = Integer.parseInt(weightName.substring(n + 1).trim());
                        }
                        if ((n = weightName.indexOf(43)) >= 0) {
                            isAbsolute = true;
                            weight = Integer.parseInt(weightName.substring(n + 1).trim());
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn("Error while parsing weight category weight parameter", (Throwable)e);
                    }
                    weightCategoryOption = this.weightCategoryOptionManager.getActiveWeightCategory(weight, isAbsolute, gender);
                    if (weightCategoryOption == null) {
                        errors.put(name, DataImportException.ErrorType.WeightCategoryInvalid);
                    }
                } else if (category instanceof DuoCategory) {
                    if (weightName.equalsIgnoreCase("mix")) {
                        gender = Gender.MIX;
                    } else if (weightName.startsWith("m") || weightName.startsWith("M")) {
                        gender = Gender.MALE;
                    } else if (weightName.startsWith("w") || weightName.startsWith("W") || weightName.startsWith("f") || weightName.startsWith("F")) {
                        gender = Gender.FEMALE;
                    }
                }
            }
            CategoryGroup categoryGroup = null;
            if (fileLine.getData(categoryGroupIndex) != null && !fileLine.getData(categoryGroupIndex).trim().isEmpty()) {
                String categoryGroupName = fileLine.getData(categoryGroupIndex).trim();
                categoryGroup = this.categoryGroupManager.getCategoryGroupByName(competition, categoryGroupName);
            }
            category.setType(type);
            category.setName(name);
            category.setShortName(shortName);
            category.setStatus(Category.Status.ACTIVE);
            category.setCountForClubPlacings(Boolean.TRUE);
            if (categoryGroup != null) {
                category.setCategoryGroups(new LinkedList());
                category.getCategoryGroups().add(categoryGroup);
            }
            if (category instanceof TreeCategory) {
                TreeCategory treeCategory = (TreeCategory)category;
                treeCategory.setDouble3rdPlace(Boolean.valueOf(double3rdPlace));
                treeCategory.setRepassageFromRound(Integer.valueOf(repassageFromRound));
                treeCategory.setRepassageType(repassageType);
                treeCategory.setTreeAdvancment(treeAdvancment);
                treeCategory.setTreeType(TreeCategory.TreeType.TABLE2);
            }
            if (category instanceof FightingCategory) {
                FightingCategory fightingCategory = (FightingCategory)category;
                fightingCategory.setAgeCategoryOption(ageCategoryOption);
                fightingCategory.setWeightCategoryOption(weightCategoryOption);
            }
            if (category instanceof DuoCategory) {
                DuoCategory duoCategory = (DuoCategory)category;
                duoCategory.setAgeCategoryOption(ageCategoryOption);
                duoCategory.setGender(gender);
            }
            if (category instanceof NewazaCategory) {
                NewazaCategory newazaCategory = (NewazaCategory)category;
                newazaCategory.setAgeCategoryOption(ageCategoryOption);
                newazaCategory.setWeightCategoryOption(weightCategoryOption);
            }
            if (category instanceof Duo2023Category) {
                Duo2023Category duo2023Category = (Duo2023Category)category;
                duo2023Category.setAgeCategoryOption(ageCategoryOption);
                duo2023Category.setGender(gender);
                duo2023Category.setDouble3rdPlace(Boolean.valueOf(double3rdPlace));
                duo2023Category.setAdvancedLevel(Boolean.valueOf(advancedLevel));
                duo2023Category.setNoviceLevel(Boolean.valueOf(noviceLevel));
            }
            categories.add((Category)category);
        }
        return categories;
    }

    public void importCategories(Competition competition, List<Category> categories) {
        for (Category category : categories) {
            category.setCompetition(competition);
            if (this.categoryManager.getActiveCategoryByName(competition, category.getName()) != null) continue;
            this.categoryManager.createCategory(category);
            if (category.getCategoryGroups() == null) continue;
            this.categoryGroupManager.setCategoryGroupsForCategory(category, category.getCategoryGroups());
        }
    }

    public byte[] exportCategories(FileType fileType, List<Category> categories, String[] header) throws Exception {
        FileWriter fileWriter = ImporterUtil.getFileWriter(fileType);
        String[][] fileContent = new String[categories.size() + 1][];
        fileContent[0] = header;
        int i = 1;
        for (Category category : categories) {
            String type = "custom";
            AgeCategoryOption ageCategoryOption = null;
            WeightCategoryOption weightCategoryOption = null;
            if (category.getType() == Category.Type.FIGHTING) {
                type = "Fights";
                ageCategoryOption = this.ageCategoryOptionManager.getForCategory((FightingCategory)category);
                weightCategoryOption = this.weightCategoryOptionManager.getForCategory((FightingCategory)category);
            } else if (category.getType() == Category.Type.DUO) {
                type = "Duo";
                ageCategoryOption = this.ageCategoryOptionManager.getForCategory((DuoCategory)category);
            } else if (category.getType() == Category.Type.NEWAZA) {
                type = "Newaza";
                ageCategoryOption = this.ageCategoryOptionManager.getForCategory((NewazaCategory)category);
                weightCategoryOption = this.weightCategoryOptionManager.getForCategory((NewazaCategory)category);
            } else if (category.getType() == Category.Type.DUO_2023) {
                type = "Duo2023";
                ageCategoryOption = this.ageCategoryOptionManager.getForCategory((Duo2023Category)category);
            }
            StringBuilder weightCategoryName = new StringBuilder();
            if (weightCategoryOption != null) {
                if (weightCategoryOption.getGender() == Gender.MALE) {
                    weightCategoryName.append("M");
                } else if (weightCategoryOption.getGender() == Gender.FEMALE) {
                    weightCategoryName.append("W");
                } else if (weightCategoryOption.getGender() == Gender.MIX) {
                    weightCategoryName.append("MIX");
                }
                if (weightCategoryOption.getIsAbsolute().booleanValue()) {
                    weightCategoryName.append("+");
                } else {
                    weightCategoryName.append("-");
                }
                weightCategoryName.append(weightCategoryOption.getWeight());
            }
            CategoryGroup categoryGroup = null;
            if (category.getCategoryGroups() != null && !category.getCategoryGroups().isEmpty()) {
                categoryGroup = (CategoryGroup)category.getCategoryGroups().get(0);
            }
            fileContent[i] = new String[]{category.getName(), category.getShortName(), type, ageCategoryOption != null ? ageCategoryOption.getName() : "", weightCategoryName.toString(), categoryGroup != null ? categoryGroup.getName() : ""};
            ++i;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(65536);
        fileWriter.writeFile((OutputStream)buffer, fileContent);
        return buffer.toByteArray();
    }
}

