/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.services.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.matches.DuoPresentation;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.tatami.FightOrder;
import si.nevensrok.jtekma.common.tatami.Semaphore;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.common.tatami.TatamiFightData;
import si.nevensrok.jtekma.common.tatami.TatamiFightOrder;
import si.nevensrok.jtekma.common.tatami.TatamiOnSemaphore;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.DuoPresentationManager;
import si.nevensrok.jtekma.server.management.MatchManager;
import si.nevensrok.jtekma.server.management.SemaphoreManager;
import si.nevensrok.jtekma.server.management.TatamiManager;
import si.nevensrok.jtekma.services.SemaphoreService;
import si.nevensrok.jtekma.services.common.Credentials;
import si.nevensrok.jtekma.services.common.ServiceException;

public class SemaphoreServiceImpl
implements SemaphoreService {
    private SemaphoreManager semaphoreManager;
    private TatamiManager tatamiManager;
    private MatchManager matchManager;
    private CategoryManager categoryManager;
    private DuoPresentationManager duoPresentationManager;

    public void setSemaphoreManager(SemaphoreManager semaphoreManager) {
        this.semaphoreManager = semaphoreManager;
    }

    public void setTatamiManager(TatamiManager tatamiManager) {
        this.tatamiManager = tatamiManager;
    }

    public void setMatchManager(MatchManager matchManager) {
        this.matchManager = matchManager;
    }

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public void setDuoPresentationManager(DuoPresentationManager duoPresentationManager) {
        this.duoPresentationManager = duoPresentationManager;
    }

    public boolean checkLogin(Credentials credentials) throws ServiceException {
        Semaphore semaphore = this.semaphoreManager.getSemaphoreByCredentials(credentials);
        return semaphore != null;
    }

    public TatamiFightData getTatamiFightData(Credentials credentials) throws ServiceException {
        Semaphore semaphore = this.semaphoreManager.getSemaphoreByCredentials(credentials);
        if (semaphore == null) {
            throw new ServiceException("Invalid credentials");
        }
        TatamiFightData tatamiFightData = new TatamiFightData();
        tatamiFightData.setDisplayRows(semaphore.getDisplayRows());
        LinkedList<TatamiFightOrder> tatamiFightOrders = new LinkedList<TatamiFightOrder>();
        tatamiFightData.setTatamiFightOrders(tatamiFightOrders);
        ArrayList tatamiOnSemaphores = new ArrayList(this.semaphoreManager.getTatamisForSemaphore(semaphore));
        Collections.sort(tatamiOnSemaphores, new Comparator<TatamiOnSemaphore>(){

            @Override
            public int compare(TatamiOnSemaphore o1, TatamiOnSemaphore o2) {
                return o1.getOrderNum().compareTo(o2.getOrderNum());
            }
        });
        for (TatamiOnSemaphore tatamiOnSemaphore : tatamiOnSemaphores) {
            TatamiFightOrder tatamiFightOrder = new TatamiFightOrder();
            tatamiFightOrders.add(tatamiFightOrder);
            Tatami tatami = tatamiOnSemaphore.getTatami();
            tatami.setPassword(null);
            tatamiFightOrder.setTatami(tatami);
            tatamiFightOrder.setFightOrders(this.tatamiManager.getFightOrderForTatami(tatami));
            for (FightOrder fightOrder : tatamiFightOrder.getFightOrders()) {
                DuoPresentation duoPresentation;
                Match match = fightOrder.getMatch();
                if (match != null) {
                    match = this.matchManager.getByIdWithCompetitors(match.getMatchId());
                    fightOrder.setMatch(match);
                    Category category = this.categoryManager.getCategoryForMatch(match);
                    match.setCategory(category);
                }
                if ((duoPresentation = fightOrder.getDuoPresentation()) == null) continue;
                duoPresentation = this.duoPresentationManager.getByIdWithCompetitor(duoPresentation.getDuoPresentationId());
                fightOrder.setDuoPresentation(duoPresentation);
                Category category = this.categoryManager.getCategoryForDuoPresentation(duoPresentation);
                duoPresentation.setCategory(category);
            }
        }
        return tatamiFightData;
    }
}

