/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.security;

import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import si.nevensrok.common.web.security.UserData;
import si.nevensrok.common.web.security.UserDatabase;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.judges.Judge;
import si.nevensrok.jtekma.common.system.User;
import si.nevensrok.jtekma.server.management.CompetitionManager;
import si.nevensrok.jtekma.server.management.JudgeManager;
import si.nevensrok.jtekma.server.management.UserManager;
import si.nevensrok.jtekma.server.web.security.LoginUserInfo;
import si.nevensrok.jtekma.server.web.security.UserDetails;
import si.nevensrok.jtekma.services.common.Credentials;

public class UserRepository
implements UserDetailsService,
UserDatabase {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserRepository.class);
    private UserManager userManager;
    private JudgeManager judgeManager;
    private CompetitionManager competitionManager;

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public void setJudgeManager(JudgeManager judgeManager) {
        this.judgeManager = judgeManager;
    }

    public void setCompetitionManager(CompetitionManager competitionManager) {
        this.competitionManager = competitionManager;
    }

    public UserData getUserByUsernameAndPassword(String username, String password) {
        User user = this.userManager.getUserByUsername(username);
        if (user != null && user.getStatus() == User.Status.ACTIVE) {
            if (this.userManager.checkPassword(password, user.getPassword())) {
                return new LoginUserInfo(user);
            }
            return null;
        }
        Competition competition = this.competitionManager.getActiveCompetition();
        if (competition == null) {
            return null;
        }
        Credentials credentials = new Credentials(null, username, password);
        Judge judge = this.judgeManager.getJudgeByCredentials(competition, credentials);
        if (judge != null) {
            return new LoginUserInfo(judge);
        }
        return null;
    }

    public UserData getUserByUsername(String username) {
        User user = this.userManager.getUserByUsername(username);
        if (user != null && user.getStatus() != User.Status.ACTIVE) {
            return new LoginUserInfo(user);
        }
        return null;
    }

    public List<GrantedAuthority> getGrantedAuthoritys(UserData userData) {
        LoginUserInfo loginUserInfo = (LoginUserInfo)userData;
        LinkedList<GrantedAuthority> grantedAuthorities = new LinkedList<GrantedAuthority>();
        if (loginUserInfo.getUser() != null) {
            if (loginUserInfo.getUser().getIsSuperAdmin().booleanValue()) {
                grantedAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_ADMIN"));
            }
            grantedAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_USER"));
        } else if (loginUserInfo.getJudge() != null) {
            grantedAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_JUDGE"));
        }
        return grantedAuthorities;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        LOGGER.debug("Loading user details for username {}", (Object)username);
        User user = this.userManager.getUserByUsername(username);
        UserDetails userDetails = null;
        if (user != null) {
            userDetails = new UserDetails();
            userDetails.setUsername(user.getUsername());
            userDetails.setEnabled(user.getStatus() == User.Status.ACTIVE);
            userDetails.setCredentialsExpired(false);
            userDetails.setExpired(false);
            userDetails.setLocked(false);
            userDetails.getAuthorities().add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_USER"));
        }
        return userDetails;
    }
}

