/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.systemsettings;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.jtekma.server.web.controllers.CoreController;

@Controller
@RequestMapping(value={"/system-settings"})
public class SystemInfoController
extends CoreController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemInfoController.class);

    @ModelAttribute(value="systemInfoActive")
    public Boolean getSystemInfoActive() {
        return Boolean.TRUE;
    }

    @RequestMapping
    public String index(HttpServletRequest request, Model model) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        model.addAttribute("currentTime", (Object)this.getTools().getDateTool().formatDateAndTime(locale, Calendar.getInstance().getTime()));
        long freeMemory = Runtime.getRuntime().freeMemory();
        long totalMemory = Runtime.getRuntime().maxMemory();
        long usedMemory = totalMemory - freeMemory;
        model.addAttribute("usedMemoryProcentage", (Object)((int)Math.round((double)usedMemory / (double)totalMemory * 100.0)));
        model.addAttribute("usedMemory", (Object)Math.round((double)usedMemory / 1048576.0));
        model.addAttribute("totalMemory", (Object)Math.round((double)totalMemory / 1048576.0));
        int cpuCount = Runtime.getRuntime().availableProcessors();
        model.addAttribute("cpuCount", (Object)cpuCount);
        LinkedList<String> ipAddresses = new LinkedList<String>();
        try {
            Enumeration<NetworkInterface> networkInterfaceEnumerator = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaceEnumerator.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaceEnumerator.nextElement();
                if (!networkInterface.isUp() || networkInterface.isLoopback() || networkInterface.isVirtual()) continue;
                Enumeration<InetAddress> addressEnumerator = networkInterface.getInetAddresses();
                while (addressEnumerator.hasMoreElements()) {
                    Inet4Address inet4Address;
                    String ipAddress;
                    InetAddress address = addressEnumerator.nextElement();
                    if (!(address instanceof Inet4Address) || (ipAddress = (inet4Address = (Inet4Address)address).getHostAddress()).equals("127.0.0.1")) continue;
                    ipAddresses.add(ipAddress);
                }
            }
        }
        catch (Exception networkInterfaceEnumerator) {
            // empty catch block
        }
        model.addAttribute("ipAddresses", ipAddresses);
        ClassPathResource gitFileResource = new ClassPathResource("/git.properties");
        if (gitFileResource.exists()) {
            try {
                Properties properties = new Properties();
                properties.load(gitFileResource.getInputStream());
                model.addAttribute("buildVersion", properties.get("git.commit.id.describe"));
                model.addAttribute("buildRevision", properties.get("git.commit.id"));
                model.addAttribute("buildAt", properties.get("git.build.time"));
                model.addAttribute("buildBy", (Object)(properties.get("git.build.user.name") + " (" + properties.get("git.build.user.email") + ")"));
            }
            catch (Exception e) {
                LOGGER.debug("Error reading git build info", (Throwable)e);
            }
        }
        return "system-settings/info";
    }
}

