/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.data;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.ExampleFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.common.utils.ObjectUtil;
import si.nevensrok.common.utils.StringUtil;
import si.nevensrok.common.web.filter.SearchFilter;
import si.nevensrok.common.web.util.ControllerUtil;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.judges.Judge;
import si.nevensrok.jtekma.common.system.Right;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.server.dataimport.DataImportException;
import si.nevensrok.jtekma.server.dataimport.FileType;
import si.nevensrok.jtekma.server.web.common.ImportDataModel;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.controllers.data.JudgeModel;
import si.nevensrok.jtekma.server.web.security.ForbiddenException;
import si.nevensrok.jtekma.server.web.security.MethodRight;
import si.nevensrok.jtekma.server.web.tools.FilterGeneratorTool;

@Controller
@RequestMapping(value={"/data/judges"})
@SessionAttributes(value={"judgeListFilter"})
public class JudgesController
extends CoreController {
    private static final Logger LOGGER = LoggerFactory.getLogger(JudgesController.class);

    @ModelAttribute(value="judgesActive")
    public Boolean getJudgesActive() {
        return Boolean.TRUE;
    }

    @ModelAttribute(value="judgeListFilter")
    public SearchFilter getSearchFilter() {
        return FilterGeneratorTool.generateDefaultSearchFilter();
    }

    @ModelAttribute(value="editRights")
    public Boolean getEditRights() {
        return this.hasRights(Right.JUDGEEDIT);
    }

    @ModelAttribute(value="fileTypes")
    public Map<FileType, String> getFileTypes(HttpServletRequest request) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        LinkedHashMap<FileType, String> importType = new LinkedHashMap<FileType, String>();
        importType.put(FileType.CSV, this.getLanguageText(locale, "filetypes.csv"));
        importType.put(FileType.ODS, this.getLanguageText(locale, "filetypes.ods"));
        importType.put(FileType.XLS, this.getLanguageText(locale, "filetypes.xls"));
        importType.put(FileType.XLSX, this.getLanguageText(locale, "filetypes.xlsx"));
        return importType;
    }

    @RequestMapping
    public String list(HttpServletRequest request, Model model, @ModelAttribute(value="judgeListFilter") SearchFilter searchFilter, @RequestParam(value="messageCode", required=false, defaultValue="0") Integer messageCode) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        Judge example = new Judge();
        example.setName("%" + searchFilter.getSearch().trim() + "%");
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setFilter((Filter)new ExampleFilter((Object)example));
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        dataFilter.setItemCountPerPage(searchFilter.getShowPerPage().intValue());
        dataFilter.setPage(searchFilter.getPage().intValue());
        PageDataResult dataResult = this.getManagersList().getJudgeManager().find(this.getUserData().getCompetition(), (DataFilter)dataFilter);
        model.addAttribute("judges", (Object)dataResult.getData());
        model.addAttribute("totalPages", (Object)dataResult.getPageCount(true));
        if (messageCode.equals(1)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "judges.text.added"));
        } else if (messageCode.equals(2)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "judges.text.updated"));
        } else if (messageCode.equals(3)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "judges.text.deleted"));
        } else if (messageCode.equals(4)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "judges.text.tatamisSet"));
        } else if (messageCode.equals(5)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "judges.text.imported"));
        }
        return "data/judge-list";
    }

    @MethodRight(value={Right.JUDGEEDIT})
    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(HttpServletRequest request, Model model, @ModelAttribute(value="judge") JudgeModel judgeModel, BindingResult bindingResult) {
        model.addAttribute("adding", (Object)true);
        return "data/judge-edit";
    }

    @MethodRight(value={Right.JUDGEEDIT})
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public String addPost(HttpServletRequest request, Model model, @ModelAttribute(value="judge") @Valid JudgeModel judgeModel, BindingResult bindingResult) {
        if (StringUtil.isEmpty((String)judgeModel.getPassword())) {
            bindingResult.rejectValue("password", "common.error.dataNotEntered");
        }
        if (bindingResult.hasErrors()) {
            return this.add(request, model, judgeModel, bindingResult);
        }
        Judge judge = new Judge();
        ObjectUtil.copyNotNullProperties((Object)judgeModel, (Object)judge);
        judge.setCompetition(this.getUserData().getCompetition());
        judge = this.getManagersList().getJudgeManager().createJudge(judge);
        return "redirect:/data/judges?messageCode=1";
    }

    @MethodRight(value={Right.JUDGEEDIT})
    @RequestMapping(value={"/edit/{judgeId}"}, method={RequestMethod.GET})
    public String edit(HttpServletRequest request, Model model, @PathVariable(value="judgeId") Long judgeId, @ModelAttribute(value="judge") JudgeModel judgeModel, BindingResult bindingResult) {
        Judge judge = this.getManagersList().getJudgeManager().getById(judgeId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForJudge(judge).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        ObjectUtil.copyNotNullProperties((Object)judge, (Object)judgeModel);
        judgeModel.setPassword("");
        return "data/judge-edit";
    }

    @MethodRight(value={Right.JUDGEEDIT})
    @RequestMapping(value={"/edit/{judgeId}"}, method={RequestMethod.POST})
    public String editPost(HttpServletRequest request, Model model, @PathVariable(value="judgeId") Long judgeId, @ModelAttribute(value="judge") @Valid JudgeModel judgeModel, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return this.edit(request, model, judgeId, judgeModel, bindingResult);
        }
        Judge judge = this.getManagersList().getJudgeManager().getById(judgeId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForJudge(judge).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        ObjectUtil.copyNotNullProperties((Object)judgeModel, (Object)judge);
        judge = this.getManagersList().getJudgeManager().updateJudge(judge);
        if (StringUtil.isNotEmpty((String)judgeModel.getPassword())) {
            judge.setPassword(judgeModel.getPassword());
            this.getManagersList().getJudgeManager().updateJudgePassword(judge);
        }
        return "redirect:/data/judges?messageCode=2";
    }

    @MethodRight(value={Right.JUDGEEDIT})
    @RequestMapping(value={"/delete/{judgeId}"})
    public String delete(HttpServletRequest request, Model model, @PathVariable(value="judgeId") Long judgeId) {
        Judge judge = this.getManagersList().getJudgeManager().getById(judgeId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForJudge(judge).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        this.getManagersList().getJudgeManager().deleteJudge(judge);
        return "redirect:/data/judges?messageCode=3";
    }

    @MethodRight(value={Right.JUDGEEDIT})
    @RequestMapping(value={"/tatamis/{judgeId}"}, method={RequestMethod.GET})
    public String tatamis(HttpServletRequest request, Model model, @PathVariable(value="judgeId") Long judgeId) {
        Judge judge = this.getManagersList().getJudgeManager().getById(judgeId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForJudge(judge).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        model.addAttribute("judge", (Object)judge);
        HashSet<Long> currentTatamis = new HashSet<Long>();
        for (Tatami tatami : this.getManagersList().getJudgeManager().getTatamisForJudge(judge)) {
            currentTatamis.add(tatami.getTatamiId());
        }
        model.addAttribute("currentTatamis", currentTatamis);
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        PageDataResult dataResult = this.getManagersList().getTatamiManager().find(this.getUserData().getCompetition(), (DataFilter)dataFilter);
        model.addAttribute("tatamis", (Object)dataResult.getData());
        return "data/judge-tatamis";
    }

    @MethodRight(value={Right.JUDGEEDIT})
    @RequestMapping(value={"/tatamis/{judgeId}"}, method={RequestMethod.POST})
    public String tatamisPost(HttpServletRequest request, Model model, @PathVariable(value="judgeId") Long judgeId) {
        Judge judge = this.getManagersList().getJudgeManager().getById(judgeId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForJudge(judge).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        HashSet<Tatami> tatamis = new HashSet<Tatami>();
        Map parameters = request.getParameterMap();
        for (String key : parameters.keySet()) {
            if (!key.startsWith("tatami_")) continue;
            Long tatamiId = Long.parseLong(key.split("_")[1]);
            Tatami tatami = new Tatami();
            tatami.setTatamiId(tatamiId);
            tatamis.add(tatami);
        }
        this.getManagersList().getJudgeManager().setTatamisForJudge(judge, tatamis);
        return "redirect:/data/judges?messageCode=4";
    }

    @MethodRight(value={Right.JUDGEEDIT})
    @RequestMapping(value={"/import"}, method={RequestMethod.GET})
    public String importData(HttpServletRequest request, Model model, @ModelAttribute(value="data") ImportDataModel importDataModel) {
        return "data/judge-import";
    }

    @MethodRight(value={Right.JUDGEEDIT})
    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    public String importDataPost(HttpServletRequest request, Model model, @ModelAttribute(value="data") ImportDataModel importDataModel) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        try {
            LinkedHashMap errors = new LinkedHashMap();
            List judges = this.getManagersList().getJudgeImporter().parseJudges(importDataModel.getFileType(), importDataModel.getFile().getBytes(), this.getUserData().getCompetition(), errors);
            if (!errors.isEmpty()) {
                LinkedList<String> errorMessages = new LinkedList<String>();
                for (Map.Entry entry : errors.entrySet()) {
                    if (entry.getValue() != DataImportException.ErrorType.TatamiNotFound) continue;
                    errorMessages.add(this.getLanguageText(locale, "judges.error.tatamiNotFound", new String[]{(String)entry.getKey()}));
                }
                model.addAttribute("errorMessages", errorMessages);
                return this.importData(request, model, importDataModel);
            }
            this.getManagersList().getJudgeImporter().importJudges(this.getUserData().getCompetition(), judges);
            return "redirect:/data/judges?messageCode=5";
        }
        catch (DataImportException e) {
            if (e.getErrorType() == DataImportException.ErrorType.NoJudgeName) {
                model.addAttribute("errorText", (Object)this.getLanguageText(locale, "judges.error.noJudgeName"));
                return this.importData(request, model, importDataModel);
            }
            if (e.getErrorType() == DataImportException.ErrorType.NoJudgePassword) {
                model.addAttribute("errorText", (Object)this.getLanguageText(locale, "judges.error.noJudgePassword"));
                return this.importData(request, model, importDataModel);
            }
            LOGGER.error("Error while reading judge data", (Throwable)e);
            model.addAttribute("errorText", (Object)this.getLanguageText(locale, "judges.error.importError"));
            return this.importData(request, model, importDataModel);
        }
        catch (Exception e) {
            LOGGER.error("Error while reading judge data", (Throwable)e);
            model.addAttribute("errorText", (Object)this.getLanguageText(locale, "judges.error.importError"));
            return this.importData(request, model, importDataModel);
        }
    }

    @RequestMapping(value={"/export/{fileType}"})
    public void exportData(HttpServletRequest request, HttpServletResponse response, Model model, @PathVariable(value="fileType") FileType fileType) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Competition competition = this.getUserData().getCompetition();
        String fileName = competition.getName() + "-" + this.getLanguageText(locale, "judges.export.fileName");
        if (fileType == FileType.CSV) {
            fileName = fileName + ".csv";
            response.setContentType("text/csv");
        } else if (fileType == FileType.ODS) {
            fileName = fileName + ".ods";
            response.setContentType("application/vnd.oasis.opendocument.spreadsheet");
        } else if (fileType == FileType.XLS) {
            fileName = fileName + ".xls";
            response.setContentType("application/vnd.ms-excel");
        } else if (fileType == FileType.XLSX) {
            fileName = fileName + ".xlsx";
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        }
        ControllerUtil.addContentDispositionHeader((HttpServletResponse)response, (String)fileName);
        List judges = this.getManagersList().getJudgeManager().find(competition, (DataFilter)new SimpleDataFilter()).getData();
        String[] header = new String[]{this.getLanguageText(locale, "judges.export.judge"), this.getLanguageText(locale, "judges.export.password"), this.getLanguageText(locale, "judges.export.tatamis")};
        try {
            byte[] data = this.getManagersList().getJudgeImporter().exportJudges(fileType, judges, header);
            response.getOutputStream().write(data);
            response.getOutputStream().close();
        }
        catch (Exception e) {
            LOGGER.error("Error writing to output stream", (Throwable)e);
        }
    }
}

