/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.common.competition;

import java.io.Serializable;
import si.nevensrok.common.objects.ObjectToString;
import si.nevensrok.jtekma.common.rules.DuoTable;
import si.nevensrok.jtekma.server.web.common.competition.Competitor;

public class Duo2023Table
implements Serializable {
    private static final long serialVersionUID = 6921742249820040910L;
    private Row[] rows;

    public Duo2023Table() {
    }

    public Duo2023Table(DuoTable duoTable) {
        if (duoTable.getRows() == null) {
            this.rows = new Row[0];
        } else {
            this.rows = new Row[duoTable.getRows().size()];
            for (int i = 0; i < this.rows.length; ++i) {
                this.rows[i] = new Row();
                DuoTable.Row row = (DuoTable.Row)duoTable.getRows().get(i);
                if (row.getCompetitor() != null) {
                    this.rows[i].setCompetitor(new Competitor(row.getCompetitor()));
                }
                this.rows[i].setRound1Points(Float.valueOf(row.getRound1Points()));
                this.rows[i].setRound2Points(Float.valueOf(row.getRound2Points()));
                this.rows[i].setRound3Points(Float.valueOf(row.getRound3Points()));
                this.rows[i].setVarietyScorePoints(Float.valueOf(row.getTotalVarietyScorePoints()));
                this.rows[i].setPoints(Float.valueOf(row.getTotalPoints()));
                this.rows[i].setPlacing(row.getPlacing());
            }
        }
    }

    public Row[] getRows() {
        return this.rows;
    }

    public void setRows(Row[] rows) {
        this.rows = rows;
    }

    public String toString() {
        return new ObjectToString(Duo2023Table.class).addProperty("rows", (Object[])this.rows).generateString();
    }

    public static class Row
    implements Serializable {
        private static final long serialVersionUID = 2924737813084078174L;
        private Competitor competitor;
        private Float round1Points;
        private Float round2Points;
        private Float round3Points;
        private Float varietyScorePoints;
        private Float points;
        private Integer placing;

        public Competitor getCompetitor() {
            return this.competitor;
        }

        public void setCompetitor(Competitor competitor) {
            this.competitor = competitor;
        }

        public Float getRound1Points() {
            return this.round1Points;
        }

        public void setRound1Points(Float round1Points) {
            this.round1Points = round1Points;
        }

        public Float getRound2Points() {
            return this.round2Points;
        }

        public void setRound2Points(Float round2Points) {
            this.round2Points = round2Points;
        }

        public Float getRound3Points() {
            return this.round3Points;
        }

        public void setRound3Points(Float round3Points) {
            this.round3Points = round3Points;
        }

        public Float getVarietyScorePoints() {
            return this.varietyScorePoints;
        }

        public void setVarietyScorePoints(Float varietyScorePoints) {
            this.varietyScorePoints = varietyScorePoints;
        }

        public Float getPoints() {
            return this.points;
        }

        public void setPoints(Float points) {
            this.points = points;
        }

        public Integer getPlacing() {
            return this.placing;
        }

        public void setPlacing(Integer placing) {
            this.placing = placing;
        }

        public String toString() {
            return new ObjectToString(Row.class).addProperty("competitor", (Object)this.competitor).addProperty("round1Points", (Object)this.round1Points).addProperty("round2Points", (Object)this.round2Points).addProperty("round3Points", (Object)this.round3Points).addProperty("varietyScorePoints", (Object)this.varietyScorePoints).addProperty("points", (Object)this.points).addProperty("placing", (Object)this.placing).generateString();
        }
    }
}

