/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.glass.ui.Accessible;
import com.sun.glass.ui.Application;
import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.cursor.CursorFrame;
import com.sun.javafx.event.EventQueue;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.logging.PulseLogger;
import com.sun.javafx.perf.PerformanceTracker;
import com.sun.javafx.robot.impl.FXRobotHelper;
import com.sun.javafx.runtime.SystemProperties;
import com.sun.javafx.scene.CssFlags;
import com.sun.javafx.scene.LayoutFlags;
import com.sun.javafx.scene.SceneEventDispatcher;
import com.sun.javafx.scene.SceneHelper;
import com.sun.javafx.scene.input.DragboardHelper;
import com.sun.javafx.scene.input.ExtendedInputMethodRequests;
import com.sun.javafx.scene.input.InputEventUtils;
import com.sun.javafx.scene.input.PickResultChooser;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.SceneTraversalEngine;
import com.sun.javafx.scene.traversal.TopMostTraversalEngine;
import com.sun.javafx.sg.prism.NGCamera;
import com.sun.javafx.sg.prism.NGLightBase;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.TKClipboard;
import com.sun.javafx.tk.TKDragGestureListener;
import com.sun.javafx.tk.TKDragSourceListener;
import com.sun.javafx.tk.TKDropTargetListener;
import com.sun.javafx.tk.TKPulseListener;
import com.sun.javafx.tk.TKScene;
import com.sun.javafx.tk.TKSceneListener;
import com.sun.javafx.tk.TKScenePaintListener;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Logging;
import com.sun.javafx.util.Utils;
import com.sun.prism.impl.PrismSettings;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.NamedArg;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectPropertyBase;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.css.CssMetaData;
import javafx.css.StyleableObjectProperty;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Camera;
import javafx.scene.Cursor;
import javafx.scene.LightBase;
import javafx.scene.Node;
import javafx.scene.ParallelCamera;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.SceneAntialiasing;
import javafx.scene.SnapshotResult;
import javafx.scene.SubScene;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.GestureEvent;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodRequests;
import javafx.scene.input.InputMethodTextRun;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.Mnemonic;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseDragEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.PickResult;
import javafx.scene.input.RotateEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.SwipeEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.input.TouchPoint;
import javafx.scene.input.TransferMode;
import javafx.scene.input.ZoomEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.PopupWindow;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.Duration;
import sun.util.logging.PlatformLogger;

@DefaultProperty(value="root")
public class Scene
implements EventTarget {
    private double widthSetByUser = -1.0;
    private double heightSetByUser = -1.0;
    private boolean sizeInitialized = false;
    private final boolean depthBuffer;
    private final SceneAntialiasing antiAliasing;
    private int dirtyBits;
    final AccessControlContext acc = AccessController.getContext();
    private Camera defaultCamera;
    private Node transientFocusContainer;
    private static final int MIN_DIRTY_CAPACITY = 30;
    private static boolean inSynchronizer;
    private static boolean inMousePick;
    private static boolean allowPGAccess;
    private static int pgAccessCount;
    private static boolean paused;
    private static final boolean PLATFORM_DRAG_GESTURE_INITIATION = false;
    private Node[] dirtyNodes;
    private int dirtyNodesSize;
    @Deprecated
    private TKScene impl_peer;
    ScenePulseListener scenePulseListener = new ScenePulseListener();
    private ReadOnlyObjectWrapper<Window> window;
    DnDGesture dndGesture = null;
    DragGestureListener dragGestureListener;
    private ReadOnlyDoubleWrapper x;
    private ReadOnlyDoubleWrapper y;
    private ReadOnlyDoubleWrapper width;
    private ReadOnlyDoubleWrapper height;
    private TargetWrapper tmpTargetWrapper = new TargetWrapper();
    private ObjectProperty<Camera> camera;
    private ObjectProperty<Paint> fill;
    private ObjectProperty<Parent> root;
    Parent oldRoot;
    private static TKPulseListener snapshotPulseListener;
    private static List<Runnable> snapshotRunnableListA;
    private static List<Runnable> snapshotRunnableListB;
    private static List<Runnable> snapshotRunnableList;
    private ObjectProperty<Cursor> cursor;
    private final ObservableList<String> stylesheets = new TrackableObservableList<String>(){

        @Override
        protected void onChanged(ListChangeListener.Change<String> c) {
            StyleManager.getInstance().stylesheetsChanged(Scene.this, c);
            c.reset();
            while (c.next() && !c.wasRemoved()) {
            }
            Scene.this.getRoot().impl_reapplyCSS();
        }
    };
    private ObjectProperty<String> userAgentStylesheet = null;
    private PerformanceTracker tracker;
    private static final Object trackerMonitor;
    private MouseHandler mouseHandler;
    private ClickGenerator clickGenerator;
    private Point2D cursorScreenPos;
    private Point2D cursorScenePos;
    private final TouchGesture scrollGesture = new TouchGesture();
    private final TouchGesture zoomGesture = new TouchGesture();
    private final TouchGesture rotateGesture = new TouchGesture();
    private final TouchGesture swipeGesture = new TouchGesture();
    private TouchMap touchMap = new TouchMap();
    private TouchEvent nextTouchEvent = null;
    private TouchPoint[] touchPoints = null;
    private int touchEventSetId = 0;
    private int touchPointIndex = 0;
    private Map<Integer, EventTarget> touchTargets = new HashMap<Integer, EventTarget>();
    private KeyHandler keyHandler = null;
    private boolean focusDirty = true;
    private TopMostTraversalEngine traversalEngine = new SceneTraversalEngine(this);
    private Node oldFocusOwner;
    private ReadOnlyObjectWrapper<Node> focusOwner = new ReadOnlyObjectWrapper<Node>((Object)this, "focusOwner"){

        @Override
        protected void invalidated() {
            PlatformLogger logger;
            Node value;
            if (Scene.this.oldFocusOwner != null) {
                ((Node.FocusedProperty)Scene.this.oldFocusOwner.focusedProperty()).store(false);
            }
            if ((value = (Node)this.get()) != null) {
                ((Node.FocusedProperty)value.focusedProperty()).store(Scene.this.keyHandler.windowFocused);
                if (value != Scene.this.oldFocusOwner) {
                    value.getScene().impl_enableInputMethodEvents(value.getInputMethodRequests() != null && value.getOnInputMethodTextChanged() != null);
                }
            }
            Node localOldOwner = Scene.this.oldFocusOwner;
            Scene.this.oldFocusOwner = value;
            if (localOldOwner != null) {
                ((Node.FocusedProperty)localOldOwner.focusedProperty()).notifyListeners();
            }
            if (value != null) {
                ((Node.FocusedProperty)value.focusedProperty()).notifyListeners();
            }
            if ((logger = Logging.getFocusLogger()).isLoggable(PlatformLogger.Level.FINE)) {
                if (value == this.get()) {
                    logger.fine("Changed focus from " + localOldOwner + " to " + value);
                } else {
                    logger.fine("Changing focus from " + localOldOwner + " to " + value + " canceled by nested requestFocus");
                }
            }
            if (Scene.this.accessible != null) {
                Scene.this.accessible.sendNotification(AccessibleAttribute.FOCUS_NODE);
            }
        }
    };
    Runnable testPulseListener = null;
    private List<LightBase> lights = new ArrayList<LightBase>();
    private ObjectProperty<EventDispatcher> eventDispatcher;
    private SceneEventDispatcher internalEventDispatcher;
    private ObjectProperty<EventHandler<? super ContextMenuEvent>> onContextMenuRequested;
    private ObjectProperty<EventHandler<? super MouseEvent>> onMouseClicked;
    private ObjectProperty<EventHandler<? super MouseEvent>> onMouseDragged;
    private ObjectProperty<EventHandler<? super MouseEvent>> onMouseEntered;
    private ObjectProperty<EventHandler<? super MouseEvent>> onMouseExited;
    private ObjectProperty<EventHandler<? super MouseEvent>> onMouseMoved;
    private ObjectProperty<EventHandler<? super MouseEvent>> onMousePressed;
    private ObjectProperty<EventHandler<? super MouseEvent>> onMouseReleased;
    private ObjectProperty<EventHandler<? super MouseEvent>> onDragDetected;
    private ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragOver;
    private ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragReleased;
    private ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragEntered;
    private ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragExited;
    private ObjectProperty<EventHandler<? super ScrollEvent>> onScrollStarted;
    private ObjectProperty<EventHandler<? super ScrollEvent>> onScroll;
    private ObjectProperty<EventHandler<? super ScrollEvent>> onScrollFinished;
    private ObjectProperty<EventHandler<? super RotateEvent>> onRotationStarted;
    private ObjectProperty<EventHandler<? super RotateEvent>> onRotate;
    private ObjectProperty<EventHandler<? super RotateEvent>> onRotationFinished;
    private ObjectProperty<EventHandler<? super ZoomEvent>> onZoomStarted;
    private ObjectProperty<EventHandler<? super ZoomEvent>> onZoom;
    private ObjectProperty<EventHandler<? super ZoomEvent>> onZoomFinished;
    private ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeUp;
    private ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeDown;
    private ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeLeft;
    private ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeRight;
    private ObjectProperty<EventHandler<? super TouchEvent>> onTouchPressed;
    private ObjectProperty<EventHandler<? super TouchEvent>> onTouchMoved;
    private ObjectProperty<EventHandler<? super TouchEvent>> onTouchReleased;
    private ObjectProperty<EventHandler<? super TouchEvent>> onTouchStationary;
    private ObjectProperty<EventHandler<? super DragEvent>> onDragEntered;
    private ObjectProperty<EventHandler<? super DragEvent>> onDragExited;
    private ObjectProperty<EventHandler<? super DragEvent>> onDragOver;
    private ObjectProperty<EventHandler<? super DragEvent>> onDragDropped;
    private ObjectProperty<EventHandler<? super DragEvent>> onDragDone;
    private ObjectProperty<EventHandler<? super KeyEvent>> onKeyPressed;
    private ObjectProperty<EventHandler<? super KeyEvent>> onKeyReleased;
    private ObjectProperty<EventHandler<? super KeyEvent>> onKeyTyped;
    private ObjectProperty<EventHandler<? super InputMethodEvent>> onInputMethodTextChanged;
    private static final Object USER_DATA_KEY;
    private ObservableMap<Object, Object> properties;
    private static final NodeOrientation defaultNodeOrientation;
    private ObjectProperty<NodeOrientation> nodeOrientation;
    private EffectiveOrientationProperty effectiveNodeOrientationProperty;
    private NodeOrientation effectiveNodeOrientation;
    private Map<Node, Accessible> accMap;
    private Accessible accessible;

    public Scene(@NamedArg(value="root") Parent root) {
        this(root, -1.0, -1.0, Color.WHITE, false, SceneAntialiasing.DISABLED);
    }

    public Scene(@NamedArg(value="root") Parent root, @NamedArg(value="width") double width, @NamedArg(value="height") double height) {
        this(root, width, height, Color.WHITE, false, SceneAntialiasing.DISABLED);
    }

    public Scene(@NamedArg(value="root") Parent root, @NamedArg(value="fill", defaultValue="WHITE") Paint fill) {
        this(root, -1.0, -1.0, fill, false, SceneAntialiasing.DISABLED);
    }

    public Scene(@NamedArg(value="root") Parent root, @NamedArg(value="width") double width, @NamedArg(value="height") double height, @NamedArg(value="fill", defaultValue="WHITE") Paint fill) {
        this(root, width, height, fill, false, SceneAntialiasing.DISABLED);
    }

    public Scene(@NamedArg(value="root") Parent root, @NamedArg(value="width", defaultValue="-1") double width, @NamedArg(value="height", defaultValue="-1") double height, @NamedArg(value="depthBuffer") boolean depthBuffer) {
        this(root, width, height, Color.WHITE, depthBuffer, SceneAntialiasing.DISABLED);
    }

    public Scene(@NamedArg(value="root") Parent root, @NamedArg(value="width", defaultValue="-1") double width, @NamedArg(value="height", defaultValue="-1") double height, @NamedArg(value="depthBuffer") boolean depthBuffer, @NamedArg(value="antiAliasing", defaultValue="DISABLED") SceneAntialiasing antiAliasing) {
        this(root, width, height, Color.WHITE, depthBuffer, antiAliasing);
        if (antiAliasing != null && antiAliasing != SceneAntialiasing.DISABLED && !Toolkit.getToolkit().isMSAASupported()) {
            String logname = Scene.class.getName();
            PlatformLogger.getLogger(logname).warning("System can't support antiAliasing");
        }
    }

    private Scene(Parent root, double width, double height, Paint fill, boolean depthBuffer, SceneAntialiasing antiAliasing) {
        this.depthBuffer = depthBuffer;
        this.antiAliasing = antiAliasing;
        if (root == null) {
            throw new NullPointerException("Root cannot be null");
        }
        if ((depthBuffer || antiAliasing != null && antiAliasing != SceneAntialiasing.DISABLED) && !Platform.isSupported(ConditionalFeature.SCENE3D)) {
            String logname = Scene.class.getName();
            PlatformLogger.getLogger(logname).warning("System can't support ConditionalFeature.SCENE3D");
        }
        this.init();
        this.setRoot(root);
        this.init(width, height);
        this.setFill(fill);
    }

    static boolean isPGAccessAllowed() {
        return inSynchronizer || inMousePick || allowPGAccess;
    }

    @Deprecated
    public static void impl_setAllowPGAccess(boolean flag) {
        if (Utils.assertionEnabled()) {
            if (flag) {
                ++pgAccessCount;
                allowPGAccess = true;
            } else {
                if (pgAccessCount <= 0) {
                    throw new AssertionError((Object)"*** pgAccessCount underflow");
                }
                if (--pgAccessCount == 0) {
                    allowPGAccess = false;
                }
            }
        }
    }

    void addToDirtyList(Node n) {
        if ((this.dirtyNodes == null || this.dirtyNodesSize == 0) && this.impl_peer != null) {
            Toolkit.getToolkit().requestNextPulse();
        }
        if (this.dirtyNodes != null) {
            if (this.dirtyNodesSize == this.dirtyNodes.length) {
                Node[] tmp = new Node[this.dirtyNodesSize + (this.dirtyNodesSize >> 1)];
                System.arraycopy(this.dirtyNodes, 0, tmp, 0, this.dirtyNodesSize);
                this.dirtyNodes = tmp;
            }
            this.dirtyNodes[this.dirtyNodesSize++] = n;
        }
    }

    private void doCSSPass() {
        Parent sceneRoot = this.getRoot();
        if (sceneRoot.cssFlag != CssFlags.CLEAN) {
            sceneRoot.impl_clearDirty(com.sun.javafx.scene.DirtyBits.NODE_CSS);
            sceneRoot.processCSS();
        }
    }

    void doLayoutPass() {
        Parent r = this.getRoot();
        if (r != null) {
            r.layout();
        }
    }

    @Deprecated
    public TKScene impl_getPeer() {
        return this.impl_peer;
    }

    @Deprecated
    public TKPulseListener impl_getScenePulseListener() {
        if (SystemProperties.isDebug()) {
            return this.scenePulseListener;
        }
        return null;
    }

    public final SceneAntialiasing getAntiAliasing() {
        return this.antiAliasing;
    }

    private boolean getAntiAliasingInternal() {
        return this.antiAliasing != null && Toolkit.getToolkit().isMSAASupported() && Platform.isSupported(ConditionalFeature.SCENE3D) ? this.antiAliasing != SceneAntialiasing.DISABLED : false;
    }

    private void setWindow(Window value) {
        this.windowPropertyImpl().set(value);
    }

    public final Window getWindow() {
        return this.window == null ? null : (Window)this.window.get();
    }

    public final ReadOnlyObjectProperty<Window> windowProperty() {
        return this.windowPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<Window> windowPropertyImpl() {
        if (this.window == null) {
            this.window = new ReadOnlyObjectWrapper<Window>(){
                private Window oldWindow;

                @Override
                protected void invalidated() {
                    Window newWindow = (Window)this.get();
                    Scene.this.getKeyHandler().windowForSceneChanged(this.oldWindow, newWindow);
                    if (this.oldWindow != null) {
                        Scene.this.impl_disposePeer();
                    }
                    if (newWindow != null) {
                        Scene.this.impl_initPeer();
                    }
                    Scene.this.parentEffectiveOrientationInvalidated();
                    this.oldWindow = newWindow;
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "window";
                }
            };
        }
        return this.window;
    }

    @Deprecated
    public void impl_setWindow(Window value) {
        this.setWindow(value);
    }

    @Deprecated
    public void impl_initPeer() {
        assert (this.impl_peer == null);
        Window window = this.getWindow();
        assert (window != null);
        TKStage windowPeer = window.impl_getPeer();
        if (windowPeer == null) {
            return;
        }
        boolean isTransparentWindowsSupported = Platform.isSupported(ConditionalFeature.TRANSPARENT_WINDOW);
        if (!isTransparentWindowsSupported) {
            PlatformImpl.addNoTransparencyStylesheetToScene(this);
        }
        PerformanceTracker.logEvent("Scene.initPeer started");
        Scene.impl_setAllowPGAccess(true);
        Toolkit tk = Toolkit.getToolkit();
        this.impl_peer = windowPeer.createTKScene(this.isDepthBufferInternal(), this.getAntiAliasingInternal(), this.acc);
        PerformanceTracker.logEvent("Scene.initPeer TKScene created");
        this.impl_peer.setTKSceneListener(new ScenePeerListener());
        this.impl_peer.setTKScenePaintListener(new ScenePeerPaintListener());
        PerformanceTracker.logEvent("Scene.initPeer TKScene set");
        this.impl_peer.setRoot((NGNode)this.getRoot().impl_getPeer());
        this.impl_peer.setFillPaint(this.getFill() == null ? null : tk.getPaint(this.getFill()));
        this.getEffectiveCamera().impl_updatePeer();
        this.impl_peer.setCamera((NGCamera)this.getEffectiveCamera().impl_getPeer());
        this.impl_peer.markDirty();
        PerformanceTracker.logEvent("Scene.initPeer TKScene initialized");
        Scene.impl_setAllowPGAccess(false);
        tk.addSceneTkPulseListener(this.scenePulseListener);
        tk.enableDrop(this.impl_peer, new DropTargetListener());
        tk.installInputMethodRequests(this.impl_peer, new InputMethodRequestsDelegate());
        PerformanceTracker.logEvent("Scene.initPeer finished");
    }

    @Deprecated
    public void impl_disposePeer() {
        if (this.impl_peer == null) {
            return;
        }
        PerformanceTracker.logEvent("Scene.disposePeer started");
        Toolkit tk = Toolkit.getToolkit();
        tk.removeSceneTkPulseListener(this.scenePulseListener);
        if (this.accessible != null) {
            this.disposeAccessibles();
            Parent root = this.getRoot();
            if (root != null) {
                ((Node)root).releaseAccessible();
            }
            this.accessible.dispose();
            this.accessible = null;
        }
        this.impl_peer.dispose();
        this.impl_peer = null;
        PerformanceTracker.logEvent("Scene.disposePeer finished");
    }

    private final void setX(double value) {
        this.xPropertyImpl().set(value);
    }

    public final double getX() {
        return this.x == null ? 0.0 : this.x.get();
    }

    public final ReadOnlyDoubleProperty xProperty() {
        return this.xPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper xPropertyImpl() {
        if (this.x == null) {
            this.x = new ReadOnlyDoubleWrapper(this, "x");
        }
        return this.x;
    }

    private final void setY(double value) {
        this.yPropertyImpl().set(value);
    }

    public final double getY() {
        return this.y == null ? 0.0 : this.y.get();
    }

    public final ReadOnlyDoubleProperty yProperty() {
        return this.yPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper yPropertyImpl() {
        if (this.y == null) {
            this.y = new ReadOnlyDoubleWrapper(this, "y");
        }
        return this.y;
    }

    private final void setWidth(double value) {
        this.widthPropertyImpl().set(value);
    }

    public final double getWidth() {
        return this.width == null ? 0.0 : this.width.get();
    }

    public final ReadOnlyDoubleProperty widthProperty() {
        return this.widthPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper widthPropertyImpl() {
        if (this.width == null) {
            this.width = new ReadOnlyDoubleWrapper(){

                @Override
                protected void invalidated() {
                    Parent _root = Scene.this.getRoot();
                    if (_root.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
                        _root.impl_transformsChanged();
                    }
                    if (_root.isResizable()) {
                        Scene.this.resizeRootOnSceneSizeChange(this.get() - _root.getLayoutX() - _root.getTranslateX(), _root.getLayoutBounds().getHeight());
                    }
                    Scene.this.getEffectiveCamera().setViewWidth(this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "width";
                }
            };
        }
        return this.width;
    }

    private final void setHeight(double value) {
        this.heightPropertyImpl().set(value);
    }

    public final double getHeight() {
        return this.height == null ? 0.0 : this.height.get();
    }

    public final ReadOnlyDoubleProperty heightProperty() {
        return this.heightPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper heightPropertyImpl() {
        if (this.height == null) {
            this.height = new ReadOnlyDoubleWrapper(){

                @Override
                protected void invalidated() {
                    Parent _root = Scene.this.getRoot();
                    if (_root.isResizable()) {
                        Scene.this.resizeRootOnSceneSizeChange(_root.getLayoutBounds().getWidth(), this.get() - _root.getLayoutY() - _root.getTranslateY());
                    }
                    Scene.this.getEffectiveCamera().setViewHeight(this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "height";
                }
            };
        }
        return this.height;
    }

    void resizeRootOnSceneSizeChange(double newWidth, double newHeight) {
        this.getRoot().resize(newWidth, newHeight);
    }

    public final void setCamera(Camera value) {
        this.cameraProperty().set(value);
    }

    public final Camera getCamera() {
        return this.camera == null ? null : (Camera)this.camera.get();
    }

    public final ObjectProperty<Camera> cameraProperty() {
        if (this.camera == null) {
            this.camera = new ObjectPropertyBase<Camera>(){
                Camera oldCamera = null;

                @Override
                protected void invalidated() {
                    Camera _value = (Camera)this.get();
                    if (_value != null) {
                        if (_value instanceof PerspectiveCamera && !Platform.isSupported(ConditionalFeature.SCENE3D)) {
                            String logname = Scene.class.getName();
                            PlatformLogger.getLogger(logname).warning("System can't support ConditionalFeature.SCENE3D");
                        }
                        if (_value.getScene() != null && _value.getScene() != Scene.this || _value.getSubScene() != null) {
                            throw new IllegalArgumentException(_value + "is already part of other scene or subscene");
                        }
                        _value.setOwnerScene(Scene.this);
                        _value.setViewWidth(Scene.this.getWidth());
                        _value.setViewHeight(Scene.this.getHeight());
                    }
                    if (this.oldCamera != null && this.oldCamera != _value) {
                        this.oldCamera.setOwnerScene(null);
                    }
                    this.oldCamera = _value;
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "camera";
                }
            };
        }
        return this.camera;
    }

    Camera getEffectiveCamera() {
        Camera cam = this.getCamera();
        if (cam == null || cam instanceof PerspectiveCamera && !Platform.isSupported(ConditionalFeature.SCENE3D)) {
            if (this.defaultCamera == null) {
                this.defaultCamera = new ParallelCamera();
                this.defaultCamera.setOwnerScene(this);
                this.defaultCamera.setViewWidth(this.getWidth());
                this.defaultCamera.setViewHeight(this.getHeight());
            }
            return this.defaultCamera;
        }
        return cam;
    }

    void markCameraDirty() {
        this.markDirty(DirtyBits.CAMERA_DIRTY);
        this.setNeedsRepaint();
    }

    void markCursorDirty() {
        this.markDirty(DirtyBits.CURSOR_DIRTY);
    }

    public final void setFill(Paint value) {
        this.fillProperty().set(value);
    }

    public final Paint getFill() {
        return this.fill == null ? Color.WHITE : (Paint)this.fill.get();
    }

    public final ObjectProperty<Paint> fillProperty() {
        if (this.fill == null) {
            this.fill = new ObjectPropertyBase<Paint>((Paint)Color.WHITE){

                @Override
                protected void invalidated() {
                    Scene.this.markDirty(DirtyBits.FILL_DIRTY);
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "fill";
                }
            };
        }
        return this.fill;
    }

    public final void setRoot(Parent value) {
        this.rootProperty().set(value);
    }

    public final Parent getRoot() {
        return this.root == null ? null : (Parent)this.root.get();
    }

    public final ObjectProperty<Parent> rootProperty() {
        if (this.root == null) {
            this.root = new ObjectPropertyBase<Parent>(){

                private void forceUnbind() {
                    System.err.println("Unbinding illegal root.");
                    this.unbind();
                }

                @Override
                protected void invalidated() {
                    Parent _value = (Parent)this.get();
                    if (_value == null) {
                        if (this.isBound()) {
                            this.forceUnbind();
                        }
                        throw new NullPointerException("Scene's root cannot be null");
                    }
                    if (_value.getParent() != null) {
                        if (this.isBound()) {
                            this.forceUnbind();
                        }
                        throw new IllegalArgumentException(_value + "is already inside a scene-graph and cannot be set as root");
                    }
                    if (_value.getClipParent() != null) {
                        if (this.isBound()) {
                            this.forceUnbind();
                        }
                        throw new IllegalArgumentException(_value + "is set as a clip on another node, so cannot be set as root");
                    }
                    if (_value.getScene() != null && _value.getScene().getRoot() == _value && _value.getScene() != Scene.this) {
                        if (this.isBound()) {
                            this.forceUnbind();
                        }
                        throw new IllegalArgumentException(_value + "is already set as root of another scene");
                    }
                    if (Scene.this.oldRoot != null) {
                        Scene.this.oldRoot.setScenes(null, null);
                    }
                    Scene.this.oldRoot = _value;
                    _value.getStyleClass().add(0, "root");
                    _value.setScenes(Scene.this, null);
                    Scene.this.markDirty(DirtyBits.ROOT_DIRTY);
                    _value.resize(Scene.this.getWidth(), Scene.this.getHeight());
                    _value.requestLayout();
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "root";
                }
            };
        }
        return this.root;
    }

    void setNeedsRepaint() {
        if (this.impl_peer != null) {
            this.impl_peer.entireSceneNeedsRepaint();
        }
    }

    void doCSSLayoutSyncForSnapshot(Node node) {
        if (!this.sizeInitialized) {
            this.preferredSize();
        } else {
            this.doCSSPass();
        }
        this.doLayoutPass();
        if (!paused) {
            this.getRoot().updateBounds();
            if (this.impl_peer != null) {
                this.impl_peer.waitForRenderingToComplete();
                this.impl_peer.waitForSynchronization();
                try {
                    this.scenePulseListener.synchronizeSceneNodes();
                }
                finally {
                    this.impl_peer.releaseSynchronization(false);
                }
            } else {
                this.scenePulseListener.synchronizeSceneNodes();
            }
        }
    }

    static WritableImage doSnapshot(Scene scene, double x, double y, double w, double h, Node root, BaseTransform transform, boolean depthBuffer, Paint fill, Camera camera, WritableImage wimg) {
        Toolkit tk = Toolkit.getToolkit();
        Toolkit.ImageRenderingContext context = new Toolkit.ImageRenderingContext();
        int xMin = (int)Math.floor(x);
        int yMin = (int)Math.floor(y);
        int xMax = (int)Math.ceil(x + w);
        int yMax = (int)Math.ceil(y + h);
        int width = Math.max(xMax - xMin, 1);
        int height = Math.max(yMax - yMin, 1);
        if (wimg == null) {
            wimg = new WritableImage(width, height);
        } else {
            width = (int)wimg.getWidth();
            height = (int)wimg.getHeight();
        }
        Scene.impl_setAllowPGAccess(true);
        context.x = xMin;
        context.y = yMin;
        context.width = width;
        context.height = height;
        context.transform = transform;
        context.depthBuffer = depthBuffer;
        context.root = root.impl_getPeer();
        context.platformPaint = fill == null ? null : tk.getPaint(fill);
        double cameraViewWidth = 1.0;
        double cameraViewHeight = 1.0;
        if (camera != null) {
            cameraViewWidth = camera.getViewWidth();
            cameraViewHeight = camera.getViewHeight();
            camera.setViewWidth(width);
            camera.setViewHeight(height);
            camera.impl_updatePeer();
            context.camera = (NGCamera)camera.impl_getPeer();
        } else {
            context.camera = null;
        }
        context.lights = null;
        if (scene != null && !scene.lights.isEmpty()) {
            context.lights = new NGLightBase[scene.lights.size()];
            for (int i = 0; i < scene.lights.size(); ++i) {
                context.lights[i] = (NGLightBase)scene.lights.get(i).impl_getPeer();
            }
        }
        Toolkit.WritableImageAccessor accessor = Toolkit.getWritableImageAccessor();
        context.platformImage = accessor.getTkImageLoader(wimg);
        Scene.impl_setAllowPGAccess(false);
        Object tkImage = tk.renderToImage(context);
        accessor.loadTkImage(wimg, tkImage);
        if (camera != null) {
            Scene.impl_setAllowPGAccess(true);
            camera.setViewWidth(cameraViewWidth);
            camera.setViewHeight(cameraViewHeight);
            camera.impl_updatePeer();
            Scene.impl_setAllowPGAccess(false);
        }
        if (scene != null && scene.impl_peer != null) {
            scene.setNeedsRepaint();
        }
        return wimg;
    }

    private WritableImage doSnapshot(WritableImage img) {
        this.doCSSLayoutSyncForSnapshot(this.getRoot());
        double w = this.getWidth();
        double h = this.getHeight();
        BaseTransform transform = BaseTransform.IDENTITY_TRANSFORM;
        return Scene.doSnapshot(this, 0.0, 0.0, w, h, this.getRoot(), transform, this.isDepthBufferInternal(), this.getFill(), this.getEffectiveCamera(), img);
    }

    static void addSnapshotRunnable(Runnable runnable) {
        Toolkit.getToolkit().checkFxUserThread();
        if (snapshotPulseListener == null) {
            snapshotRunnableListA = new ArrayList<Runnable>();
            snapshotRunnableListB = new ArrayList<Runnable>();
            snapshotRunnableList = snapshotRunnableListA;
            snapshotPulseListener = () -> {
                if (snapshotRunnableList.size() > 0) {
                    List<Runnable> runnables = snapshotRunnableList;
                    snapshotRunnableList = snapshotRunnableList == snapshotRunnableListA ? snapshotRunnableListB : snapshotRunnableListA;
                    for (Runnable r : runnables) {
                        try {
                            r.run();
                        }
                        catch (Throwable th) {
                            System.err.println("Exception in snapshot runnable");
                            th.printStackTrace(System.err);
                        }
                    }
                    runnables.clear();
                }
            };
            Toolkit.getToolkit().addPostSceneTkPulseListener(snapshotPulseListener);
        }
        AccessControlContext acc = AccessController.getContext();
        snapshotRunnableList.add(() -> AccessController.doPrivileged(() -> {
            runnable.run();
            return null;
        }, acc));
        Toolkit.getToolkit().requestNextPulse();
    }

    public WritableImage snapshot(WritableImage image) {
        if (!paused) {
            Toolkit.getToolkit().checkFxUserThread();
        }
        return this.doSnapshot(image);
    }

    public void snapshot(Callback<SnapshotResult, Void> callback, WritableImage image) {
        Toolkit.getToolkit().checkFxUserThread();
        if (callback == null) {
            throw new NullPointerException("The callback must not be null");
        }
        Callback<SnapshotResult, Void> theCallback = callback;
        WritableImage theImage = image;
        Runnable snapshotRunnable = () -> {
            WritableImage img = this.doSnapshot(theImage);
            SnapshotResult result = new SnapshotResult(img, this, null);
            try {
                Void void_ = (Void)theCallback.call(result);
            }
            catch (Throwable th) {
                System.err.println("Exception in snapshot callback");
                th.printStackTrace(System.err);
            }
        };
        Scene.addSnapshotRunnable(snapshotRunnable);
    }

    public final void setCursor(Cursor value) {
        this.cursorProperty().set(value);
    }

    public final Cursor getCursor() {
        return this.cursor == null ? null : (Cursor)this.cursor.get();
    }

    public final ObjectProperty<Cursor> cursorProperty() {
        if (this.cursor == null) {
            this.cursor = new ObjectPropertyBase<Cursor>(){

                @Override
                protected void invalidated() {
                    Scene.this.markCursorDirty();
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "cursor";
                }
            };
        }
        return this.cursor;
    }

    public Node lookup(String selector) {
        return this.getRoot().lookup(selector);
    }

    public final ObservableList<String> getStylesheets() {
        return this.stylesheets;
    }

    public final ObjectProperty<String> userAgentStylesheetProperty() {
        if (this.userAgentStylesheet == null) {
            this.userAgentStylesheet = new SimpleObjectProperty<String>((Object)this, "userAgentStylesheet", null){

                @Override
                protected void invalidated() {
                    StyleManager.getInstance().forget(Scene.this);
                    Scene.this.getRoot().impl_reapplyCSS();
                }
            };
        }
        return this.userAgentStylesheet;
    }

    public final String getUserAgentStylesheet() {
        return this.userAgentStylesheet == null ? null : (String)this.userAgentStylesheet.get();
    }

    public final void setUserAgentStylesheet(String url) {
        this.userAgentStylesheetProperty().set(url);
    }

    public final boolean isDepthBuffer() {
        return this.depthBuffer;
    }

    boolean isDepthBufferInternal() {
        if (!Platform.isSupported(ConditionalFeature.SCENE3D)) {
            return false;
        }
        return this.depthBuffer;
    }

    private void init(double width, double height) {
        if (width >= 0.0) {
            this.widthSetByUser = width;
            this.setWidth((float)width);
        }
        if (height >= 0.0) {
            this.heightSetByUser = height;
            this.setHeight((float)height);
        }
        this.sizeInitialized = this.widthSetByUser >= 0.0 && this.heightSetByUser >= 0.0;
    }

    private void init() {
        if (PerformanceTracker.isLoggingEnabled()) {
            PerformanceTracker.logEvent("Scene.init for [" + this + "]");
        }
        this.mouseHandler = new MouseHandler();
        this.clickGenerator = new ClickGenerator();
        if (PerformanceTracker.isLoggingEnabled()) {
            PerformanceTracker.logEvent("Scene.init for [" + this + "] - finished");
        }
    }

    private void preferredSize() {
        Parent root = this.getRoot();
        this.doCSSPass();
        this.resizeRootToPreferredSize(root);
        this.doLayoutPass();
        if (this.widthSetByUser < 0.0) {
            this.setWidth(root.isResizable() ? root.getLayoutX() + root.getTranslateX() + root.getLayoutBounds().getWidth() : root.getBoundsInParent().getMaxX());
        } else {
            this.setWidth(this.widthSetByUser);
        }
        if (this.heightSetByUser < 0.0) {
            this.setHeight(root.isResizable() ? root.getLayoutY() + root.getTranslateY() + root.getLayoutBounds().getHeight() : root.getBoundsInParent().getMaxY());
        } else {
            this.setHeight(this.heightSetByUser);
        }
        this.sizeInitialized = this.getWidth() > 0.0 && this.getHeight() > 0.0;
        PerformanceTracker.logEvent("Scene preferred bounds computation complete");
    }

    final void resizeRootToPreferredSize(Parent root) {
        double preferredHeight;
        double preferredWidth;
        Orientation contentBias = root.getContentBias();
        if (contentBias == null) {
            preferredWidth = Scene.getPreferredWidth(root, this.widthSetByUser, -1.0);
            preferredHeight = Scene.getPreferredHeight(root, this.heightSetByUser, -1.0);
        } else if (contentBias == Orientation.HORIZONTAL) {
            preferredWidth = Scene.getPreferredWidth(root, this.widthSetByUser, -1.0);
            preferredHeight = Scene.getPreferredHeight(root, this.heightSetByUser, preferredWidth);
        } else {
            preferredHeight = Scene.getPreferredHeight(root, this.heightSetByUser, -1.0);
            preferredWidth = Scene.getPreferredWidth(root, this.widthSetByUser, preferredHeight);
        }
        root.resize(preferredWidth, preferredHeight);
    }

    private static double getPreferredWidth(Parent root, double forcedWidth, double height) {
        if (forcedWidth >= 0.0) {
            return forcedWidth;
        }
        double normalizedHeight = height >= 0.0 ? height : -1.0;
        return root.boundedSize(root.prefWidth(normalizedHeight), root.minWidth(normalizedHeight), root.maxWidth(normalizedHeight));
    }

    private static double getPreferredHeight(Parent root, double forcedHeight, double width) {
        if (forcedHeight >= 0.0) {
            return forcedHeight;
        }
        double normalizedWidth = width >= 0.0 ? width : -1.0;
        return root.boundedSize(root.prefHeight(normalizedWidth), root.minHeight(normalizedWidth), root.maxHeight(normalizedWidth));
    }

    @Deprecated
    public void impl_preferredSize() {
        this.preferredSize();
    }

    @Deprecated
    public void impl_processMouseEvent(MouseEvent e) {
        this.mouseHandler.process(e, false);
    }

    private void processMenuEvent(double x2, double y2, double xAbs, double yAbs, boolean isKeyboardTrigger) {
        EventTarget eventTarget = null;
        inMousePick = true;
        if (isKeyboardTrigger) {
            Node sceneFocusOwner = this.getFocusOwner();
            double xOffset = xAbs - x2;
            double yOffset = yAbs - y2;
            if (sceneFocusOwner != null) {
                Bounds bounds = sceneFocusOwner.localToScene(sceneFocusOwner.getBoundsInLocal());
                x2 = bounds.getMinX() + bounds.getWidth() / 4.0;
                y2 = bounds.getMinY() + bounds.getHeight() / 2.0;
                eventTarget = sceneFocusOwner;
            } else {
                x2 = this.getWidth() / 4.0;
                y2 = this.getWidth() / 2.0;
                eventTarget = this;
            }
            xAbs = x2 + xOffset;
            yAbs = y2 + yOffset;
        }
        PickResult res = this.pick(x2, y2);
        if (!isKeyboardTrigger && (eventTarget = res.getIntersectedNode()) == null) {
            eventTarget = this;
        }
        if (eventTarget != null) {
            ContextMenuEvent context = new ContextMenuEvent(ContextMenuEvent.CONTEXT_MENU_REQUESTED, x2, y2, xAbs, yAbs, isKeyboardTrigger, res);
            Event.fireEvent(eventTarget, context);
        }
        inMousePick = false;
    }

    private void processGestureEvent(GestureEvent e, TouchGesture gesture) {
        EventTarget pickedTarget = null;
        if (e.getEventType() == ZoomEvent.ZOOM_STARTED || e.getEventType() == RotateEvent.ROTATION_STARTED || e.getEventType() == ScrollEvent.SCROLL_STARTED) {
            gesture.target = null;
            gesture.finished = false;
        }
        if (gesture.target != null && (!gesture.finished || e.isInertia())) {
            pickedTarget = gesture.target;
        } else {
            pickedTarget = e.getPickResult().getIntersectedNode();
            if (pickedTarget == null) {
                pickedTarget = this;
            }
        }
        if (e.getEventType() == ZoomEvent.ZOOM_STARTED || e.getEventType() == RotateEvent.ROTATION_STARTED || e.getEventType() == ScrollEvent.SCROLL_STARTED) {
            gesture.target = pickedTarget;
        }
        if (e.getEventType() != ZoomEvent.ZOOM_FINISHED && e.getEventType() != RotateEvent.ROTATION_FINISHED && e.getEventType() != ScrollEvent.SCROLL_FINISHED && !e.isInertia()) {
            gesture.sceneCoords = new Point2D(e.getSceneX(), e.getSceneY());
            gesture.screenCoords = new Point2D(e.getScreenX(), e.getScreenY());
        }
        if (pickedTarget != null) {
            Event.fireEvent(pickedTarget, e);
        }
        if (e.getEventType() == ZoomEvent.ZOOM_FINISHED || e.getEventType() == RotateEvent.ROTATION_FINISHED || e.getEventType() == ScrollEvent.SCROLL_FINISHED) {
            gesture.finished = true;
        }
    }

    private void processTouchEvent(TouchEvent e, TouchPoint[] touchPoints) {
        inMousePick = true;
        ++this.touchEventSetId;
        List<TouchPoint> touchList = Arrays.asList(touchPoints);
        for (TouchPoint tp : touchPoints) {
            if (tp.getTarget() == null) continue;
            EventType<TouchEvent> type = null;
            switch (tp.getState()) {
                case MOVED: {
                    type = TouchEvent.TOUCH_MOVED;
                    break;
                }
                case PRESSED: {
                    type = TouchEvent.TOUCH_PRESSED;
                    break;
                }
                case RELEASED: {
                    type = TouchEvent.TOUCH_RELEASED;
                    break;
                }
                case STATIONARY: {
                    type = TouchEvent.TOUCH_STATIONARY;
                }
            }
            for (TouchPoint t : touchPoints) {
                t.impl_reset();
            }
            TouchEvent te = new TouchEvent(type, tp, touchList, this.touchEventSetId, e.isShiftDown(), e.isControlDown(), e.isAltDown(), e.isMetaDown());
            Event.fireEvent(tp.getTarget(), te);
        }
        for (TouchPoint tp : touchPoints) {
            EventTarget grabbed = tp.getGrabbed();
            if (grabbed != null) {
                this.touchTargets.put(tp.getId(), grabbed);
            }
            if (grabbed != null && tp.getState() != TouchPoint.State.RELEASED) continue;
            this.touchTargets.remove(tp.getId());
        }
        inMousePick = false;
    }

    Node test_pick(double x, double y) {
        inMousePick = true;
        PickResult result = this.mouseHandler.pickNode(new PickRay(x, y, 1.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
        inMousePick = false;
        if (result != null) {
            return result.getIntersectedNode();
        }
        return null;
    }

    private PickResult pick(double x, double y) {
        this.pick(this.tmpTargetWrapper, x, y);
        return this.tmpTargetWrapper.getResult();
    }

    private boolean isInScene(double x, double y) {
        if (x < 0.0 || y < 0.0 || x > this.getWidth() || y > this.getHeight()) {
            return false;
        }
        Window w = this.getWindow();
        return !(w instanceof Stage) || ((Stage)w).getStyle() != StageStyle.TRANSPARENT || this.getFill() != null;
    }

    private void pick(TargetWrapper target, double x, double y) {
        PickRay pickRay = this.getEffectiveCamera().computePickRay(x, y, null);
        double mag = pickRay.getDirectionNoClone().length();
        pickRay.getDirectionNoClone().normalize();
        PickResult res = this.mouseHandler.pickNode(pickRay);
        if (res != null) {
            target.setNodeResult(res);
        } else {
            Vec3d o = pickRay.getOriginNoClone();
            Vec3d d = pickRay.getDirectionNoClone();
            target.setSceneResult(new PickResult(null, new Point3D(o.x + mag * d.x, o.y + mag * d.y, o.z + mag * d.z), mag), this.isInScene(x, y) ? this : null);
        }
    }

    private KeyHandler getKeyHandler() {
        if (this.keyHandler == null) {
            this.keyHandler = new KeyHandler();
        }
        return this.keyHandler;
    }

    final void setFocusDirty(boolean value) {
        if (!this.focusDirty) {
            Toolkit.getToolkit().requestNextPulse();
        }
        this.focusDirty = value;
    }

    final boolean isFocusDirty() {
        return this.focusDirty;
    }

    boolean traverse(Node node, Direction dir) {
        if (node.getSubScene() != null) {
            return node.getSubScene().traverse(node, dir);
        }
        return this.traversalEngine.trav(node, dir) != null;
    }

    private void focusInitial() {
        this.traversalEngine.traverseToFirst();
    }

    private void focusIneligible(Node node) {
        this.traverse(node, Direction.NEXT);
    }

    @Deprecated
    public void impl_processKeyEvent(KeyEvent e) {
        if (this.dndGesture != null && !this.dndGesture.processKey(e)) {
            this.dndGesture = null;
        }
        this.getKeyHandler().process(e);
    }

    void requestFocus(Node node) {
        this.getKeyHandler().requestFocus(node);
    }

    public final Node getFocusOwner() {
        return (Node)this.focusOwner.get();
    }

    public final ReadOnlyObjectProperty<Node> focusOwnerProperty() {
        return this.focusOwner.getReadOnlyProperty();
    }

    void focusCleanup() {
        this.scenePulseListener.focusCleanup();
    }

    private void processInputMethodEvent(InputMethodEvent e) {
        Node node = this.getFocusOwner();
        if (node != null) {
            node.fireEvent(e);
        }
    }

    @Deprecated
    public void impl_enableInputMethodEvents(boolean enable) {
        if (this.impl_peer != null) {
            this.impl_peer.enableInputMethodEvents(enable);
        }
    }

    boolean isQuiescent() {
        Parent r = this.getRoot();
        return !this.isFocusDirty() && (r == null || r.cssFlag == CssFlags.CLEAN && r.layoutFlag == LayoutFlags.CLEAN);
    }

    private void markDirty(DirtyBits dirtyBit) {
        this.setDirty(dirtyBit);
        if (this.impl_peer != null) {
            Toolkit.getToolkit().requestNextPulse();
        }
    }

    private void setDirty(DirtyBits dirtyBit) {
        this.dirtyBits |= dirtyBit.getMask();
    }

    private boolean isDirty(DirtyBits dirtyBit) {
        return (this.dirtyBits & dirtyBit.getMask()) != 0;
    }

    private boolean isDirtyEmpty() {
        return this.dirtyBits == 0;
    }

    private void clearDirty() {
        this.dirtyBits = 0;
    }

    final void addLight(LightBase light) {
        if (!this.lights.contains(light)) {
            this.lights.add(light);
            this.markDirty(DirtyBits.LIGHTS_DIRTY);
        }
    }

    final void removeLight(LightBase light) {
        if (this.lights.remove(light)) {
            this.markDirty(DirtyBits.LIGHTS_DIRTY);
        }
    }

    private void syncLights() {
        if (!this.isDirty(DirtyBits.LIGHTS_DIRTY)) {
            return;
        }
        inSynchronizer = true;
        NGLightBase[] peerLights = this.impl_peer.getLights();
        if (!this.lights.isEmpty() || peerLights != null) {
            if (this.lights.isEmpty()) {
                this.impl_peer.setLights(null);
            } else {
                int i;
                if (peerLights == null || peerLights.length < this.lights.size()) {
                    peerLights = new NGLightBase[this.lights.size()];
                }
                for (i = 0; i < this.lights.size(); ++i) {
                    peerLights[i] = (NGLightBase)this.lights.get(i).impl_getPeer();
                }
                while (i < peerLights.length && peerLights[i] != null) {
                    peerLights[i++] = null;
                }
                this.impl_peer.setLights(peerLights);
            }
        }
        inSynchronizer = false;
    }

    void generateMouseExited(Node removing) {
        this.mouseHandler.handleNodeRemoval(removing);
    }

    public final void setEventDispatcher(EventDispatcher value) {
        this.eventDispatcherProperty().set(value);
    }

    public final EventDispatcher getEventDispatcher() {
        return (EventDispatcher)this.eventDispatcherProperty().get();
    }

    public final ObjectProperty<EventDispatcher> eventDispatcherProperty() {
        this.initializeInternalEventDispatcher();
        return this.eventDispatcher;
    }

    public final <T extends Event> void addEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().addEventHandler(eventType, eventHandler);
    }

    public final <T extends Event> void removeEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().removeEventHandler(eventType, eventHandler);
    }

    public final <T extends Event> void addEventFilter(EventType<T> eventType, EventHandler<? super T> eventFilter) {
        this.getInternalEventDispatcher().getEventHandlerManager().addEventFilter(eventType, eventFilter);
    }

    public final <T extends Event> void removeEventFilter(EventType<T> eventType, EventHandler<? super T> eventFilter) {
        this.getInternalEventDispatcher().getEventHandlerManager().removeEventFilter(eventType, eventFilter);
    }

    protected final <T extends Event> void setEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().setEventHandler(eventType, eventHandler);
    }

    private SceneEventDispatcher getInternalEventDispatcher() {
        this.initializeInternalEventDispatcher();
        return this.internalEventDispatcher;
    }

    final void initializeInternalEventDispatcher() {
        if (this.internalEventDispatcher == null) {
            this.internalEventDispatcher = this.createInternalEventDispatcher();
            this.eventDispatcher = new SimpleObjectProperty<SceneEventDispatcher>(this, "eventDispatcher", this.internalEventDispatcher);
        }
    }

    private SceneEventDispatcher createInternalEventDispatcher() {
        return new SceneEventDispatcher(this);
    }

    public void addMnemonic(Mnemonic m) {
        this.getInternalEventDispatcher().getKeyboardShortcutsHandler().addMnemonic(m);
    }

    public void removeMnemonic(Mnemonic m) {
        this.getInternalEventDispatcher().getKeyboardShortcutsHandler().removeMnemonic(m);
    }

    final void clearNodeMnemonics(Node node) {
        this.getInternalEventDispatcher().getKeyboardShortcutsHandler().clearNodeMnemonics(node);
    }

    public ObservableMap<KeyCombination, ObservableList<Mnemonic>> getMnemonics() {
        return this.getInternalEventDispatcher().getKeyboardShortcutsHandler().getMnemonics();
    }

    public ObservableMap<KeyCombination, Runnable> getAccelerators() {
        return this.getInternalEventDispatcher().getKeyboardShortcutsHandler().getAccelerators();
    }

    @Override
    public EventDispatchChain buildEventDispatchChain(EventDispatchChain tail) {
        EventDispatcher eventDispatcherValue;
        if (this.eventDispatcher != null && (eventDispatcherValue = (EventDispatcher)this.eventDispatcher.get()) != null) {
            tail = tail.prepend(eventDispatcherValue);
        }
        if (this.getWindow() != null) {
            tail = this.getWindow().buildEventDispatchChain(tail);
        }
        return tail;
    }

    public final void setOnContextMenuRequested(EventHandler<? super ContextMenuEvent> value) {
        this.onContextMenuRequestedProperty().set(value);
    }

    public final EventHandler<? super ContextMenuEvent> getOnContextMenuRequested() {
        return this.onContextMenuRequested == null ? null : (EventHandler)this.onContextMenuRequested.get();
    }

    public final ObjectProperty<EventHandler<? super ContextMenuEvent>> onContextMenuRequestedProperty() {
        if (this.onContextMenuRequested == null) {
            this.onContextMenuRequested = new ObjectPropertyBase<EventHandler<? super ContextMenuEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(ContextMenuEvent.CONTEXT_MENU_REQUESTED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onContextMenuRequested";
                }
            };
        }
        return this.onContextMenuRequested;
    }

    public final void setOnMouseClicked(EventHandler<? super MouseEvent> value) {
        this.onMouseClickedProperty().set(value);
    }

    public final EventHandler<? super MouseEvent> getOnMouseClicked() {
        return this.onMouseClicked == null ? null : (EventHandler)this.onMouseClicked.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseClickedProperty() {
        if (this.onMouseClicked == null) {
            this.onMouseClicked = new ObjectPropertyBase<EventHandler<? super MouseEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMouseClicked";
                }
            };
        }
        return this.onMouseClicked;
    }

    public final void setOnMouseDragged(EventHandler<? super MouseEvent> value) {
        this.onMouseDraggedProperty().set(value);
    }

    public final EventHandler<? super MouseEvent> getOnMouseDragged() {
        return this.onMouseDragged == null ? null : (EventHandler)this.onMouseDragged.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseDraggedProperty() {
        if (this.onMouseDragged == null) {
            this.onMouseDragged = new ObjectPropertyBase<EventHandler<? super MouseEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseEvent.MOUSE_DRAGGED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMouseDragged";
                }
            };
        }
        return this.onMouseDragged;
    }

    public final void setOnMouseEntered(EventHandler<? super MouseEvent> value) {
        this.onMouseEnteredProperty().set(value);
    }

    public final EventHandler<? super MouseEvent> getOnMouseEntered() {
        return this.onMouseEntered == null ? null : (EventHandler)this.onMouseEntered.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseEnteredProperty() {
        if (this.onMouseEntered == null) {
            this.onMouseEntered = new ObjectPropertyBase<EventHandler<? super MouseEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseEvent.MOUSE_ENTERED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMouseEntered";
                }
            };
        }
        return this.onMouseEntered;
    }

    public final void setOnMouseExited(EventHandler<? super MouseEvent> value) {
        this.onMouseExitedProperty().set(value);
    }

    public final EventHandler<? super MouseEvent> getOnMouseExited() {
        return this.onMouseExited == null ? null : (EventHandler)this.onMouseExited.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseExitedProperty() {
        if (this.onMouseExited == null) {
            this.onMouseExited = new ObjectPropertyBase<EventHandler<? super MouseEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseEvent.MOUSE_EXITED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMouseExited";
                }
            };
        }
        return this.onMouseExited;
    }

    public final void setOnMouseMoved(EventHandler<? super MouseEvent> value) {
        this.onMouseMovedProperty().set(value);
    }

    public final EventHandler<? super MouseEvent> getOnMouseMoved() {
        return this.onMouseMoved == null ? null : (EventHandler)this.onMouseMoved.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseMovedProperty() {
        if (this.onMouseMoved == null) {
            this.onMouseMoved = new ObjectPropertyBase<EventHandler<? super MouseEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseEvent.MOUSE_MOVED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMouseMoved";
                }
            };
        }
        return this.onMouseMoved;
    }

    public final void setOnMousePressed(EventHandler<? super MouseEvent> value) {
        this.onMousePressedProperty().set(value);
    }

    public final EventHandler<? super MouseEvent> getOnMousePressed() {
        return this.onMousePressed == null ? null : (EventHandler)this.onMousePressed.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMousePressedProperty() {
        if (this.onMousePressed == null) {
            this.onMousePressed = new ObjectPropertyBase<EventHandler<? super MouseEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseEvent.MOUSE_PRESSED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMousePressed";
                }
            };
        }
        return this.onMousePressed;
    }

    public final void setOnMouseReleased(EventHandler<? super MouseEvent> value) {
        this.onMouseReleasedProperty().set(value);
    }

    public final EventHandler<? super MouseEvent> getOnMouseReleased() {
        return this.onMouseReleased == null ? null : (EventHandler)this.onMouseReleased.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseReleasedProperty() {
        if (this.onMouseReleased == null) {
            this.onMouseReleased = new ObjectPropertyBase<EventHandler<? super MouseEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseEvent.MOUSE_RELEASED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMouseReleased";
                }
            };
        }
        return this.onMouseReleased;
    }

    public final void setOnDragDetected(EventHandler<? super MouseEvent> value) {
        this.onDragDetectedProperty().set(value);
    }

    public final EventHandler<? super MouseEvent> getOnDragDetected() {
        return this.onDragDetected == null ? null : (EventHandler)this.onDragDetected.get();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onDragDetectedProperty() {
        if (this.onDragDetected == null) {
            this.onDragDetected = new ObjectPropertyBase<EventHandler<? super MouseEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseEvent.DRAG_DETECTED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onDragDetected";
                }
            };
        }
        return this.onDragDetected;
    }

    public final void setOnMouseDragOver(EventHandler<? super MouseDragEvent> value) {
        this.onMouseDragOverProperty().set(value);
    }

    public final EventHandler<? super MouseDragEvent> getOnMouseDragOver() {
        return this.onMouseDragOver == null ? null : (EventHandler)this.onMouseDragOver.get();
    }

    public final ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragOverProperty() {
        if (this.onMouseDragOver == null) {
            this.onMouseDragOver = new ObjectPropertyBase<EventHandler<? super MouseDragEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseDragEvent.MOUSE_DRAG_OVER, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMouseDragOver";
                }
            };
        }
        return this.onMouseDragOver;
    }

    public final void setOnMouseDragReleased(EventHandler<? super MouseDragEvent> value) {
        this.onMouseDragReleasedProperty().set(value);
    }

    public final EventHandler<? super MouseDragEvent> getOnMouseDragReleased() {
        return this.onMouseDragReleased == null ? null : (EventHandler)this.onMouseDragReleased.get();
    }

    public final ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragReleasedProperty() {
        if (this.onMouseDragReleased == null) {
            this.onMouseDragReleased = new ObjectPropertyBase<EventHandler<? super MouseDragEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseDragEvent.MOUSE_DRAG_RELEASED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMouseDragReleased";
                }
            };
        }
        return this.onMouseDragReleased;
    }

    public final void setOnMouseDragEntered(EventHandler<? super MouseDragEvent> value) {
        this.onMouseDragEnteredProperty().set(value);
    }

    public final EventHandler<? super MouseDragEvent> getOnMouseDragEntered() {
        return this.onMouseDragEntered == null ? null : (EventHandler)this.onMouseDragEntered.get();
    }

    public final ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragEnteredProperty() {
        if (this.onMouseDragEntered == null) {
            this.onMouseDragEntered = new ObjectPropertyBase<EventHandler<? super MouseDragEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseDragEvent.MOUSE_DRAG_ENTERED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMouseDragEntered";
                }
            };
        }
        return this.onMouseDragEntered;
    }

    public final void setOnMouseDragExited(EventHandler<? super MouseDragEvent> value) {
        this.onMouseDragExitedProperty().set(value);
    }

    public final EventHandler<? super MouseDragEvent> getOnMouseDragExited() {
        return this.onMouseDragExited == null ? null : (EventHandler)this.onMouseDragExited.get();
    }

    public final ObjectProperty<EventHandler<? super MouseDragEvent>> onMouseDragExitedProperty() {
        if (this.onMouseDragExited == null) {
            this.onMouseDragExited = new ObjectPropertyBase<EventHandler<? super MouseDragEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(MouseDragEvent.MOUSE_DRAG_EXITED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onMouseDragExited";
                }
            };
        }
        return this.onMouseDragExited;
    }

    public final void setOnScrollStarted(EventHandler<? super ScrollEvent> value) {
        this.onScrollStartedProperty().set(value);
    }

    public final EventHandler<? super ScrollEvent> getOnScrollStarted() {
        return this.onScrollStarted == null ? null : (EventHandler)this.onScrollStarted.get();
    }

    public final ObjectProperty<EventHandler<? super ScrollEvent>> onScrollStartedProperty() {
        if (this.onScrollStarted == null) {
            this.onScrollStarted = new ObjectPropertyBase<EventHandler<? super ScrollEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(ScrollEvent.SCROLL_STARTED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onScrollStarted";
                }
            };
        }
        return this.onScrollStarted;
    }

    public final void setOnScroll(EventHandler<? super ScrollEvent> value) {
        this.onScrollProperty().set(value);
    }

    public final EventHandler<? super ScrollEvent> getOnScroll() {
        return this.onScroll == null ? null : (EventHandler)this.onScroll.get();
    }

    public final ObjectProperty<EventHandler<? super ScrollEvent>> onScrollProperty() {
        if (this.onScroll == null) {
            this.onScroll = new ObjectPropertyBase<EventHandler<? super ScrollEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(ScrollEvent.SCROLL, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onScroll";
                }
            };
        }
        return this.onScroll;
    }

    public final void setOnScrollFinished(EventHandler<? super ScrollEvent> value) {
        this.onScrollFinishedProperty().set(value);
    }

    public final EventHandler<? super ScrollEvent> getOnScrollFinished() {
        return this.onScrollFinished == null ? null : (EventHandler)this.onScrollFinished.get();
    }

    public final ObjectProperty<EventHandler<? super ScrollEvent>> onScrollFinishedProperty() {
        if (this.onScrollFinished == null) {
            this.onScrollFinished = new ObjectPropertyBase<EventHandler<? super ScrollEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(ScrollEvent.SCROLL_FINISHED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onScrollFinished";
                }
            };
        }
        return this.onScrollFinished;
    }

    public final void setOnRotationStarted(EventHandler<? super RotateEvent> value) {
        this.onRotationStartedProperty().set(value);
    }

    public final EventHandler<? super RotateEvent> getOnRotationStarted() {
        return this.onRotationStarted == null ? null : (EventHandler)this.onRotationStarted.get();
    }

    public final ObjectProperty<EventHandler<? super RotateEvent>> onRotationStartedProperty() {
        if (this.onRotationStarted == null) {
            this.onRotationStarted = new ObjectPropertyBase<EventHandler<? super RotateEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(RotateEvent.ROTATION_STARTED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onRotationStarted";
                }
            };
        }
        return this.onRotationStarted;
    }

    public final void setOnRotate(EventHandler<? super RotateEvent> value) {
        this.onRotateProperty().set(value);
    }

    public final EventHandler<? super RotateEvent> getOnRotate() {
        return this.onRotate == null ? null : (EventHandler)this.onRotate.get();
    }

    public final ObjectProperty<EventHandler<? super RotateEvent>> onRotateProperty() {
        if (this.onRotate == null) {
            this.onRotate = new ObjectPropertyBase<EventHandler<? super RotateEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(RotateEvent.ROTATE, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onRotate";
                }
            };
        }
        return this.onRotate;
    }

    public final void setOnRotationFinished(EventHandler<? super RotateEvent> value) {
        this.onRotationFinishedProperty().set(value);
    }

    public final EventHandler<? super RotateEvent> getOnRotationFinished() {
        return this.onRotationFinished == null ? null : (EventHandler)this.onRotationFinished.get();
    }

    public final ObjectProperty<EventHandler<? super RotateEvent>> onRotationFinishedProperty() {
        if (this.onRotationFinished == null) {
            this.onRotationFinished = new ObjectPropertyBase<EventHandler<? super RotateEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(RotateEvent.ROTATION_FINISHED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onRotationFinished";
                }
            };
        }
        return this.onRotationFinished;
    }

    public final void setOnZoomStarted(EventHandler<? super ZoomEvent> value) {
        this.onZoomStartedProperty().set(value);
    }

    public final EventHandler<? super ZoomEvent> getOnZoomStarted() {
        return this.onZoomStarted == null ? null : (EventHandler)this.onZoomStarted.get();
    }

    public final ObjectProperty<EventHandler<? super ZoomEvent>> onZoomStartedProperty() {
        if (this.onZoomStarted == null) {
            this.onZoomStarted = new ObjectPropertyBase<EventHandler<? super ZoomEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(ZoomEvent.ZOOM_STARTED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onZoomStarted";
                }
            };
        }
        return this.onZoomStarted;
    }

    public final void setOnZoom(EventHandler<? super ZoomEvent> value) {
        this.onZoomProperty().set(value);
    }

    public final EventHandler<? super ZoomEvent> getOnZoom() {
        return this.onZoom == null ? null : (EventHandler)this.onZoom.get();
    }

    public final ObjectProperty<EventHandler<? super ZoomEvent>> onZoomProperty() {
        if (this.onZoom == null) {
            this.onZoom = new ObjectPropertyBase<EventHandler<? super ZoomEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(ZoomEvent.ZOOM, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onZoom";
                }
            };
        }
        return this.onZoom;
    }

    public final void setOnZoomFinished(EventHandler<? super ZoomEvent> value) {
        this.onZoomFinishedProperty().set(value);
    }

    public final EventHandler<? super ZoomEvent> getOnZoomFinished() {
        return this.onZoomFinished == null ? null : (EventHandler)this.onZoomFinished.get();
    }

    public final ObjectProperty<EventHandler<? super ZoomEvent>> onZoomFinishedProperty() {
        if (this.onZoomFinished == null) {
            this.onZoomFinished = new ObjectPropertyBase<EventHandler<? super ZoomEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(ZoomEvent.ZOOM_FINISHED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onZoomFinished";
                }
            };
        }
        return this.onZoomFinished;
    }

    public final void setOnSwipeUp(EventHandler<? super SwipeEvent> value) {
        this.onSwipeUpProperty().set(value);
    }

    public final EventHandler<? super SwipeEvent> getOnSwipeUp() {
        return this.onSwipeUp == null ? null : (EventHandler)this.onSwipeUp.get();
    }

    public final ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeUpProperty() {
        if (this.onSwipeUp == null) {
            this.onSwipeUp = new ObjectPropertyBase<EventHandler<? super SwipeEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(SwipeEvent.SWIPE_UP, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onSwipeUp";
                }
            };
        }
        return this.onSwipeUp;
    }

    public final void setOnSwipeDown(EventHandler<? super SwipeEvent> value) {
        this.onSwipeDownProperty().set(value);
    }

    public final EventHandler<? super SwipeEvent> getOnSwipeDown() {
        return this.onSwipeDown == null ? null : (EventHandler)this.onSwipeDown.get();
    }

    public final ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeDownProperty() {
        if (this.onSwipeDown == null) {
            this.onSwipeDown = new ObjectPropertyBase<EventHandler<? super SwipeEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(SwipeEvent.SWIPE_DOWN, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onSwipeDown";
                }
            };
        }
        return this.onSwipeDown;
    }

    public final void setOnSwipeLeft(EventHandler<? super SwipeEvent> value) {
        this.onSwipeLeftProperty().set(value);
    }

    public final EventHandler<? super SwipeEvent> getOnSwipeLeft() {
        return this.onSwipeLeft == null ? null : (EventHandler)this.onSwipeLeft.get();
    }

    public final ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeLeftProperty() {
        if (this.onSwipeLeft == null) {
            this.onSwipeLeft = new ObjectPropertyBase<EventHandler<? super SwipeEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(SwipeEvent.SWIPE_LEFT, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onSwipeLeft";
                }
            };
        }
        return this.onSwipeLeft;
    }

    public final void setOnSwipeRight(EventHandler<? super SwipeEvent> value) {
        this.onSwipeRightProperty().set(value);
    }

    public final EventHandler<? super SwipeEvent> getOnSwipeRight() {
        return this.onSwipeRight == null ? null : (EventHandler)this.onSwipeRight.get();
    }

    public final ObjectProperty<EventHandler<? super SwipeEvent>> onSwipeRightProperty() {
        if (this.onSwipeRight == null) {
            this.onSwipeRight = new ObjectPropertyBase<EventHandler<? super SwipeEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(SwipeEvent.SWIPE_RIGHT, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onSwipeRight";
                }
            };
        }
        return this.onSwipeRight;
    }

    public final void setOnTouchPressed(EventHandler<? super TouchEvent> value) {
        this.onTouchPressedProperty().set(value);
    }

    public final EventHandler<? super TouchEvent> getOnTouchPressed() {
        return this.onTouchPressed == null ? null : (EventHandler)this.onTouchPressed.get();
    }

    public final ObjectProperty<EventHandler<? super TouchEvent>> onTouchPressedProperty() {
        if (this.onTouchPressed == null) {
            this.onTouchPressed = new ObjectPropertyBase<EventHandler<? super TouchEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(TouchEvent.TOUCH_PRESSED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onTouchPressed";
                }
            };
        }
        return this.onTouchPressed;
    }

    public final void setOnTouchMoved(EventHandler<? super TouchEvent> value) {
        this.onTouchMovedProperty().set(value);
    }

    public final EventHandler<? super TouchEvent> getOnTouchMoved() {
        return this.onTouchMoved == null ? null : (EventHandler)this.onTouchMoved.get();
    }

    public final ObjectProperty<EventHandler<? super TouchEvent>> onTouchMovedProperty() {
        if (this.onTouchMoved == null) {
            this.onTouchMoved = new ObjectPropertyBase<EventHandler<? super TouchEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(TouchEvent.TOUCH_MOVED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onTouchMoved";
                }
            };
        }
        return this.onTouchMoved;
    }

    public final void setOnTouchReleased(EventHandler<? super TouchEvent> value) {
        this.onTouchReleasedProperty().set(value);
    }

    public final EventHandler<? super TouchEvent> getOnTouchReleased() {
        return this.onTouchReleased == null ? null : (EventHandler)this.onTouchReleased.get();
    }

    public final ObjectProperty<EventHandler<? super TouchEvent>> onTouchReleasedProperty() {
        if (this.onTouchReleased == null) {
            this.onTouchReleased = new ObjectPropertyBase<EventHandler<? super TouchEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(TouchEvent.TOUCH_RELEASED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onTouchReleased";
                }
            };
        }
        return this.onTouchReleased;
    }

    public final void setOnTouchStationary(EventHandler<? super TouchEvent> value) {
        this.onTouchStationaryProperty().set(value);
    }

    public final EventHandler<? super TouchEvent> getOnTouchStationary() {
        return this.onTouchStationary == null ? null : (EventHandler)this.onTouchStationary.get();
    }

    public final ObjectProperty<EventHandler<? super TouchEvent>> onTouchStationaryProperty() {
        if (this.onTouchStationary == null) {
            this.onTouchStationary = new ObjectPropertyBase<EventHandler<? super TouchEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(TouchEvent.TOUCH_STATIONARY, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onTouchStationary";
                }
            };
        }
        return this.onTouchStationary;
    }

    public final void setOnDragEntered(EventHandler<? super DragEvent> value) {
        this.onDragEnteredProperty().set(value);
    }

    public final EventHandler<? super DragEvent> getOnDragEntered() {
        return this.onDragEntered == null ? null : (EventHandler)this.onDragEntered.get();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragEnteredProperty() {
        if (this.onDragEntered == null) {
            this.onDragEntered = new ObjectPropertyBase<EventHandler<? super DragEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(DragEvent.DRAG_ENTERED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onDragEntered";
                }
            };
        }
        return this.onDragEntered;
    }

    public final void setOnDragExited(EventHandler<? super DragEvent> value) {
        this.onDragExitedProperty().set(value);
    }

    public final EventHandler<? super DragEvent> getOnDragExited() {
        return this.onDragExited == null ? null : (EventHandler)this.onDragExited.get();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragExitedProperty() {
        if (this.onDragExited == null) {
            this.onDragExited = new ObjectPropertyBase<EventHandler<? super DragEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(DragEvent.DRAG_EXITED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onDragExited";
                }
            };
        }
        return this.onDragExited;
    }

    public final void setOnDragOver(EventHandler<? super DragEvent> value) {
        this.onDragOverProperty().set(value);
    }

    public final EventHandler<? super DragEvent> getOnDragOver() {
        return this.onDragOver == null ? null : (EventHandler)this.onDragOver.get();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragOverProperty() {
        if (this.onDragOver == null) {
            this.onDragOver = new ObjectPropertyBase<EventHandler<? super DragEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(DragEvent.DRAG_OVER, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onDragOver";
                }
            };
        }
        return this.onDragOver;
    }

    public final void setOnDragDropped(EventHandler<? super DragEvent> value) {
        this.onDragDroppedProperty().set(value);
    }

    public final EventHandler<? super DragEvent> getOnDragDropped() {
        return this.onDragDropped == null ? null : (EventHandler)this.onDragDropped.get();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragDroppedProperty() {
        if (this.onDragDropped == null) {
            this.onDragDropped = new ObjectPropertyBase<EventHandler<? super DragEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(DragEvent.DRAG_DROPPED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onDragDropped";
                }
            };
        }
        return this.onDragDropped;
    }

    public final void setOnDragDone(EventHandler<? super DragEvent> value) {
        this.onDragDoneProperty().set(value);
    }

    public final EventHandler<? super DragEvent> getOnDragDone() {
        return this.onDragDone == null ? null : (EventHandler)this.onDragDone.get();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragDoneProperty() {
        if (this.onDragDone == null) {
            this.onDragDone = new ObjectPropertyBase<EventHandler<? super DragEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(DragEvent.DRAG_DONE, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onDragDone";
                }
            };
        }
        return this.onDragDone;
    }

    public Dragboard startDragAndDrop(TransferMode ... transferModes) {
        return this.startDragAndDrop(this, transferModes);
    }

    public void startFullDrag() {
        this.startFullDrag(this);
    }

    Dragboard startDragAndDrop(EventTarget source, TransferMode ... transferModes) {
        Toolkit.getToolkit().checkFxUserThread();
        if (this.dndGesture == null || this.dndGesture.dragDetected != DragDetectedState.PROCESSING) {
            throw new IllegalStateException("Cannot start drag and drop outside of DRAG_DETECTED event handler");
        }
        EnumSet<TransferMode> set = EnumSet.noneOf(TransferMode.class);
        for (TransferMode tm : InputEventUtils.safeTransferModes(transferModes)) {
            set.add(tm);
        }
        return this.dndGesture.startDrag(source, set);
    }

    void startFullDrag(EventTarget source) {
        Toolkit.getToolkit().checkFxUserThread();
        if (this.dndGesture.dragDetected != DragDetectedState.PROCESSING) {
            throw new IllegalStateException("Cannot start full drag outside of DRAG_DETECTED event handler");
        }
        if (this.dndGesture != null) {
            this.dndGesture.startFullPDR(source);
            return;
        }
        throw new IllegalStateException("Cannot start full drag when mouse button is not pressed");
    }

    public final void setOnKeyPressed(EventHandler<? super KeyEvent> value) {
        this.onKeyPressedProperty().set(value);
    }

    public final EventHandler<? super KeyEvent> getOnKeyPressed() {
        return this.onKeyPressed == null ? null : (EventHandler)this.onKeyPressed.get();
    }

    public final ObjectProperty<EventHandler<? super KeyEvent>> onKeyPressedProperty() {
        if (this.onKeyPressed == null) {
            this.onKeyPressed = new ObjectPropertyBase<EventHandler<? super KeyEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onKeyPressed";
                }
            };
        }
        return this.onKeyPressed;
    }

    public final void setOnKeyReleased(EventHandler<? super KeyEvent> value) {
        this.onKeyReleasedProperty().set(value);
    }

    public final EventHandler<? super KeyEvent> getOnKeyReleased() {
        return this.onKeyReleased == null ? null : (EventHandler)this.onKeyReleased.get();
    }

    public final ObjectProperty<EventHandler<? super KeyEvent>> onKeyReleasedProperty() {
        if (this.onKeyReleased == null) {
            this.onKeyReleased = new ObjectPropertyBase<EventHandler<? super KeyEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(KeyEvent.KEY_RELEASED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onKeyReleased";
                }
            };
        }
        return this.onKeyReleased;
    }

    public final void setOnKeyTyped(EventHandler<? super KeyEvent> value) {
        this.onKeyTypedProperty().set(value);
    }

    public final EventHandler<? super KeyEvent> getOnKeyTyped() {
        return this.onKeyTyped == null ? null : (EventHandler)this.onKeyTyped.get();
    }

    public final ObjectProperty<EventHandler<? super KeyEvent>> onKeyTypedProperty() {
        if (this.onKeyTyped == null) {
            this.onKeyTyped = new ObjectPropertyBase<EventHandler<? super KeyEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(KeyEvent.KEY_TYPED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onKeyTyped";
                }
            };
        }
        return this.onKeyTyped;
    }

    public final void setOnInputMethodTextChanged(EventHandler<? super InputMethodEvent> value) {
        this.onInputMethodTextChangedProperty().set(value);
    }

    public final EventHandler<? super InputMethodEvent> getOnInputMethodTextChanged() {
        return this.onInputMethodTextChanged == null ? null : (EventHandler)this.onInputMethodTextChanged.get();
    }

    public final ObjectProperty<EventHandler<? super InputMethodEvent>> onInputMethodTextChangedProperty() {
        if (this.onInputMethodTextChanged == null) {
            this.onInputMethodTextChanged = new ObjectPropertyBase<EventHandler<? super InputMethodEvent>>(){

                @Override
                protected void invalidated() {
                    Scene.this.setEventHandler(InputMethodEvent.INPUT_METHOD_TEXT_CHANGED, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "onInputMethodTextChanged";
                }
            };
        }
        return this.onInputMethodTextChanged;
    }

    public final ObservableMap<Object, Object> getProperties() {
        if (this.properties == null) {
            this.properties = FXCollections.observableMap(new HashMap());
        }
        return this.properties;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public void setUserData(Object value) {
        this.getProperties().put(USER_DATA_KEY, value);
    }

    public Object getUserData() {
        return this.getProperties().get(USER_DATA_KEY);
    }

    public final void setNodeOrientation(NodeOrientation orientation) {
        this.nodeOrientationProperty().set(orientation);
    }

    public final NodeOrientation getNodeOrientation() {
        return this.nodeOrientation == null ? defaultNodeOrientation : (NodeOrientation)((Object)this.nodeOrientation.get());
    }

    public final ObjectProperty<NodeOrientation> nodeOrientationProperty() {
        if (this.nodeOrientation == null) {
            this.nodeOrientation = new StyleableObjectProperty<NodeOrientation>(defaultNodeOrientation){

                @Override
                protected void invalidated() {
                    Scene.this.sceneEffectiveOrientationInvalidated();
                    Scene.this.getRoot().applyCss();
                }

                @Override
                public Object getBean() {
                    return Scene.this;
                }

                @Override
                public String getName() {
                    return "nodeOrientation";
                }

                @Override
                public CssMetaData getCssMetaData() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
        }
        return this.nodeOrientation;
    }

    public final NodeOrientation getEffectiveNodeOrientation() {
        if (this.effectiveNodeOrientation == null) {
            this.effectiveNodeOrientation = this.calcEffectiveNodeOrientation();
        }
        return this.effectiveNodeOrientation;
    }

    public final ReadOnlyObjectProperty<NodeOrientation> effectiveNodeOrientationProperty() {
        if (this.effectiveNodeOrientationProperty == null) {
            this.effectiveNodeOrientationProperty = new EffectiveOrientationProperty();
        }
        return this.effectiveNodeOrientationProperty;
    }

    private void parentEffectiveOrientationInvalidated() {
        if (this.getNodeOrientation() == NodeOrientation.INHERIT) {
            this.sceneEffectiveOrientationInvalidated();
        }
    }

    private void sceneEffectiveOrientationInvalidated() {
        this.effectiveNodeOrientation = null;
        if (this.effectiveNodeOrientationProperty != null) {
            this.effectiveNodeOrientationProperty.invalidate();
        }
        this.getRoot().parentResolvedOrientationInvalidated();
    }

    private NodeOrientation calcEffectiveNodeOrientation() {
        NodeOrientation orientation = this.getNodeOrientation();
        if (orientation == NodeOrientation.INHERIT) {
            Window window = this.getWindow();
            if (window != null) {
                Scene scene;
                Window parent = null;
                if (window instanceof Stage) {
                    parent = ((Stage)window).getOwner();
                } else if (window instanceof PopupWindow) {
                    parent = ((PopupWindow)window).getOwnerWindow();
                }
                if (parent != null && (scene = parent.getScene()) != null) {
                    return scene.getEffectiveNodeOrientation();
                }
            }
            return NodeOrientation.LEFT_TO_RIGHT;
        }
        return orientation;
    }

    Accessible removeAccessible(Node node) {
        if (this.accMap == null) {
            return null;
        }
        return this.accMap.remove(node);
    }

    void addAccessible(Node node, Accessible acc) {
        if (this.accMap == null) {
            this.accMap = new HashMap<Node, Accessible>();
        }
        this.accMap.put(node, acc);
    }

    private void disposeAccessibles() {
        if (this.accMap != null) {
            for (Map.Entry<Node, Accessible> entry : this.accMap.entrySet()) {
                Node node = entry.getKey();
                Accessible acc = entry.getValue();
                if (node.accessible != null) {
                    if (node.accessible == acc) {
                        System.err.println("[A11y] 'node.accessible == acc' should never happen.");
                    }
                    if (node.getScene() == this) {
                        System.err.println("[A11y] 'node.getScene() == this' should never happen.");
                    }
                    acc.dispose();
                    continue;
                }
                if (node.getScene() == this) {
                    node.accessible = acc;
                    continue;
                }
                acc.dispose();
            }
            this.accMap.clear();
        }
    }

    Accessible getAccessible() {
        if (this.impl_peer == null) {
            return null;
        }
        if (this.accessible == null) {
            this.accessible = Application.GetApplication().createAccessible();
            this.accessible.setEventHandler(new Accessible.EventHandler(){

                @Override
                public AccessControlContext getAccessControlContext() {
                    return Scene.this.impl_getPeer().getAccessControlContext();
                }

                @Override
                public Object getAttribute(AccessibleAttribute attribute, Object ... parameters) {
                    switch (attribute) {
                        case CHILDREN: {
                            Parent root = Scene.this.getRoot();
                            if (root == null) break;
                            return FXCollections.observableArrayList(root);
                        }
                        case TEXT: {
                            Window w = Scene.this.getWindow();
                            if (!(w instanceof Stage)) break;
                            return ((Stage)w).getTitle();
                        }
                        case NODE_AT_POINT: {
                            Node node;
                            Window window = Scene.this.getWindow();
                            Point2D pt = (Point2D)parameters[0];
                            PickResult res = Scene.this.pick(pt.getX() - Scene.this.getX() - window.getX(), pt.getY() - Scene.this.getY() - window.getY());
                            if (res != null && (node = res.getIntersectedNode()) != null) {
                                return node;
                            }
                            return Scene.this.getRoot();
                        }
                        case ROLE: {
                            return AccessibleRole.PARENT;
                        }
                        case SCENE: {
                            return Scene.this;
                        }
                        case FOCUS_NODE: {
                            if (Scene.this.transientFocusContainer != null) {
                                return Scene.this.transientFocusContainer.queryAccessibleAttribute(AccessibleAttribute.FOCUS_NODE, new Object[0]);
                            }
                            return Scene.this.getFocusOwner();
                        }
                    }
                    return super.getAttribute(attribute, parameters);
                }
            });
            PlatformImpl.accessibilityActiveProperty().set(true);
        }
        return this.accessible;
    }

    static /* synthetic */ Node[] access$2602(Scene x0, Node[] x1) {
        x0.dirtyNodes = x1;
        return x1;
    }

    static /* synthetic */ TouchPoint[] access$5402(Scene x0, TouchPoint[] x1) {
        x0.touchPoints = x1;
        return x1;
    }

    static {
        PerformanceTracker.setSceneAccessor(new PerformanceTracker.SceneAccessor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPerfTracker(Scene scene, PerformanceTracker tracker) {
                Object object = trackerMonitor;
                synchronized (object) {
                    scene.tracker = tracker;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PerformanceTracker getPerfTracker(Scene scene) {
                Object object = trackerMonitor;
                synchronized (object) {
                    return scene.tracker;
                }
            }
        });
        FXRobotHelper.setSceneAccessor(new FXRobotHelper.FXRobotSceneAccessor(){

            @Override
            public void processKeyEvent(Scene scene, KeyEvent keyEvent) {
                scene.impl_processKeyEvent(keyEvent);
            }

            @Override
            public void processMouseEvent(Scene scene, MouseEvent mouseEvent) {
                scene.impl_processMouseEvent(mouseEvent);
            }

            @Override
            public void processScrollEvent(Scene scene, ScrollEvent scrollEvent) {
                scene.processGestureEvent(scrollEvent, scene.scrollGesture);
            }

            @Override
            public ObservableList<Node> getChildren(Parent parent) {
                return parent.getChildren();
            }

            @Override
            public Object renderToImage(Scene scene, Object platformImage) {
                return scene.snapshot(null).impl_getPlatformImage();
            }
        });
        SceneHelper.setSceneAccessor(new SceneHelper.SceneAccessor(){

            @Override
            public void setPaused(boolean paused) {
                paused = paused;
            }

            @Override
            public void parentEffectiveOrientationInvalidated(Scene scene) {
                scene.parentEffectiveOrientationInvalidated();
            }

            @Override
            public Camera getEffectiveCamera(Scene scene) {
                return scene.getEffectiveCamera();
            }

            @Override
            public Scene createPopupScene(Parent root) {
                return new Scene(root){

                    @Override
                    void doLayoutPass() {
                        this.resizeRootToPreferredSize(this.getRoot());
                        super.doLayoutPass();
                    }

                    @Override
                    void resizeRootOnSceneSizeChange(double newWidth, double newHeight) {
                    }
                };
            }

            @Override
            public void setTransientFocusContainer(Scene scene, Node node) {
                if (scene != null) {
                    scene.transientFocusContainer = node;
                }
            }

            @Override
            public Accessible getAccessible(Scene scene) {
                return scene.getAccessible();
            }
        });
        inSynchronizer = false;
        inMousePick = false;
        allowPGAccess = false;
        pgAccessCount = 0;
        paused = false;
        snapshotPulseListener = null;
        trackerMonitor = new Object();
        USER_DATA_KEY = new Object();
        defaultNodeOrientation = AccessController.doPrivileged(() -> Boolean.getBoolean("javafx.scene.nodeOrientation.RTL")) != false ? NodeOrientation.RIGHT_TO_LEFT : NodeOrientation.INHERIT;
    }

    private final class EffectiveOrientationProperty
    extends ReadOnlyObjectPropertyBase<NodeOrientation> {
        private EffectiveOrientationProperty() {
        }

        @Override
        public NodeOrientation get() {
            return Scene.this.getEffectiveNodeOrientation();
        }

        @Override
        public Object getBean() {
            return Scene.this;
        }

        @Override
        public String getName() {
            return "effectiveNodeOrientation";
        }

        public void invalidate() {
            this.fireValueChangedEvent();
        }
    }

    private static class TargetWrapper {
        private Scene scene;
        private Node node;
        private PickResult result;

        private TargetWrapper() {
        }

        public void fillHierarchy(List<EventTarget> list) {
            list.clear();
            Node n = this.node;
            while (n != null) {
                list.add(n);
                Parent p = n.getParent();
                n = p != null ? p : n.getSubScene();
            }
            if (this.scene != null) {
                list.add(this.scene);
            }
        }

        public EventTarget getEventTarget() {
            return this.node != null ? this.node : this.scene;
        }

        public Cursor getCursor() {
            Cursor cursor = null;
            if (this.node != null) {
                cursor = this.node.getCursor();
                Parent n = this.node.getParent();
                while (cursor == null && n != null) {
                    cursor = n.getCursor();
                    Parent p = n.getParent();
                    n = p != null ? p : n.getSubScene();
                }
            }
            return cursor;
        }

        public void clear() {
            this.set(null, null);
            this.result = null;
        }

        public void setNodeResult(PickResult result) {
            if (result != null) {
                this.result = result;
                Node n = result.getIntersectedNode();
                this.set(n, n.getScene());
            }
        }

        public void setSceneResult(PickResult result, Scene scene) {
            if (result != null) {
                this.result = result;
                this.set(null, scene);
            }
        }

        public PickResult getResult() {
            return this.result;
        }

        public void copy(TargetWrapper tw) {
            this.node = tw.node;
            this.scene = tw.scene;
            this.result = tw.result;
        }

        private void set(Node n, Scene s) {
            this.node = n;
            this.scene = s;
        }
    }

    private static class TouchMap {
        private static final int FAST_THRESHOLD = 10;
        int[] fastMap = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        Map<Long, Integer> slowMap = new HashMap<Long, Integer>();
        List<Integer> order = new LinkedList<Integer>();
        List<Long> removed = new ArrayList<Long>(10);
        int counter = 0;
        int active = 0;

        private TouchMap() {
        }

        public int add(long id) {
            ++this.counter;
            ++this.active;
            if (id < 10L) {
                this.fastMap[(int)id] = this.counter;
            } else {
                this.slowMap.put(id, this.counter);
            }
            this.order.add(this.counter);
            return this.counter;
        }

        public void remove(long id) {
            this.removed.add(id);
        }

        public int get(long id) {
            if (id < 10L) {
                int result = this.fastMap[(int)id];
                if (result == 0) {
                    throw new RuntimeException("Platform reported wrong touch point ID");
                }
                return result;
            }
            try {
                return this.slowMap.get(id);
            }
            catch (NullPointerException e) {
                throw new RuntimeException("Platform reported wrong touch point ID");
            }
        }

        public int getOrder(int id) {
            return this.order.indexOf(id);
        }

        public boolean cleanup() {
            for (long id : this.removed) {
                --this.active;
                this.order.remove((Object)this.get(id));
                if (id < 10L) {
                    this.fastMap[(int)id] = 0;
                } else {
                    this.slowMap.remove(id);
                }
                if (this.active != 0) continue;
                this.counter = 0;
            }
            this.removed.clear();
            return this.active == 0;
        }
    }

    class InputMethodRequestsDelegate
    implements ExtendedInputMethodRequests {
        InputMethodRequestsDelegate() {
        }

        @Override
        public Point2D getTextLocation(int offset) {
            InputMethodRequests requests = this.getClientRequests();
            if (requests != null) {
                return requests.getTextLocation(offset);
            }
            return new Point2D(0.0, 0.0);
        }

        @Override
        public int getLocationOffset(int x, int y) {
            InputMethodRequests requests = this.getClientRequests();
            if (requests != null) {
                return requests.getLocationOffset(x, y);
            }
            return 0;
        }

        @Override
        public void cancelLatestCommittedText() {
            InputMethodRequests requests = this.getClientRequests();
            if (requests != null) {
                requests.cancelLatestCommittedText();
            }
        }

        @Override
        public String getSelectedText() {
            InputMethodRequests requests = this.getClientRequests();
            if (requests != null) {
                return requests.getSelectedText();
            }
            return null;
        }

        @Override
        public int getInsertPositionOffset() {
            InputMethodRequests requests = this.getClientRequests();
            if (requests != null && requests instanceof ExtendedInputMethodRequests) {
                return ((ExtendedInputMethodRequests)requests).getInsertPositionOffset();
            }
            return 0;
        }

        @Override
        public String getCommittedText(int begin, int end) {
            InputMethodRequests requests = this.getClientRequests();
            if (requests != null && requests instanceof ExtendedInputMethodRequests) {
                return ((ExtendedInputMethodRequests)requests).getCommittedText(begin, end);
            }
            return null;
        }

        @Override
        public int getCommittedTextLength() {
            InputMethodRequests requests = this.getClientRequests();
            if (requests != null && requests instanceof ExtendedInputMethodRequests) {
                return ((ExtendedInputMethodRequests)requests).getCommittedTextLength();
            }
            return 0;
        }

        private InputMethodRequests getClientRequests() {
            Node focusOwner = Scene.this.getFocusOwner();
            if (focusOwner != null) {
                return focusOwner.getInputMethodRequests();
            }
            return null;
        }
    }

    class KeyHandler {
        private boolean windowFocused;
        private final InvalidationListener sceneWindowFocusedListener = valueModel -> this.setWindowFocused(((ReadOnlyBooleanProperty)valueModel).get());

        KeyHandler() {
        }

        private void setFocusOwner(Node value) {
            TKScene peer;
            Scene s;
            if (Scene.this.oldFocusOwner != null && (s = Scene.this.oldFocusOwner.getScene()) != null && (peer = s.impl_getPeer()) != null) {
                peer.finishInputMethodComposition();
            }
            Scene.this.focusOwner.set(value);
        }

        protected boolean isWindowFocused() {
            return this.windowFocused;
        }

        protected void setWindowFocused(boolean value) {
            this.windowFocused = value;
            if (Scene.this.getFocusOwner() != null) {
                Scene.this.getFocusOwner().setFocused(this.windowFocused);
            }
            if (this.windowFocused && Scene.this.accessible != null) {
                Scene.this.accessible.sendNotification(AccessibleAttribute.FOCUS_NODE);
            }
        }

        private void windowForSceneChanged(Window oldWindow, Window window) {
            if (oldWindow != null) {
                oldWindow.focusedProperty().removeListener(this.sceneWindowFocusedListener);
            }
            if (window != null) {
                window.focusedProperty().addListener(this.sceneWindowFocusedListener);
                this.setWindowFocused(window.isFocused());
            } else {
                this.setWindowFocused(false);
            }
        }

        private void process(KeyEvent e) {
            Node sceneFocusOwner = Scene.this.getFocusOwner();
            EventTarget eventTarget = sceneFocusOwner != null ? sceneFocusOwner : Scene.this;
            Event.fireEvent(eventTarget, e);
        }

        private void requestFocus(Node node) {
            if (Scene.this.getFocusOwner() == node || node != null && !node.isCanReceiveFocus()) {
                return;
            }
            this.setFocusOwner(node);
        }
    }

    class MouseHandler {
        private TargetWrapper pdrEventTarget = new TargetWrapper();
        private boolean pdrInProgress = false;
        private boolean fullPDREntered = false;
        private EventTarget currentEventTarget = null;
        private MouseEvent lastEvent;
        private boolean hover = false;
        private boolean primaryButtonDown = false;
        private boolean secondaryButtonDown = false;
        private boolean middleButtonDown = false;
        private EventTarget fullPDRSource = null;
        private TargetWrapper fullPDRTmpTargetWrapper = new TargetWrapper();
        private final List<EventTarget> pdrEventTargets = new ArrayList<EventTarget>();
        private final List<EventTarget> currentEventTargets = new ArrayList<EventTarget>();
        private final List<EventTarget> newEventTargets = new ArrayList<EventTarget>();
        private final List<EventTarget> fullPDRCurrentEventTargets = new ArrayList<EventTarget>();
        private final List<EventTarget> fullPDRNewEventTargets = new ArrayList<EventTarget>();
        private EventTarget fullPDRCurrentTarget = null;
        private Cursor currCursor;
        private CursorFrame currCursorFrame;
        private EventQueue queue = new EventQueue();
        private Runnable pickProcess = new Runnable(){

            @Override
            public void run() {
                if (Scene.this.impl_peer != null && MouseHandler.this.lastEvent != null) {
                    MouseHandler.this.process(MouseHandler.this.lastEvent, true);
                }
            }
        };

        MouseHandler() {
        }

        private void pulse() {
            if (this.hover && this.lastEvent != null) {
                Platform.runLater(this.pickProcess);
            }
        }

        private void clearPDREventTargets() {
            this.pdrInProgress = false;
            this.currentEventTarget = this.currentEventTargets.size() > 0 ? this.currentEventTargets.get(0) : null;
            this.pdrEventTarget.clear();
        }

        public void enterFullPDR(EventTarget gestureSource) {
            this.fullPDREntered = true;
            this.fullPDRSource = gestureSource;
            this.fullPDRCurrentTarget = null;
            this.fullPDRCurrentEventTargets.clear();
        }

        public void exitFullPDR(MouseEvent e) {
            if (!this.fullPDREntered) {
                return;
            }
            this.fullPDREntered = false;
            for (int i = this.fullPDRCurrentEventTargets.size() - 1; i >= 0; --i) {
                EventTarget entered = this.fullPDRCurrentEventTargets.get(i);
                Event.fireEvent(entered, MouseEvent.copyForMouseDragEvent(e, entered, entered, MouseDragEvent.MOUSE_DRAG_EXITED_TARGET, this.fullPDRSource, e.getPickResult()));
            }
            this.fullPDRSource = null;
            this.fullPDRCurrentEventTargets.clear();
            this.fullPDRCurrentTarget = null;
        }

        private void handleNodeRemoval(Node removing) {
            EventTarget trg;
            int i;
            if (this.lastEvent == null) {
                return;
            }
            if (this.currentEventTargets.contains(removing)) {
                i = 0;
                trg = null;
                while (trg != removing) {
                    trg = this.currentEventTargets.get(i++);
                    this.queue.postEvent(this.lastEvent.copyFor(trg, trg, MouseEvent.MOUSE_EXITED_TARGET));
                }
                this.currentEventTargets.subList(0, i).clear();
            }
            if (this.fullPDREntered && this.fullPDRCurrentEventTargets.contains(removing)) {
                i = 0;
                trg = null;
                while (trg != removing) {
                    trg = this.fullPDRCurrentEventTargets.get(i++);
                    this.queue.postEvent(MouseEvent.copyForMouseDragEvent(this.lastEvent, trg, trg, MouseDragEvent.MOUSE_DRAG_EXITED_TARGET, this.fullPDRSource, this.lastEvent.getPickResult()));
                }
                this.fullPDRCurrentEventTargets.subList(0, i).clear();
            }
            this.queue.fire();
            if (this.pdrInProgress && this.pdrEventTargets.contains(removing)) {
                i = 0;
                trg = null;
                while (trg != removing) {
                    trg = this.pdrEventTargets.get(i++);
                    ((Node)trg).setPressed(false);
                }
                this.pdrEventTargets.subList(0, i).clear();
                trg = this.pdrEventTargets.get(0);
                PickResult res = this.pdrEventTarget.getResult();
                if (trg instanceof Node) {
                    this.pdrEventTarget.setNodeResult(new PickResult((Node)trg, res.getIntersectedPoint(), res.getIntersectedDistance()));
                } else {
                    this.pdrEventTarget.setSceneResult(new PickResult(null, res.getIntersectedPoint(), res.getIntersectedDistance()), (Scene)trg);
                }
            }
        }

        private void handleEnterExit(MouseEvent e, TargetWrapper pickedTarget) {
            if (pickedTarget.getEventTarget() != this.currentEventTarget || e.getEventType() == MouseEvent.MOUSE_EXITED) {
                if (e.getEventType() == MouseEvent.MOUSE_EXITED) {
                    this.newEventTargets.clear();
                } else {
                    pickedTarget.fillHierarchy(this.newEventTargets);
                }
                int newTargetsSize = this.newEventTargets.size();
                int i = this.currentEventTargets.size() - 1;
                int j = newTargetsSize - 1;
                int k = this.pdrEventTargets.size() - 1;
                while (i >= 0 && j >= 0 && this.currentEventTargets.get(i) == this.newEventTargets.get(j)) {
                    --i;
                    --j;
                    --k;
                }
                int memk = k;
                while (i >= 0) {
                    EventTarget exitedEventTarget = this.currentEventTargets.get(i);
                    if (this.pdrInProgress && (k < 0 || exitedEventTarget != this.pdrEventTargets.get(k))) break;
                    this.queue.postEvent(e.copyFor(exitedEventTarget, exitedEventTarget, MouseEvent.MOUSE_EXITED_TARGET));
                    --i;
                    --k;
                }
                k = memk;
                while (j >= 0) {
                    EventTarget enteredEventTarget = this.newEventTargets.get(j);
                    if (this.pdrInProgress && (k < 0 || enteredEventTarget != this.pdrEventTargets.get(k))) break;
                    this.queue.postEvent(e.copyFor(enteredEventTarget, enteredEventTarget, MouseEvent.MOUSE_ENTERED_TARGET));
                    --j;
                    --k;
                }
                this.currentEventTarget = pickedTarget.getEventTarget();
                this.currentEventTargets.clear();
                ++j;
                while (j < newTargetsSize) {
                    this.currentEventTargets.add(this.newEventTargets.get(j));
                    ++j;
                }
            }
            this.queue.fire();
        }

        private void process(MouseEvent e, boolean onPulse) {
            Toolkit.getToolkit().checkFxUserThread();
            inMousePick = true;
            Scene.this.cursorScreenPos = new Point2D(e.getScreenX(), e.getScreenY());
            Scene.this.cursorScenePos = new Point2D(e.getSceneX(), e.getSceneY());
            boolean gestureStarted = false;
            if (!onPulse) {
                if (e.getEventType() == MouseEvent.MOUSE_PRESSED) {
                    if (!(this.primaryButtonDown || this.secondaryButtonDown || this.middleButtonDown)) {
                        gestureStarted = true;
                        Scene.this.dndGesture = new DnDGesture();
                        this.clearPDREventTargets();
                    }
                } else if (e.getEventType() == MouseEvent.MOUSE_MOVED) {
                    this.clearPDREventTargets();
                } else if (e.getEventType() == MouseEvent.MOUSE_ENTERED) {
                    this.hover = true;
                } else if (e.getEventType() == MouseEvent.MOUSE_EXITED) {
                    this.hover = false;
                }
                this.primaryButtonDown = e.isPrimaryButtonDown();
                this.secondaryButtonDown = e.isSecondaryButtonDown();
                this.middleButtonDown = e.isMiddleButtonDown();
            }
            Scene.this.pick(Scene.this.tmpTargetWrapper, e.getSceneX(), e.getSceneY());
            PickResult res = Scene.this.tmpTargetWrapper.getResult();
            if (res != null) {
                e = new MouseEvent(e.getEventType(), e.getSceneX(), e.getSceneY(), e.getScreenX(), e.getScreenY(), e.getButton(), e.getClickCount(), e.isShiftDown(), e.isControlDown(), e.isAltDown(), e.isMetaDown(), e.isPrimaryButtonDown(), e.isMiddleButtonDown(), e.isSecondaryButtonDown(), e.isSynthesized(), e.isPopupTrigger(), e.isStillSincePress(), res);
            }
            if (e.getEventType() == MouseEvent.MOUSE_EXITED) {
                Scene.this.tmpTargetWrapper.clear();
            }
            TargetWrapper target = this.pdrInProgress ? this.pdrEventTarget : Scene.this.tmpTargetWrapper;
            if (gestureStarted) {
                this.pdrEventTarget.copy(target);
                this.pdrEventTarget.fillHierarchy(this.pdrEventTargets);
            }
            if (!onPulse) {
                e = Scene.this.clickGenerator.preProcess(e);
            }
            this.handleEnterExit(e, Scene.this.tmpTargetWrapper);
            if (Scene.this.dndGesture != null) {
                Scene.this.dndGesture.processDragDetection(e);
            }
            if (this.fullPDREntered && e.getEventType() == MouseEvent.MOUSE_RELEASED) {
                this.processFullPDR(e, onPulse);
            }
            if (target.getEventTarget() != null && e.getEventType() != MouseEvent.MOUSE_ENTERED && e.getEventType() != MouseEvent.MOUSE_EXITED && !onPulse) {
                Event.fireEvent(target.getEventTarget(), e);
            }
            if (this.fullPDREntered && e.getEventType() != MouseEvent.MOUSE_RELEASED) {
                this.processFullPDR(e, onPulse);
            }
            if (!onPulse) {
                Scene.this.clickGenerator.postProcess(e, target, Scene.this.tmpTargetWrapper);
            }
            if (!onPulse && Scene.this.dndGesture != null && !Scene.this.dndGesture.process(e, target.getEventTarget())) {
                Scene.this.dndGesture = null;
            }
            Cursor cursor = target.getCursor();
            if (e.getEventType() != MouseEvent.MOUSE_EXITED) {
                if (cursor == null && this.hover) {
                    cursor = Scene.this.getCursor();
                }
                this.updateCursor(cursor);
                this.updateCursorFrame();
            }
            if (gestureStarted) {
                this.pdrInProgress = true;
            }
            if (this.pdrInProgress && !this.primaryButtonDown && !this.secondaryButtonDown && !this.middleButtonDown) {
                this.clearPDREventTargets();
                this.exitFullPDR(e);
                Scene.this.pick(Scene.this.tmpTargetWrapper, e.getSceneX(), e.getSceneY());
                this.handleEnterExit(e, Scene.this.tmpTargetWrapper);
            }
            this.lastEvent = e.getEventType() == MouseEvent.MOUSE_EXITED ? null : e;
            inMousePick = false;
        }

        private void processFullPDR(MouseEvent e, boolean onPulse) {
            Scene.this.pick(this.fullPDRTmpTargetWrapper, e.getSceneX(), e.getSceneY());
            PickResult result = this.fullPDRTmpTargetWrapper.getResult();
            EventTarget eventTarget = this.fullPDRTmpTargetWrapper.getEventTarget();
            if (eventTarget != this.fullPDRCurrentTarget) {
                int j;
                this.fullPDRTmpTargetWrapper.fillHierarchy(this.fullPDRNewEventTargets);
                int newTargetsSize = this.fullPDRNewEventTargets.size();
                int i = this.fullPDRCurrentEventTargets.size() - 1;
                for (j = newTargetsSize - 1; i >= 0 && j >= 0 && this.fullPDRCurrentEventTargets.get(i) == this.fullPDRNewEventTargets.get(j); --i, --j) {
                }
                while (i >= 0) {
                    EventTarget exitedEventTarget = this.fullPDRCurrentEventTargets.get(i);
                    Event.fireEvent(exitedEventTarget, MouseEvent.copyForMouseDragEvent(e, exitedEventTarget, exitedEventTarget, MouseDragEvent.MOUSE_DRAG_EXITED_TARGET, this.fullPDRSource, result));
                    --i;
                }
                while (j >= 0) {
                    EventTarget enteredEventTarget = this.fullPDRNewEventTargets.get(j);
                    Event.fireEvent(enteredEventTarget, MouseEvent.copyForMouseDragEvent(e, enteredEventTarget, enteredEventTarget, MouseDragEvent.MOUSE_DRAG_ENTERED_TARGET, this.fullPDRSource, result));
                    --j;
                }
                this.fullPDRCurrentTarget = eventTarget;
                this.fullPDRCurrentEventTargets.clear();
                this.fullPDRCurrentEventTargets.addAll(this.fullPDRNewEventTargets);
                this.fullPDRNewEventTargets.clear();
            }
            if (eventTarget != null && !onPulse) {
                if (e.getEventType() == MouseEvent.MOUSE_DRAGGED) {
                    Event.fireEvent(eventTarget, MouseEvent.copyForMouseDragEvent(e, eventTarget, eventTarget, MouseDragEvent.MOUSE_DRAG_OVER, this.fullPDRSource, result));
                }
                if (e.getEventType() == MouseEvent.MOUSE_RELEASED) {
                    Event.fireEvent(eventTarget, MouseEvent.copyForMouseDragEvent(e, eventTarget, eventTarget, MouseDragEvent.MOUSE_DRAG_RELEASED, this.fullPDRSource, result));
                }
            }
        }

        private void updateCursor(Cursor newCursor) {
            if (this.currCursor != newCursor) {
                if (this.currCursor != null) {
                    this.currCursor.deactivate();
                }
                if (newCursor != null) {
                    newCursor.activate();
                }
                this.currCursor = newCursor;
            }
        }

        public void updateCursorFrame() {
            CursorFrame newCursorFrame;
            CursorFrame cursorFrame = newCursorFrame = this.currCursor != null ? this.currCursor.getCurrentFrame() : Cursor.DEFAULT.getCurrentFrame();
            if (this.currCursorFrame != newCursorFrame) {
                if (Scene.this.impl_peer != null) {
                    Scene.this.impl_peer.setCursor(newCursorFrame);
                }
                this.currCursorFrame = newCursorFrame;
            }
        }

        private PickResult pickNode(PickRay pickRay) {
            PickResultChooser r = new PickResultChooser();
            Scene.this.getRoot().impl_pickNode(pickRay, r);
            return r.toPickResult();
        }
    }

    static class ClickGenerator {
        private ClickCounter lastPress = null;
        private Map<MouseButton, ClickCounter> counters = new EnumMap<MouseButton, ClickCounter>(MouseButton.class);
        private List<EventTarget> pressedTargets = new ArrayList<EventTarget>();
        private List<EventTarget> releasedTargets = new ArrayList<EventTarget>();

        public ClickGenerator() {
            for (MouseButton mb : MouseButton.values()) {
                if (mb == MouseButton.NONE) continue;
                this.counters.put(mb, new ClickCounter());
            }
        }

        private MouseEvent preProcess(MouseEvent e) {
            boolean still;
            for (ClickCounter cc : this.counters.values()) {
                cc.moved(e.getSceneX(), e.getSceneY());
            }
            ClickCounter cc = this.counters.get((Object)e.getButton());
            boolean bl = still = this.lastPress != null ? this.lastPress.isStill() : false;
            if (e.getEventType() == MouseEvent.MOUSE_PRESSED) {
                if (!e.isPrimaryButtonDown()) {
                    this.counters.get((Object)MouseButton.PRIMARY).clear();
                }
                if (!e.isSecondaryButtonDown()) {
                    this.counters.get((Object)MouseButton.SECONDARY).clear();
                }
                if (!e.isMiddleButtonDown()) {
                    this.counters.get((Object)MouseButton.MIDDLE).clear();
                }
                cc.applyOut();
                cc.inc();
                cc.start(e.getSceneX(), e.getSceneY());
                this.lastPress = cc;
            }
            return new MouseEvent(e.getEventType(), e.getSceneX(), e.getSceneY(), e.getScreenX(), e.getScreenY(), e.getButton(), cc != null && e.getEventType() != MouseEvent.MOUSE_MOVED ? cc.get() : 0, e.isShiftDown(), e.isControlDown(), e.isAltDown(), e.isMetaDown(), e.isPrimaryButtonDown(), e.isMiddleButtonDown(), e.isSecondaryButtonDown(), e.isSynthesized(), e.isPopupTrigger(), still, e.getPickResult());
        }

        private void postProcess(MouseEvent e, TargetWrapper target, TargetWrapper pickedTarget) {
            if (e.getEventType() == MouseEvent.MOUSE_RELEASED) {
                ClickCounter cc = this.counters.get((Object)e.getButton());
                target.fillHierarchy(this.pressedTargets);
                pickedTarget.fillHierarchy(this.releasedTargets);
                int i = this.pressedTargets.size() - 1;
                EventTarget clickedTarget = null;
                for (int j = this.releasedTargets.size() - 1; i >= 0 && j >= 0 && this.pressedTargets.get(i) == this.releasedTargets.get(j); --i, --j) {
                    clickedTarget = this.pressedTargets.get(i);
                }
                this.pressedTargets.clear();
                this.releasedTargets.clear();
                if (clickedTarget != null && this.lastPress != null) {
                    MouseEvent click = new MouseEvent(null, clickedTarget, MouseEvent.MOUSE_CLICKED, e.getSceneX(), e.getSceneY(), e.getScreenX(), e.getScreenY(), e.getButton(), cc.get(), e.isShiftDown(), e.isControlDown(), e.isAltDown(), e.isMetaDown(), e.isPrimaryButtonDown(), e.isMiddleButtonDown(), e.isSecondaryButtonDown(), e.isSynthesized(), e.isPopupTrigger(), this.lastPress.isStill(), e.getPickResult());
                    Event.fireEvent(clickedTarget, click);
                }
            }
        }
    }

    static class ClickCounter {
        Toolkit toolkit = Toolkit.getToolkit();
        private int count;
        private boolean out;
        private boolean still;
        private Timeline timeout;
        private double pressedX;
        private double pressedY;

        ClickCounter() {
        }

        private void inc() {
            ++this.count;
        }

        private int get() {
            return this.count;
        }

        private boolean isStill() {
            return this.still;
        }

        private void clear() {
            this.count = 0;
            this.stopTimeout();
        }

        private void out() {
            this.out = true;
            this.stopTimeout();
        }

        private void applyOut() {
            if (this.out) {
                this.clear();
            }
            this.out = false;
        }

        private void moved(double x, double y) {
            if (Math.abs(x - this.pressedX) > (double)this.toolkit.getMultiClickMaxX() || Math.abs(y - this.pressedY) > (double)this.toolkit.getMultiClickMaxY()) {
                this.out();
                this.still = false;
            }
        }

        private void start(double x, double y) {
            this.pressedX = x;
            this.pressedY = y;
            this.out = false;
            if (this.timeout != null) {
                this.timeout.stop();
            }
            this.timeout = new Timeline();
            this.timeout.getKeyFrames().add(new KeyFrame(new Duration(this.toolkit.getMultiClickTime()), event -> {
                this.out = true;
                this.timeout = null;
            }, new KeyValue[0]));
            this.timeout.play();
            this.still = true;
        }

        private void stopTimeout() {
            if (this.timeout != null) {
                this.timeout.stop();
                this.timeout = null;
            }
        }
    }

    class DragSourceListener
    implements TKDragSourceListener {
        DragSourceListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dragDropEnd(double x, double y, double screenX, double screenY, TransferMode transferMode) {
            if (Scene.this.dndGesture != null) {
                if (Scene.this.dndGesture.dragboard == null) {
                    throw new RuntimeException("dndGesture.dragboard is null in dragDropEnd");
                }
                DragEvent dragEvent = new DragEvent(DragEvent.ANY, Scene.this.dndGesture.dragboard, x, y, screenX, screenY, transferMode, null, null, null);
                DragboardHelper.setDataAccessRestriction(Scene.this.dndGesture.dragboard, false);
                try {
                    Scene.this.dndGesture.processDropEnd(dragEvent);
                }
                finally {
                    DragboardHelper.setDataAccessRestriction(Scene.this.dndGesture.dragboard, true);
                }
                Scene.this.dndGesture = null;
            }
        }
    }

    private static enum DragDetectedState {
        NOT_YET,
        PROCESSING,
        DONE;

    }

    class DnDGesture {
        private final double hysteresisSizeX = Toolkit.getToolkit().getMultiClickMaxX();
        private final double hysteresisSizeY = Toolkit.getToolkit().getMultiClickMaxY();
        private EventTarget source = null;
        private Set<TransferMode> sourceTransferModes = null;
        private TransferMode acceptedTransferMode = null;
        private Dragboard dragboard = null;
        private EventTarget potentialTarget = null;
        private EventTarget target = null;
        private DragDetectedState dragDetected = DragDetectedState.NOT_YET;
        private double pressedX;
        private double pressedY;
        private List<EventTarget> currentTargets = new ArrayList<EventTarget>();
        private List<EventTarget> newTargets = new ArrayList<EventTarget>();
        private EventTarget fullPDRSource = null;

        DnDGesture() {
        }

        private void fireEvent(EventTarget target, Event e) {
            if (target != null) {
                Event.fireEvent(target, e);
            }
        }

        private void processingDragDetected() {
            this.dragDetected = DragDetectedState.PROCESSING;
        }

        private void dragDetectedProcessed() {
            boolean hasContent;
            this.dragDetected = DragDetectedState.DONE;
            boolean bl = hasContent = this.dragboard != null && this.dragboard.impl_contentPut();
            if (hasContent) {
                Toolkit.getToolkit().startDrag(Scene.this.impl_peer, this.sourceTransferModes, new DragSourceListener(), this.dragboard);
            } else if (this.fullPDRSource != null) {
                Scene.this.mouseHandler.enterFullPDR(this.fullPDRSource);
            }
            this.fullPDRSource = null;
        }

        private void processDragDetection(MouseEvent mouseEvent) {
            if (this.dragDetected != DragDetectedState.NOT_YET) {
                mouseEvent.setDragDetect(false);
                return;
            }
            if (mouseEvent.getEventType() == MouseEvent.MOUSE_PRESSED) {
                this.pressedX = mouseEvent.getSceneX();
                this.pressedY = mouseEvent.getSceneY();
                mouseEvent.setDragDetect(false);
            } else if (mouseEvent.getEventType() == MouseEvent.MOUSE_DRAGGED) {
                double deltaX = Math.abs(mouseEvent.getSceneX() - this.pressedX);
                double deltaY = Math.abs(mouseEvent.getSceneY() - this.pressedY);
                mouseEvent.setDragDetect(deltaX > this.hysteresisSizeX || deltaY > this.hysteresisSizeY);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean process(MouseEvent mouseEvent, EventTarget target) {
            boolean continueProcessing = true;
            if (this.dragDetected != DragDetectedState.DONE && (mouseEvent.getEventType() == MouseEvent.MOUSE_PRESSED || mouseEvent.getEventType() == MouseEvent.MOUSE_DRAGGED) && mouseEvent.isDragDetect()) {
                this.processingDragDetected();
                if (target != null) {
                    MouseEvent detectedEvent = mouseEvent.copyFor(mouseEvent.getSource(), target, MouseEvent.DRAG_DETECTED);
                    try {
                        this.fireEvent(target, detectedEvent);
                    }
                    finally {
                        if (this.dragboard != null) {
                            DragboardHelper.setDataAccessRestriction(this.dragboard, true);
                        }
                    }
                }
                this.dragDetectedProcessed();
            }
            if (mouseEvent.getEventType() == MouseEvent.MOUSE_RELEASED) {
                continueProcessing = false;
            }
            return continueProcessing;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean processRecognized(DragEvent de) {
            MouseEvent me = new MouseEvent(MouseEvent.DRAG_DETECTED, de.getX(), de.getY(), de.getSceneX(), de.getScreenY(), MouseButton.PRIMARY, 1, false, false, false, false, false, true, false, false, false, false, de.getPickResult());
            this.processingDragDetected();
            Node target = de.getPickResult().getIntersectedNode();
            try {
                this.fireEvent(target != null ? target : Scene.this, me);
            }
            finally {
                if (this.dragboard != null) {
                    DragboardHelper.setDataAccessRestriction(this.dragboard, true);
                }
            }
            this.dragDetectedProcessed();
            boolean hasContent = this.dragboard != null && !this.dragboard.getContentTypes().isEmpty();
            return hasContent;
        }

        private void processDropEnd(DragEvent de) {
            if (this.source == null) {
                System.out.println("Scene.DnDGesture.processDropEnd() - UNEXPECTD - source is NULL");
                return;
            }
            de = new DragEvent(de.getSource(), this.source, DragEvent.DRAG_DONE, de.getDragboard(), de.getSceneX(), de.getSceneY(), de.getScreenX(), de.getScreenY(), de.getTransferMode(), this.source, this.target, de.getPickResult());
            Event.fireEvent(this.source, de);
            Scene.this.tmpTargetWrapper.clear();
            this.handleExitEnter(de, Scene.this.tmpTargetWrapper);
            Toolkit.getToolkit().stopDrag(this.dragboard);
        }

        private TransferMode processTargetEnterOver(DragEvent de) {
            Scene.this.pick(Scene.this.tmpTargetWrapper, de.getSceneX(), de.getSceneY());
            EventTarget pickedTarget = Scene.this.tmpTargetWrapper.getEventTarget();
            if (this.dragboard == null) {
                this.dragboard = this.createDragboard(de, false);
            }
            de = new DragEvent(de.getSource(), pickedTarget, de.getEventType(), this.dragboard, de.getSceneX(), de.getSceneY(), de.getScreenX(), de.getScreenY(), de.getTransferMode(), this.source, this.potentialTarget, de.getPickResult());
            this.handleExitEnter(de, Scene.this.tmpTargetWrapper);
            de = new DragEvent(de.getSource(), pickedTarget, DragEvent.DRAG_OVER, de.getDragboard(), de.getSceneX(), de.getSceneY(), de.getScreenX(), de.getScreenY(), de.getTransferMode(), this.source, this.potentialTarget, de.getPickResult());
            this.fireEvent(pickedTarget, de);
            Object acceptingObject = de.getAcceptingObject();
            this.potentialTarget = acceptingObject instanceof EventTarget ? (EventTarget)acceptingObject : null;
            this.acceptedTransferMode = de.getAcceptedTransferMode();
            return this.acceptedTransferMode;
        }

        private void processTargetActionChanged(DragEvent de) {
        }

        private void processTargetExit(DragEvent de) {
            if (this.dragboard == null) {
                throw new NullPointerException("dragboard is null in processTargetExit()");
            }
            if (this.currentTargets.size() > 0) {
                this.potentialTarget = null;
                Scene.this.tmpTargetWrapper.clear();
                this.handleExitEnter(de, Scene.this.tmpTargetWrapper);
            }
        }

        private TransferMode processTargetDrop(DragEvent de) {
            Scene.this.pick(Scene.this.tmpTargetWrapper, de.getSceneX(), de.getSceneY());
            EventTarget pickedTarget = Scene.this.tmpTargetWrapper.getEventTarget();
            de = new DragEvent(de.getSource(), pickedTarget, DragEvent.DRAG_DROPPED, de.getDragboard(), de.getSceneX(), de.getSceneY(), de.getScreenX(), de.getScreenY(), this.acceptedTransferMode, this.source, this.potentialTarget, de.getPickResult());
            if (this.dragboard == null) {
                throw new NullPointerException("dragboard is null in processTargetDrop()");
            }
            this.handleExitEnter(de, Scene.this.tmpTargetWrapper);
            this.fireEvent(pickedTarget, de);
            Object acceptingObject = de.getAcceptingObject();
            this.target = this.potentialTarget = acceptingObject instanceof EventTarget ? (EventTarget)acceptingObject : null;
            TransferMode result = de.isDropCompleted() ? de.getAcceptedTransferMode() : null;
            Scene.this.tmpTargetWrapper.clear();
            this.handleExitEnter(de, Scene.this.tmpTargetWrapper);
            return result;
        }

        private void handleExitEnter(DragEvent e, TargetWrapper target) {
            EventTarget currentTarget;
            EventTarget eventTarget = currentTarget = this.currentTargets.size() > 0 ? this.currentTargets.get(0) : null;
            if (target.getEventTarget() != currentTarget) {
                EventTarget t;
                int j;
                target.fillHierarchy(this.newTargets);
                int i = this.currentTargets.size() - 1;
                for (j = this.newTargets.size() - 1; i >= 0 && j >= 0 && this.currentTargets.get(i) == this.newTargets.get(j); --i, --j) {
                }
                while (i >= 0) {
                    t = this.currentTargets.get(i);
                    if (this.potentialTarget == t) {
                        this.potentialTarget = null;
                    }
                    e = e.copyFor(e.getSource(), t, this.source, this.potentialTarget, DragEvent.DRAG_EXITED_TARGET);
                    Event.fireEvent(t, e);
                    --i;
                }
                this.potentialTarget = null;
                while (j >= 0) {
                    t = this.newTargets.get(j);
                    Object acceptingObject = (e = e.copyFor(e.getSource(), t, this.source, this.potentialTarget, DragEvent.DRAG_ENTERED_TARGET)).getAcceptingObject();
                    if (acceptingObject instanceof EventTarget) {
                        this.potentialTarget = (EventTarget)acceptingObject;
                    }
                    Event.fireEvent(t, e);
                    --j;
                }
                this.currentTargets.clear();
                this.currentTargets.addAll(this.newTargets);
                this.newTargets.clear();
            }
        }

        private boolean processKey(KeyEvent e) {
            if (e.getEventType() == KeyEvent.KEY_PRESSED && e.getCode() == KeyCode.ESCAPE) {
                DragEvent de = new DragEvent(this.source, this.source, DragEvent.DRAG_DONE, this.dragboard, 0.0, 0.0, 0.0, 0.0, null, this.source, null, null);
                if (this.source != null) {
                    Event.fireEvent(this.source, de);
                }
                Scene.this.tmpTargetWrapper.clear();
                this.handleExitEnter(de, Scene.this.tmpTargetWrapper);
                return false;
            }
            return true;
        }

        private Dragboard startDrag(EventTarget source, Set<TransferMode> t) {
            if (this.dragDetected != DragDetectedState.PROCESSING) {
                throw new IllegalStateException("Cannot start drag and drop outside of DRAG_DETECTED event handler");
            }
            if (t.isEmpty()) {
                this.dragboard = null;
            } else if (this.dragboard == null) {
                this.dragboard = this.createDragboard(null, true);
            }
            DragboardHelper.setDataAccessRestriction(this.dragboard, false);
            this.source = source;
            this.potentialTarget = source;
            this.sourceTransferModes = t;
            return this.dragboard;
        }

        private void startFullPDR(EventTarget source) {
            this.fullPDRSource = source;
        }

        private Dragboard createDragboard(DragEvent de, boolean isDragSource) {
            Dragboard dragboard = null;
            if (de != null && (dragboard = de.getDragboard()) != null) {
                return dragboard;
            }
            TKClipboard dragboardPeer = Scene.this.impl_peer.createDragboard(isDragSource);
            return Dragboard.impl_createDragboard(dragboardPeer);
        }
    }

    class DragGestureListener
    implements TKDragGestureListener {
        DragGestureListener() {
        }

        @Override
        public void dragGestureRecognized(double x, double y, double screenX, double screenY, int button, TKClipboard dragboard) {
            Dragboard db = Dragboard.impl_createDragboard(dragboard);
            Scene.this.dndGesture = new DnDGesture();
            Scene.this.dndGesture.dragboard = db;
            DragEvent dragEvent = new DragEvent(DragEvent.ANY, db, x, y, screenX, screenY, null, null, null, Scene.this.pick(x, y));
            Scene.this.dndGesture.processRecognized(dragEvent);
            Scene.this.dndGesture = null;
        }
    }

    class DropTargetListener
    implements TKDropTargetListener {
        DropTargetListener() {
        }

        @Override
        public TransferMode dragEnter(double x, double y, double screenX, double screenY, TransferMode transferMode, TKClipboard dragboard) {
            if (Scene.this.dndGesture == null) {
                Scene.this.dndGesture = new DnDGesture();
            }
            Dragboard db = Dragboard.impl_createDragboard(dragboard);
            Scene.this.dndGesture.dragboard = db;
            DragEvent dragEvent = new DragEvent(DragEvent.ANY, Scene.this.dndGesture.dragboard, x, y, screenX, screenY, transferMode, null, null, Scene.this.pick(x, y));
            return Scene.this.dndGesture.processTargetEnterOver(dragEvent);
        }

        @Override
        public TransferMode dragOver(double x, double y, double screenX, double screenY, TransferMode transferMode) {
            if (Scene.this.dndGesture == null) {
                System.err.println("GOT A dragOver when dndGesture is null!");
                return null;
            }
            if (Scene.this.dndGesture.dragboard == null) {
                throw new RuntimeException("dndGesture.dragboard is null in dragOver");
            }
            DragEvent dragEvent = new DragEvent(DragEvent.ANY, Scene.this.dndGesture.dragboard, x, y, screenX, screenY, transferMode, null, null, Scene.this.pick(x, y));
            return Scene.this.dndGesture.processTargetEnterOver(dragEvent);
        }

        @Override
        public void dragExit(double x, double y, double screenX, double screenY) {
            if (Scene.this.dndGesture == null) {
                System.err.println("GOT A dragExit when dndGesture is null!");
            } else {
                if (Scene.this.dndGesture.dragboard == null) {
                    throw new RuntimeException("dndGesture.dragboard is null in dragExit");
                }
                DragEvent dragEvent = new DragEvent(DragEvent.ANY, Scene.this.dndGesture.dragboard, x, y, screenX, screenY, null, null, null, Scene.this.pick(x, y));
                Scene.this.dndGesture.processTargetExit(dragEvent);
                if (Scene.this.dndGesture.source == null) {
                    Scene.this.dndGesture.dragboard = null;
                    Scene.this.dndGesture = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TransferMode drop(double x, double y, double screenX, double screenY, TransferMode transferMode) {
            TransferMode tm;
            if (Scene.this.dndGesture == null) {
                System.err.println("GOT A drop when dndGesture is null!");
                return null;
            }
            if (Scene.this.dndGesture.dragboard == null) {
                throw new RuntimeException("dndGesture.dragboard is null in dragDrop");
            }
            DragEvent dragEvent = new DragEvent(DragEvent.ANY, Scene.this.dndGesture.dragboard, x, y, screenX, screenY, transferMode, null, null, Scene.this.pick(x, y));
            DragboardHelper.setDataAccessRestriction(Scene.this.dndGesture.dragboard, false);
            try {
                tm = Scene.this.dndGesture.processTargetDrop(dragEvent);
            }
            finally {
                DragboardHelper.setDataAccessRestriction(Scene.this.dndGesture.dragboard, true);
            }
            if (Scene.this.dndGesture.source == null) {
                Scene.this.dndGesture.dragboard = null;
                Scene.this.dndGesture = null;
            }
            return tm;
        }
    }

    private class ScenePeerPaintListener
    implements TKScenePaintListener {
        private ScenePeerPaintListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void frameRendered() {
            Object object = trackerMonitor;
            synchronized (object) {
                if (Scene.this.tracker != null) {
                    Scene.this.tracker.frameRendered();
                }
            }
        }
    }

    class ScenePeerListener
    implements TKSceneListener {
        ScenePeerListener() {
        }

        @Override
        public void changedLocation(float x, float y) {
            if ((double)x != Scene.this.getX()) {
                Scene.this.setX(x);
            }
            if ((double)y != Scene.this.getY()) {
                Scene.this.setY(y);
            }
        }

        @Override
        public void changedSize(float w, float h) {
            if ((double)w != Scene.this.getWidth()) {
                Scene.this.setWidth(w);
            }
            if ((double)h != Scene.this.getHeight()) {
                Scene.this.setHeight(h);
            }
        }

        @Override
        public void mouseEvent(EventType<MouseEvent> type, double x, double y, double screenX, double screenY, MouseButton button, boolean popupTrigger, boolean synthesized, boolean shiftDown, boolean controlDown, boolean altDown, boolean metaDown, boolean primaryDown, boolean middleDown, boolean secondaryDown) {
            MouseEvent mouseEvent = new MouseEvent(type, x, y, screenX, screenY, button, 0, shiftDown, controlDown, altDown, metaDown, primaryDown, middleDown, secondaryDown, synthesized, popupTrigger, false, null);
            Scene.this.impl_processMouseEvent(mouseEvent);
        }

        @Override
        public void keyEvent(KeyEvent keyEvent) {
            Scene.this.impl_processKeyEvent(keyEvent);
        }

        @Override
        public void inputMethodEvent(EventType<InputMethodEvent> type, ObservableList<InputMethodTextRun> composed, String committed, int caretPosition) {
            InputMethodEvent inputMethodEvent = new InputMethodEvent(type, composed, committed, caretPosition);
            Scene.this.processInputMethodEvent(inputMethodEvent);
        }

        @Override
        public void menuEvent(double x, double y, double xAbs, double yAbs, boolean isKeyboardTrigger) {
            Scene.this.processMenuEvent(x, y, xAbs, yAbs, isKeyboardTrigger);
        }

        @Override
        public void scrollEvent(EventType<ScrollEvent> eventType, double scrollX, double scrollY, double totalScrollX, double totalScrollY, double xMultiplier, double yMultiplier, int touchCount, int scrollTextX, int scrollTextY, int defaultTextX, int defaultTextY, double x, double y, double screenX, double screenY, boolean _shiftDown, boolean _controlDown, boolean _altDown, boolean _metaDown, boolean _direct, boolean _inertia) {
            double xText;
            ScrollEvent.HorizontalTextScrollUnits xUnits = scrollTextX > 0 ? ScrollEvent.HorizontalTextScrollUnits.CHARACTERS : ScrollEvent.HorizontalTextScrollUnits.NONE;
            double d = xText = scrollTextX < 0 ? 0.0 : (double)scrollTextX * scrollX;
            ScrollEvent.VerticalTextScrollUnits yUnits = scrollTextY > 0 ? ScrollEvent.VerticalTextScrollUnits.LINES : (scrollTextY < 0 ? ScrollEvent.VerticalTextScrollUnits.PAGES : ScrollEvent.VerticalTextScrollUnits.NONE);
            double yText = scrollTextY < 0 ? scrollY : (double)scrollTextY * scrollY;
            xMultiplier = defaultTextX > 0 && scrollTextX >= 0 ? (double)Math.round(xMultiplier * (double)scrollTextX / (double)defaultTextX) : xMultiplier;
            double d2 = yMultiplier = defaultTextY > 0 && scrollTextY >= 0 ? (double)Math.round(yMultiplier * (double)scrollTextY / (double)defaultTextY) : yMultiplier;
            if (eventType == ScrollEvent.SCROLL_FINISHED) {
                x = ((Scene)Scene.this).scrollGesture.sceneCoords.getX();
                y = ((Scene)Scene.this).scrollGesture.sceneCoords.getY();
                screenX = ((Scene)Scene.this).scrollGesture.screenCoords.getX();
                screenY = ((Scene)Scene.this).scrollGesture.screenCoords.getY();
            } else if (Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(screenX) || Double.isNaN(screenY)) {
                if (Scene.this.cursorScenePos == null || Scene.this.cursorScreenPos == null) {
                    return;
                }
                x = Scene.this.cursorScenePos.getX();
                y = Scene.this.cursorScenePos.getY();
                screenX = Scene.this.cursorScreenPos.getX();
                screenY = Scene.this.cursorScreenPos.getY();
            }
            inMousePick = true;
            Scene.this.processGestureEvent(new ScrollEvent(eventType, x, y, screenX, screenY, _shiftDown, _controlDown, _altDown, _metaDown, _direct, _inertia, scrollX * xMultiplier, scrollY * yMultiplier, totalScrollX * xMultiplier, totalScrollY * yMultiplier, xMultiplier, yMultiplier, xUnits, xText, yUnits, yText, touchCount, Scene.this.pick(x, y)), Scene.this.scrollGesture);
            inMousePick = false;
        }

        @Override
        public void zoomEvent(EventType<ZoomEvent> eventType, double zoomFactor, double totalZoomFactor, double x, double y, double screenX, double screenY, boolean _shiftDown, boolean _controlDown, boolean _altDown, boolean _metaDown, boolean _direct, boolean _inertia) {
            if (eventType == ZoomEvent.ZOOM_FINISHED) {
                x = ((Scene)Scene.this).zoomGesture.sceneCoords.getX();
                y = ((Scene)Scene.this).zoomGesture.sceneCoords.getY();
                screenX = ((Scene)Scene.this).zoomGesture.screenCoords.getX();
                screenY = ((Scene)Scene.this).zoomGesture.screenCoords.getY();
            } else if (Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(screenX) || Double.isNaN(screenY)) {
                if (Scene.this.cursorScenePos == null || Scene.this.cursorScreenPos == null) {
                    return;
                }
                x = Scene.this.cursorScenePos.getX();
                y = Scene.this.cursorScenePos.getY();
                screenX = Scene.this.cursorScreenPos.getX();
                screenY = Scene.this.cursorScreenPos.getY();
            }
            inMousePick = true;
            Scene.this.processGestureEvent(new ZoomEvent(eventType, x, y, screenX, screenY, _shiftDown, _controlDown, _altDown, _metaDown, _direct, _inertia, zoomFactor, totalZoomFactor, Scene.this.pick(x, y)), Scene.this.zoomGesture);
            inMousePick = false;
        }

        @Override
        public void rotateEvent(EventType<RotateEvent> eventType, double angle, double totalAngle, double x, double y, double screenX, double screenY, boolean _shiftDown, boolean _controlDown, boolean _altDown, boolean _metaDown, boolean _direct, boolean _inertia) {
            if (eventType == RotateEvent.ROTATION_FINISHED) {
                x = ((Scene)Scene.this).rotateGesture.sceneCoords.getX();
                y = ((Scene)Scene.this).rotateGesture.sceneCoords.getY();
                screenX = ((Scene)Scene.this).rotateGesture.screenCoords.getX();
                screenY = ((Scene)Scene.this).rotateGesture.screenCoords.getY();
            } else if (Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(screenX) || Double.isNaN(screenY)) {
                if (Scene.this.cursorScenePos == null || Scene.this.cursorScreenPos == null) {
                    return;
                }
                x = Scene.this.cursorScenePos.getX();
                y = Scene.this.cursorScenePos.getY();
                screenX = Scene.this.cursorScreenPos.getX();
                screenY = Scene.this.cursorScreenPos.getY();
            }
            inMousePick = true;
            Scene.this.processGestureEvent(new RotateEvent(eventType, x, y, screenX, screenY, _shiftDown, _controlDown, _altDown, _metaDown, _direct, _inertia, angle, totalAngle, Scene.this.pick(x, y)), Scene.this.rotateGesture);
            inMousePick = false;
        }

        @Override
        public void swipeEvent(EventType<SwipeEvent> eventType, int touchCount, double x, double y, double screenX, double screenY, boolean _shiftDown, boolean _controlDown, boolean _altDown, boolean _metaDown, boolean _direct) {
            if (Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(screenX) || Double.isNaN(screenY)) {
                if (Scene.this.cursorScenePos == null || Scene.this.cursorScreenPos == null) {
                    return;
                }
                x = Scene.this.cursorScenePos.getX();
                y = Scene.this.cursorScenePos.getY();
                screenX = Scene.this.cursorScreenPos.getX();
                screenY = Scene.this.cursorScreenPos.getY();
            }
            inMousePick = true;
            Scene.this.processGestureEvent(new SwipeEvent(eventType, x, y, screenX, screenY, _shiftDown, _controlDown, _altDown, _metaDown, _direct, touchCount, Scene.this.pick(x, y)), Scene.this.swipeGesture);
            inMousePick = false;
        }

        @Override
        public void touchEventBegin(long time, int touchCount, boolean isDirect, boolean _shiftDown, boolean _controlDown, boolean _altDown, boolean _metaDown) {
            if (!isDirect) {
                Scene.this.nextTouchEvent = null;
                return;
            }
            Scene.this.nextTouchEvent = new TouchEvent(TouchEvent.ANY, null, null, 0, _shiftDown, _controlDown, _altDown, _metaDown);
            if (Scene.this.touchPoints == null || Scene.this.touchPoints.length != touchCount) {
                Scene.access$5402(Scene.this, new TouchPoint[touchCount]);
            }
            Scene.this.touchPointIndex = 0;
        }

        @Override
        public void touchEventNext(TouchPoint.State state, long touchId, double x, double y, double screenX, double screenY) {
            TouchPoint tp;
            int order;
            int id;
            inMousePick = true;
            if (Scene.this.nextTouchEvent == null) {
                return;
            }
            Scene.this.touchPointIndex++;
            int n = id = state == TouchPoint.State.PRESSED ? Scene.this.touchMap.add(touchId) : Scene.this.touchMap.get(touchId);
            if (state == TouchPoint.State.RELEASED) {
                Scene.this.touchMap.remove(touchId);
            }
            if ((order = Scene.this.touchMap.getOrder(id)) >= Scene.this.touchPoints.length) {
                throw new RuntimeException("Too many touch points reported");
            }
            boolean isGrabbed = false;
            PickResult pickRes = Scene.this.pick(x, y);
            EventTarget pickedTarget = (EventTarget)Scene.this.touchTargets.get(id);
            if (pickedTarget == null) {
                pickedTarget = pickRes.getIntersectedNode();
                if (pickedTarget == null) {
                    pickedTarget = Scene.this;
                }
            } else {
                isGrabbed = true;
            }
            ((Scene)Scene.this).touchPoints[order] = tp = new TouchPoint(id, state, x, y, screenX, screenY, pickedTarget, pickRes);
            if (isGrabbed) {
                tp.grab(pickedTarget);
            }
            if (tp.getState() == TouchPoint.State.PRESSED) {
                tp.grab(pickedTarget);
                Scene.this.touchTargets.put(tp.getId(), pickedTarget);
            } else if (tp.getState() == TouchPoint.State.RELEASED) {
                Scene.this.touchTargets.remove(tp.getId());
            }
            inMousePick = false;
        }

        @Override
        public void touchEventEnd() {
            if (Scene.this.nextTouchEvent == null) {
                return;
            }
            if (Scene.this.touchPointIndex != Scene.this.touchPoints.length) {
                throw new RuntimeException("Wrong number of touch points reported");
            }
            Scene.this.processTouchEvent(Scene.this.nextTouchEvent, Scene.this.touchPoints);
            if (Scene.this.touchMap.cleanup()) {
                Scene.this.touchEventSetId = 0;
            }
        }

        @Override
        public Accessible getSceneAccessible() {
            return Scene.this.getAccessible();
        }
    }

    class ScenePulseListener
    implements TKPulseListener {
        private boolean firstPulse = true;

        ScenePulseListener() {
        }

        private void synchronizeSceneNodes() {
            Toolkit.getToolkit().checkFxUserThread();
            inSynchronizer = true;
            if (Scene.this.dirtyNodes == null) {
                this.syncAll(Scene.this.getRoot());
                Scene.access$2602(Scene.this, new Node[30]);
            } else {
                for (int i = 0; i < Scene.this.dirtyNodesSize; ++i) {
                    Node node = Scene.this.dirtyNodes[i];
                    ((Scene)Scene.this).dirtyNodes[i] = null;
                    if (node.getScene() != Scene.this) continue;
                    node.impl_syncPeer();
                }
                Scene.this.dirtyNodesSize = 0;
            }
            inSynchronizer = false;
        }

        private int syncAll(Node node) {
            node.impl_syncPeer();
            int size = 1;
            if (node instanceof Parent) {
                Parent p = (Parent)node;
                int childrenCount = p.getChildren().size();
                for (int i = 0; i < childrenCount; ++i) {
                    Node n = (Node)p.getChildren().get(i);
                    if (n == null) continue;
                    size += this.syncAll(n);
                }
            } else if (node instanceof SubScene) {
                SubScene subScene = (SubScene)node;
                size += this.syncAll(subScene.getRoot());
            }
            if (node.getClip() != null) {
                size += this.syncAll(node.getClip());
            }
            return size;
        }

        private void synchronizeSceneProperties() {
            inSynchronizer = true;
            if (Scene.this.isDirty(DirtyBits.ROOT_DIRTY)) {
                Scene.this.impl_peer.setRoot((NGNode)Scene.this.getRoot().impl_getPeer());
            }
            if (Scene.this.isDirty(DirtyBits.FILL_DIRTY)) {
                Toolkit tk = Toolkit.getToolkit();
                Scene.this.impl_peer.setFillPaint(Scene.this.getFill() == null ? null : tk.getPaint(Scene.this.getFill()));
            }
            Camera cam = Scene.this.getEffectiveCamera();
            if (Scene.this.isDirty(DirtyBits.CAMERA_DIRTY)) {
                cam.impl_updatePeer();
                Scene.this.impl_peer.setCamera((NGCamera)cam.impl_getPeer());
            }
            if (Scene.this.isDirty(DirtyBits.CURSOR_DIRTY)) {
                Scene.this.mouseHandler.updateCursor(Scene.this.getCursor());
            }
            Scene.this.clearDirty();
            inSynchronizer = false;
        }

        private void focusCleanup() {
            if (Scene.this.isFocusDirty()) {
                Node oldOwner = Scene.this.getFocusOwner();
                if (oldOwner == null) {
                    Scene.this.focusInitial();
                } else if (oldOwner.getScene() != Scene.this) {
                    Scene.this.requestFocus(null);
                    Scene.this.focusInitial();
                } else if (!oldOwner.isCanReceiveFocus()) {
                    Scene.this.requestFocus(null);
                    Scene.this.focusIneligible(oldOwner);
                }
                Scene.this.setFocusDirty(false);
            }
        }

        @Override
        public void pulse() {
            boolean dirty;
            if (Scene.this.tracker != null) {
                Scene.this.tracker.pulse();
            }
            if (this.firstPulse) {
                PerformanceTracker.logEvent("Scene - first repaint");
            }
            this.focusCleanup();
            Scene.this.disposeAccessibles();
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newPhase("CSS Pass");
            }
            Scene.this.doCSSPass();
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.newPhase("Layout Pass");
            }
            Scene.this.doLayoutPass();
            boolean bl = dirty = Scene.this.dirtyNodes == null || Scene.this.dirtyNodesSize != 0 || !Scene.this.isDirtyEmpty();
            if (dirty) {
                if (PulseLogger.PULSE_LOGGING_ENABLED) {
                    PulseLogger.newPhase("Update bounds");
                }
                Scene.this.getRoot().updateBounds();
                if (Scene.this.impl_peer != null) {
                    try {
                        if (PulseLogger.PULSE_LOGGING_ENABLED) {
                            PulseLogger.newPhase("Waiting for previous rendering");
                        }
                        Scene.this.impl_peer.waitForRenderingToComplete();
                        Scene.this.impl_peer.waitForSynchronization();
                        if (PulseLogger.PULSE_LOGGING_ENABLED) {
                            PulseLogger.newPhase("Copy state to render graph");
                        }
                        Scene.this.syncLights();
                        this.synchronizeSceneProperties();
                        this.synchronizeSceneNodes();
                        Scene.this.mouseHandler.pulse();
                        Scene.this.impl_peer.markDirty();
                    }
                    finally {
                        Scene.this.impl_peer.releaseSynchronization(true);
                    }
                } else {
                    if (PulseLogger.PULSE_LOGGING_ENABLED) {
                        PulseLogger.newPhase("Synchronize with null peer");
                    }
                    this.synchronizeSceneNodes();
                    Scene.this.mouseHandler.pulse();
                }
                if (Scene.this.getRoot().cssFlag != CssFlags.CLEAN) {
                    Scene.this.getRoot().impl_markDirty(com.sun.javafx.scene.DirtyBits.NODE_CSS);
                }
            }
            Scene.this.mouseHandler.updateCursorFrame();
            if (this.firstPulse) {
                if (PerformanceTracker.isLoggingEnabled()) {
                    PerformanceTracker.logEvent("Scene - first repaint - layout complete");
                    if (PrismSettings.perfLogFirstPaintFlush) {
                        PerformanceTracker.outputLog();
                    }
                    if (PrismSettings.perfLogFirstPaintExit) {
                        System.exit(0);
                    }
                }
                this.firstPulse = false;
            }
            if (Scene.this.testPulseListener != null) {
                Scene.this.testPulseListener.run();
            }
        }
    }

    private static enum DirtyBits {
        FILL_DIRTY,
        ROOT_DIRTY,
        CAMERA_DIRTY,
        LIGHTS_DIRTY,
        CURSOR_DIRTY;

        private int mask = 1 << this.ordinal();

        public final int getMask() {
            return this.mask;
        }
    }

    private static class TouchGesture {
        EventTarget target;
        Point2D sceneCoords;
        Point2D screenCoords;
        boolean finished;

        private TouchGesture() {
        }
    }
}

