/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.dl.query;

import java.util.List;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.objects.ObjectToString;

public class ListDataResult<T>
implements PageDataResult<T> {
    private static final long serialVersionUID = -5637829557977149410L;
    private List<T> data;
    private Long totalCount;
    private Integer displayItemsPerPage;
    private boolean hasMore = false;

    public ListDataResult() {
    }

    public ListDataResult(List<T> data) {
        this.data = data;
    }

    public ListDataResult(Long totalCount) {
        this.totalCount = totalCount;
    }

    public ListDataResult(List<T> data, Long totalCount) {
        this.data = data;
        this.totalCount = totalCount;
    }

    @Override
    public List<T> getData() {
        return this.data;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    @Override
    public T getSingleItem() {
        if (!this.data.isEmpty()) {
            return this.data.get(0);
        }
        return null;
    }

    @Override
    public Long getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    public Integer getDisplayItemsPerPage() {
        return this.displayItemsPerPage;
    }

    public void setDisplayItemsPerPage(Integer displayItemsPerPage) {
        this.displayItemsPerPage = displayItemsPerPage;
    }

    @Override
    public int getPageCount() {
        return this.getPageCount(true);
    }

    @Override
    public boolean isHasMore() {
        return this.hasMore;
    }

    public void setHasMore(boolean hasMore) {
        this.hasMore = hasMore;
    }

    @Override
    public int getPageCount(boolean minToOne) {
        if (this.totalCount == null) {
            throw new IllegalArgumentException("Property 'totalCount' is not set");
        }
        if (this.displayItemsPerPage == null) {
            throw new IllegalArgumentException("Property 'displayItemsPerPage' is not set");
        }
        int num = (int)Math.ceil(this.totalCount.doubleValue() / this.displayItemsPerPage.doubleValue());
        if (num == 0 && minToOne) {
            return 1;
        }
        return num;
    }

    public String toString() {
        return new ObjectToString(ListDataResult.class).addProperty("totalCount", (Object)this.totalCount).addProperty("displayItemsPerPage", (Object)this.displayItemsPerPage).addProperty("hasMore", this.hasMore).addProperty("data", this.data).generateString();
    }
}

