/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui;

import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import si.nevensrok.jtekma.tabla.common.MatchData;

public class HelpDialog
extends JDialog
implements ApplicationContextAware,
DisposableBean {
    private ApplicationContext applicationContext;
    private MatchData matchData;
    private JFrame tablaWindow;
    private JLabel[] labels = new JLabel[26];

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public void setTablaWindow(JFrame tablaWindow) {
        this.tablaWindow = tablaWindow;
    }

    public String getLanguageText(String key) {
        return this.applicationContext.getMessage(key, null, key, this.matchData.getLocale());
    }

    public void destroy() throws Exception {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                HelpDialog.this.setVisible(false);
                HelpDialog.this.dispose();
            }
        });
    }

    public HelpDialog() {
        this.setAlwaysOnTop(true);
        this.setSize(300, 550);
        this.setResizable(false);
        this.setLayout(new GridLayout(this.labels.length, 1));
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i] = new JLabel();
            this.add(this.labels[i]);
        }
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    HelpDialog.this.setVisible(false);
                }
            }
        });
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocationRelativeTo(this.tablaWindow);
            this.setTitle(this.getLanguageText("title.help"));
            for (int i = 0; i < this.labels.length; ++i) {
                this.labels[i].setText(this.getLanguageText("help." + i));
            }
        }
        super.setVisible(b);
    }
}

