(function() {
    let view = definePackage("jtekma.view");
    let judge = definePackage("jtekma.judge");

    judge.StateSwitch = class PointInput extends view.main {

        constructor(competitor, series, attack, initialState) {
            super("div");
            this.competitor = competitor;
            this.series = series;
            this.attack = attack;

            this.setClass("btn-group");
            this.setAttribute("data-toggle", "buttons");

            let onRadio = new view.input("radio");
            onRadio.setName("on");
            let onIcon = new view.i();
            onIcon.setClass("glyphicon glyphicon-ok");
            this.onButton = new view.label();
            this.onButton.setClass("tablet-button btn btn-default");
            this.onButton.addContent(onRadio);
            this.onButton.addContent(onIcon);
            this.onButton.onClick(() => {
                this.setState(true);
            });
            this.addContent(this.onButton);

            let offRadio = new view.input("radio");
            offRadio.setName("off");
            let offIcon = new view.i();
            offIcon.setClass("glyphicon glyphicon-remove");
            this.offButton = new view.label();
            this.offButton.setClass("tablet-button btn btn-default");
            this.offButton.addContent(offRadio);
            this.offButton.addContent(offIcon);
            this.offButton.onClick(() => {
                this.setState(false);
            });
            this.addContent(this.offButton);

            this.setState(initialState);
        }

        setState(state) {
            if (state) {
                this.state = true;
                this.onButton.addClass("active");
                this.offButton.removeClass("active");
            }
            else {
                this.state = false;
                this.offButton.addClass("active");
                this.onButton.removeClass("active");
            }
            this.saveState();
        }

        saveState() {
            if (this.competitor == 1) {
                if (!isArray(judge.data.invalidAttacks1)) {
                    judge.data.invalidAttacks1 = [];
                }
                if (!isArray(judge.data.invalidAttacks1[this.series])) {
                    judge.data.invalidAttacks1[this.series] = [];
                }
                if (this.state) {
                    judge.data.invalidAttacks1[this.series][this.attack] = true;
                }
                else {
                    judge.data.invalidAttacks1[this.series][this.attack] = false;
                }
            }
            else if (this.competitor == 2) {
                if (!isArray(judge.data.invalidAttacks2)) {
                    judge.data.invalidAttacks2 = [];
                }
                if (!isArray(judge.data.invalidAttacks2[this.series])) {
                    judge.data.invalidAttacks2[this.series] = [];
                }
                if (this.state) {
                    judge.data.invalidAttacks2[this.series][this.attack] = true;
                }
                else {
                    judge.data.invalidAttacks2[this.series][this.attack] = false;
                }
            }
        }

    };

})();
