(function() {
    let view = definePackage("jtekma.view");
    let judge = definePackage("jtekma.judge");

    judge.PointInput = class PointInput extends view.main {

        constructor(competitor, series, attack, part, minPoints, maxPoints) {
            super("div");
            this.competitor = competitor;
            this.series = series;
            this.attack = attack;
            this.part = part;

            if (isNotNull(minPoints)) {
                this.minPoints = minPoints;
            }
            else {
                this.minPoints = 0;
            }
            if (isNotNull(maxPoints)) {
                this.maxPoints = maxPoints;
            }
            else {
                this.maxPoints = 10;
            }

            this.point = this.minPoints;

            let buttonRemove = new view.button("-");
            buttonRemove.setClass("judge-point-button tablet-button btn btn-default");
            buttonRemove.onClick(() => {
                this.addPoints(-1);
            });
            this.addContent(buttonRemove);

            this.pointInput = new view.input("text", String(this.point));
            this.pointInput.setClass("judge-point");
            this.pointInput.addStyle("margin-top: 3px");
            this.pointInput.addEventListener("change", () => {
                let p = Number(this.pointInput.getValue());
                if (!isValidNumber(p)) {
                    this.point = 0;
                    this.pointInput.setValue(String(this.point));
                }
                else {
                    if (p != Math.round(p)) {
                        p = Math.round(p);
                        this.pointInput.setValue(String(p));
                    }
                    if (p < this.minPoints) {
                        p = this.minPoints;
                        this.pointInput.setValue(String(p));
                    }
                    if (p > this.maxPoints) {
                        p = this.maxPoints;
                        this.pointInput.setValue(String(p));
                    }
                    this.point = p;
                    this.savePoints();
                }
            });
            this.addContent(this.pointInput);

            let buttonAdd = new view.button("+");
            buttonAdd.setClass("judge-point-button tablet-button btn btn-default");
            buttonAdd.onClick(() => {
                this.addPoints(1);
            });
            this.addContent(buttonAdd);
        }

        setPoint(point) {
            if (isNull(point)) {
                point = 0;
            }
            this.point = point;
            if (this.point < this.minPoints) {
                this.point = this.minPoints;
            }
            if (this.point > this.maxPoints) {
                this.point = this.maxPoints;
            }
            this.pointInput.setValue(String(this.point));
            this.savePoints();
        }

        addPoints(points) {
            this.setPoint(this.point + points);
        }

        savePoints() {
            if (isNull(this.competitor) || isNull(this.series) || isNull(this.attack) || isNull(this.part)) {
                return;
            }
            if (this.competitor == 1) {
                if (!isArray(judge.data.points1)) {
                    judge.data.points1 = [];
                }
                if (!isArray(judge.data.points1[this.series])) {
                    judge.data.points1[this.series] = [];
                }
                if (!isArray(judge.data.points1[this.series][this.attack])) {
                    judge.data.points1[this.series][this.attack] = [];
                }
                judge.data.points1[this.series][this.attack][this.part] = this.point;
            }
            else if (this.competitor == 2) {
                if (!isArray(judge.data.points2)) {
                    judge.data.points2 = [];
                }
                if (!isArray(judge.data.points2[this.series])) {
                    judge.data.points2[this.series] = [];
                }
                if (!isArray(judge.data.points2[this.series][this.attack])) {
                    judge.data.points2[this.series][this.attack] = [];
                }
                judge.data.points2[this.series][this.attack][this.part] = this.point;
            }
        }
    };

})();
