/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.documents.odf;

import java.awt.Color;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import javax.imageio.ImageIO;
import org.odftoolkit.simple.TextDocument;
import org.odftoolkit.simple.draw.FrameContainer;
import org.odftoolkit.simple.draw.FrameStyleHandler;
import org.odftoolkit.simple.style.Border;
import org.odftoolkit.simple.style.Font;
import org.odftoolkit.simple.style.MasterPage;
import org.odftoolkit.simple.style.StyleTypeDefinitions;
import org.odftoolkit.simple.table.Cell;
import org.odftoolkit.simple.table.Row;
import org.odftoolkit.simple.text.Paragraph;
import org.odftoolkit.simple.text.list.BulletDecorator;
import org.odftoolkit.simple.text.list.List;
import org.odftoolkit.simple.text.list.ListDecorator;
import org.odftoolkit.simple.text.list.NumberDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.documents.DocumentException;
import si.nevensrok.common.documents.common.Alignment;
import si.nevensrok.common.documents.common.Border;
import si.nevensrok.common.documents.common.Content;
import si.nevensrok.common.documents.common.Document;
import si.nevensrok.common.documents.common.Heading;
import si.nevensrok.common.documents.common.Image;
import si.nevensrok.common.documents.common.LineList;
import si.nevensrok.common.documents.common.PageBreak;
import si.nevensrok.common.documents.common.PageDirection;
import si.nevensrok.common.documents.common.Table;
import si.nevensrok.common.documents.common.TableCell;
import si.nevensrok.common.documents.common.TableRow;
import si.nevensrok.common.documents.common.TextContent;
import si.nevensrok.common.documents.common.VerticalAlignment;

public class OdfDocumentBuilder {
    private static final Logger log = LoggerFactory.getLogger(OdfDocumentBuilder.class);
    private static final String NORMAL_PAGE_STYLE = "Default Style";
    private static final String LANDSPACE_PAGE_STYLE = "Landscape";
    private Document document;
    private OutputStream outputStream;
    private TextDocument textDocument = null;
    private float currentPageWidth = 175.9f;

    public OdfDocumentBuilder(Document document, OutputStream outputStream) {
        this.document = document;
        this.outputStream = outputStream;
    }

    public void build() throws DocumentException {
        log.trace("Building odf document");
        try {
            this.textDocument = TextDocument.newTextDocument();
            for (Content content : this.document.getContentList()) {
                if (content instanceof PageBreak) {
                    this.addPageBreak((PageBreak)content);
                    continue;
                }
                if (content instanceof Heading) {
                    this.addHeading((Heading)content);
                    continue;
                }
                if (content instanceof si.nevensrok.common.documents.common.Paragraph) {
                    this.addParagraph((si.nevensrok.common.documents.common.Paragraph)content);
                    continue;
                }
                if (content instanceof LineList) {
                    this.addLineList((LineList)content);
                    continue;
                }
                if (content instanceof Table) {
                    this.addTable((Table)content);
                    continue;
                }
                if (content instanceof Image) {
                    this.addImage((Image)content);
                    continue;
                }
                log.error("Unsupported content type {}", (Object)content.getClass().getName());
            }
            this.textDocument.save(this.outputStream);
        }
        catch (DocumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DocumentException("Error creating odf document", e);
        }
        finally {
            try {
                this.textDocument.close();
            }
            catch (Exception exception) {}
        }
    }

    private void addPageBreak(PageBreak pageBreak) throws Exception {
        if (pageBreak.getPageDirection() == null) {
            this.textDocument.addPageBreak();
        } else if (pageBreak.getPageDirection() == PageDirection.PORTRAIT) {
            MasterPage masterPage = MasterPage.getOrCreateMasterPage((org.odftoolkit.simple.Document)this.textDocument, (String)NORMAL_PAGE_STYLE);
            masterPage.setPrintOrientation(StyleTypeDefinitions.PrintOrientation.PORTRAIT);
            this.textDocument.addPageBreak(this.textDocument.addParagraph(""), masterPage);
            this.currentPageWidth = 175.9f;
        } else {
            MasterPage masterPage = MasterPage.getOrCreateMasterPage((org.odftoolkit.simple.Document)this.textDocument, (String)LANDSPACE_PAGE_STYLE);
            masterPage.setPageWidth(279.4);
            masterPage.setPageHeight(215.9);
            masterPage.setPrintOrientation(StyleTypeDefinitions.PrintOrientation.LANDSCAPE);
            masterPage.setMargins(20.0, 20.0, 20.0, 20.0);
            this.textDocument.addPageBreak(this.textDocument.addParagraph(""), masterPage);
            this.currentPageWidth = 239.4f;
        }
    }

    private void addHeading(Heading heading) {
        Paragraph odfParagraph = this.textDocument.addParagraph(heading.getText());
        if (heading.getHeadingType() == Heading.HeadingType.H1) {
            odfParagraph.applyHeading(true, 1);
        } else if (heading.getHeadingType() == Heading.HeadingType.H2) {
            odfParagraph.applyHeading(true, 2);
        } else if (heading.getHeadingType() == Heading.HeadingType.H3) {
            odfParagraph.applyHeading(true, 3);
        } else if (heading.getHeadingType() == Heading.HeadingType.H4) {
            odfParagraph.applyHeading(true, 4);
        }
        odfParagraph.setFont(this.getFont(heading));
        if (heading.getAlignment() == Alignment.CENTER) {
            odfParagraph.setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType.CENTER);
        } else if (heading.getAlignment() == Alignment.RIGHT) {
            odfParagraph.setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType.RIGHT);
        } else if (heading.getAlignment() == Alignment.JUSTIFY) {
            odfParagraph.setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType.JUSTIFY);
        } else {
            odfParagraph.setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType.LEFT);
        }
    }

    private void addParagraph(si.nevensrok.common.documents.common.Paragraph paragraph) {
        Paragraph odfParagraph = this.textDocument.addParagraph(paragraph.getText());
        odfParagraph.setFont(this.getFont(paragraph));
        if (paragraph.getAlignment() == Alignment.CENTER) {
            odfParagraph.setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType.CENTER);
        } else if (paragraph.getAlignment() == Alignment.RIGHT) {
            odfParagraph.setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType.RIGHT);
        } else if (paragraph.getAlignment() == Alignment.JUSTIFY) {
            odfParagraph.setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType.JUSTIFY);
        } else {
            odfParagraph.setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType.LEFT);
        }
    }

    private Font getFont(TextContent textContent) {
        String fontFamilyName = "SansSerif";
        StyleTypeDefinitions.FontStyle fontStyle = StyleTypeDefinitions.FontStyle.REGULAR;
        float fontSize = textContent.getFontSize().floatValue();
        if (textContent.getBold().booleanValue() && textContent.getItalic().booleanValue()) {
            fontStyle = StyleTypeDefinitions.FontStyle.BOLDITALIC;
        } else if (textContent.getBold().booleanValue()) {
            fontStyle = StyleTypeDefinitions.FontStyle.BOLD;
        } else if (textContent.getItalic().booleanValue()) {
            fontStyle = StyleTypeDefinitions.FontStyle.ITALIC;
        }
        switch (textContent.getFontType()) {
            case DejaVuSans: {
                fontFamilyName = "SansSerif";
            }
        }
        return new Font(fontFamilyName, fontStyle, (double)fontSize, this.getColor(textContent.getColor()));
    }

    private void addLineList(LineList lineList) {
        log.trace("Adding line list content");
        Object listDecorator = null;
        listDecorator = lineList.getIconType() == LineList.IconType.CIRCLE ? new BulletDecorator((org.odftoolkit.simple.Document)this.textDocument) : new NumberDecorator((org.odftoolkit.simple.Document)this.textDocument);
        List odfList = this.textDocument.addList((ListDecorator)listDecorator);
        for (String line : lineList.getLines()) {
            odfList.addItem(line);
        }
    }

    private void addTable(Table table) {
        log.trace("Adding table content");
        int numRows = 0;
        int numCols = 0;
        for (TableRow tableRow : table.getTableRows()) {
            ++numRows;
            numCols = Math.max(numCols, tableRow.getTableCells().size());
        }
        if (numRows == 0 || numCols == 0) {
            return;
        }
        org.odftoolkit.simple.table.Table odfTable = this.textDocument.addTable(numRows, numCols);
        odfTable.setCellStyleInheritance(false);
        odfTable.setWidth((double)(this.currentPageWidth / 100.0f * table.getWidthPrecentage()));
        int rowIndex = 0;
        for (TableRow tableRow : table.getTableRows()) {
            Row row = odfTable.getRowByIndex(rowIndex);
            int colIndex = 0;
            for (TableCell tableCell : tableRow.getTableCells()) {
                Cell cell = row.getCellByIndex(colIndex);
                if (tableCell.getVerticalAlignment() == VerticalAlignment.BOTTOM) {
                    cell.setVerticalAlignment(StyleTypeDefinitions.VerticalAlignmentType.BOTTOM);
                } else if (tableCell.getVerticalAlignment() == VerticalAlignment.MIDDLE) {
                    cell.setVerticalAlignment(StyleTypeDefinitions.VerticalAlignmentType.MIDDLE);
                } else if (tableCell.getVerticalAlignment() == VerticalAlignment.TOP) {
                    cell.setVerticalAlignment(StyleTypeDefinitions.VerticalAlignmentType.TOP);
                }
                if (tableCell.getBackgroundColor() != null) {
                    cell.setCellBackgroundColor(this.getColor(tableCell.getBackgroundColor()));
                }
                cell.setBorders(StyleTypeDefinitions.CellBordersType.LEFT, this.getBorder(tableCell.getCellBorder().getLeft()));
                cell.setBorders(StyleTypeDefinitions.CellBordersType.TOP, this.getBorder(tableCell.getCellBorder().getTop()));
                cell.setBorders(StyleTypeDefinitions.CellBordersType.RIGHT, this.getBorder(tableCell.getCellBorder().getRight()));
                cell.setBorders(StyleTypeDefinitions.CellBordersType.BOTTOM, this.getBorder(tableCell.getCellBorder().getBottom()));
                for (si.nevensrok.common.documents.common.Paragraph paragraph : tableCell.getContentList()) {
                    Paragraph odfParagraph = cell.addParagraph(paragraph.getText());
                    odfParagraph.setFont(this.getFont(paragraph));
                    if (paragraph.getAlignment() == Alignment.CENTER) {
                        odfParagraph.setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType.CENTER);
                        continue;
                    }
                    if (paragraph.getAlignment() == Alignment.RIGHT) {
                        odfParagraph.setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType.RIGHT);
                        continue;
                    }
                    if (paragraph.getAlignment() == Alignment.JUSTIFY) {
                        odfParagraph.setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType.JUSTIFY);
                        continue;
                    }
                    odfParagraph.setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType.LEFT);
                }
                ++colIndex;
            }
            ++rowIndex;
        }
    }

    private Border getBorder(si.nevensrok.common.documents.common.Border border) {
        if (border.getBorderType() == Border.BorderType.NONE) {
            Border odfBorder = Border.NONE;
            return odfBorder;
        }
        Border odfBorder = new Border(this.getColor(border.getBorderColor()), (double)border.getBorderSize(), StyleTypeDefinitions.SupportedLinearMeasure.PT);
        odfBorder.setLineStyle(StyleTypeDefinitions.LineType.SINGLE);
        return odfBorder;
    }

    private org.odftoolkit.odfdom.type.Color getColor(Color color) {
        return new org.odftoolkit.odfdom.type.Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addImage(Image image) {
        log.trace("Adding image content");
        if (image.getImageData() != null) {
            Paragraph odfParagraph = this.textDocument.addParagraph("");
            File imageFile = null;
            try {
                imageFile = File.createTempFile("odfimg", ".png");
                log.trace("Temporary image file: [{}]", (Object)imageFile.getAbsolutePath());
                ImageIO.write((RenderedImage)image.getImageData(), "PNG", imageFile);
                org.odftoolkit.simple.draw.Image img = org.odftoolkit.simple.draw.Image.newImage((FrameContainer)odfParagraph, (URI)new URI("file:" + imageFile.getAbsolutePath()));
                img.setVerticalPosition(StyleTypeDefinitions.FrameVerticalPosition.TOP);
                if (image.getAlignment() == Alignment.CENTER) {
                    odfParagraph.setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType.CENTER);
                    img.setHorizontalPosition(StyleTypeDefinitions.FrameHorizontalPosition.CENTER);
                } else if (image.getAlignment() == Alignment.RIGHT) {
                    odfParagraph.setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType.RIGHT);
                    img.setHorizontalPosition(StyleTypeDefinitions.FrameHorizontalPosition.RIGHT);
                } else if (image.getAlignment() == Alignment.JUSTIFY) {
                    odfParagraph.setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType.JUSTIFY);
                    img.setHorizontalPosition(StyleTypeDefinitions.FrameHorizontalPosition.LEFT);
                } else {
                    odfParagraph.setHorizontalAlignment(StyleTypeDefinitions.HorizontalAlignmentType.LEFT);
                    img.setHorizontalPosition(StyleTypeDefinitions.FrameHorizontalPosition.LEFT);
                }
                FrameStyleHandler frameStyleHandler = img.getStyleHandler();
                frameStyleHandler.setAchorType(StyleTypeDefinitions.AnchorType.AS_CHARACTER);
                frameStyleHandler.setHorizontalRelative(StyleTypeDefinitions.HorizontalRelative.PARAGRAPH);
                frameStyleHandler.setVerticalRelative(StyleTypeDefinitions.VerticalRelative.PARAGRAPH);
            }
            catch (Exception e) {
                log.error("Error adding image", (Throwable)e);
            }
            finally {
                try {
                    imageFile.delete();
                }
                catch (Exception exception) {}
            }
        }
    }
}

