/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.dao;

import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.query.Query;
import si.nevensrok.common.dl.CoreDao;
import si.nevensrok.common.dl.ParamsBinder;
import si.nevensrok.common.dl.adapters.database.DatabaseAdapterPool;
import si.nevensrok.common.utils.CollectionUtil;
import si.nevensrok.jtekma.common.judges.Judge;
import si.nevensrok.jtekma.common.matches.DuoPresentation;
import si.nevensrok.jtekma.common.matches.DuoPresentationGrading;
import si.nevensrok.jtekma.server.dl.dto.judges.JudgeDTO;
import si.nevensrok.jtekma.server.dl.dto.matches.DuoPresentationDTO;
import si.nevensrok.jtekma.server.dl.dto.matches.DuoPresentationGradingDTO;

public class DuoPresentationGradingDAO
extends CoreDao {
    protected DatabaseAdapterPool adapterPool;

    public void setDatabaseAdapterPool(DatabaseAdapterPool adapterPool) {
        this.adapterPool = adapterPool;
    }

    public DatabaseAdapterPool getAdapterPool() {
        return this.adapterPool;
    }

    public DuoPresentationGrading getDuoPresentationGrading(DuoPresentation duoPresentation, Judge judge) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select dpg from DuoPresentationGradingDTO as dpg where dpg.duoPresentationGradingKey.duoPresentation.duoPresentationId = ");
        sql.append(paramsBinder.addParam(duoPresentation.getDuoPresentationId()));
        sql.append(" and dpg.judge.judgeId = ");
        sql.append(paramsBinder.addParam(judge.getJudgeId()));
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        DuoPresentationGradingDTO duoPresentationGradingDTO = (DuoPresentationGradingDTO)DuoPresentationGradingDAO.getSingleResult((Query)query);
        DuoPresentationGrading duoPresentationGrading = null;
        if (duoPresentationGradingDTO != null) {
            duoPresentationGrading = new DuoPresentationGrading();
            duoPresentationGrading.setDuoPresentation((DuoPresentation)this.adapterPool.create(DuoPresentation.class, (Object)duoPresentationGradingDTO.getDuoPresentationGradingKey().getDuoPresentation()));
            duoPresentationGrading.setJudgeNum(duoPresentationGradingDTO.getDuoPresentationGradingKey().getJudgeNum());
            duoPresentationGrading.setJudge((Judge)this.adapterPool.create(Judge.class, (Object)duoPresentationGradingDTO.getJudge()));
            duoPresentationGrading.setSentAt(duoPresentationGradingDTO.getSentAt());
            duoPresentationGrading.setFinalResult(duoPresentationGradingDTO.getFinalResult());
        }
        this.flush();
        return duoPresentationGrading;
    }

    public List<DuoPresentationGrading> getDuoPresentationGradings(DuoPresentation duoPresentation) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select dpg from DuoPresentationGradingDTO as dpg where dpg.duoPresentationGradingKey.duoPresentation.duoPresentationId = ");
        sql.append(paramsBinder.addParam(duoPresentation.getDuoPresentationId()));
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        LinkedList<DuoPresentationGrading> duoPresentationGradings = new LinkedList<DuoPresentationGrading>();
        List list = query.getResultList();
        for (DuoPresentationGradingDTO duoPresentationGradingDTO : list) {
            DuoPresentationGrading duoPresentationGrading = new DuoPresentationGrading();
            duoPresentationGrading.setDuoPresentation((DuoPresentation)this.adapterPool.create(DuoPresentation.class, (Object)duoPresentationGradingDTO.getDuoPresentationGradingKey().getDuoPresentation()));
            duoPresentationGrading.setJudgeNum(duoPresentationGradingDTO.getDuoPresentationGradingKey().getJudgeNum());
            duoPresentationGrading.setJudge((Judge)this.adapterPool.create(Judge.class, (Object)duoPresentationGradingDTO.getJudge()));
            duoPresentationGrading.setSentAt(duoPresentationGradingDTO.getSentAt());
            duoPresentationGrading.setFinalResult(duoPresentationGradingDTO.getFinalResult());
            duoPresentationGradings.add(duoPresentationGrading);
        }
        this.flush();
        return duoPresentationGradings;
    }

    public DuoPresentationGrading getOrCreateDuoPresentationGrading(DuoPresentation duoPresentation, Judge judge, boolean normalReferee) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select dpg from DuoPresentationGradingDTO as dpg where dpg.duoPresentationGradingKey.duoPresentation.duoPresentationId = ");
        sql.append(paramsBinder.addParam(duoPresentation.getDuoPresentationId()));
        sql.append(" and dpg.judge.judgeId = ");
        sql.append(paramsBinder.addParam(judge.getJudgeId()));
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        DuoPresentationGradingDTO duoPresentationGradingDTO = (DuoPresentationGradingDTO)DuoPresentationGradingDAO.getSingleResult((Query)query);
        DuoPresentationGrading duoPresentationGrading = null;
        if (duoPresentationGradingDTO == null) {
            int judgeNum;
            paramsBinder = new ParamsBinder();
            sql = new StringBuilder();
            sql.append("select dpg.duoPresentationGradingKey.judgeNum from DuoPresentationGradingDTO as dpg where dpg.duoPresentationGradingKey.duoPresentation.duoPresentationId = ");
            sql.append(paramsBinder.addParam(duoPresentation.getDuoPresentationId()));
            query = this.createQuery(sql.toString());
            paramsBinder.bindParams(query);
            if (normalReferee) {
                judgeNum = 1;
                for (Integer num : query.getResultList()) {
                    if (num < judgeNum) continue;
                    judgeNum = num + 1;
                }
                if (judgeNum > 3) {
                    throw new IllegalStateException("Too many judges present for duo presentation");
                }
            } else {
                judgeNum = 4;
                for (Integer num : query.getResultList()) {
                    if (num < judgeNum) continue;
                    judgeNum = num + 1;
                }
                if (judgeNum > 4) {
                    throw new IllegalStateException("Too many judges present for duo presentation");
                }
            }
            DuoPresentationDTO duoPresentationDTO = new DuoPresentationDTO();
            duoPresentationDTO.setDuoPresentationId(duoPresentation.getDuoPresentationId());
            JudgeDTO judgeDTO = new JudgeDTO();
            judgeDTO.setJudgeId(judge.getJudgeId());
            duoPresentationGradingDTO = new DuoPresentationGradingDTO(duoPresentationDTO, judgeNum);
            duoPresentationGradingDTO.setJudge(judgeDTO);
            duoPresentationGradingDTO.setSentAt(Calendar.getInstance());
            duoPresentationGradingDTO = (DuoPresentationGradingDTO)this.saveInstance(duoPresentationGradingDTO);
            duoPresentationGrading = new DuoPresentationGrading();
            duoPresentationGrading.setDuoPresentation(duoPresentation);
            duoPresentationGrading.setJudgeNum(Integer.valueOf(judgeNum));
            duoPresentationGrading.setJudge(judge);
            duoPresentationGrading.setSentAt(duoPresentationGradingDTO.getSentAt());
            duoPresentationGrading.setFinalResult(duoPresentationGradingDTO.getFinalResult());
        } else {
            duoPresentationGrading = new DuoPresentationGrading();
            duoPresentationGrading.setDuoPresentation((DuoPresentation)this.adapterPool.create(DuoPresentation.class, (Object)duoPresentationGradingDTO.getDuoPresentationGradingKey().getDuoPresentation()));
            duoPresentationGrading.setJudgeNum(duoPresentationGradingDTO.getDuoPresentationGradingKey().getJudgeNum());
            duoPresentationGrading.setJudge((Judge)this.adapterPool.create(Judge.class, (Object)duoPresentationGradingDTO.getJudge()));
            duoPresentationGrading.setSentAt(duoPresentationGradingDTO.getSentAt());
            duoPresentationGrading.setFinalResult(duoPresentationGradingDTO.getFinalResult());
        }
        this.flush();
        return duoPresentationGrading;
    }

    public DuoPresentationGrading updateDuoPresentationGrading(DuoPresentationGrading duoPresentationGrading) {
        DuoPresentationDTO duoPresentationDTO = new DuoPresentationDTO();
        duoPresentationDTO.setDuoPresentationId(duoPresentationGrading.getDuoPresentation().getDuoPresentationId());
        JudgeDTO judgeDTO = new JudgeDTO();
        judgeDTO.setJudgeId(duoPresentationGrading.getJudge().getJudgeId());
        DuoPresentationGradingDTO duoPresentationGradingDTO = new DuoPresentationGradingDTO(duoPresentationDTO, duoPresentationGrading.getJudgeNum());
        duoPresentationGradingDTO.setJudge(judgeDTO);
        duoPresentationGradingDTO.setSentAt(duoPresentationGrading.getSentAt());
        duoPresentationGradingDTO.setFinalResult(duoPresentationGrading.getFinalResult());
        duoPresentationGradingDTO = (DuoPresentationGradingDTO)this.saveInstance(duoPresentationGradingDTO);
        this.flush();
        duoPresentationGrading = new DuoPresentationGrading();
        duoPresentationGrading.setDuoPresentation((DuoPresentation)this.adapterPool.create(DuoPresentation.class, (Object)duoPresentationGradingDTO.getDuoPresentationGradingKey().getDuoPresentation()));
        duoPresentationGrading.setJudgeNum(duoPresentationGradingDTO.getDuoPresentationGradingKey().getJudgeNum());
        duoPresentationGrading.setJudge((Judge)this.adapterPool.create(Judge.class, (Object)duoPresentationGradingDTO.getJudge()));
        duoPresentationGrading.setSentAt(duoPresentationGradingDTO.getSentAt());
        duoPresentationGrading.setFinalResult(duoPresentationGradingDTO.getFinalResult());
        return duoPresentationGrading;
    }

    public void setDuoPresentationGradings(DuoPresentation duoPresentation, List<DuoPresentationGrading> duoPresentationGradings) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("delete from DuoPresentationGradingDTO where duoPresentationGradingKey.duoPresentation.duoPresentationId = ");
        sql.append(paramsBinder.addParam(duoPresentation.getDuoPresentationId()));
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        query.executeUpdate();
        if (CollectionUtil.isNotEmpty(duoPresentationGradings)) {
            DuoPresentationDTO duoPresentationDTO = new DuoPresentationDTO();
            duoPresentationDTO.setDuoPresentationId(duoPresentation.getDuoPresentationId());
            for (DuoPresentationGrading duoPresentationGrading : duoPresentationGradings) {
                JudgeDTO judgeDTO = new JudgeDTO();
                judgeDTO.setJudgeId(duoPresentationGrading.getJudge().getJudgeId());
                DuoPresentationGradingDTO duoPresentationGradingDTO = new DuoPresentationGradingDTO(duoPresentationDTO, duoPresentationGrading.getJudgeNum());
                duoPresentationGradingDTO.setJudge(judgeDTO);
                duoPresentationGradingDTO.setSentAt(duoPresentationGrading.getSentAt());
                duoPresentationGradingDTO.setFinalResult(duoPresentationGrading.getFinalResult());
                this.saveInstance(duoPresentationGradingDTO);
            }
        }
        this.flush();
    }

    public void deleteAllForJudge(Judge judge) {
        ParamsBinder paramsBinder = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("delete DuoPresentationGradingDTO where judge.judgeId = ");
        sql.append(paramsBinder.addParam(judge.getJudgeId()));
        Query query = this.createQuery(sql.toString());
        paramsBinder.bindParams(query);
        query.executeUpdate();
        this.flush();
    }
}

