/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.dao;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.query.Query;
import si.nevensrok.common.dl.ExtendedDao;
import si.nevensrok.common.dl.ParamsBinder;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.matches.DuoPresentation;
import si.nevensrok.jtekma.common.matches.DuoPresentationPoint;
import si.nevensrok.jtekma.common.matches.Round;
import si.nevensrok.jtekma.server.dl.dto.matches.DuoPresentationDTO;
import si.nevensrok.jtekma.server.dl.dto.matches.DuoPresentationPointDTO;

public class DuoPresentationDAO
extends ExtendedDao<Long, DuoPresentationDTO, DuoPresentation> {
    public DuoPresentationDAO() {
        super(DuoPresentationDTO.class, DuoPresentation.class);
    }

    protected String getTableFieldName(String fieldName) {
        if (fieldName.equalsIgnoreCase("id")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("duoPresentationId")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("competitor")) {
            return "competitor.id";
        }
        if (fieldName.equalsIgnoreCase("category")) {
            return "category.id";
        }
        if (fieldName.equalsIgnoreCase("status")) {
            return "status";
        }
        if (fieldName.equalsIgnoreCase("round")) {
            return "round";
        }
        if (fieldName.equalsIgnoreCase("rank")) {
            return "rank";
        }
        if (fieldName.equalsIgnoreCase("groupNumber")) {
            return "groupNumber";
        }
        if (fieldName.equalsIgnoreCase("groupPosition")) {
            return "groupPosition";
        }
        if (fieldName.equalsIgnoreCase("notNeeded")) {
            return "notNeeded";
        }
        if (fieldName.equalsIgnoreCase("startedAt")) {
            return "startedAt";
        }
        if (fieldName.equalsIgnoreCase("finishedAt")) {
            return "finishedAt";
        }
        if (fieldName.equalsIgnoreCase("matchDuration")) {
            return "matchDuration";
        }
        throw new IllegalArgumentException("Unknown field name " + fieldName);
    }

    public DuoPresentation getByIdWithCompetitor(Long duoPresentationId) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select duoPresentation,(select competitor from CompetitorDTO as competitor where competitor.id=duoPresentation.competitor.id) as competitor from DuoPresentationDTO as duoPresentation where duoPresentation.id=");
        sql.append(params.addParam(duoPresentationId));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        Object[] parts = (Object[])DuoPresentationDAO.getSingleResult((Query)query);
        DuoPresentation duoPresentation = null;
        if (parts != null) {
            duoPresentation = (DuoPresentation)this.getAdapterPool().create(DuoPresentation.class, parts[0]);
            Competitor competitor = (Competitor)this.getAdapterPool().create(Competitor.class, parts[1]);
            duoPresentation.setCompetitor(competitor);
        }
        this.flush();
        return duoPresentation;
    }

    public List<DuoPresentation> getDuoPresentationsForCategory(Category category) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select duoPresentation,(select competitor from CompetitorDTO as competitor where competitor.id=duoPresentation.competitor.id) as competitor from DuoPresentationDTO as duoPresentation where duoPresentation.category.id=");
        sql.append(params.addParam(category.getCategoryId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        List list = query.getResultList();
        LinkedList<DuoPresentation> duoPresentations = new LinkedList<DuoPresentation>();
        for (Object item : list) {
            Object[] parts = (Object[])item;
            DuoPresentation duoPresentation = (DuoPresentation)this.getAdapterPool().create(DuoPresentation.class, parts[0]);
            Competitor competitor = (Competitor)this.getAdapterPool().create(Competitor.class, parts[1]);
            duoPresentation.setCompetitor(competitor);
            duoPresentations.add(duoPresentation);
        }
        this.flush();
        return duoPresentations;
    }

    public DuoPresentation getDuoPresentationsForCategory(Category category, Round round, Competitor competitor) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select duoPresentation,(select competitor from CompetitorDTO as competitor where competitor.id=duoPresentation.competitor.id) as competitor from DuoPresentationDTO as duoPresentation where duoPresentation.category.id=");
        sql.append(params.addParam(category.getCategoryId()));
        sql.append(" and duoPresentation.round = ");
        sql.append(params.addParam((Object)round));
        sql.append(" and duoPresentation.competitor.competitorId = ");
        sql.append(params.addParam(competitor.getCompetitorId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        Object[] result = (Object[])DuoPresentationDAO.getSingleResult((Query)query);
        DuoPresentation duoPresentation = null;
        if (result != null) {
            duoPresentation = (DuoPresentation)this.getAdapterPool().create(DuoPresentation.class, result[0]);
            Competitor c = (Competitor)this.getAdapterPool().create(Competitor.class, result[1]);
            duoPresentation.setCompetitor(c);
        }
        this.flush();
        return duoPresentation;
    }

    public void setDuoPresentationStatus(DuoPresentation duoPresentation, DuoPresentation.Status status) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("update DuoPresentationDTO set status=");
        sql.append(params.addParam((Object)status));
        sql.append(" where duoPresentationId=");
        sql.append(params.addParam(duoPresentation.getDuoPresentationId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public void setDuoPresentationStartedAt(DuoPresentation duoPresentation) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("update DuoPresentationDTO set startedAt=");
        sql.append(params.addParam(duoPresentation.getStartedAt()));
        sql.append(" where duoPresentationId=");
        sql.append(params.addParam(duoPresentation.getDuoPresentationId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public void setDuoPresentationFinishedAt(DuoPresentation duoPresentation) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("update DuoPresentationDTO set finishedAt=");
        sql.append(params.addParam(duoPresentation.getFinishedAt()));
        sql.append(" where duoPresentationId=");
        sql.append(params.addParam(duoPresentation.getDuoPresentationId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public void updateDuoPresentationAdvancementData(Collection<DuoPresentation> duoPresentations) {
        for (DuoPresentation duoPresentation : duoPresentations) {
            ParamsBinder params = new ParamsBinder();
            StringBuilder sql = new StringBuilder();
            sql.append("update DuoPresentationDTO set groupNumber=");
            sql.append(params.addParam(duoPresentation.getGroupNumber()));
            sql.append(", groupPosition=");
            sql.append(params.addParam(duoPresentation.getGroupPosition()));
            sql.append(", notNeeded=");
            sql.append(params.addParam(duoPresentation.getNotNeeded()));
            sql.append(" where duoPresentationId=");
            sql.append(params.addParam(duoPresentation.getDuoPresentationId()));
            Query query = this.createQuery(sql.toString());
            params.bindParams(query);
            query.executeUpdate();
        }
        this.flush();
    }

    public Set<DuoPresentationPoint> getDuoPresentationPointsForDuoPresentation(DuoPresentation duoPresentation) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select duoPresentationPoint from DuoPresentationPointDTO as duoPresentationPoint where duoPresentationPoint.duoPresentation.id=");
        sql.append(params.addParam(duoPresentation.getDuoPresentationId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        List list = query.getResultList();
        HashSet<DuoPresentationPoint> duoPresentationPoints = new HashSet<DuoPresentationPoint>();
        for (Object item : list) {
            DuoPresentationPoint duoPresentationPoint = (DuoPresentationPoint)this.getAdapterPool().create(DuoPresentationPoint.class, item);
            duoPresentationPoints.add(duoPresentationPoint);
        }
        this.flush();
        return duoPresentationPoints;
    }

    public Map<DuoPresentation, Set<DuoPresentationPoint>> getDuoPresentationsForDuoPresentations(Set<DuoPresentation> duoPresentations) {
        if (duoPresentations.isEmpty()) {
            return new HashMap<DuoPresentation, Set<DuoPresentationPoint>>();
        }
        HashMap<Long, DuoPresentation> duoPresentationMap = new HashMap<Long, DuoPresentation>();
        HashMap<DuoPresentation, Set<DuoPresentationPoint>> duoPresentationPoints = new HashMap<DuoPresentation, Set<DuoPresentationPoint>>();
        for (DuoPresentation duoPresentation : duoPresentations) {
            duoPresentationMap.put(duoPresentation.getDuoPresentationId(), duoPresentation);
            duoPresentationPoints.put(duoPresentation, new HashSet());
        }
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select duoPresentationPoint.duoPresentation.id, duoPresentationPoint from DuoPresentationPointDTO as duoPresentationPoint where duoPresentationPoint.duoPresentation.id in ");
        sql.append(params.addParam(duoPresentationMap.keySet()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        List list = query.getResultList();
        for (Object item : list) {
            Object[] parts = (Object[])item;
            Long duoPresentationId = (Long)parts[0];
            DuoPresentationPoint duoPresentationPoint = (DuoPresentationPoint)this.getAdapterPool().create(DuoPresentationPoint.class, parts[1]);
            ((Set)duoPresentationPoints.get(duoPresentationMap.get(duoPresentationId))).add(duoPresentationPoint);
        }
        this.flush();
        return duoPresentationPoints;
    }

    public void setDuoPresentationPointsForDuoPresentation(DuoPresentation duoPresentation, Set<DuoPresentationPoint> duoPresentationPoints) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("delete from DuoPresentationPointDTO where duoPresentation.duoPresentationId=");
        sql.append(params.addParam(duoPresentation.getDuoPresentationId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        DuoPresentationDTO duoPresentationDTO = new DuoPresentationDTO();
        duoPresentationDTO.setDuoPresentationId(duoPresentation.getDuoPresentationId());
        for (DuoPresentationPoint duoPresentationPoint : duoPresentationPoints) {
            DuoPresentationPointDTO duoPresentationPointDTO = (DuoPresentationPointDTO)this.getAdapterPool().create(DuoPresentationPointDTO.class, (Object)duoPresentationPoint);
            duoPresentationPointDTO.setDuoPresentation(duoPresentationDTO);
            this.getCurrentSession().save((Object)duoPresentationPointDTO);
        }
        this.flush();
    }

    public void setDuoPresentationPointsForDuoPresentation(DuoPresentation duoPresentation, int judgeNum, Set<DuoPresentationPoint> duoPresentationPoints) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("delete from DuoPresentationPointDTO where duoPresentation.duoPresentationId = ");
        sql.append(params.addParam(duoPresentation.getDuoPresentationId()));
        sql.append(" and judge = ");
        sql.append(params.addParam(Integer.valueOf(judgeNum)));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        DuoPresentationDTO duoPresentationDTO = new DuoPresentationDTO();
        duoPresentationDTO.setDuoPresentationId(duoPresentation.getDuoPresentationId());
        for (DuoPresentationPoint duoPresentationPoint : duoPresentationPoints) {
            DuoPresentationPointDTO duoPresentationPointDTO = (DuoPresentationPointDTO)this.getAdapterPool().create(DuoPresentationPointDTO.class, (Object)duoPresentationPoint);
            duoPresentationPointDTO.setDuoPresentation(duoPresentationDTO);
            duoPresentationPointDTO.setJudge(judgeNum);
            this.getCurrentSession().save((Object)duoPresentationPointDTO);
        }
        this.flush();
    }

    public void setVRDuoPresentationPointsForDuoPresentation(DuoPresentation duoPresentation, Set<DuoPresentationPoint> duoPresentationPoints) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("delete from DuoPresentationPointDTO where duoPresentation.duoPresentationId = ");
        sql.append(params.addParam(duoPresentation.getDuoPresentationId()));
        sql.append(" and type in ");
        sql.append(params.addParam(Arrays.asList(DuoPresentationPoint.Type.VARIETY_SCORE_POINTS, DuoPresentationPoint.Type.PENALTY)));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        DuoPresentationDTO duoPresentationDTO = new DuoPresentationDTO();
        duoPresentationDTO.setDuoPresentationId(duoPresentation.getDuoPresentationId());
        for (DuoPresentationPoint duoPresentationPoint : duoPresentationPoints) {
            DuoPresentationPointDTO duoPresentationPointDTO = (DuoPresentationPointDTO)this.getAdapterPool().create(DuoPresentationPointDTO.class, (Object)duoPresentationPoint);
            duoPresentationPointDTO.setDuoPresentation(duoPresentationDTO);
            this.getCurrentSession().save((Object)duoPresentationPointDTO);
        }
        this.flush();
    }
}

