/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.dao;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.query.Query;
import si.nevensrok.common.dl.ExtendedDao;
import si.nevensrok.common.dl.ParamsBinder;
import si.nevensrok.jtekma.common.category.AgeCategoryOption;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.CategoryCompetitorCount;
import si.nevensrok.jtekma.common.category.CategoryMatchCount;
import si.nevensrok.jtekma.common.category.Duo2023Category;
import si.nevensrok.jtekma.common.category.DuoCategory;
import si.nevensrok.jtekma.common.category.FightingCategory;
import si.nevensrok.jtekma.common.category.NewazaCategory;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.category.WeightCategoryOption;
import si.nevensrok.jtekma.common.club.Club;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.competitors.GroupDraw;
import si.nevensrok.jtekma.common.matches.DuoPresentation;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.Rank;
import si.nevensrok.jtekma.common.rules.TreeAdvancment;
import si.nevensrok.jtekma.common.system.User;
import si.nevensrok.jtekma.server.dl.dto.category.CategoryCompetitorCountDTO;
import si.nevensrok.jtekma.server.dl.dto.category.CategoryDTO;
import si.nevensrok.jtekma.server.dl.dto.category.ShowCategoryDTO;
import si.nevensrok.jtekma.server.dl.dto.competitors.CompetesInCategoryDTO;
import si.nevensrok.jtekma.server.dl.dto.competitors.CompetitorDTO;
import si.nevensrok.jtekma.server.dl.dto.system.UserDTO;

public class CategoryDAO
extends ExtendedDao<Long, CategoryDTO, Category> {
    public CategoryDAO() {
        super(CategoryDTO.class, Category.class);
    }

    protected String getTableFieldName(String fieldName) {
        if (fieldName.equalsIgnoreCase("id")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("categoryId")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("name")) {
            return "name";
        }
        if (fieldName.equalsIgnoreCase("shortName")) {
            return "shortName";
        }
        if (fieldName.equalsIgnoreCase("type")) {
            return "type";
        }
        if (fieldName.equalsIgnoreCase("competition")) {
            return "competition.id";
        }
        if (fieldName.equalsIgnoreCase("treeAvancment")) {
            return "treeAvancment.id";
        }
        if (fieldName.equalsIgnoreCase("status")) {
            return "status";
        }
        throw new IllegalArgumentException("Unknown field name " + fieldName);
    }

    public void setCategoryTreeAdvancment(TreeCategory treeCategory, TreeAdvancment treeAdvancment) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("update TreeCategoryDTO set treeAdvancment=");
        sql.append(params.addParam(treeAdvancment.getTreeAdvancmentId()));
        sql.append(" where categoryId=");
        sql.append(params.addParam(treeCategory.getCategoryId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public void setCategoryWeightCategoryOption(FightingCategory fightingCategory, WeightCategoryOption weightCategoryOption) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("update FightingCategoryDTO set weightCategoryOption=");
        if (weightCategoryOption == null) {
            sql.append(params.addParam(null));
        } else {
            sql.append(params.addParam(weightCategoryOption.getWeightCategoryOptionId()));
        }
        sql.append(" where categoryId=");
        sql.append(params.addParam(fightingCategory.getCategoryId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public void setCategoryAgeCategoryOption(FightingCategory fightingCategory, AgeCategoryOption ageCategoryOption) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("update FightingCategoryDTO set ageCategoryOption=");
        if (ageCategoryOption == null) {
            sql.append(params.addParam(null));
        } else {
            sql.append(params.addParam(ageCategoryOption.getAgeCategoryId()));
        }
        sql.append(" where categoryId=");
        sql.append(params.addParam(fightingCategory.getCategoryId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public void setCategoryAgeCategoryOption(DuoCategory duoCategory, AgeCategoryOption ageCategoryOption) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("update DuoCategoryDTO set ageCategoryOption=");
        if (ageCategoryOption == null) {
            sql.append(params.addParam(null));
        } else {
            sql.append(params.addParam(ageCategoryOption.getAgeCategoryId()));
        }
        sql.append(" where categoryId=");
        sql.append(params.addParam(duoCategory.getCategoryId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public void setCategoryAgeCategoryOption(Duo2023Category duo2023Category, AgeCategoryOption ageCategoryOption) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("update Duo2023CategoryDTO set ageCategoryOption=");
        if (ageCategoryOption == null) {
            sql.append(params.addParam(null));
        } else {
            sql.append(params.addParam(ageCategoryOption.getAgeCategoryId()));
        }
        sql.append(" where categoryId=");
        sql.append(params.addParam(duo2023Category.getCategoryId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public void setCategoryWeightCategoryOption(NewazaCategory newazaCategory, WeightCategoryOption weightCategoryOption) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("update NewazaCategoryDTO set weightCategoryOption=");
        if (weightCategoryOption == null) {
            sql.append(params.addParam(null));
        } else {
            sql.append(params.addParam(weightCategoryOption.getWeightCategoryOptionId()));
        }
        sql.append(" where categoryId=");
        sql.append(params.addParam(newazaCategory.getCategoryId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public void setCategoryAgeCategoryOption(NewazaCategory newazaCategory, AgeCategoryOption ageCategoryOption) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("update NewazaCategoryDTO set ageCategoryOption=");
        if (ageCategoryOption == null) {
            sql.append(params.addParam(null));
        } else {
            sql.append(params.addParam(ageCategoryOption.getAgeCategoryId()));
        }
        sql.append(" where categoryId=");
        sql.append(params.addParam(newazaCategory.getCategoryId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public Map<Competitor, Integer> getDraw(Category category) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select competesInCategory.drawNumber,competesInCategory.competesInCategoryKey.competitor from CompetesInCategoryDTO as competesInCategory where competesInCategory.competesInCategoryKey.category.id=");
        sqlQuery.append(params.addParam(category.getCategoryId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        List result = query.getResultList();
        HashMap<Competitor, Integer> draw = new HashMap<Competitor, Integer>();
        for (Object item : result) {
            Object[] parts = (Object[])item;
            Integer num = (Integer)parts[0];
            Competitor competitor = (Competitor)this.getAdapterPool().create(Competitor.class, parts[1]);
            draw.put(competitor, num);
        }
        this.flush();
        return draw;
    }

    public Map<Competitor, GroupDraw> getGroupDraw(Category category) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select competesInCategory.drawNumber,competesInCategory.drawGroup,competesInCategory.competesInCategoryKey.competitor from CompetesInCategoryDTO as competesInCategory where competesInCategory.competesInCategoryKey.category.id=");
        sqlQuery.append(params.addParam(category.getCategoryId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        List result = query.getResultList();
        HashMap<Competitor, GroupDraw> draw = new HashMap<Competitor, GroupDraw>();
        for (Object item : result) {
            Object[] parts = (Object[])item;
            Integer drawNumber = (Integer)parts[0];
            Integer drawGroup = (Integer)parts[1];
            Competitor competitor = (Competitor)this.getAdapterPool().create(Competitor.class, parts[2]);
            draw.put(competitor, new GroupDraw(drawNumber, drawGroup));
        }
        this.flush();
        return draw;
    }

    public void setDraw(Category category, Map<Competitor, Integer> draw) {
        for (Map.Entry<Competitor, Integer> entry : draw.entrySet()) {
            ParamsBinder params = new ParamsBinder();
            StringBuilder sqlQuery = new StringBuilder();
            sqlQuery.append("update CompetesInCategoryDTO set drawNumber = ");
            sqlQuery.append(params.addParam(entry.getValue()));
            sqlQuery.append(", drawGroup = null");
            sqlQuery.append(" where competesInCategoryKey.category.id = ");
            sqlQuery.append(params.addParam(category.getCategoryId()));
            sqlQuery.append(" and competesInCategoryKey.competitor.id = ");
            sqlQuery.append(params.addParam(entry.getKey().getCompetitorId()));
            Query query = this.createQuery(sqlQuery.toString());
            params.bindParams(query);
            query.executeUpdate();
        }
        this.flush();
    }

    public void setGroupDraw(Category category, Map<Competitor, GroupDraw> draw) {
        for (Map.Entry<Competitor, GroupDraw> entry : draw.entrySet()) {
            ParamsBinder params = new ParamsBinder();
            StringBuilder sqlQuery = new StringBuilder();
            sqlQuery.append("update CompetesInCategoryDTO set drawNumber = ");
            sqlQuery.append(params.addParam(entry.getValue().getDrawNumber()));
            sqlQuery.append(", drawGroup = ");
            sqlQuery.append(params.addParam(entry.getValue().getDrawGroup()));
            sqlQuery.append(" where competesInCategoryKey.category.id = ");
            sqlQuery.append(params.addParam(category.getCategoryId()));
            sqlQuery.append(" and competesInCategoryKey.competitor.id = ");
            sqlQuery.append(params.addParam(entry.getKey().getCompetitorId()));
            Query query = this.createQuery(sqlQuery.toString());
            params.bindParams(query);
            query.executeUpdate();
        }
        this.flush();
    }

    public void setPlacings(Category category, Map<Competitor, Integer> placings) {
        for (Map.Entry<Competitor, Integer> entry : placings.entrySet()) {
            ParamsBinder params = new ParamsBinder();
            StringBuilder sqlQuery = new StringBuilder();
            sqlQuery.append("update CompetesInCategoryDTO set competitorPlacing = ");
            sqlQuery.append(params.addParam(entry.getValue()));
            sqlQuery.append(", placingRank = null");
            sqlQuery.append(" where competesInCategoryKey.category.id = ");
            sqlQuery.append(params.addParam(category.getCategoryId()));
            sqlQuery.append(" and competesInCategoryKey.competitor.id = ");
            sqlQuery.append(params.addParam(entry.getKey().getCompetitorId()));
            Query query = this.createQuery(sqlQuery.toString());
            params.bindParams(query);
            query.executeUpdate();
        }
        this.flush();
    }

    public void setPlacings(Category category, Map<Competitor, Integer> placings, Rank rank) {
        for (Map.Entry<Competitor, Integer> entry : placings.entrySet()) {
            ParamsBinder params = new ParamsBinder();
            StringBuilder sqlQuery = new StringBuilder();
            sqlQuery.append("update CompetesInCategoryDTO set competitorPlacing = ");
            sqlQuery.append(params.addParam(entry.getValue()));
            sqlQuery.append(", placingRank = ");
            sqlQuery.append(params.addParam((Object)rank));
            sqlQuery.append(" where competesInCategoryKey.category.id = ");
            sqlQuery.append(params.addParam(category.getCategoryId()));
            sqlQuery.append(" and competesInCategoryKey.competitor.id = ");
            sqlQuery.append(params.addParam(entry.getKey().getCompetitorId()));
            Query query = this.createQuery(sqlQuery.toString());
            params.bindParams(query);
            query.executeUpdate();
        }
        this.flush();
    }

    public Map<Competitor, Integer> getPlacings(Category category) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select competesInCategory.competitorPlacing,competesInCategory.competesInCategoryKey.competitor from CompetesInCategoryDTO as competesInCategory where competesInCategory.competesInCategoryKey.category.id=");
        sqlQuery.append(params.addParam(category.getCategoryId()));
        sqlQuery.append(" and competesInCategory.placingRank is null");
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        List result = query.getResultList();
        HashMap<Competitor, Integer> placings = new HashMap<Competitor, Integer>();
        for (Object item : result) {
            Object[] parts = (Object[])item;
            Integer num = (Integer)parts[0];
            if (num == null) continue;
            Competitor competitor = (Competitor)this.getAdapterPool().create(Competitor.class, parts[1]);
            placings.put(competitor, num);
        }
        this.flush();
        return placings;
    }

    public Map<Competitor, Integer> getPlacings(Category category, Rank rank) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select competesInCategory.competitorPlacing,competesInCategory.competesInCategoryKey.competitor from CompetesInCategoryDTO as competesInCategory where competesInCategory.competesInCategoryKey.category.id=");
        sqlQuery.append(params.addParam(category.getCategoryId()));
        sqlQuery.append(" and competesInCategory.placingRank = ");
        sqlQuery.append(params.addParam((Object)rank));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        List result = query.getResultList();
        HashMap<Competitor, Integer> placings = new HashMap<Competitor, Integer>();
        for (Object item : result) {
            Object[] parts = (Object[])item;
            Integer num = (Integer)parts[0];
            if (num == null) continue;
            Competitor competitor = (Competitor)this.getAdapterPool().create(Competitor.class, parts[1]);
            placings.put(competitor, num);
        }
        this.flush();
        return placings;
    }

    public List<Category> getCategoriesForCompetitor(Competitor competitor) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select competesInCategory.competesInCategoryKey.category from CompetesInCategoryDTO as competesInCategory where competesInCategory.competesInCategoryKey.competitor.id=");
        sqlQuery.append(params.addParam(competitor.getCompetitorId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        List result = query.getResultList();
        LinkedList<Category> categories = new LinkedList<Category>();
        for (Object item : result) {
            Category category = (Category)this.getAdapterPool().create(Category.class, item);
            categories.add(category);
        }
        this.flush();
        return categories;
    }

    public void setCategoryTreeType(TreeCategory category, TreeCategory.TreeType treeType) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("update TreeCategoryDTO set treeType=");
        sqlQuery.append(params.addParam((Object)treeType));
        sqlQuery.append(" where categoryId=");
        sqlQuery.append(params.addParam(category.getCategoryId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public void setRepassageType(TreeCategory category, TreeCategory.RepassageType repassageType) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("update TreeCategoryDTO set repassageType=");
        sqlQuery.append(params.addParam((Object)repassageType));
        sqlQuery.append(" where categoryId=");
        sqlQuery.append(params.addParam(category.getCategoryId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public void setDouble3rdPlace(TreeCategory category, Boolean double3rdPlace) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("update TreeCategoryDTO set double3rdPlace=");
        sqlQuery.append(params.addParam(double3rdPlace));
        sqlQuery.append(" where categoryId=");
        sqlQuery.append(params.addParam(category.getCategoryId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public void setRepassageFromRound(TreeCategory category, Integer repassageFromRound) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("update TreeCategoryDTO set repassageFromRound=");
        sqlQuery.append(params.addParam(repassageFromRound));
        sqlQuery.append(" where categoryId=");
        sqlQuery.append(params.addParam(category.getCategoryId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public void setDouble3rdPlace(Duo2023Category category, Boolean double3rdPlace) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("update Duo2023CategoryDTO set double3rdPlace=");
        sqlQuery.append(params.addParam(double3rdPlace));
        sqlQuery.append(" where categoryId=");
        sqlQuery.append(params.addParam(category.getCategoryId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public void setAdvancedLevel(Duo2023Category category, Boolean advancedLevel) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("update Duo2023CategoryDTO set advancedLevel=");
        sqlQuery.append(params.addParam(advancedLevel));
        sqlQuery.append(" where categoryId=");
        sqlQuery.append(params.addParam(category.getCategoryId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public void setNoviceLevel(Duo2023Category category, Boolean noviceLevel) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("update Duo2023CategoryDTO set noviceLevel=");
        sqlQuery.append(params.addParam(noviceLevel));
        sqlQuery.append(" where categoryId=");
        sqlQuery.append(params.addParam(category.getCategoryId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.executeUpdate();
        this.flush();
    }

    public Category getCategoryForMatch(Match match) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select match.category from MatchDTO as match where match.id=");
        sqlQuery.append(params.addParam(match.getMatchId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        CategoryDTO categoryDTO = (CategoryDTO)CategoryDAO.getSingleResult((Query)query);
        Category category = null;
        if (categoryDTO != null) {
            category = (Category)this.getAdapterPool().create(Category.class, (Object)categoryDTO);
        }
        this.flush();
        return category;
    }

    public Category getCategoryForDuoPresentation(DuoPresentation duoPresentation) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select duoPresentation.category from DuoPresentationDTO as duoPresentation where duoPresentation.id=");
        sqlQuery.append(params.addParam(duoPresentation.getDuoPresentationId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        CategoryDTO categoryDTO = (CategoryDTO)CategoryDAO.getSingleResult((Query)query);
        Category category = null;
        if (categoryDTO != null) {
            category = (Category)this.getAdapterPool().create(Category.class, (Object)categoryDTO);
        }
        this.flush();
        return category;
    }

    public Category getActiveCategoryByName(Competition competition, String name) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select category from CategoryDTO as category where category.competition.id=");
        sqlQuery.append(params.addParam(competition.getCompetitionId()));
        sqlQuery.append(" and UPPER(category.name)=UPPER(");
        sqlQuery.append(params.addParam(name));
        sqlQuery.append(") and category.status=");
        sqlQuery.append(params.addParam((Object)Category.Status.ACTIVE));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        CategoryDTO categoryDTO = (CategoryDTO)CategoryDAO.getSingleResult((Query)query);
        Category category = null;
        if (categoryDTO != null) {
            category = (Category)this.getAdapterPool().create(Category.class, (Object)categoryDTO);
        }
        this.flush();
        return category;
    }

    public boolean hasCompetitorInCategory(Category category, Club club) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select count(*) from CompetesInCategoryDTO as competesInCategory where competesInCategory.competesInCategoryKey.competitor.club.id=");
        sqlQuery.append(params.addParam(club.getClubId()));
        sqlQuery.append(" and competesInCategory.competesInCategoryKey.category.id=");
        sqlQuery.append(params.addParam(category.getCategoryId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        Long count = (Long)CategoryDAO.getSingleResult((Query)query);
        this.flush();
        return count > 0L;
    }

    public void setShowCategoryForUser(User user, Map<Category, Boolean> categories) {
        UserDTO userDTO = new UserDTO();
        userDTO.setUserId(user.getUserId());
        for (Map.Entry<Category, Boolean> entry : categories.entrySet()) {
            CategoryDTO categoryDTO = new CategoryDTO();
            categoryDTO.setCategoryId(entry.getKey().getCategoryId());
            ShowCategoryDTO showCategoryDTO = new ShowCategoryDTO(userDTO, categoryDTO);
            if (entry.getValue().booleanValue()) {
                this.getCurrentSession().saveOrUpdate((Object)showCategoryDTO);
                continue;
            }
            this.getCurrentSession().delete((Object)showCategoryDTO);
        }
        this.flush();
    }

    public Map<Category, Boolean> getShowCategoryForUser(User user, Set<Category> categories) {
        HashMap<Long, Category> categoryById = new HashMap<Long, Category>();
        HashMap<Category, Boolean> showCategories = new HashMap<Category, Boolean>();
        for (Category category : categories) {
            categoryById.put(category.getCategoryId(), category);
            showCategories.put(category, false);
        }
        if (categories.isEmpty()) {
            return showCategories;
        }
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select showCategory.showCategoryKey.category.id from ShowCategoryDTO as showCategory where showCategory.showCategoryKey.user.id=");
        sqlQuery.append(params.addParam(user.getUserId()));
        sqlQuery.append(" and showCategory.showCategoryKey.category.id in ");
        sqlQuery.append(params.addParam(categoryById.keySet()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        List categoryIdList = query.getResultList();
        for (Long categoryId : categoryIdList) {
            showCategories.put((Category)categoryById.get(categoryId), true);
        }
        this.flush();
        return showCategories;
    }

    public Map<Category, CategoryMatchCount> getCategoryMatchCount(Set<Category> categories) {
        LinkedHashMap<Category, CategoryMatchCount> matchCountDate = new LinkedHashMap<Category, CategoryMatchCount>();
        if (categories.isEmpty()) {
            return matchCountDate;
        }
        for (Category category : categories) {
            Long count;
            Match.Status status;
            int totalMatches = 0;
            int finishedMatches = 0;
            int neededMatches = 0;
            int totalPresentations = 0;
            int finishedPresentations = 0;
            int neededPresentations = 0;
            ParamsBinder params = new ParamsBinder();
            StringBuilder sqlQuery = new StringBuilder();
            sqlQuery.append("select match.status, count(*) from MatchDTO as match where match.category.categoryId = ");
            sqlQuery.append(params.addParam(category.getCategoryId()));
            sqlQuery.append(" and match.notNeeded = ");
            sqlQuery.append(params.addParam(Boolean.FALSE));
            sqlQuery.append(" and match.matchEmpty = ");
            sqlQuery.append(params.addParam(Boolean.FALSE));
            sqlQuery.append(" group by match.status");
            Query query = this.createQuery(sqlQuery.toString());
            params.bindParams(query);
            List list = query.getResultList();
            for (Object[] parts : list) {
                status = (Match.Status)parts[0];
                count = (Long)parts[1];
                totalMatches += count.intValue();
                if (status == Match.Status.FINISHED) {
                    ++finishedMatches;
                    continue;
                }
                ++neededMatches;
            }
            params = new ParamsBinder();
            sqlQuery = new StringBuilder();
            sqlQuery.append("select duoPresentation.status, count(*) from DuoPresentationDTO as duoPresentation where duoPresentation.category.categoryId = ");
            sqlQuery.append(params.addParam(category.getCategoryId()));
            sqlQuery.append(" and duoPresentation.notNeeded = ");
            sqlQuery.append(params.addParam(Boolean.FALSE));
            sqlQuery.append(" group by duoPresentation.status");
            query = this.createQuery(sqlQuery.toString());
            params.bindParams(query);
            list = query.getResultList();
            for (Object[] parts : list) {
                status = (DuoPresentation.Status)parts[0];
                count = (Long)parts[1];
                totalPresentations += count.intValue();
                if (status == DuoPresentation.Status.FINISHED) {
                    ++finishedPresentations;
                    continue;
                }
                ++neededPresentations;
            }
            CategoryMatchCount categoryMatchCount = new CategoryMatchCount();
            categoryMatchCount.setTotalMatches(Integer.valueOf(totalMatches));
            categoryMatchCount.setFinishedMatches(Integer.valueOf(finishedMatches));
            categoryMatchCount.setNeededMatches(Integer.valueOf(neededMatches));
            categoryMatchCount.setTotalPresentations(Integer.valueOf(totalPresentations));
            categoryMatchCount.setFinishedPresentations(Integer.valueOf(finishedPresentations));
            categoryMatchCount.setNeededPresentations(Integer.valueOf(neededPresentations));
            matchCountDate.put(category, categoryMatchCount);
        }
        this.flush();
        return matchCountDate;
    }

    public Map<Category, CategoryCompetitorCount> getCategoryCompetitorCount(Set<Category> categories) {
        LinkedHashMap<Category, CategoryCompetitorCount> competitorCountDate = new LinkedHashMap<Category, CategoryCompetitorCount>();
        if (categories.isEmpty()) {
            return competitorCountDate;
        }
        HashMap<Long, Category> categoryById = new HashMap<Long, Category>();
        for (Category category : categories) {
            categoryById.put(category.getCategoryId(), category);
        }
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select categoryCompetitorCount from CategoryCompetitorCountDTO as categoryCompetitorCount where categoryCompetitorCount.categoryId in ");
        sqlQuery.append(params.addParam(categoryById.keySet()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        List list = query.getResultList();
        for (CategoryCompetitorCountDTO categoryCompetitorCountDTO : list) {
            competitorCountDate.put((Category)categoryById.get(categoryCompetitorCountDTO.getCategoryId()), (CategoryCompetitorCount)this.getAdapterPool().create(CategoryCompetitorCount.class, (Object)categoryCompetitorCountDTO));
        }
        this.flush();
        return competitorCountDate;
    }

    public void setCompetitorsForCategory(Category category, List<Competitor> competitors) {
        CategoryDTO categoryDTO = new CategoryDTO();
        categoryDTO.setCategoryId(category.getCategoryId());
        for (Competitor competitor : competitors) {
            CompetitorDTO competitorDTO = new CompetitorDTO();
            competitorDTO.setCompetitorId(competitor.getCompetitorId());
            CompetesInCategoryDTO competesInCategoryDTO = (CompetesInCategoryDTO)this.getInstance(CompetesInCategoryDTO.class, new CompetesInCategoryDTO.CompetesInCategoryKey(categoryDTO, competitorDTO));
            if (competesInCategoryDTO != null) continue;
            competesInCategoryDTO = new CompetesInCategoryDTO(categoryDTO, competitorDTO);
            this.createInstance(competesInCategoryDTO);
        }
        this.flush();
    }

    public List<Competitor> getCompetitorsForCategory(Category category) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select competesInCategory.competesInCategoryKey.competitor from CompetesInCategoryDTO as competesInCategory where competesInCategory.competesInCategoryKey.category.id=");
        sqlQuery.append(params.addParam(category.getCategoryId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        List list = query.getResultList();
        LinkedList<Competitor> competitors = new LinkedList<Competitor>();
        for (CompetitorDTO competitorDTO : list) {
            Competitor competitor = (Competitor)this.getAdapterPool().create(Competitor.class, (Object)competitorDTO);
            competitors.add(competitor);
        }
        this.flush();
        return competitors;
    }

    public void setCategoryAutomationOrder(Competition competition, Map<Category, Integer> categoryAutomationOrder) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("update CategoryDTO set automationOrder=null where competition.competitionId=");
        sqlQuery.append(params.addParam(competition.getCompetitionId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.executeUpdate();
        for (Map.Entry<Category, Integer> entry : categoryAutomationOrder.entrySet()) {
            params = new ParamsBinder();
            sqlQuery = new StringBuilder();
            sqlQuery.append("update CategoryDTO set automationOrder=");
            sqlQuery.append(params.addParam(entry.getValue()));
            sqlQuery.append(" where categoryId=");
            sqlQuery.append(params.addParam(entry.getKey().getCategoryId()));
            query = this.createQuery(sqlQuery.toString());
            params.bindParams(query);
            query.executeUpdate();
        }
        this.flush();
    }

    public List<Category> getCategoriesForAutomation(Competition competition) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select category from CategoryDTO as category where category.competition.competitionId=");
        sqlQuery.append(params.addParam(competition.getCompetitionId()));
        sqlQuery.append(" and category.automationOrder is not null");
        sqlQuery.append(" order by category.automationOrder");
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        List list = query.getResultList();
        LinkedList<Category> categories = new LinkedList<Category>();
        for (CategoryDTO categoryDTO : list) {
            Category category = (Category)this.getAdapterPool().create(Category.class, (Object)categoryDTO);
            categories.add(category);
        }
        return categories;
    }
}

