/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.dao;

import java.util.LinkedList;
import java.util.List;
import org.hibernate.query.Query;
import si.nevensrok.common.dl.ExtendedDao;
import si.nevensrok.common.dl.ParamsBinder;
import si.nevensrok.jtekma.common.category.AgeCategoryOption;
import si.nevensrok.jtekma.common.category.Duo2023Category;
import si.nevensrok.jtekma.common.category.DuoCategory;
import si.nevensrok.jtekma.common.category.FightingCategory;
import si.nevensrok.jtekma.common.category.NewazaCategory;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.server.dl.dto.category.AgeCategoryOptionDTO;

public class AgeCategoryOptionDAO
extends ExtendedDao<Long, AgeCategoryOptionDTO, AgeCategoryOption> {
    public AgeCategoryOptionDAO() {
        super(AgeCategoryOptionDTO.class, AgeCategoryOption.class);
    }

    protected String getTableFieldName(String fieldName) {
        if (fieldName.equalsIgnoreCase("id")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("ageCategoryId")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("name")) {
            return "name";
        }
        if (fieldName.equalsIgnoreCase("age")) {
            return "age";
        }
        if (fieldName.equalsIgnoreCase("status")) {
            return "status";
        }
        throw new IllegalArgumentException("Unknown field name " + fieldName);
    }

    public AgeCategoryOption getForCategory(FightingCategory fightingCategory) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select fightingCategory.ageCategoryOption from FightingCategoryDTO as fightingCategory where fightingCategory.id=");
        sql.append(params.addParam(fightingCategory.getCategoryId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        AgeCategoryOptionDTO ageCategoryOptionDTO = (AgeCategoryOptionDTO)AgeCategoryOptionDAO.getSingleResult((Query)query);
        AgeCategoryOption ageCategoryOption = null;
        if (ageCategoryOptionDTO != null) {
            ageCategoryOption = (AgeCategoryOption)this.getAdapterPool().create(AgeCategoryOption.class, (Object)ageCategoryOptionDTO);
        }
        this.flush();
        return ageCategoryOption;
    }

    public AgeCategoryOption getForCategory(DuoCategory duoCategory) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select duoCategory.ageCategoryOption from DuoCategoryDTO as duoCategory where duoCategory.id=");
        sql.append(params.addParam(duoCategory.getCategoryId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        AgeCategoryOptionDTO ageCategoryOptionDTO = (AgeCategoryOptionDTO)AgeCategoryOptionDAO.getSingleResult((Query)query);
        AgeCategoryOption ageCategoryOption = null;
        if (ageCategoryOptionDTO != null) {
            ageCategoryOption = (AgeCategoryOption)this.getAdapterPool().create(AgeCategoryOption.class, (Object)ageCategoryOptionDTO);
        }
        this.flush();
        return ageCategoryOption;
    }

    public AgeCategoryOption getForCategory(NewazaCategory newazaCategory) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select newazaCategory.ageCategoryOption from NewazaCategoryDTO as newazaCategory where newazaCategory.id=");
        sql.append(params.addParam(newazaCategory.getCategoryId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        AgeCategoryOptionDTO ageCategoryOptionDTO = (AgeCategoryOptionDTO)AgeCategoryOptionDAO.getSingleResult((Query)query);
        AgeCategoryOption ageCategoryOption = null;
        if (ageCategoryOptionDTO != null) {
            ageCategoryOption = (AgeCategoryOption)this.getAdapterPool().create(AgeCategoryOption.class, (Object)ageCategoryOptionDTO);
        }
        this.flush();
        return ageCategoryOption;
    }

    public AgeCategoryOption getForCategory(Duo2023Category duo2023Category) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select duo2023Category.ageCategoryOption from Duo2023CategoryDTO as duo2023Category where duo2023Category.id=");
        sql.append(params.addParam(duo2023Category.getCategoryId()));
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        AgeCategoryOptionDTO ageCategoryOptionDTO = (AgeCategoryOptionDTO)AgeCategoryOptionDAO.getSingleResult((Query)query);
        AgeCategoryOption ageCategoryOption = null;
        if (ageCategoryOptionDTO != null) {
            ageCategoryOption = (AgeCategoryOption)this.getAdapterPool().create(AgeCategoryOption.class, (Object)ageCategoryOptionDTO);
        }
        this.flush();
        return ageCategoryOption;
    }

    public AgeCategoryOption getAgeCategoryOptionByName(String name, boolean onlyActive) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select ageCategoryOption from AgeCategoryOptionDTO as ageCategoryOption where UPPER(ageCategoryOption.name)=UPPER(");
        sql.append(params.addParam(name));
        sql.append(")");
        if (onlyActive) {
            sql.append(" and ageCategoryOption.status=");
            sql.append(params.addParam((Object)AgeCategoryOption.Status.ACTIVE));
        }
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        AgeCategoryOptionDTO ageCategoryOptionDTO = (AgeCategoryOptionDTO)AgeCategoryOptionDAO.getSingleResult((Query)query);
        AgeCategoryOption ageCategoryOption = null;
        if (ageCategoryOptionDTO != null) {
            ageCategoryOption = (AgeCategoryOption)this.getAdapterPool().create(AgeCategoryOption.class, (Object)ageCategoryOptionDTO);
        }
        this.flush();
        return ageCategoryOption;
    }

    public List<AgeCategoryOption> getActiveAgeCategoriesForCompetitions(Competition competition) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sql = new StringBuilder();
        sql.append("select ageCategoryOption from AgeCategoryOptionDTO as ageCategoryOption where ageCategoryOption.status=");
        sql.append(params.addParam((Object)AgeCategoryOption.Status.ACTIVE));
        sql.append(" and ((select count(*) from FightingCategoryDTO as fightingCategory where fightingCategory.ageCategoryOption.id=ageCategoryOption.id and fightingCategory.competition.id=");
        sql.append(params.addParam(competition.getCompetitionId()));
        sql.append(")>0");
        sql.append(" or (select count(*) from DuoCategoryDTO as duoCategory where duoCategory.ageCategoryOption.id=ageCategoryOption.id and duoCategory.competition.id=");
        sql.append(params.addParam(competition.getCompetitionId()));
        sql.append(")>0");
        sql.append(" or (select count(*) from NewazaCategoryDTO as newazaCategory where newazaCategory.ageCategoryOption.id=ageCategoryOption.id and newazaCategory.competition.id=");
        sql.append(params.addParam(competition.getCompetitionId()));
        sql.append(")>0)");
        Query query = this.createQuery(sql.toString());
        params.bindParams(query);
        List list = query.getResultList();
        LinkedList<AgeCategoryOption> ageCategoryOptions = new LinkedList<AgeCategoryOption>();
        for (AgeCategoryOptionDTO ageCategoryOptionDTO : list) {
            ageCategoryOptions.add((AgeCategoryOption)this.getAdapterPool().create(AgeCategoryOption.class, (Object)ageCategoryOptionDTO));
        }
        this.flush();
        return ageCategoryOptions;
    }
}

