/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.chart;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPathConstants;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.chart.ChartChartElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawObjectElement;
import org.odftoolkit.odfdom.dom.element.style.StyleGraphicPropertiesElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfPackageDocument;
import org.odftoolkit.odfdom.type.CellRangeAddressList;
import org.odftoolkit.simple.ChartDocument;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.SpreadsheetDocument;
import org.odftoolkit.simple.chart.Chart;
import org.odftoolkit.simple.chart.ChartContainer;
import org.odftoolkit.simple.chart.ChartType;
import org.odftoolkit.simple.chart.DataSet;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChartContainer
implements ChartContainer {
    private Document mDocument;
    private Map<String, Chart> mCharts;
    private String ROOT_STRING = "./";

    protected AbstractChartContainer(Document doc) {
        try {
            this.mDocument = doc;
            this.mCharts = new HashMap<String, Chart>();
            List<Document> charts = this.mDocument.getEmbeddedDocuments(Document.OdfMediaType.CHART);
            for (Document chartDoc : charts) {
                OdfContentDom contentDom = chartDoc.getContentDom();
                ChartChartElement chartEle = (ChartChartElement)contentDom.getXPath().evaluate("//chart:chart[1]", contentDom, XPathConstants.NODE);
                String documentPath = chartDoc.getDocumentPath();
                this.mCharts.put(documentPath, new Chart(chartEle, documentPath));
            }
        }
        catch (Exception ex) {
            Logger.getLogger(AbstractChartContainer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected abstract DrawFrameElement getChartFrame() throws Exception;

    @Override
    public Chart createChart(String title, DataSet dataset, Rectangle rect) {
        try {
            DrawObjectElement drawObject;
            String sName = this.mDocument.getDocumentPath() + "/" + title + "_" + System.currentTimeMillis();
            ChartDocument newChartDocument = ChartDocument.newChartDocument();
            this.mDocument.insertDocument((OdfPackageDocument)newChartDocument, sName);
            OdfContentDom contentDom = newChartDocument.getContentDom();
            ChartChartElement chartEle = (ChartChartElement)contentDom.getXPath().evaluate("//chart:chart[1]", contentDom, XPathConstants.NODE);
            Chart chart = new Chart(chartEle, sName);
            chart.setChartTitle(title);
            chart.setChartType(ChartType.BAR);
            chart.setUseLegend(true);
            chart.setChartData(dataset);
            DrawFrameElement drawFrame = this.getChartFrame();
            drawFrame.setProperty(StyleGraphicPropertiesElement.OleDrawAspect, "1");
            drawFrame.setPresentationUserTransformedAttribute(Boolean.valueOf(true));
            drawFrame.removeAttributeNS(OdfDocumentNamespace.PRESENTATION.getUri(), "placeholder");
            if (rect != null) {
                drawFrame.setSvgXAttribute(new Integer(rect.x).toString());
                drawFrame.setSvgYAttribute(new Integer(rect.y).toString());
                drawFrame.setSvgWidthAttribute(new Integer(rect.width).toString());
                drawFrame.setSvgHeightAttribute(new Integer(rect.height).toString());
            }
            if ((drawObject = (DrawObjectElement)OdfElement.findFirstChildNode(DrawObjectElement.class, (Node)drawFrame)) == null) {
                drawObject = drawFrame.newDrawObjectElement();
            }
            if (dataset.getCellRangeAddress() != null) {
                drawObject.setDrawNotifyOnUpdateOfRangesAttribute(dataset.getCellRangeAddress().toString());
            }
            drawObject.setXlinkHrefAttribute(this.ROOT_STRING + sName);
            drawObject.setXlinkTypeAttribute("simple");
            drawObject.setXlinkShowAttribute("embed");
            drawObject.setXlinkActuateAttribute("onLoad");
            this.mCharts.put(sName, chart);
            return chart;
        }
        catch (Exception ex) {
            Logger.getLogger(AbstractChartContainer.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public Chart createChart(String title, SpreadsheetDocument document, CellRangeAddressList cellRangeAddr, boolean firstRowAsLabel, boolean firstColumnAsLabel, boolean rowAsDataSeries, Rectangle rect) {
        DataSet dataset = new DataSet(cellRangeAddr, document, firstRowAsLabel, firstColumnAsLabel, rowAsDataSeries);
        return this.createChart(title, dataset, rect);
    }

    @Override
    public Chart createChart(String title, String[] labels, String[] legends, double[][] data, Rectangle rect) {
        DataSet dataset = new DataSet(labels, legends, data);
        return this.createChart(title, dataset, rect);
    }

    @Override
    public void deleteChartById(String chartId) {
        try {
            this.mCharts.remove(chartId);
            this.mDocument.removeDocument(chartId);
            NodeList frameObjects = this.mDocument.getContentDom().getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "object");
            for (int i = 0; i < frameObjects.getLength(); ++i) {
                DrawObjectElement object = (DrawObjectElement)frameObjects.item(i);
                if (!object.getXlinkHrefAttribute().toString().endsWith(chartId)) continue;
                DrawFrameElement frame = (DrawFrameElement)object.getParentNode();
                frame.getParentNode().removeChild((Node)frame);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(AbstractChartContainer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void deleteChartByTitle(String title) {
        ArrayList<String> delChartIDList = new ArrayList<String>();
        Set<String> chartSet = this.mCharts.keySet();
        for (String chartIter : chartSet) {
            Chart chart = this.mCharts.get(chartIter);
            if (!chart.getChartTitle().equals(title)) continue;
            delChartIDList.add(chartIter);
        }
        for (int i = 0; i < delChartIDList.size(); ++i) {
            this.deleteChartById((String)delChartIDList.get(i));
        }
    }

    @Override
    public Chart getChartById(String chartId) {
        try {
            Document embedChartDoc = this.mDocument.getEmbeddedDocument(chartId);
            if (embedChartDoc != null) {
                OdfContentDom contentDom = embedChartDoc.getContentDom();
                ChartChartElement chartEle = (ChartChartElement)contentDom.getXPath().evaluate("//chart:chart[1]", contentDom, XPathConstants.NODE);
                Chart chart = new Chart(chartEle, chartId);
                if (this.mCharts.get(chartId) != null) {
                    return chart;
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(AbstractChartContainer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    @Override
    public List<Chart> getChartByTitle(String title) {
        ArrayList<Chart> chartList = new ArrayList<Chart>();
        Set<String> chartSet = this.mCharts.keySet();
        for (String chartIter : chartSet) {
            Chart chart = this.mCharts.get(chartIter);
            if (!chart.getChartTitle().equals(title)) continue;
            chartList.add(chart);
        }
        return chartList;
    }

    @Override
    public int getChartCount() {
        int cnt = this.mDocument.getEmbeddedDocuments(Document.OdfMediaType.CHART).size();
        return cnt;
    }
}

