/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.fontbox.FontBoxFont;
import org.apache.fontbox.ttf.OpenTypeFont;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.type1.Type1Font;
import org.apache.pdfbox.pdmodel.font.CIDFontMapping;
import org.apache.pdfbox.pdmodel.font.FileSystemFontProvider;
import org.apache.pdfbox.pdmodel.font.FontCache;
import org.apache.pdfbox.pdmodel.font.FontFormat;
import org.apache.pdfbox.pdmodel.font.FontInfo;
import org.apache.pdfbox.pdmodel.font.FontMapper;
import org.apache.pdfbox.pdmodel.font.FontMapping;
import org.apache.pdfbox.pdmodel.font.FontProvider;
import org.apache.pdfbox.pdmodel.font.PDCIDSystemInfo;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDPanoseClassification;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;

final class FontMapperImpl
implements FontMapper {
    private static final FontCache fontCache = new FontCache();
    private FontProvider fontProvider;
    private Map<String, FontInfo> fontInfoByName;
    private final TrueTypeFont lastResortFont;
    private final Map<String, List<String>> substitutes = new HashMap<String, List<String>>();

    FontMapperImpl() {
        this.substitutes.put("Courier", Arrays.asList("CourierNew", "CourierNewPSMT", "LiberationMono", "NimbusMonL-Regu"));
        this.substitutes.put("Courier-Bold", Arrays.asList("CourierNewPS-BoldMT", "CourierNew-Bold", "LiberationMono-Bold", "NimbusMonL-Bold"));
        this.substitutes.put("Courier-Oblique", Arrays.asList("CourierNewPS-ItalicMT", "CourierNew-Italic", "LiberationMono-Italic", "NimbusMonL-ReguObli"));
        this.substitutes.put("Courier-BoldOblique", Arrays.asList("CourierNewPS-BoldItalicMT", "CourierNew-BoldItalic", "LiberationMono-BoldItalic", "NimbusMonL-BoldObli"));
        this.substitutes.put("Helvetica", Arrays.asList("ArialMT", "Arial", "LiberationSans", "NimbusSanL-Regu"));
        this.substitutes.put("Helvetica-Bold", Arrays.asList("Arial-BoldMT", "Arial-Bold", "LiberationSans-Bold", "NimbusSanL-Bold"));
        this.substitutes.put("Helvetica-Oblique", Arrays.asList("Arial-ItalicMT", "Arial-Italic", "Helvetica-Italic", "LiberationSans-Italic", "NimbusSanL-ReguItal"));
        this.substitutes.put("Helvetica-BoldOblique", Arrays.asList("Arial-BoldItalicMT", "Helvetica-BoldItalic", "LiberationSans-BoldItalic", "NimbusSanL-BoldItal"));
        this.substitutes.put("Times-Roman", Arrays.asList("TimesNewRomanPSMT", "TimesNewRoman", "TimesNewRomanPS", "LiberationSerif", "NimbusRomNo9L-Regu"));
        this.substitutes.put("Times-Bold", Arrays.asList("TimesNewRomanPS-BoldMT", "TimesNewRomanPS-Bold", "TimesNewRoman-Bold", "LiberationSerif-Bold", "NimbusRomNo9L-Medi"));
        this.substitutes.put("Times-Italic", Arrays.asList("TimesNewRomanPS-ItalicMT", "TimesNewRomanPS-Italic", "TimesNewRoman-Italic", "LiberationSerif-Italic", "NimbusRomNo9L-ReguItal"));
        this.substitutes.put("Times-BoldItalic", Arrays.asList("TimesNewRomanPS-BoldItalicMT", "TimesNewRomanPS-BoldItalic", "TimesNewRoman-BoldItalic", "LiberationSerif-BoldItalic", "NimbusRomNo9L-MediItal"));
        this.substitutes.put("Symbol", Arrays.asList("Symbol", "SymbolMT", "StandardSymL"));
        this.substitutes.put("ZapfDingbats", Arrays.asList("ZapfDingbatsITC", "Dingbats", "MS-Gothic"));
        for (String baseName : Standard14Fonts.getNames()) {
            if (this.substitutes.containsKey(baseName)) continue;
            String mappedName = Standard14Fonts.getMappedFontName(baseName);
            this.substitutes.put(baseName, this.copySubstitutes(mappedName));
        }
        try {
            String ttfName = "org/apache/pdfbox/resources/ttf/LiberationSans-Regular.ttf";
            URL url = FontMapper.class.getClassLoader().getResource(ttfName);
            if (url == null) {
                throw new IOException("Error loading resource: " + ttfName);
            }
            InputStream ttfStream = url.openStream();
            TTFParser ttfParser = new TTFParser();
            this.lastResortFont = ttfParser.parse(ttfStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void setProvider(FontProvider fontProvider) {
        this.fontProvider = fontProvider;
        this.fontInfoByName = this.createFontInfoByName(fontProvider.getFontInfo());
    }

    public synchronized FontProvider getProvider() {
        if (this.fontProvider == null) {
            this.setProvider(DefaultFontProvider.INSTANCE);
        }
        return this.fontProvider;
    }

    public FontCache getFontCache() {
        return fontCache;
    }

    private Map<String, FontInfo> createFontInfoByName(List<? extends FontInfo> fontInfoList) {
        LinkedHashMap<String, FontInfo> map = new LinkedHashMap<String, FontInfo>();
        for (FontInfo fontInfo : fontInfoList) {
            for (String name : this.getPostScriptNames(fontInfo.getPostScriptName())) {
                map.put(name, fontInfo);
            }
        }
        return map;
    }

    private Set<String> getPostScriptNames(String postScriptName) {
        HashSet<String> names = new HashSet<String>();
        names.add(postScriptName);
        names.add(postScriptName.replaceAll("-", ""));
        return names;
    }

    private List<String> copySubstitutes(String postScriptName) {
        return new ArrayList<String>((Collection)this.substitutes.get(postScriptName));
    }

    public void addSubstitute(String match, String replace) {
        if (!this.substitutes.containsKey(match)) {
            this.substitutes.put(match, new ArrayList());
        }
        this.substitutes.get(match).add(replace);
    }

    private List<String> getSubstitutes(String postScriptName) {
        List<String> subs = this.substitutes.get(postScriptName.replaceAll(" ", ""));
        if (subs != null) {
            return subs;
        }
        return Collections.emptyList();
    }

    private String getFallbackFontName(PDFontDescriptor fontDescriptor) {
        String fontName;
        if (fontDescriptor != null) {
            boolean isBold = false;
            String name = fontDescriptor.getFontName();
            if (name != null) {
                String lower = fontDescriptor.getFontName().toLowerCase();
                boolean bl = isBold = lower.contains("bold") || lower.contains("black") || lower.contains("heavy");
            }
            if (fontDescriptor.isFixedPitch()) {
                fontName = "Courier";
                if (isBold && fontDescriptor.isItalic()) {
                    fontName = fontName + "-BoldOblique";
                } else if (isBold) {
                    fontName = fontName + "-Bold";
                } else if (fontDescriptor.isItalic()) {
                    fontName = fontName + "-Oblique";
                }
            } else if (fontDescriptor.isSerif()) {
                fontName = "Times";
                fontName = isBold && fontDescriptor.isItalic() ? fontName + "-BoldItalic" : (isBold ? fontName + "-Bold" : (fontDescriptor.isItalic() ? fontName + "-Italic" : fontName + "-Roman"));
            } else {
                fontName = "Helvetica";
                if (isBold && fontDescriptor.isItalic()) {
                    fontName = fontName + "-BoldOblique";
                } else if (isBold) {
                    fontName = fontName + "-Bold";
                } else if (fontDescriptor.isItalic()) {
                    fontName = fontName + "-Oblique";
                }
            }
        } else {
            fontName = "Times-Roman";
        }
        return fontName;
    }

    @Override
    public FontMapping<TrueTypeFont> getTrueTypeFont(String baseFont, PDFontDescriptor fontDescriptor) {
        TrueTypeFont ttf = (TrueTypeFont)this.findFont(FontFormat.TTF, baseFont);
        if (ttf != null) {
            return new FontMapping<TrueTypeFont>(ttf, false);
        }
        String fontName = this.getFallbackFontName(fontDescriptor);
        ttf = (TrueTypeFont)this.findFont(FontFormat.TTF, fontName);
        if (ttf == null) {
            ttf = this.lastResortFont;
        }
        return new FontMapping<TrueTypeFont>(ttf, true);
    }

    @Override
    public FontMapping<FontBoxFont> getFontBoxFont(String baseFont, PDFontDescriptor fontDescriptor) {
        FontBoxFont font = this.findFontBoxFont(baseFont);
        if (font != null) {
            return new FontMapping<FontBoxFont>(font, false);
        }
        String fallbackName = this.getFallbackFontName(fontDescriptor);
        font = this.findFontBoxFont(fallbackName);
        if (font == null) {
            font = this.lastResortFont;
        }
        return new FontMapping<FontBoxFont>(font, true);
    }

    private FontBoxFont findFontBoxFont(String postScriptName) {
        Type1Font t1 = (Type1Font)this.findFont(FontFormat.PFB, postScriptName);
        if (t1 != null) {
            return t1;
        }
        TrueTypeFont ttf = (TrueTypeFont)this.findFont(FontFormat.TTF, postScriptName);
        if (ttf != null) {
            return ttf;
        }
        OpenTypeFont otf = (OpenTypeFont)this.findFont(FontFormat.OTF, postScriptName);
        if (otf != null) {
            return otf;
        }
        return null;
    }

    private FontBoxFont findFont(FontFormat format, String postScriptName) {
        FontInfo info;
        if (postScriptName == null) {
            return null;
        }
        if (this.fontProvider == null) {
            this.getProvider();
        }
        if ((info = this.getFont(format, postScriptName)) != null) {
            return info.getFont();
        }
        info = this.getFont(format, postScriptName.replaceAll("-", ""));
        if (info != null) {
            return info.getFont();
        }
        for (String substituteName : this.getSubstitutes(postScriptName)) {
            info = this.getFont(format, substituteName);
            if (info == null) continue;
            return info.getFont();
        }
        info = this.getFont(format, postScriptName.replaceAll(",", "-"));
        if (info != null) {
            return info.getFont();
        }
        return null;
    }

    private FontInfo getFont(FontFormat format, String postScriptName) {
        FontInfo info;
        if (postScriptName.contains("+")) {
            postScriptName = postScriptName.substring(postScriptName.indexOf(43) + 1);
        }
        if ((info = this.fontInfoByName.get(postScriptName)) != null && info.getFormat() == format) {
            return info;
        }
        return null;
    }

    @Override
    public CIDFontMapping getCIDFont(String baseFont, PDFontDescriptor fontDescriptor, PDCIDSystemInfo cidSystemInfo) {
        PriorityQueue<FontMatch> queue;
        FontMatch bestMatch;
        String collection;
        OpenTypeFont otf1 = (OpenTypeFont)this.findFont(FontFormat.OTF, baseFont);
        if (otf1 != null) {
            return new CIDFontMapping(otf1, null, false);
        }
        TrueTypeFont ttf = (TrueTypeFont)this.findFont(FontFormat.TTF, baseFont);
        if (ttf != null) {
            return new CIDFontMapping(null, (FontBoxFont)ttf, false);
        }
        if (cidSystemInfo != null && ((collection = cidSystemInfo.getRegistry() + "-" + cidSystemInfo.getOrdering()).equals("Adobe-GB1") || collection.equals("Adobe-CNS1") || collection.equals("Adobe-Japan1") || collection.equals("Adobe-Korea1")) && (bestMatch = (queue = this.getFontMatches(fontDescriptor, cidSystemInfo)).poll()) != null) {
            FontBoxFont font = bestMatch.info.getFont();
            if (font instanceof OpenTypeFont) {
                return new CIDFontMapping((OpenTypeFont)font, null, true);
            }
            return new CIDFontMapping(null, font, true);
        }
        return new CIDFontMapping(null, (FontBoxFont)this.lastResortFont, true);
    }

    private PriorityQueue<FontMatch> getFontMatches(PDFontDescriptor fontDescriptor, PDCIDSystemInfo cidSystemInfo) {
        PriorityQueue<FontMatch> queue = new PriorityQueue<FontMatch>(20);
        for (FontInfo info : this.fontInfoByName.values()) {
            if (cidSystemInfo != null && !this.isCharSetMatch(cidSystemInfo, info)) continue;
            FontMatch match = new FontMatch(info);
            if (fontDescriptor.getPanose() != null && info.getPanose() != null) {
                PDPanoseClassification panose = fontDescriptor.getPanose().getPanose();
                if (panose.getFamilyKind() == info.getPanose().getFamilyKind()) {
                    if (panose.getSerifStyle() == info.getPanose().getSerifStyle()) {
                        match.score += 2.0;
                    } else if (panose.getSerifStyle() >= 2 && panose.getSerifStyle() <= 5 && info.getPanose().getSerifStyle() >= 2 && info.getPanose().getSerifStyle() <= 5) {
                        match.score += 1.0;
                    } else if (panose.getSerifStyle() >= 11 && panose.getSerifStyle() <= 13 && info.getPanose().getSerifStyle() >= 11 && info.getPanose().getSerifStyle() <= 13) {
                        match.score += 1.0;
                    } else if (panose.getSerifStyle() != 0 && info.getPanose().getSerifStyle() != 0) {
                        match.score -= 1.0;
                    }
                    int weight = info.getPanose().getWeight();
                    int weightClass = info.getWeightClassAsPanose();
                    if (Math.abs(weight - weightClass) > 2) {
                        weight = weightClass;
                    }
                    if (panose.getWeight() == weight) {
                        match.score += 2.0;
                    } else if (panose.getWeight() > 1 && weight > 1) {
                        float dist = Math.abs(panose.getWeight() - weight);
                        match.score += 1.0 - (double)dist * 0.5;
                    }
                }
            } else if (fontDescriptor.getFontWeight() > 0.0f && info.getWeightClass() > 0) {
                float dist = Math.abs(fontDescriptor.getFontWeight() - (float)info.getWeightClass());
                match.score += 1.0 - (double)(dist / 100.0f) * 0.5;
            }
            queue.add(match);
        }
        return queue;
    }

    private boolean isCharSetMatch(PDCIDSystemInfo cidSystemInfo, FontInfo info) {
        if (info.getCIDSystemInfo() != null) {
            return info.getCIDSystemInfo().getRegistry().equals(cidSystemInfo.getRegistry()) && info.getCIDSystemInfo().getOrdering().equals(cidSystemInfo.getOrdering());
        }
        long codePageRange = info.getCodePageRange();
        long JIS_JAPAN = 131072L;
        long CHINESE_SIMPLIFIED = 262144L;
        long KOREAN_WANSUNG = 524288L;
        long CHINESE_TRADITIONAL = 0x100000L;
        long KOREAN_JOHAB = 0x200000L;
        if (cidSystemInfo.getOrdering().equals("GB1") && (codePageRange & CHINESE_SIMPLIFIED) == CHINESE_SIMPLIFIED) {
            return true;
        }
        if (cidSystemInfo.getOrdering().equals("CNS1") && (codePageRange & CHINESE_TRADITIONAL) == CHINESE_TRADITIONAL) {
            return true;
        }
        if (cidSystemInfo.getOrdering().equals("Japan1") && (codePageRange & JIS_JAPAN) == JIS_JAPAN) {
            return true;
        }
        return cidSystemInfo.getOrdering().equals("Korea1") && (codePageRange & KOREAN_WANSUNG) == KOREAN_WANSUNG || (codePageRange & KOREAN_JOHAB) == KOREAN_JOHAB;
    }

    private FontMatch printMatches(PriorityQueue<FontMatch> queue) {
        FontMatch bestMatch = queue.peek();
        System.out.println("-------");
        while (!queue.isEmpty()) {
            FontMatch match = queue.poll();
            FontInfo info = match.info;
            System.out.println(match.score + " | " + info.getMacStyle() + " " + info.getFamilyClass() + " " + info.getPanose() + " " + info.getCIDSystemInfo() + " " + info.getPostScriptName() + " " + (Object)((Object)info.getFormat()));
        }
        System.out.println("-------");
        return bestMatch;
    }

    static /* synthetic */ FontCache access$000() {
        return fontCache;
    }

    private class FontMatch
    implements Comparable<FontMatch> {
        double score;
        final FontInfo info;

        FontMatch(FontInfo info) {
            this.info = info;
        }

        @Override
        public int compareTo(FontMatch match) {
            return Double.compare(match.score, this.score);
        }
    }

    private static class DefaultFontProvider {
        private static final FontProvider INSTANCE = new FileSystemFontProvider(FontMapperImpl.access$000());

        private DefaultFontProvider() {
        }
    }
}

