/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.remoting;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.network.NetworkMessageHandler;
import si.nevensrok.common.network.tcp.ConnectionEstablishedHandler;
import si.nevensrok.common.network.tcp.TcpNetworkConnection;
import si.nevensrok.common.network.tcp.TcpNetworkServer;
import si.nevensrok.common.remoting.ServiceExporter;
import si.nevensrok.common.remoting.TcpRequestHandler;

public class TcpRemoteService
implements InitializingBean {
    private TcpNetworkServer tcpNetworkServer;
    private Map<String, ServiceExporter> serviceExporters;

    public void setTcpNetworkServer(TcpNetworkServer tcpNetworkServer) {
        this.tcpNetworkServer = tcpNetworkServer;
    }

    public TcpNetworkServer getTcpNetworkServer() {
        return this.tcpNetworkServer;
    }

    public void setServiceExporters(List<ServiceExporter> serviceExporters) {
        this.serviceExporters = new HashMap<String, ServiceExporter>();
        for (ServiceExporter serviceExporter : serviceExporters) {
            this.serviceExporters.put(serviceExporter.getServiceName(), serviceExporter);
        }
    }

    public void setServiceExporters(ServiceExporter ... serviceExporters) {
        this.serviceExporters = new HashMap<String, ServiceExporter>();
        for (ServiceExporter serviceExporter : serviceExporters) {
            this.serviceExporters.put(serviceExporter.getServiceName(), serviceExporter);
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getTcpNetworkServer() == null) {
            throw new IllegalArgumentException("Property 'serviceInterface' is required");
        }
        this.getTcpNetworkServer().setConnectionEstablishedHandler(new ConnectionEstablishedHandler(){

            public void connectionAccepted(TcpNetworkConnection networkConnection) {
                networkConnection.setNetworkMessageHandler((NetworkMessageHandler)new TcpRequestHandler(networkConnection, TcpRemoteService.this.serviceExporters));
            }
        });
    }
}

