/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.competition;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.competitors.GroupDraw;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.security.ForbiddenException;

@Controller
@RequestMapping(value={"/competition/data"})
public class CompetitionDataCompetitorController
extends CoreController {
    @RequestMapping(value={"/competitor"}, method={RequestMethod.GET})
    @ResponseBody
    public List<si.nevensrok.jtekma.server.web.common.competition.Competitor> getCompetitorList(HttpServletResponse response, @RequestParam(value="categoryId") Long categoryId) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Category category = new Category();
        category.setCategoryId(categoryId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategory(category).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for category");
        }
        HashMap draw = new HashMap();
        for (Map.Entry entry : this.getManagersList().getCategoryManager().getGroupDraw(category).entrySet()) {
            draw.put(((Competitor)entry.getKey()).getCompetitorId(), entry.getValue());
        }
        LinkedList<si.nevensrok.jtekma.server.web.common.competition.Competitor> competitors = new LinkedList<si.nevensrok.jtekma.server.web.common.competition.Competitor>();
        for (Competitor competitor : this.getManagersList().getCompetitorManager().getCompetitorsForCategory(category)) {
            si.nevensrok.jtekma.server.web.common.competition.Competitor c = new si.nevensrok.jtekma.server.web.common.competition.Competitor(competitor);
            GroupDraw groupDraw = (GroupDraw)draw.get(c.getId());
            c.setDraw(groupDraw.getDrawNumber());
            c.setDrawGroup(groupDraw.getDrawGroup());
            competitors.add(c);
        }
        return competitors;
    }
}

