/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.updaters;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.management.RulesManager;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.rules.CompetitionRules;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.common.rules.Table;
import si.nevensrok.jtekma.common.rules.TreeAdvancment;
import si.nevensrok.jtekma.common.rules.TreeAdvancmentItem;
import si.nevensrok.jtekma.common.rules.TreeType;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.CompetitionManager;
import si.nevensrok.jtekma.server.management.MatchManager;
import si.nevensrok.jtekma.server.management.TreeAdvancmentManager;

public class TableCalculator {
    private CompetitionManager competitionManager;
    private RulesManager rulesManager;
    private MatchManager matchManager;
    private TreeAdvancmentManager treeAdvancmentManager;
    private CategoryManager categoryManager;

    public void setCompetitionManager(CompetitionManager competitionManager) {
        this.competitionManager = competitionManager;
    }

    public void setRulesManager(RulesManager rulesManager) {
        this.rulesManager = rulesManager;
    }

    public void setMatchManager(MatchManager matchManager) {
        this.matchManager = matchManager;
    }

    public void setTreeAdvancmentManager(TreeAdvancmentManager treeAdvancmentManager) {
        this.treeAdvancmentManager = treeAdvancmentManager;
    }

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public Table getTable(TreeCategory treeCategory) {
        Competition competition = this.competitionManager.getCompetitionForCategory((Category)treeCategory);
        CompetitionRules competitionRules = this.rulesManager.getCompetitionRules(competition.getRules());
        HashMap<Integer, Match> matches = new HashMap<Integer, Match>();
        for (Match match : this.matchManager.getMatchesForCategory((Category)treeCategory)) {
            matches.put(match.getFightNumber(), match);
        }
        TreeAdvancment treeAdvancment = this.treeAdvancmentManager.getForCategory(treeCategory);
        Map draw = this.categoryManager.getDraw((Category)treeCategory);
        Table table = new Table();
        Table.Row[] rows = treeCategory.getTreeType() == TreeCategory.TreeType.TABLE2 ? new Table.Row[2] : (treeCategory.getTreeType() == TreeCategory.TreeType.TABLE3 ? new Table.Row[3] : (treeCategory.getTreeType() == TreeCategory.TreeType.TABLE4 ? new Table.Row[4] : new Table.Row[5]));
        table.setRows(rows);
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = new Table.Row();
            if (treeCategory.getTreeType() == TreeCategory.TreeType.TABLE2) {
                rows[i].setMatches(new Table.Row.Match[2]);
                continue;
            }
            if (treeCategory.getTreeType() == TreeCategory.TreeType.TABLE3) {
                rows[i].setMatches(new Table.Row.Match[3]);
                continue;
            }
            if (treeCategory.getTreeType() == TreeCategory.TreeType.TABLE4) {
                rows[i].setMatches(new Table.Row.Match[4]);
                continue;
            }
            rows[i].setMatches(new Table.Row.Match[5]);
        }
        for (Map.Entry entry : draw.entrySet()) {
            if (entry.getValue() == null) continue;
            int n = (Integer)entry.getValue();
            rows[n - 1].setCompetitor((Competitor)entry.getKey());
        }
        for (int i = 0; i < rows.length; ++i) {
            Table.Row row = rows[i];
            Competitor competitor = row.getCompetitor();
            if (competitor == null) continue;
            for (TreeAdvancmentItem treeAdvancmentItem : treeAdvancment.getTableTreeAdvancmentItemsForDraw(i + 1)) {
                Match match = (Match)matches.get(treeAdvancmentItem.getForMatch());
                CompetitorType otherCompetitorType = treeAdvancmentItem.getCompetitorType() == CompetitorType.COMPETITOR1 ? CompetitorType.COMPETITOR2 : CompetitorType.COMPETITOR1;
                TreeAdvancmentItem otherTreeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(match.getFightNumber().intValue(), otherCompetitorType, TreeType.TABLE);
                int otherNum = otherTreeAdvancmentItem.getFromMatch();
                if (otherNum > rows.length) continue;
                Set points = this.matchManager.getMatchPointsForMatch(match);
                Competitor winner = competitionRules.getMatchWinner(match, points);
                Competitor looser = competitionRules.getMatchLoser(match, points);
                Boolean amIWinner = winner == null ? null : Boolean.valueOf(winner.getCompetitorId().equals(competitor.getCompetitorId()));
                Boolean amILooser = looser == null ? null : Boolean.valueOf(looser.getCompetitorId().equals(competitor.getCompetitorId()));
                boolean isFullIpponWin = false;
                boolean isFullIpponLoose = false;
                float myPoints = 0.0f;
                float otherPoints = 0.0f;
                float myIppons = 0.0f;
                float otherIppons = 0.0f;
                Match.Type matchType = null;
                if (treeCategory.getType() == Category.Type.FIGHTING) {
                    matchType = Match.Type.FIGHT;
                } else if (treeCategory.getType() == Category.Type.DUO) {
                    matchType = Match.Type.DUO;
                } else if (treeCategory.getType() == Category.Type.NEWAZA) {
                    matchType = Match.Type.NEWAZA;
                }
                if (treeAdvancmentItem.getCompetitorType() == CompetitorType.COMPETITOR1) {
                    isFullIpponWin = competitionRules.isFullIpponFor(CompetitorType.COMPETITOR1, points) || competitionRules.isFinishingMove(CompetitorType.COMPETITOR1, points) || competitionRules.isDisqualificationFor(matchType, CompetitorType.COMPETITOR2, points);
                    isFullIpponLoose = competitionRules.isFullIpponFor(CompetitorType.COMPETITOR2, points) || competitionRules.isFinishingMove(CompetitorType.COMPETITOR2, points) || competitionRules.isDisqualificationFor(matchType, CompetitorType.COMPETITOR1, points);
                    myPoints = competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR1, points);
                    otherPoints = competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR2, points);
                    myIppons = competitionRules.sumIpponsFor(CompetitorType.COMPETITOR1, points);
                    otherIppons = competitionRules.sumIpponsFor(CompetitorType.COMPETITOR2, points);
                } else {
                    isFullIpponWin = competitionRules.isFullIpponFor(CompetitorType.COMPETITOR2, points) || competitionRules.isFinishingMove(CompetitorType.COMPETITOR2, points) || competitionRules.isDisqualificationFor(matchType, CompetitorType.COMPETITOR1, points);
                    isFullIpponLoose = competitionRules.isFullIpponFor(CompetitorType.COMPETITOR1, points) || competitionRules.isFinishingMove(CompetitorType.COMPETITOR1, points) || competitionRules.isDisqualificationFor(matchType, CompetitorType.COMPETITOR2, points);
                    myPoints = competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR2, points);
                    otherPoints = competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR1, points);
                    myIppons = competitionRules.sumIpponsFor(CompetitorType.COMPETITOR2, points);
                    otherIppons = competitionRules.sumIpponsFor(CompetitorType.COMPETITOR1, points);
                }
                if (!match.getNoWinner().booleanValue() && match.getStatus() == Match.Status.FINISHED) {
                    if (amIWinner != null && amIWinner.booleanValue()) {
                        row.setWins(Integer.valueOf(row.getWins() + 1));
                    }
                    if (amILooser != null && amILooser.booleanValue()) {
                        row.setLooses(Integer.valueOf(row.getLooses() + 1));
                    }
                    if (isFullIpponWin) {
                        row.setFullIpponWins(Integer.valueOf(row.getFullIpponWins() + 1));
                    }
                    if (isFullIpponLoose) {
                        row.setFullIpponLooses(Integer.valueOf(row.getFullIpponLooses() + 1));
                    }
                    row.setPointsGained(Float.valueOf(row.getPointsGained().floatValue() + myPoints));
                    row.setPointsAgainst(Float.valueOf(row.getPointsAgainst().floatValue() + otherPoints));
                    row.setIpponsGained(Float.valueOf(row.getIpponsGained().floatValue() + myIppons));
                    row.setIpponsAgainst(Float.valueOf(row.getIpponsAgainst().floatValue() + otherIppons));
                }
                row.getMatches()[otherNum - 1] = new Table.Row.Match();
                row.getMatches()[otherNum - 1].setMyPoints(Float.valueOf(myPoints));
                row.getMatches()[otherNum - 1].setOtherPoints(Float.valueOf(otherPoints));
                row.getMatches()[otherNum - 1].setAmIWinner(Boolean.valueOf(amIWinner == null ? false : amIWinner));
            }
        }
        return table;
    }
}

