/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.impl;

import java.util.HashSet;
import java.util.Set;
import org.jasypt.util.password.PasswordEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import si.nevensrok.common.dl.Pojo;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.FieldFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.GroupFilter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.judges.Judge;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.server.dl.dao.DuoPresentationGradingDAO;
import si.nevensrok.jtekma.server.dl.dao.JudgeDAO;
import si.nevensrok.jtekma.server.dl.dao.MatchGradingDAO;
import si.nevensrok.jtekma.server.management.JudgeManager;
import si.nevensrok.jtekma.services.common.Credentials;

public class JudgeManagerImpl
implements JudgeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(JudgeManagerImpl.class);
    private PasswordEncryptor passwordEncryptor;
    private JudgeDAO judgeDAO;
    private DuoPresentationGradingDAO duoPresentationGradingDAO;
    private MatchGradingDAO matchGradingDAO;

    public void setPasswordEncryptor(PasswordEncryptor passwordEncryptor) {
        this.passwordEncryptor = passwordEncryptor;
    }

    public void setJudgeDAO(JudgeDAO judgeDAO) {
        this.judgeDAO = judgeDAO;
    }

    public void setDuoPresentationGradingDAO(DuoPresentationGradingDAO duoPresentationGradingDAO) {
        this.duoPresentationGradingDAO = duoPresentationGradingDAO;
    }

    public void setMatchGradingDAO(MatchGradingDAO matchGradingDAO) {
        this.matchGradingDAO = matchGradingDAO;
    }

    @Transactional(value="jtekmaTransactionManager")
    public Judge createJudge(Judge judge) {
        judge.setPassword(this.passwordEncryptor.encryptPassword(judge.getPassword()));
        LOGGER.debug("Creating judge {}", (Object)judge);
        return (Judge)this.judgeDAO.create((Pojo)judge);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Judge createJudgeWithPassword(Judge judge) {
        LOGGER.debug("Creating judge {}", (Object)judge);
        return (Judge)this.judgeDAO.create((Pojo)judge);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Judge updateJudge(Judge judge) {
        LOGGER.debug("Updating judge {}", (Object)judge);
        return (Judge)this.judgeDAO.update((Pojo)judge);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void updateJudgePassword(Judge judge) {
        judge.setPassword(this.passwordEncryptor.encryptPassword(judge.getPassword()));
        LOGGER.debug("Updating judges password {}", (Object)judge);
        this.judgeDAO.updateJudgePassword(judge);
    }

    @Transactional(value="jtekmaTransactionManager")
    public void deleteJudge(Judge judge) {
        LOGGER.debug("Deleting judge {}", (Object)judge);
        this.duoPresentationGradingDAO.deleteAllForJudge(judge);
        this.matchGradingDAO.deleteAllForJudge(judge);
        this.judgeDAO.setTatamisForJudge(judge, new HashSet());
        this.judgeDAO.delete((Pojo)judge);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Judge getById(Long judgeId) {
        return (Judge)this.judgeDAO.getById((Object)judgeId);
    }

    @Transactional(value="jtekmaTransactionManager")
    public PageDataResult<Judge> find(Competition competition, DataFilter dataFilter) {
        GroupFilter rootFilter = new GroupFilter(GroupFilter.Combine.AND);
        rootFilter.addFilter((Filter)new FieldFilter("competition", FieldFilter.Comparator.EQUAL, (Object)competition.getId()));
        rootFilter.addFilter(dataFilter.getFilter());
        ((SimpleDataFilter)dataFilter).setFilter((Filter)rootFilter);
        return this.judgeDAO.find(dataFilter);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Judge getActiveJudgeByName(Competition competition, String name) {
        return this.judgeDAO.getActiveJudgeByName(competition, name);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Judge getJudgeByCredentials(Competition competition, Credentials credentials) {
        if (credentials.getUsername() == null || credentials.getPassword() == null) {
            return null;
        }
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        GroupFilter rootFilter = new GroupFilter(GroupFilter.Combine.AND);
        rootFilter.addFilter((Filter)new FieldFilter("competition", FieldFilter.Comparator.EQUAL, (Object)competition.getId()));
        rootFilter.addFilter((Filter)new FieldFilter("name", FieldFilter.Comparator.EQUAL, (Object)credentials.getUsername()));
        dataFilter.setFilter((Filter)rootFilter);
        dataFilter.setItemLimit(Integer.valueOf(1));
        dataFilter.setFetchCount(false);
        PageDataResult result = this.judgeDAO.find((DataFilter)dataFilter);
        Judge judge = (Judge)result.getSingleItem();
        if (judge == null) {
            return null;
        }
        if (this.passwordEncryptor.checkPassword(credentials.getPassword(), judge.getPassword())) {
            return judge;
        }
        return null;
    }

    @Transactional(value="jtekmaTransactionManager")
    public void setTatamisForJudge(Judge judge, Set<Tatami> tatamis) {
        this.judgeDAO.setTatamisForJudge(judge, tatamis);
    }

    @Transactional(value="jtekmaTransactionManager")
    public Set<Tatami> getTatamisForJudge(Judge judge) {
        return this.judgeDAO.getTatamisForJudge(judge);
    }

    @Transactional(value="jtekmaTransactionManager")
    public boolean isJudgeOnTatami(Judge judge, Tatami tatami) {
        return this.judgeDAO.isJudgeOnTatami(judge, tatami);
    }
}

