/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.fileuploader;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.jtekma.server.fileuploader.FileUploader;

public class ScpFileUploader
implements FileUploader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScpFileUploader.class);

    @Override
    public boolean uploadFile(String hostname, int port, String username, final String password, String path, String fileName, byte[] fileContent, boolean overrideExisting) {
        Session session = null;
        ChannelExec channel = null;
        OutputStream outputStream = null;
        InputStream intputStream = null;
        try {
            JSch jsch = new JSch();
            session = jsch.getSession(username, hostname, port);
            session.setUserInfo(new UserInfo(){
                private boolean passwordSent = false;

                public void showMessage(String message) {
                }

                public boolean promptYesNo(String message) {
                    return true;
                }

                public boolean promptPassword(String message) {
                    if (this.passwordSent) {
                        return false;
                    }
                    this.passwordSent = true;
                    return true;
                }

                public boolean promptPassphrase(String message) {
                    return true;
                }

                public String getPassword() {
                    return password;
                }

                public String getPassphrase() {
                    return null;
                }
            });
            session.connect(10000);
            channel = (ChannelExec)session.openChannel("exec");
            if (!path.isEmpty() && !path.endsWith("/")) {
                path = path + "/";
            }
            String command = "scp -t " + path + fileName;
            LOGGER.debug("Command: [{}]", (Object)command);
            channel.setCommand(command);
            outputStream = channel.getOutputStream();
            intputStream = channel.getInputStream();
            channel.connect();
            if (ScpFileUploader.checkAck(intputStream) != 0) {
                throw new RuntimeException("Error while connecting");
            }
            int fileSize = fileContent.length;
            command = "C0644 " + fileSize + " " + fileName + "\n";
            outputStream.write(command.getBytes());
            outputStream.flush();
            if (ScpFileUploader.checkAck(intputStream) != 0) {
                throw new RuntimeException("Error while sending file information");
            }
            outputStream.write(fileContent);
            outputStream.write(0);
            outputStream.flush();
            if (ScpFileUploader.checkAck(intputStream) != 0) {
                throw new RuntimeException("Error while sending file data");
            }
            outputStream.close();
            intputStream.close();
            channel.disconnect();
            session.disconnect();
            return true;
        }
        catch (Exception e) {
            try {
                outputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                intputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                channel.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                session.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LOGGER.error("Error uploading file to SCP server", (Throwable)e);
            return false;
        }
    }

    private static int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                LOGGER.debug("Error while parsing response " + b + ": '" + sb.toString() + "'");
            }
            if (b == 2) {
                LOGGER.debug("Error while parsing response " + b + ": '" + sb.toString() + "'");
            }
        }
        return b;
    }
}

