/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.fileuploader;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.net.ftp.FTPSClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.jtekma.server.fileuploader.FileUploader;

public class FtpsFileUploader
implements FileUploader {
    private static final Logger LOGGER = LoggerFactory.getLogger(FtpsFileUploader.class);

    @Override
    public boolean uploadFile(String hostname, int port, String username, String password, String path, String fileName, byte[] fileContent, boolean overrideExisting) {
        FTPSClient ftpClient = null;
        try {
            boolean uploaded = false;
            ftpClient = new FTPSClient();
            ftpClient.setConnectTimeout(10000);
            ftpClient.setDataTimeout(5000);
            ftpClient.setControlKeepAliveTimeout(10000L);
            ftpClient.setControlKeepAliveReplyTimeout(10000);
            ftpClient.connect(hostname, port);
            if (!ftpClient.login(username, password)) {
                throw new RuntimeException("Error while authenticating with FTP server [" + username + "@" + hostname + ":" + port + "]");
            }
            ftpClient.enterLocalPassiveMode();
            if (path != null && !path.isEmpty() && !ftpClient.changeWorkingDirectory(path)) {
                throw new RuntimeException("Error while changeing dir to [" + path + "]");
            }
            String[] existing = ftpClient.listNames("./" + fileName);
            if (existing == null || existing.length < 1 || overrideExisting) {
                ftpClient.setFileType(2);
                ftpClient.storeFile(fileName, (InputStream)new ByteArrayInputStream(fileContent));
                ftpClient.setFileType(0);
                uploaded = true;
            } else {
                LOGGER.debug("File [{}] already exists.", (Object)fileName);
            }
            ftpClient.disconnect();
            return uploaded;
        }
        catch (Exception e) {
            try {
                ftpClient.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LOGGER.error("Error uploading file to FTP server", (Throwable)e);
            return false;
        }
    }
}

